/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.component.ComponentItems;
import io.axoniq.axonserver.component.command.ComponentCommand;
import io.axoniq.axonserver.component.command.DefaultCommands;
import io.axoniq.axonserver.component.processor.ClientsByEventProcessor;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.grpc.SerializedCommand;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.logging.PluginEventsLogger;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.message.command.CommandRegistrationCache;
import io.axoniq.axonserver.rest.CommandRestController;
import io.axoniq.axonserver.rest.c;
import io.axoniq.axonserver.rest.json.CommandRequestJson;
import io.axoniq.axonserver.rest.json.CommandResponseJson;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.security.Principal;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="CommandRestController")
@RequestMapping(value={"/v1"})
public class CommandRestController {
    private final CommandDispatcher l;
    private static final Logger I = AuditLog.getLogger();
    private final CommandRegistrationCache L;

    @GetMapping(value={"commands/count"})
    public int M(@Parameter(hidden=true) Principal a2) {
        if (I.isDebugEnabled()) {
            I.debug(PluginEventsLogger.M((Object)"1-\u0017\u000bJ\u0004\u000f'\u001f3\u0019\"J0\u0005$J\"\u00023J7\t\"\u0003 \u000fv\t9\u0007;\u000b8\u000ev\t9\u001f8\u001ex"), (Object)AuditLog.username((Principal)a2));
        }
        return this.l.activeCommandCount();
    }

    @GetMapping(value={"commands/queues"})
    public List<c> d(@Parameter(hidden=true) Principal a2) {
        I.info(ClientsByEventProcessor.M((Object)"SYu\u007f(pmS}G{V(Vg\u0002dK{V(CdN(agOeCfFYWmWmQ&"), (Object)AuditLog.username((Principal)a2));
        return this.l.getCommandQueues().M().entrySet().stream().map(c::M).collect(Collectors.toList());
    }

    @GetMapping(value={"/components/{component}/commands"})
    public Iterable<ComponentCommand> M(@PathVariable(value="component") String component, @RequestParam(value="context") String context, @Parameter(hidden=true) Principal a2) {
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = component;
        objectArray[2] = StringUtils.sanitize((String)context);
        I.info(PluginEventsLogger.M((Object)"1-\u0017\u000bJ\u0004\u000f'\u001f3\u0019\"J\"\u0005v\u0006?\u0019\"J7\u0006:J\u0015\u0005;\u00077\u00042\u0019v\f9\u0018v\u001d>\u00035\u0002v\t9\u0007&\u00058\u000f8\u001evH-\u0017tJ?\u0004v\t9\u0004\"\u000f.\u001evH-\u0017tJ>\u000b%J7J$\u000f1\u0003%\u001e3\u00183\u000ev\u00027\u00042\u00063\u0018x"), objectArray);
        return new ComponentItems(component, context, (Iterable)new DefaultCommands(this.L));
    }

    public CommandRestController(CommandDispatcher a2, CommandRegistrationCache a3) {
        CommandRestController a4;
        CommandRestController commandRestController = a4;
        commandRestController.l = a2;
        commandRestController.L = a3;
    }

    @GetMapping(value={"commands"})
    public List<JsonClientMapping> M(@Parameter(hidden=true) Principal a2) {
        I.info(ClientsByEventProcessor.M((Object)"ys_U\u0002ZGyWmQ|\u0002|M(NaQ|\u0002iNd\u0002KMeOiLlQ(U`KkJ(JiTm\u0002i\u0002zGoK{VmPmF(JiLlNmP&"), (Object)AuditLog.username((Principal)a2));
        return this.L.getAll().entrySet().stream().map(JsonClientMapping::M).collect(Collectors.toList());
    }

    @PostMapping(value={"commands/run"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public Future<CommandResponseJson> M(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String context, @RequestBody @Valid CommandRequestJson command, @Parameter(hidden=true) Authentication a2) {
        I.info(PluginEventsLogger.M((Object)"1-\u0017\u000bJ\u0004\u000f'\u001f3\u0019\"J\"\u0005v\u000e?\u0019&\u000b\"\t>J7Jt\u0011+Hv)9\u0007;\u000b8\u000ex"), (Object)AuditLog.username((Principal)a2), (Object)command.getName());
        CompletableFuture<CommandResponseJson> completableFuture = new CompletableFuture<CommandResponseJson>();
        this.l.dispatch(context, (Authentication)ObjectUtils.M((Object)a2, (Object)GrpcContextAuthenticationProvider.I), new SerializedCommand(command.asCommand()), a3 -> completableFuture.complete(new CommandResponseJson(a3.wrapped())));
        return completableFuture;
    }
}

