/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.admin.application.api.Client;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.grpc.event.GetAggregateEventsRequest;
import io.axoniq.axonserver.grpc.event.GetAggregateSnapshotsRequest;
import io.axoniq.axonserver.grpc.event.GetEventsRequest;
import io.axoniq.axonserver.interceptor.PluginRemovedEvent;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.localstorage.SerializedEventWithToken;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.event.EventDispatcher;
import io.axoniq.axonserver.rest.EventsRestController;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.security.Principal;
import java.util.concurrent.TimeUnit;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

@RestController(value="EventsRestController")
@RequestMapping(value={"/v1"})
public class EventsRestController {
    private final EventDispatcher l;
    private static final Logger I = AuditLog.getLogger();
    private final Logger L;

    @GetMapping(path={"events"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public SseEmitter M(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String context, @RequestParam(value="aggregateId", required=false) String aggregateId, @RequestParam(value="initialSequence", defaultValue="0", required=false) long initialSequence, @RequestParam(value="allowSnapshots", defaultValue="true", required=false) boolean allowSnapshots, @RequestParam(value="trackingToken", defaultValue="0", required=false) long trackingToken, @RequestParam(value="timeout", defaultValue="3600", required=false) long a22, @RequestParam(value="maxEvents", defaultValue="10000", required=false) long a5, @Parameter(hidden=true) Authentication a6) {
        Object[] objectArray = new Object[5];
        objectArray[0] = AuditLog.username((Principal)a6);
        objectArray[1] = context;
        objectArray[2] = aggregateId;
        objectArray[3] = initialSequence;
        objectArray[4] = trackingToken;
        I.info(PluginRemovedEvent.M((Object)"\u0007X!c'^\u0001\u0003\u000eF-V9P(\u0003:L.\u0003=M|F*F2WqP(Q9B1\u00033E|B;D.F;B(F|\u0001'^~\u000f|P(B.W5M;\u0003=W|P9R)F2@9\u0003'^p\u0003(L7F2\u0003'^r"), objectArray);
        SseEmitter a22 = new SseEmitter(Long.valueOf(TimeUnit.SECONDS.toMillis(a22)));
        if (aggregateId != null) {
            GetAggregateEventsRequest getAggregateEventsRequest = GetAggregateEventsRequest.newBuilder().setAggregateId(aggregateId).setAllowSnapshots(allowSnapshots).setInitialSequence(initialSequence).build();
            ObjectMapper objectMapper = new ObjectMapper();
            aggregateId = this.l.aggregateEvents(context, (Authentication)ObjectUtils.M((Object)a6, (Object)GrpcContextAuthenticationProvider.I), getAggregateEventsRequest).subscribe(a4 -> {
                EventsRestController a5;
                a5.M(a22, objectMapper, a4);
            }, arg_0 -> ((SseEmitter)a22).completeWithError(arg_0), () -> {
                EventsRestController a3;
                a3.M(a22);
            });
            this.M(a22, () -> ((Disposable)aggregateId).dispose());
            return a22;
        }
        GetEventsRequest getEventsRequest = GetEventsRequest.newBuilder().setTrackingToken(trackingToken).setNumberOfPermits(a5).setClientId(Client.M((Object)"DIEX")).build();
        Sinks.Many many = Sinks.many().unicast().onBackpressureBuffer();
        this.l.events(context, (Authentication)ObjectUtils.M((Object)a6, (Object)GrpcContextAuthenticationProvider.I), many.asFlux()).subscribe(a3 -> {
            EventsRestController a4;
            a4.M(a22, a3);
        }, arg_0 -> ((SseEmitter)a22).completeWithError(arg_0), () -> {
            EventsRestController a3;
            a3.M(a22);
        });
        many.emitNext((Object)getEventsRequest, Sinks.EmitFailureHandler.FAIL_FAST);
        this.M(a22, () -> many.emitComplete(Sinks.EmitFailureHandler.FAIL_FAST));
        return a22;
    }

    @PostMapping(value={"snapshots"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public Mono<Void> d(@RequestHeader(value="AxonIQ-Context", required=false, defaultValue="default") String context, @RequestBody @Valid JsonEvent jsonEvent, @Parameter(hidden=true) Authentication a2) {
        I.info(PluginRemovedEvent.M((Object)"x'^\u001cX!~|q9R)F/W|W3\u0003=S,F2G|F*F2WtPu"), (Object)AuditLog.username((Principal)a2), (Object)context);
        return this.l.appendSnapshot(StringUtils.getOrDefault((String)context, (String)"default"), jsonEvent.asEvent(), (Authentication)ObjectUtils.M((Object)a2, (Object)GrpcContextAuthenticationProvider.I));
    }

    private /* synthetic */ void M(SseEmitter a2, Runnable a4) {
        a2.onError(a3 -> a4.run());
        a2.onCompletion(a4::run);
        a2.onTimeout(a4::run);
    }

    private /* synthetic */ void M(SseEmitter a2) {
        try {
            a2.send(SseEmitter.event().comment(Client.M((Object)"Ixh6cp,exdiwa")));
            return;
        }
        catch (Exception exception) {
            EventsRestController a3;
            a3.L.debug(PluginRemovedEvent.M((Object)"f.Q3Q|L2\u0003/F2G5M;\u0003?L1S0F(F8"), (Throwable)exception);
            return;
        }
        finally {
            a2.complete();
        }
    }

    @PostMapping(value={"snapshot"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    @Deprecated
    public Mono<Void> M(@RequestHeader(value="AxonIQ-Context", required=false, defaultValue="default") String context, @RequestBody @Valid JsonEvent jsonEvent, @Parameter(hidden=true) Authentication a2) {
        I.warn(Client.M((Object)"WmqVwkQ6^s}ciex6xy,w|fixh6i`ixx>\u007f?,c\u007f\u007fbq,rif~sowxsh6MFE"), (Object)AuditLog.username((Principal)a2), (Object)context);
        return this.d(context, jsonEvent, a2);
    }

    @GetMapping(path={"snapshots"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public SseEmitter M(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String context, @RequestParam(value="aggregateId", required=true) String aggregateId, @RequestParam(value="maxSequence", defaultValue="-1", required=false) long maxSequence, @RequestParam(value="initialSequence", defaultValue="0", required=false) long a2, @Parameter(hidden=true) Authentication a4) {
        Object[] objectArray = new Object[5];
        objectArray[0] = AuditLog.username((Principal)a4);
        objectArray[1] = context;
        objectArray[2] = aggregateId;
        objectArray[3] = a2;
        objectArray[4] = maxSequence;
        I.info(PluginRemovedEvent.M((Object)"x'^\u001cX!~|q9R)F/W|E3Q|O5P(\u00033E|P2B,P4L(P|L:\u0003=D;Q9D=W9\u0003~X!\u0001p\u0003\u0007X!\u000e'^\u0001"), objectArray);
        SseEmitter sseEmitter = new SseEmitter();
        aggregateId = GetAggregateSnapshotsRequest.newBuilder().setAggregateId(aggregateId).setInitialSequence(a2).setMaxSequence(maxSequence >= 0L ? maxSequence : Long.MAX_VALUE).build();
        this.l.aggregateSnapshots(StringUtils.getOrDefault((String)context, (String)"default"), (Authentication)ObjectUtils.M((Object)a4, (Object)GrpcContextAuthenticationProvider.I), (GetAggregateSnapshotsRequest)aggregateId).doOnError(arg_0 -> ((SseEmitter)sseEmitter).completeWithError(arg_0)).doOnComplete(() -> {
            EventsRestController a3;
            a3.M(sseEmitter);
        }).subscribe(a3 -> {
            try {
                sseEmitter.send(SseEmitter.event().data((Object)new JsonEvent(a3.M())));
                return;
            }
            catch (Exception a22) {
                EventsRestController a4;
                a4.L.debug(PluginRemovedEvent.M((Object)"\u0019[?F,W5L2\u00033M|P9M8J2D|F*F2W|\u000e|X!"), (Object)a22.getMessage(), (Object)a22);
                return;
            }
        });
        return sseEmitter;
    }

    public EventsRestController(EventDispatcher a2) {
        EventsRestController a3;
        EventsRestController eventsRestController = a3;
        eventsRestController.L = LoggerFactory.getLogger(EventsRestController.class);
        eventsRestController.l = a2;
    }

    @PostMapping(value={"events"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public Mono<Void> M(@RequestHeader(value="AxonIQ-Context", required=false, defaultValue="default") String context, @Valid @RequestBody JsonEventList jsonEvents, @Parameter(hidden=true) Authentication a3) {
        if (jsonEvents.messages.isEmpty()) {
            throw new IllegalArgumentException(Client.M((Object)"[ee\u007f\u007fbq,{ie\u007fwks\u007f"));
        }
        jsonEvents = Flux.fromStream(jsonEvents.messages.stream().map(a2 -> new SerializedEvent(a2.asEvent())));
        return this.l.appendEvent(context, a3, (Flux)jsonEvents);
    }

    private /* synthetic */ void M(SseEmitter a22, ObjectMapper a3, SerializedEvent a4) {
        try {
            a22.send(SseEmitter.event().data((Object)a3.writeValueAsString((Object)new JsonEvent(a4.M()))));
            return;
        }
        catch (Exception a22) {
            EventsRestController a5;
            a5.L.debug(PluginRemovedEvent.M((Object)"\u0019[?F,W5L2\u00033M|P9M8J2D|F*F2W|\u000e|X!"), (Object)a22.getMessage(), (Object)a22);
            return;
        }
    }

    private /* synthetic */ void M(SseEmitter a2, SerializedEventWithToken a32) {
        try {
            a2.send(SseEmitter.event().id(String.valueOf(a32.M() + 1L)).data((Object)new JsonEvent(a32.M())));
            return;
        }
        catch (Exception a32) {
            EventsRestController a4;
            Exception exception = a32;
            a4.L.debug(Client.M((Object)"Inos|beyb6cx,eixh\u007fbq,szsbb,;,mq"), (Object)exception.getMessage(), (Object)a32);
            a2.completeWithError((Throwable)exception);
            return;
        }
    }
}

