/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.component.processor.ClientEventProcessorInfo;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.common.PluginKey;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.plugin.PluginController;
import io.axoniq.axonserver.plugin.PluginInfo;
import io.axoniq.axonserver.plugin.SimplePluginKey;
import io.axoniq.axonserver.rest.PluginConfigurationJSON;
import io.axoniq.axonserver.rest.PluginPropertyGroup;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"v1/plugins"})
@CrossOrigin
public class PluginsRestController {
    private static final Logger B = AuditLog.getLogger();
    private final PluginController C;
    private final boolean D;
    private final FeatureChecker l;
    public static final String I = "Plugins disabled";
    private final Logger L;

    @DeleteMapping(value={"context"})
    public void M(@RequestParam(value="name") String name, @RequestParam(value="version") String version, @RequestParam(required=false, name="targetContext") String context, @Parameter(hidden=true) Principal a2) {
        if (!this.D || !this.l.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, I);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        objectArray[3] = StringUtils.sanitize((String)context);
        B.info(ActiveQuery.M((Object)"\\0z\u0016'\u0019b:r.t?'?hkr%u.`\"t?b9';k>`\"ik|6(0zka$ukd$i?b3sk|6)"), objectArray);
        this.C.unregisterPluginForContext((PluginKey)new SimplePluginKey(name, version), context);
    }

    @PostMapping(value={"status"})
    public void M(@RequestParam(value="name") String name, @RequestParam(value="version") String version, @RequestParam(required=false, name="targetContext") String context, @RequestParam boolean active, @Parameter(hidden=true) Principal a2) {
        if (!this.D || !this.l.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, I);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = active ? ActiveQuery.M((Object)"t?f9s") : ClientEventProcessorInfo.M((Object)"^4B0");
        objectArray[2] = StringUtils.sanitize((String)name);
        objectArray[3] = StringUtils.sanitize((String)version);
        B.info(ClientEventProcessorInfo.M((Object)"\u001bV=p`\u007f%\\5H3Y`Y/\r;P`],X'D.\r;PoV=\u0003`"), objectArray);
        this.C.updatePluginStatus((PluginKey)new SimplePluginKey(name, version), context, active);
    }

    private /* synthetic */ String M(String a2) {
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.OTHER, ActiveQuery.M((Object)"\u0005hkw'r,n%';f(l*`.';u$q\"c.c"));
        }
        if (a2.contains(File.separator)) {
            throw new MessagingPlatformException(ErrorCode.OTHER, ClientEventProcessorInfo.M((Object)"\u0006D,H.L-H`^(B5A$\r.B4\r#B.Y!D.\r$D2H#Y/_9\r3H0L2L4B2"));
        }
        int n = a2.lastIndexOf(46);
        if (n > 0) {
            return a2.substring(0, n) + "-" + System.currentTimeMillis() + a2.substring(n);
        }
        return a2 + "-" + System.currentTimeMillis();
    }

    @GetMapping
    public Iterable<PluginInfo> M(@Parameter(hidden=true) Principal a2) {
        B.info(ActiveQuery.M((Object)"\u0010|6ZkU.v>b8sks$''n8skd>u9b%skw'r,n%te'"), (Object)AuditLog.username((Principal)a2));
        return this.C.listPlugins();
    }

    @DeleteMapping
    public void M(@RequestParam(value="name") String name, @RequestParam(value="version") String version, @Parameter(hidden=true) Principal a2) {
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        B.info(ClientEventProcessorInfo.M((Object)"v;P\u001d\r\u0012H1X%^4\r4B`X.D.^4L,A`],X'D.\r;PoV=\u0003`"), objectArray);
        this.C.uninstallPlugin((PluginKey)new SimplePluginKey(name, version));
    }

    public PluginsRestController(PluginController a2, MessagingPlatformConfiguration a3, FeatureChecker a4) {
        PluginsRestController a5;
        PluginsRestController pluginsRestController = a5;
        PluginsRestController pluginsRestController2 = a5;
        pluginsRestController2.L = LoggerFactory.getLogger(PluginsRestController.class);
        pluginsRestController2.D = a3.isPluginsEnabled();
        pluginsRestController.C = a2;
        pluginsRestController.l = a4;
    }

    @PostMapping(value={"configuration"})
    public void M(@RequestBody PluginConfigurationJSON configurationJSON, @Parameter(hidden=true) Principal a2) {
        if (!this.D || !this.l.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, I);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)configurationJSON.getName());
        objectArray[2] = StringUtils.sanitize((String)configurationJSON.getVersion());
        B.info(ActiveQuery.M((Object)"\\0z\u0016'\u0019b:r.t?'?hkr;c*s.'(h%a\"`>u*s\"h%'$ak|6(0ze'"), objectArray);
        this.C.updateConfiguration((PluginKey)new SimplePluginKey(configurationJSON.getName(), configurationJSON.getVersion()), configurationJSON.getContext(), configurationJSON.getProperties());
    }

    @GetMapping(value={"configuration"})
    public Iterable<PluginPropertyGroup> M(@RequestParam(value="name") String name, @RequestParam(value="version") String version, @RequestParam(required=false, name="targetContext") String context, @Parameter(hidden=true) Principal a2) {
        if (!this.D || !this.l.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, I);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        B.info(ClientEventProcessorInfo.M((Object)"\u001bV=p`\u007f%\\5H3Y`K/_`N/C&D'X2L4D/C`B&\r;PoV=\u0003`"), objectArray);
        try {
            return this.C.listProperties((PluginKey)new SimplePluginKey(name, version), context);
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = name;
            objectArray2[1] = version;
            objectArray2[2] = runtimeException;
            this.L.warn(ActiveQuery.M((Object)"A*n'b/'?hku.s9n.q.';u$w.u?n.tka$uk|6=0z"), objectArray2);
            throw runtimeException;
        }
    }

    @PostMapping(consumes={"multipart/form-data"})
    public PluginKey M(@RequestPart(value="bundle") MultipartFile pluginBundle22, @Parameter(hidden=true) Principal a2) throws IOException {
        MultipartFile pluginBundle22;
        block6: {
            if (!this.D || !this.l.plugins()) {
                throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, I);
            }
            B.info(ClientEventProcessorInfo.M((Object)"\u001bV=p`\u007f%\\5H3Y`Y/\r)C3Y!A,\r0A5J)C`V=\u0003`"), (Object)AuditLog.username((Principal)a2), (Object)StringUtils.sanitize((String)pluginBundle22.getOriginalFilename()));
            a2 = pluginBundle22.getInputStream();
            try {
                PluginsRestController pluginsRestController = this;
                String string = pluginsRestController.M(pluginBundle22.getOriginalFilename());
                pluginBundle22 = pluginsRestController.C.addPlugin(string, (InputStream)a2);
                if (a2 == null) break block6;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                block7: {
                    if (a2 != null) {
                        try {
                            ((InputStream)a2).close();
                            throwable2 = throwable;
                            break block7;
                        }
                        catch (Throwable pluginBundle22) {
                            throwable.addSuppressed(pluginBundle22);
                        }
                    }
                    throwable2 = throwable;
                }
                throw throwable2;
            }
            ((InputStream)a2).close();
        }
        return pluginBundle22;
    }
}

