/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.runtime.ReplicationGroupMembers;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.logging.PluginEventsLogger;
import io.axoniq.axonserver.message.query.subscription.metric.GlobalSubscriptionMetricRegistry;
import io.axoniq.axonserver.rest.RaftGroupInfoService;
import io.swagger.v3.oas.annotations.Operation;
import java.security.Principal;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"internal/raft"})
public class RaftGroupInfoService {
    private final MessagingPlatformConfiguration l;
    private final ReplicationGroupMembers I;
    private static final Logger L = AuditLog.getLogger();

    @GetMapping(value={"members/{group}"})
    @Operation(hidden=true)
    public Set<ReplicationGroupMemberJson> M(@PathVariable(value="group") String group, Principal a3) {
        if (L.isInfoEnabled()) {
            L.info(PluginEventsLogger.M((Object)"\r\u0011+7v83\u001b#\u000f%\u001ev\u001e9J:\u0003%\u001ev\u00183\u001a:\u00035\u000b\"\u00039\u0004v\r$\u0005#\u001av\u00073\u00074\u000f$\u0019v\f9\u0018v\u0011+J9\u0004v\u001e>\u0003%J8\u00052\u000fx"), (Object)AuditLog.username((Principal)a3), (Object)group);
        }
        return this.I.findByGroupId(group).stream().map(a2 -> new ReplicationGroupMemberJson(a2)).collect(Collectors.toSet());
    }

    public RaftGroupInfoService(ReplicationGroupMembers a2, MessagingPlatformConfiguration a3) {
        RaftGroupInfoService a4;
        RaftGroupInfoService raftGroupInfoService = a4;
        raftGroupInfoService.I = a2;
        raftGroupInfoService.l = a3;
    }

    @GetMapping(value={"groups"})
    @Operation(hidden=true)
    public Set<ReplicationGroupMemberJson> M(Principal a3) {
        RaftGroupInfoService a4;
        if (L.isInfoEnabled()) {
            L.info(GlobalSubscriptionMetricRegistry.M((Object)"\u0012,4\ni\u0005,&<2:#i#&w%>:#i%,'%>*6=>&9i0;8<':w&9i#!>:w'8-2g"), (Object)AuditLog.username((Principal)a3));
        }
        RaftGroupInfoService raftGroupInfoService = a4;
        return raftGroupInfoService.I.findByNodeName(raftGroupInfoService.l.getName()).stream().map(a2 -> new ReplicationGroupMemberJson(a2)).collect(Collectors.toSet());
    }
}

