/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.AxonServerAccessController;
import io.axoniq.axonserver.KeepNames;
import io.axoniq.axonserver.config.AccessControlConfiguration;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.plugin.PluginConfigurationManager;
import io.axoniq.axonserver.rest.WebSecurityConfigurer;
import io.axoniq.axonserver.version.VersionInfo;
import java.lang.invoke.MethodHandles;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
@EnableWebSecurity
@KeepNames
public class WebSecurityConfiguration {
    private final AccessControlConfiguration accessControlConfiguration;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AxonServerAccessController accessController;
    private final DataSource dataSource;
    private WebSecurityConfigurerAdapter altConfigurer;

    public WebSecurityConfiguration(MessagingPlatformConfiguration a2, AxonServerAccessController a3, DataSource a4) {
        WebSecurityConfiguration a5;
        WebSecurityConfiguration webSecurityConfiguration = a5;
        a5.accessControlConfiguration = a2.getAccesscontrol();
        webSecurityConfiguration.accessController = a3;
        webSecurityConfiguration.dataSource = a4;
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder a2, PasswordEncoder a3) throws Exception {
        WebSecurityConfiguration a4;
        if (a4.accessControlConfiguration.isEnabled()) {
            a2.jdbcAuthentication().dataSource(a4.dataSource).usersByUsernameQuery(a4.accessController.usersByUsernameQuery()).authoritiesByUsernameQuery(a4.accessController.authoritiesByUsernameQuery()).passwordEncoder(a3);
        }
    }

    public void setAltConfigurer(WebSecurityConfigurerAdapter a2) {
        logger.info(VersionInfo.M((Object)"?\u0019\u0018\b\u0005\u0012\u000b\\\u0019\fL\u001d\u0000\b\t\u000e\u0002\u001d\u0018\u0019L\u000f\t\u001f\u0019\u000e\u0005\b\u0015\\\u000f\u0013\u0002\u001a\u0005\u001b\u0019\u000e\t\u000eB\\D\u0007\u0011U"), (Object)a2.getClass().getName());
        a.altConfigurer = a2;
    }

    @Bean
    public WebSecurityConfigurerAdapter webSecurityConfigurer() {
        WebSecurityConfiguration a2;
        if (a2.altConfigurer == null) {
            logger.debug(PluginConfigurationManager.M((Object)"/9\u0013$\u001dj\u001e/\u001c+\u000f&\u000ej\t/\u0019?\b#\u000e3Z)\u0015$\u001c#\u001d?\b/\bd"));
            WebSecurityConfiguration webSecurityConfiguration = a2;
            return new WebSecurityConfigurer(webSecurityConfiguration.accessControlConfiguration, webSecurityConfiguration.accessController);
        }
        logger.debug(VersionInfo.M((Object)"9\u000f\u0005\u0012\u000b\\\r\u0010\u0018\u0019\u001e\u0012\r\b\t\\\u001f\u0019\u000f\t\u001e\u0015\u0018\u0005L\u001f\u0003\u0012\n\u0015\u000b\t\u001e\u0019\u001eR"));
        return a2.altConfigurer;
    }
}

