/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.taskscheduler;

import io.axoniq.axonserver.component.processor.balancing.SameProcessor;
import io.axoniq.axonserver.configuration.runtime.Task;
import io.axoniq.axonserver.configuration.runtime.Tasks;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.TaskStatus;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.plugin.PluginConfigurationManager;
import io.axoniq.axonserver.taskscheduler.ScheduledTaskExecutor;
import io.axoniq.axonserver.taskscheduler.TransientException;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Tags;
import java.time.Clock;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.SmartLifecycle;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class BaseTaskManager
implements SmartLifecycle {
    protected final Map<String, Map<String, ScheduledFuture<?>>> K;
    private boolean h;
    private static final String i = "true";
    private final long J;
    private final MeterFactory M;
    protected final PlatformTransactionManager e;
    private static final String j = "false";
    protected static final long g = TimeUnit.MINUTES.toMillis(1L);
    protected static final Logger E = LoggerFactory.getLogger(BaseTaskManager.class);
    protected final ScheduledExecutorService F;
    protected final Supplier<Set<String>> a;
    private final Map<String, Gauge> d;
    protected final AtomicLong k;
    private static final String B = "replicationGroup";
    private static final String C = "transient";
    protected final Tasks D;
    protected final Clock l;
    protected final Predicate<String> I;
    protected final ScheduledTaskExecutor L;

    protected void unschedule(String a2, String a3) {
        BaseTaskManager a4;
        if ((a2 = (ScheduledFuture)a4.K.getOrDefault(a2, Collections.emptyMap()).remove(a3)) != null) {
            a2.cancel(false);
        }
    }

    protected void completed(Task a2, long a4) {
        BaseTaskManager a5;
        a5.processResult(a2.getReplicationGroup(), a2.getTaskId(), TaskStatus.COMPLETED, a5.l.millis(), 0L, null).exceptionally(a3 -> {
            Object[] objectArray = new Object[4];
            objectArray[0] = a2.getReplicationGroup();
            objectArray[1] = a2.getTaskId();
            objectArray[2] = a2.getTaskExecutor();
            objectArray[3] = a3;
            E.warn(PluginConfigurationManager.M((Object)"\u00017@j<+\u0013&\u001f.Z>\u0015j\n8\u0015)\u001f9\tj\b/\t?\u0016>Z,\u00158Z)\u0015'\n&\u001f>\u001f.Z>\u001b9\u0011j\u00017@j\u00017"), objectArray);
            return null;
        });
        String[] stringArray = new String[4];
        stringArray[0] = B;
        stringArray[1] = a2.getReplicationGroup();
        stringArray[2] = "request";
        stringArray[3] = a2.getTaskExecutor();
        a5.M.timer((MetricName)BaseMetricName.v, Tags.of((String[])stringArray)).record(a5.l.millis() - a4, TimeUnit.MILLISECONDS);
    }

    protected String asString(Throwable a2) {
        return MessagingPlatformException.create((Throwable)a2).getMessage();
    }

    protected boolean isTransient(Throwable a2) {
        BaseTaskManager a3;
        if (a2 == null) {
            return false;
        }
        if (a2 instanceof TransientException) {
            return true;
        }
        return a3.isTransient(a2.getCause());
    }

    public BaseTaskManager(ScheduledTaskExecutor taskExecutor, Tasks taskRepository, Supplier<Set<String>> leaderForGroupProvider, Predicate<String> raftLeaderTest, PlatformTransactionManager platformTransactionManager, @Qualifier(value="taskScheduler") ScheduledExecutorService scheduler, MeterFactory meterFactory, Clock a2) {
        BaseTaskManager baseTaskManager = this;
        BaseTaskManager baseTaskManager2 = this;
        BaseTaskManager baseTaskManager3 = this;
        BaseTaskManager baseTaskManager4 = this;
        BaseTaskManager baseTaskManager5 = this;
        BaseTaskManager baseTaskManager6 = this;
        this.K = new ConcurrentHashMap();
        BaseTaskManager baseTaskManager7 = this;
        baseTaskManager6.d = new ConcurrentHashMap();
        BaseTaskManager baseTaskManager8 = this;
        baseTaskManager5.k = new AtomicLong();
        baseTaskManager5.J = Duration.ofMinutes(5L).toMillis();
        baseTaskManager4.L = taskExecutor;
        baseTaskManager4.D = taskRepository;
        baseTaskManager3.a = leaderForGroupProvider;
        baseTaskManager3.I = raftLeaderTest;
        baseTaskManager2.e = platformTransactionManager;
        baseTaskManager2.F = scheduler;
        baseTaskManager.M = meterFactory;
        baseTaskManager.l = a2;
    }

    public void start() {
        BaseTaskManager a2;
        a2.h = true;
        a2.M();
    }

    protected void saveAndSchedule(Task a4) {
        BaseTaskManager a5;
        a5.d.computeIfAbsent(a4.getReplicationGroup(), a2 -> {
            BaseTaskManager a3;
            return a3.M.gauge((MetricName)BaseMetricName.I, Tags.of((String)B, (String)a2), () -> {
                BaseTaskManager a3;
                return a3.M(a2);
            });
        });
        new TransactionTemplate(a5.e).execute(a3 -> {
            BaseTaskManager a4;
            return a4.D.save(a4);
        });
        E.debug(PluginConfigurationManager.M((Object)"1\u0007pZ\u001e\u001b9\u0011j\t)\u0012/\u001e?\u0016/\u001ej\u00017"), (Object)a4.getReplicationGroup(), (Object)a4.getTaskId());
        a5.doScheduleTask(a4);
    }

    public boolean isRunning() {
        BaseTaskManager a2;
        return a2.h;
    }

    protected void schedule(Task a4) {
        BaseTaskManager a5;
        a5.K.computeIfAbsent(a4.getReplicationGroup(), a2 -> new ConcurrentHashMap()).computeIfAbsent(a4.getTaskId(), a3 -> {
            BaseTaskManager a4;
            return a4.F.schedule(() -> {
                BaseTaskManager a3;
                a3.M(a4);
            }, a4.M(a4), TimeUnit.MILLISECONDS);
        });
    }

    private /* synthetic */ void M() {
        BaseTaskManager a2;
        E.debug(PluginConfigurationManager.M((Object)"\u0003\u0014#\u000ej\u001c/\u000e)\u0012\u001e\u001b9\u0011\u0018\u000f$\u0014/\bfZ=\u0013$\u001e%\rjGj\u00017"), (Object)a2.J);
        a2.F.scheduleWithFixedDelay(() -> {
            BaseTaskManager a2;
            if (!a2.h) {
                return;
            }
            try {
                BaseTaskManager baseTaskManager = a2;
                long l2 = baseTaskManager.k.getAndSet(baseTaskManager.l.millis() + a2.J);
                ((Set)baseTaskManager.a.get()).forEach(a3 -> {
                    BaseTaskManager a4;
                    List list = a4.D.findScheduled(a3, l2, a4.k.get());
                    Object[] objectArray = new Object[4];
                    objectArray[0] = a3;
                    objectArray[1] = list.size();
                    objectArray[2] = l2;
                    objectArray[3] = a4.k.get();
                    E.debug(SameProcessor.M((Object)"i$(ya:z<v,~0|>2\"oyf8a2ayp<f.w<|yi$28|=2\"o"), objectArray);
                    list.forEach(arg_0 -> a4.schedule(arg_0));
                });
                return;
            }
            catch (Exception exception) {
                E.warn(SameProcessor.M((Object)"\u001cj:w)f0}72?w-q1{7uya:z<v,~<vyf8a2au2.{5~yf+kys>s0|y~8f<`"), (Throwable)exception);
                return;
            }
        }, 0L, a2.J, TimeUnit.MILLISECONDS);
    }

    protected void error(Task a2, Throwable a4) {
        CompletableFuture completableFuture;
        BaseTaskManager a5;
        if (a5.isTransient(a4)) {
            BaseTaskManager baseTaskManager;
            Task task = a2;
            long l2 = Math.min(task.getRetryInterval() * 2L, g);
            if (task.getRetryInterval() < g) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a2.getReplicationGroup();
                objectArray[1] = a2.getPayload().getType();
                objectArray[2] = l2;
                E.info(SameProcessor.M((Object)"\"oc2\u001fs0~<vyf62<j<q,f<2-s*yy5\"o~<y2\u000bw-` {7uy{72\"oy\u007f*<w<"), objectArray);
                baseTaskManager = a5;
            } else {
                Object[] objectArray = new Object[5];
                objectArray[0] = a2.getReplicationGroup();
                objectArray[1] = a2.getTaskId();
                objectArray[2] = a2.getTaskExecutor();
                objectArray[3] = a4.getMessage();
                objectArray[4] = l2;
                E.warn(PluginConfigurationManager.M((Object)"\u00017@j<+\u0013&\u001f.Z>\u0015j\u001f2\u001f)\u000f>\u001fj\u000e+\t!Z1\u0007pZ1\u0007jWj\u00017Tj(/\u000e8\u0003#\u0014-Z#\u0014j\u00017Z'\tdTd"), objectArray);
                baseTaskManager = a5;
            }
            CompletableFuture completableFuture2 = baseTaskManager.processResult(a2.getReplicationGroup(), a2.getTaskId(), TaskStatus.SCHEDULED, a5.newSchedule(a2), l2, a5.asString(a4));
            String[] stringArray = new String[8];
            stringArray[0] = B;
            stringArray[1] = a2.getReplicationGroup();
            stringArray[2] = "request";
            stringArray[3] = a2.getTaskExecutor();
            stringArray[4] = C;
            stringArray[5] = i;
            stringArray[6] = "error";
            stringArray[7] = ErrorCode.fromException((Throwable)a4).getCode();
            a5.M.counter((MetricName)BaseMetricName.O, Tags.of((String[])stringArray)).increment();
            completableFuture = completableFuture2;
        } else {
            Object[] objectArray = new Object[4];
            objectArray[0] = a2.getReplicationGroup();
            objectArray[1] = a2.getTaskId();
            objectArray[2] = a2.getTaskExecutor();
            objectArray[3] = a4;
            E.warn(SameProcessor.M((Object)"i$(yT8{5w=2-}yw!w:g-wyf8a22\"oc2\"o"), objectArray);
            BaseTaskManager baseTaskManager = a5;
            CompletableFuture completableFuture3 = baseTaskManager.processResult(a2.getReplicationGroup(), a2.getTaskId(), TaskStatus.FAILED, a5.l.millis(), 0L, a5.asString(a4));
            String[] stringArray = new String[8];
            stringArray[0] = B;
            stringArray[1] = a2.getReplicationGroup();
            stringArray[2] = "request";
            stringArray[3] = a2.getTaskExecutor();
            stringArray[4] = C;
            stringArray[5] = j;
            stringArray[6] = "error";
            stringArray[7] = ErrorCode.fromException((Throwable)a4).getCode();
            baseTaskManager.M.counter((MetricName)BaseMetricName.O, Tags.of((String[])stringArray)).increment();
            completableFuture = completableFuture3;
        }
        completableFuture.exceptionally(a3 -> {
            Object[] objectArray = new Object[4];
            objectArray[0] = a2.getReplicationGroup();
            objectArray[1] = a2.getTaskId();
            objectArray[2] = a2.getTaskExecutor();
            objectArray[3] = a3;
            E.warn(PluginConfigurationManager.M((Object)"\u00017@j<+\u0013&\u001f.Z>\u0015j\n8\u0015)\u001f9\tj\b/\t?\u0016>Z,\u00158Z>\u001b9\u0011j\u00017@j\u00017"), objectArray);
            return null;
        });
    }

    private /* synthetic */ void M(Task a2) {
        BaseTaskManager a5;
        BaseTaskManager baseTaskManager = a5;
        long l2 = baseTaskManager.l.millis();
        baseTaskManager.K.getOrDefault(a2.getReplicationGroup(), Collections.emptyMap()).remove(a2.getTaskId());
        if (E.isDebugEnabled()) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a2.getReplicationGroup();
            objectArray[1] = a2.getTaskId();
            objectArray[2] = a2.getTaskExecutor();
            objectArray[3] = a5.l.millis() - a2.getTimestamp();
            E.debug(SameProcessor.M((Object)"\"oc2\u001cj<q,f<2-s*yyi$(yi$2)~8|7w=2<j<q,f0}72\"o4ays>}"), objectArray);
        }
        try {
            ((CompletableFuture)a5.L.executeTask(a2).thenAccept(a4 -> {
                BaseTaskManager a5;
                a5.completed(a2, l2);
            })).exceptionally(a3 -> {
                BaseTaskManager a4;
                a4.error(a2, a3);
                return null;
            });
            return;
        }
        catch (Exception exception) {
            a5.error(a2, (Throwable)exception);
            return;
        }
    }

    protected long newSchedule(Task a2) {
        BaseTaskManager a3;
        return a3.l.millis() + Math.min(a2.getRetryInterval(), g);
    }

    protected abstract CompletableFuture<Void> processResult(String var1, String var2, TaskStatus var3, long var4, long var6, String var8);

    public void stop() {
        BaseTaskManager a2;
        a2.h = false;
        E.info(PluginConfigurationManager.M((Object)")>\u0015:Z\u001e\u001b9\u0011\u0007\u001b$\u001b-\u001f8"));
        a2.F.shutdown();
    }

    private /* synthetic */ Number M(String a2) {
        BaseTaskManager a3;
        return a3.D.countByContext(a2);
    }

    protected void doScheduleTask(Task a2) {
        BaseTaskManager a3;
        if (a3.I.test(a2.getReplicationGroup()) && a2.getTimestamp() < a3.k.get() && TaskStatus.SCHEDULED.equals((Object)a2.getStatus())) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.getReplicationGroup();
            objectArray[1] = a2.getTimestamp();
            objectArray[2] = a3.k;
            E.debug(SameProcessor.M((Object)"\"oc28v={7uyf8a22-}ya:z<v,~<`yf0\u007f<2\"oyp<t6`<2\"o"), objectArray);
            a3.schedule(a2);
        }
    }

    private /* synthetic */ long M(Task a2) {
        BaseTaskManager a3;
        return a2.getTimestamp() - a3.l.millis();
    }
}

