/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.topology;

import io.axoniq.axonserver.accesscontrol.VisibleContexts;
import io.axoniq.axonserver.admin.context.api.ContextAdminService;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.cluster.util.RoleUtils;
import io.axoniq.axonserver.configuration.admin.AdminContext;
import io.axoniq.axonserver.configuration.admin.AdminContexts;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.configuration.runtime.Context;
import io.axoniq.axonserver.configuration.runtime.Contexts;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.NodeSelector;
import io.axoniq.axonserver.enterprise.replication.ContextLeaderProvider;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftController;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.topology.AxonServerNode;
import io.axoniq.axonserver.topology.ClusterTopology;
import io.axoniq.axonserver.topology.Topology;
import io.axoniq.axonserver.topology.g;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;

@Component
public class ClusterTopology
implements Topology,
VisibleContexts {
    private final ContextLeaderProvider k;
    private final AdminContexts B;
    private final GrpcRaftController C;
    private final ClusterController D;
    private final ContextAdminService l;
    private final Contexts I;
    private final NodeSelector L;

    public Stream<? extends AxonServerNode> nodes() {
        ClusterTopology a2;
        if (a2.D.isAdminNode()) {
            return a2.D.nodes().map(DefaultAxonServerNode::new);
        }
        return a2.nodesFromRaftGroups();
    }

    public boolean isLeader(String a2, String a3) {
        ClusterTopology a4;
        return a2.equals(a4.k.getLeaderOrWait(a3, false));
    }

    public Iterable<String> knownContexts() {
        ClusterTopology a2;
        if (a2.D.isAdminNode()) {
            return a2.B.findAll().stream().map(AdminContext::getName).collect(Collectors.toSet());
        }
        return a2.I.findAll().stream().map(Context::getName).collect(Collectors.toSet());
    }

    public boolean isActive(AxonServerNode a2) {
        ClusterTopology a3;
        return a3.D.isActive(a2.getName());
    }

    public boolean isMultiContext() {
        return true;
    }

    public boolean initialized() {
        ClusterTopology a2;
        if (!a2.D.getRemoteConnections().isEmpty() || !a2.C.getRaftGroups().isEmpty()) {
            return true;
        }
        return false;
    }

    public Iterable<String> getMyContextNames() {
        ClusterTopology a2;
        return a2.C.getAllNonAdminContexts();
    }

    public boolean validContext(String a2) {
        ClusterTopology a3;
        if (a3.isAdminNode()) {
            return true;
        }
        if (a3.C.getRaftNodeForContext(a2) != null) {
            return true;
        }
        return false;
    }

    public Iterable<String> getMyStorageContextNames() {
        ClusterTopology a2;
        return a2.C.getAllNonAdminContexts();
    }

    public AxonServerNode getMe() {
        ClusterTopology a2;
        return new DefaultAxonServerNode(a2.D.getMe());
    }

    public Stream<AxonServerNode> nodesFromRaftGroups() {
        ClusterTopology a2;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        a2.D.nodes().forEach(a3 -> hashMap.put(a3, new HashSet()));
        a2.C.getRaftGroups().forEach(a4 -> {
            ClusterTopology a5;
            Iterator iterator;
            Iterator iterator2 = iterator = a5.C.getRaftGroup(a4).raftConfiguration().groupMembers().iterator();
            while (iterator2.hasNext()) {
                Node node = (Node)iterator.next();
                ClusterTopology clusterTopology = a5;
                ClusterNode clusterNode = clusterTopology.D.getNode(node.getNodeName());
                clusterTopology.I.findByReplicationGroupName(a4).forEach(a7 -> {
                    hashMap.computeIfAbsent(clusterNode, a2 -> new HashSet()).add(a7.getName());
                    if (RoleUtils.d((Role)node.getRole())) {
                        hashMap2.computeIfAbsent(clusterNode, a2 -> new HashSet()).add(a7.getName());
                    }
                });
                iterator2 = iterator;
            }
        });
        return hashMap.entrySet().stream().map(a3 -> {
            ClusterTopology a4;
            return new g(a4, a3, hashMap2);
        });
    }

    public AxonServerNode findNodeForClient(String a2, String a3, String a4, Map<String, String> a5) {
        ClusterTopology a6;
        return new DefaultAxonServerNode(a6.L.findNodeForClient(a2, a3, a4, a5));
    }

    public ClusterTopology(ClusterController a2, GrpcRaftController a3, ContextAdminService a4, NodeSelector a5, ContextLeaderProvider a6, Contexts a7, AdminContexts a8) {
        ClusterTopology a9;
        ClusterTopology clusterTopology = a9;
        ClusterTopology clusterTopology2 = a9;
        ClusterTopology clusterTopology3 = a9;
        a9.D = a2;
        clusterTopology3.C = a3;
        clusterTopology3.l = a4;
        clusterTopology2.L = a5;
        clusterTopology2.k = a6;
        clusterTopology.I = a7;
        clusterTopology.B = a8;
    }

    public String getName() {
        ClusterTopology a2;
        return a2.D.getName();
    }

    public boolean isAdminNode() {
        ClusterTopology a2;
        return a2.D.isAdminNode();
    }

    public Set<String> visibleContexts(boolean a2, Authentication a3) {
        ClusterTopology a4;
        return (Set)a4.l.getVisibleContexts(a2, a3).collect(Collectors.toSet()).block();
    }
}

