/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.grpc;

import io.axoniq.axonserver.AxonServerAccessController;
import io.axoniq.axonserver.admin.user.requestprocessor.UserController;
import io.axoniq.axonserver.configuration.admin.AdminUser;
import io.axoniq.axonserver.configuration.admin.AdminUserRole;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.GrpcExceptionBuilder;
import io.axoniq.axonserver.grpc.admin.ApplicationRoles;
import io.axoniq.axonserver.grpc.admin.AuthenticateUserRequest;
import io.axoniq.axonserver.grpc.admin.AuthenticationServiceGrpc;
import io.axoniq.axonserver.grpc.admin.ContextRole;
import io.axoniq.axonserver.grpc.admin.Token;
import io.axoniq.axonserver.grpc.admin.UserRoles;
import io.axoniq.axonserver.message.query.QueryHandler;
import io.axoniq.axonserver.rest.HttpStreamingQuery;
import io.grpc.stub.StreamObserver;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Controller;

@Controller
public class AuthenticationGrpcController
extends AuthenticationServiceGrpc.AuthenticationServiceImplBase
implements AxonServerClientService {
    private final UserController l;
    private final AxonServerAccessController I;
    private final PasswordEncoder L;

    private /* synthetic */ ContextRole M(String a2, String a3) {
        return ContextRole.newBuilder().setRole(a2).setContext(a3).build();
    }

    public void authenticateToken(Token a22, StreamObserver<ApplicationRoles> a4) {
        try {
            AuthenticationGrpcController a5;
            a22 = a5.I.authenticate(a22.getToken());
            ApplicationRoles.Builder builder = ApplicationRoles.newBuilder().setApplicationName(a22.getName());
            a22.getAuthorities().forEach(a3 -> {
                AuthenticationGrpcController a4;
                builder.addApplicationRole(a4.M(a3));
            });
            StreamObserver<ApplicationRoles> streamObserver = a4;
            streamObserver.onNext((Object)builder.build());
            streamObserver.onCompleted();
            return;
        }
        catch (Exception a22) {
            a4.onError((Throwable)GrpcExceptionBuilder.build((Throwable)a22));
            return;
        }
    }

    public AuthenticationGrpcController(UserController a2, AxonServerAccessController a3, PasswordEncoder a4) {
        AuthenticationGrpcController a5;
        AuthenticationGrpcController authenticationGrpcController = a5;
        a5.l = a2;
        authenticationGrpcController.I = a3;
        authenticationGrpcController.L = a4;
    }

    public void authenticateUser(AuthenticateUserRequest a2, StreamObserver<UserRoles> a3) {
        AuthenticationGrpcController a4;
        AdminUser adminUser = a4.l.findUser(a2.getUserName());
        if (adminUser == null) {
            a3.onError((Throwable)GrpcExceptionBuilder.build((Throwable)new MessagingPlatformException(ErrorCode.AUTHENTICATION_INVALID_TOKEN, HttpStreamingQuery.M((Object)"\u0014\\+S1[9\u00121]:[3"))));
            return;
        }
        if (!a4.L.matches((CharSequence)a2.getPassword(), adminUser.getPassword())) {
            a3.onError((Throwable)GrpcExceptionBuilder.build((Throwable)new MessagingPlatformException(ErrorCode.AUTHENTICATION_INVALID_TOKEN, QueryHandler.M((Object)"VLiCsK{\u0002sMxKq"))));
            return;
        }
        a2 = UserRoles.newBuilder().setUserName(adminUser.getUserName());
        adminUser.getRoles().forEach(arg_0 -> a4.M((UserRoles.Builder)a2, arg_0));
        StreamObserver<UserRoles> streamObserver = a3;
        streamObserver.onNext((Object)a2.build());
        streamObserver.onCompleted();
    }

    private /* synthetic */ void M(UserRoles.Builder a2, AdminUserRole a3) {
        AuthenticationGrpcController a4;
        a2.addUserRoles(a4.M(a3.getRole(), a3.getContext()));
    }

    private /* synthetic */ ContextRole M(GrantedAuthority a2) {
        AuthenticationGrpcController a3;
        a2 = a2.getAuthority().split(HttpStreamingQuery.M((Object)"\u001d"), 2);
        if (a2.length == 2) {
            return a3.M(a2[0], a2[1]);
        }
        return a3.M(a2[0], a3.I.defaultContextForRest());
    }
}

