/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest;

import io.axoniq.axonserver.admin.context.api.ContextAdminService;
import io.axoniq.axonserver.admin.context.api.ContextOverview;
import io.axoniq.axonserver.admin.context.api.ContextPropertiesUpdate;
import io.axoniq.axonserver.admin.context.api.RemoveContext;
import io.axoniq.axonserver.admin.context.api.ReplicationGroupContext;
import io.axoniq.axonserver.admin.context.requestprocessor.DefaultContextPropertiesUpdate;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroupAdminService;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.config.ExternalLogin;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroupMember;
import io.axoniq.axonserver.diagnostics.DiagnosticsOptions;
import io.axoniq.axonserver.enterprise.replication.ContextLeaderProvider;
import io.axoniq.axonserver.enterprise.replication.admin.AdminReplicationGroupController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.ContextPropertyDefinition;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.replication.ReplicationLeaderProvider;
import io.axoniq.axonserver.rest.ContextJSON;
import io.axoniq.axonserver.rest.NodeAndRole;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.transport.rest.E;
import io.axoniq.axonserver.transport.rest.PrincipalAuthentication;
import io.axoniq.axonserver.transport.rest.c;
import io.axoniq.axonserver.transport.rest.e;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.security.Principal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Deprecated
@RestController
@CrossOrigin
@RequestMapping(value={"/v1"})
public class ContextRestController {
    private final ReplicationGroupAdminService k;
    private final ContextAdminService B;
    private final AdminReplicationGroupController C;
    private static final Logger D = AuditLog.getLogger();
    private final Logger l;
    private final ContextLeaderProvider I;
    private final ReplicationLeaderProvider L;

    public ContextRestController(ContextAdminService a2, ReplicationGroupAdminService a3, ContextLeaderProvider a4, ReplicationLeaderProvider a5, AdminReplicationGroupController a6) {
        ContextRestController a7;
        ContextRestController contextRestController = a7;
        ContextRestController contextRestController2 = a7;
        ContextRestController contextRestController3 = a7;
        contextRestController3.l = LoggerFactory.getLogger(ContextRestController.class);
        contextRestController3.B = a2;
        contextRestController2.k = a3;
        contextRestController2.I = a4;
        contextRestController.L = a5;
        contextRestController.C = a6;
    }

    @GetMapping(value={"public/context-properties"})
    public ContextPropertyDefinition[] M(@Parameter(hidden=true) Principal a2) {
        D.info(ExternalLogin.M((Object)"\u001f\u001197d8!\u001b1\u000f7\u001ed\u001e+J#\u000f0J'\u0005*\u001e!\u00120J4\u0018+\u001a!\u00180\u0003!\u0019j"), (Object)AuditLog.username((Principal)a2));
        return ContextPropertyDefinition.values();
    }

    private /* synthetic */ Mono<Void> M(ContextJSON a2, String a3, Principal a4) {
        ContextRestController a5;
        return a5.B.createContext((ReplicationGroupContext)new c(a5, a2, a3), (Authentication)new PrincipalAuthentication(a4));
    }

    @GetMapping(path={"public/context"})
    public Flux<ContextJSON> d(@Parameter(hidden=true) Principal a3) {
        return this.B.getContexts((Authentication)new PrincipalAuthentication(a3)).map(a2 -> {
            ContextRestController a3;
            ContextJSON contextJSON = new ContextJSON(a2.name());
            ContextOverview contextOverview = a2;
            contextJSON.setChangePending(contextOverview.replicationGroup().changePending());
            if (contextOverview.pendingSince() != null) {
                contextJSON.setPendingSince(Objects.requireNonNull(a2.pendingSince()).getTime());
            }
            ContextJSON contextJSON2 = contextJSON;
            ContextOverview contextOverview2 = a2;
            contextJSON.setLeader(a3.I.getLeader(a2.name()));
            contextJSON2.setReplicationGroup(contextOverview2.replicationGroup().name());
            contextJSON2.setRoles(contextOverview2.replicationGroup().members().stream().map(NodeAndRole::new).sorted().collect(Collectors.toList()));
            if (a2.replicationGroup().members().stream().anyMatch(AdminReplicationGroupMember::isPendingDelete)) {
                contextJSON.setChangePending(true);
            }
            ContextJSON contextJSON3 = contextJSON;
            contextJSON3.setMetaData(a2.metaData());
            return contextJSON3;
        }).sort(Comparator.comparing(ContextJSON::getContext));
    }

    public Mono<String> d(String a2) {
        ContextRestController a3;
        return Mono.fromCallable(() -> {
            ContextRestController a3;
            return a3.L.getLeader(a2);
        }).subscribeOn(Schedulers.boundedElastic());
    }

    @DeleteMapping(path={"context/{name}"})
    public Mono<ResponseEntity<RestResponse>> d(@PathVariable(value="name") String name, @RequestParam(name="preserveEventStore", required=false, defaultValue="false") boolean preserveEventStore, @Parameter(hidden=true) Principal a3) {
        return this.M(name, preserveEventStore, a3).thenReturn((Object)this.M(ExternalLogin.M((Object)"\u0005\t'\u000f4\u001e!\u000ed\u000e!\u0006!\u001e!J'\u0005*\u001e!\u00120J6\u000f5\u001f!\u00190"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
    }

    public Mono<Void> M(String a3) {
        ContextRestController a4;
        return a4.d(a3).repeatWhenEmpty(100, a2 -> a2.delayElements(Duration.ofMillis(100L))).onErrorMap(IllegalStateException.class, a2 -> new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, ExternalLogin.M((Object)"?*\u000b&\u0006!J0\u0005d\f-\u0004 J(\u000f%\u000e!\u0018d\f+\u0018d\u001e,\u000fd\u0004!\u001d(\u0013d\t6\u000f%\u001e!\u000ed\u0018!\u001a(\u0003'\u000b0\u0003+\u0004d\r6\u00051\u001ad\u001d-\u001e,\u0003*J0\u0002!J6\u000f5\u001f-\u0018!\u000ed\u001e-\u0007!"))).then();
    }

    @PostMapping(path={"context/init"})
    public Mono<ResponseEntity<RestResponse>> M(@RequestParam(name="context", required=false) String context, @Parameter(hidden=true) Principal a3) {
        return Mono.defer(() -> {
            ContextRestController contextRestController;
            ContextRestController a4;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (StringUtils.isEmpty((String)context)) {
                contextRestController = a4;
                arrayList.add("default");
            } else {
                arrayList.add(context);
                contextRestController = a4;
            }
            return contextRestController.B.initCluster(arrayList, (Authentication)new PrincipalAuthentication(a3));
        }).thenReturn((Object)this.M(DiagnosticsOptions.M((Object)"^F|@oQzA?LqLk\u0005|IjVk@m\u0005m@nPzVk"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
    }

    @PostMapping(path={"context"})
    public Mono<ResponseEntity<RestResponse>> d(@RequestBody @Valid ContextJSON contextJson, @Parameter(hidden=true) Principal a3) {
        return Mono.defer(() -> {
            ContextRestController a4;
            String string;
            Mono mono = Mono.empty();
            String string2 = string = StringUtils.isEmpty((String)contextJson.getReplicationGroup()) ? contextJson.getContext() : contextJson.getReplicationGroup();
            if ((AdminReplicationGroup)a4.C.findByName(string).orElse(null) == null) {
                if (contextJson.getRoles() == null || contextJson.getRoles().isEmpty()) {
                    throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, DiagnosticsOptions.M((Object)"RLlVvKx\u0005m@oIvF~QvJq\u0005xWpPo\u0005qJ{@l"));
                }
                mono = a4.M(contextJson, string, (Authentication)new PrincipalAuthentication(a3)).then(a4.M(string));
            }
            mono = mono.then(a4.M(contextJson, string, a3).timeout(Duration.ofSeconds(45L)));
            return mono;
        }).thenReturn((Object)this.M(ExternalLogin.M((Object)"+'\t!\u001a0\u000f J%\u000e J'\u0005*\u001e!\u00120J6\u000f5\u001f!\u00190"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
    }

    @PatchMapping(path={"context/{name}"})
    public Mono<ResponseEntity<RestResponse>> M(@PathVariable(name="name") String name, @RequestBody @Valid Map<String, String> metaData, @Parameter(hidden=true) Principal a3) {
        return this.B.updateContext((ContextPropertiesUpdate)new DefaultContextPropertiesUpdate(name, metaData), (Authentication)new PrincipalAuthentication(a3)).thenReturn((Object)this.M(ExternalLogin.M((Object)"\u0005\t'\u000f4\u001e!\u000ed\u001f4\u000e%\u001e!J'\u0005*\u001e!\u00120J6\u000f5\u001f!\u00190"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
    }

    @GetMapping(path={"public/context/updates"}, produces={"text/event-stream"})
    public Flux<ServerSentEvent<String>> M(@Parameter(hidden=true) Principal a3) {
        a3 = this.B.subscribeContextUpdates((Authentication)new PrincipalAuthentication(a3)).doOnSubscribe(a2 -> {
            ContextRestController a3;
            a3.l.info(DiagnosticsOptions.M((Object)"LP}V|WvGzA?Qp\u0005|JqQz]k\u0005jU{Dk@l"));
        }).doOnError(a2 -> {
            ContextRestController a3;
            a3.l.warn(DiagnosticsOptions.M((Object)"`mWpW?J|FjWm@{\u0005hMvIz\u0005sLlQvKx\u0005yJm\u0005|JqQz]k\u0005jU{Dk@l\u001f?^b"), (Object)a2.getMessage());
        }).onErrorResume(a2 -> Mono.empty()).map(a2 -> ServerSentEvent.builder().data((Object)a2.name()).event(a2.state().name()).build());
        Flux flux = Flux.interval((Duration)Duration.ofSeconds(2L)).map(a2 -> ServerSentEvent.builder().event(DiagnosticsOptions.M((Object)"Nz@o\b~IvSz")).build());
        Publisher[] publisherArray = new Publisher[2];
        publisherArray[0] = a3;
        publisherArray[1] = flux;
        return Flux.merge((Publisher[])publisherArray);
    }

    private /* synthetic */ Mono<Void> M(ContextJSON a2, String a3, Authentication a4) {
        ContextRestController a5;
        return a5.k.createReplicationGroup((ReplicationGroup)new E(a5, a3, a2), a4);
    }

    private /* synthetic */ Mono<Void> M(String a2, boolean a3, Principal a4) {
        ContextRestController a5;
        return a5.B.deleteContext((RemoveContext)new e(a5, a2, a3), (Authentication)new PrincipalAuthentication(a4));
    }

    @GetMapping(path={"public/visiblecontexts"})
    public Mono<List<String>> M(@RequestParam(name="includeAdmin", required=false, defaultValue="false") boolean includeAdmin, @Parameter(hidden=true) Principal a2) {
        return this.B.getVisibleContexts(includeAdmin, (Authentication)new PrincipalAuthentication(a2)).collectList();
    }

    private /* synthetic */ ResponseEntity<RestResponse> M(String a2) {
        return ResponseEntity.accepted().body((Object)new RestResponse(true, a2));
    }
}

