/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest;

import io.axoniq.axonserver.admin.replicationgroup.api.JoinReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.LeaveReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.RemoveReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroupAdminService;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroupOverview;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroupMember;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.replication.ReplicationLeaderProvider;
import io.axoniq.axonserver.rest.ContextJSON;
import io.axoniq.axonserver.rest.NodeAndRole;
import io.axoniq.axonserver.rest.ReplicationGroupJSON;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.taskscheduler.task.NodeContext;
import io.axoniq.axonserver.transport.rest.I;
import io.axoniq.axonserver.transport.rest.PrincipalAuthentication;
import io.axoniq.axonserver.transport.rest.d;
import io.axoniq.axonserver.transport.rest.i;
import io.axoniq.axonserver.transport.rest.j;
import io.axoniq.axonserver.transport.rest.v2.ClusterUpdatesRestController;
import io.swagger.v3.oas.annotations.Parameter;
import java.security.Principal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@CrossOrigin
@RequestMapping(value={"/v1"})
public class ReplicationGroupRestController {
    private static final Logger D = AuditLog.getLogger();
    private final ReplicationLeaderProvider l;
    private final Logger I;
    private final ReplicationGroupAdminService L;

    @DeleteMapping(path={"replicationgroups/{replicationgroup}/{node}"})
    public Mono<ResponseEntity<RestResponse>> d(@PathVariable(value="replicationgroup") String name, @PathVariable(value="node") String node, @RequestParam(name="preserveEventStore", required=false, defaultValue="false") boolean preserveEventStore, @Parameter(hidden=true) Principal a2) {
        return Mono.defer(() -> {
            ReplicationGroupRestController a7;
            Object[] objectArray = new Object[3];
            objectArray[0] = node;
            objectArray[1] = name;
            objectArray[2] = preserveEventStore ? ClusterUpdatesRestController.M((Object)"w\u0016\u0011S?F3X=\u0016?@?X.\u0016)B5D?") : "";
            a7.I.info(NodeContext.M((Object)"5l\u001dl\u0005lQg\u001em\u0014)\u0003l\u0000|\u0014z\u0005)\u0003l\u0012l\u0018\u007f\u0014mQo\u001e{Qg\u001em\u00143Qr\f)\\)\u0010g\u0015)\u0003l\u0001e\u0018j\u0010}\u0018f\u001f)\u0016{\u001e|\u00013Qr\f)\nt"), objectArray);
            return a7.M(name, node, preserveEventStore, (Authentication)new PrincipalAuthentication(a2)).thenReturn((Object)a7.M(NodeContext.M((Object)"H\u0012j\u0014y\u0005l\u0015)\u0015l\u001dl\u0005lQ{\u0014x\u0004l\u0002}"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
        });
    }

    @PostMapping(path={"replicationgroups"})
    public Mono<ResponseEntity<RestResponse>> d(@RequestBody @Valid ReplicationGroupJSON replicationGroupJSON, @Parameter(hidden=true) Principal a2) {
        return Mono.defer(() -> {
            ReplicationGroupRestController a5;
            ReplicationGroupJSON replicationGroupJSON = replicationGroupJSON;
            a5.I.info(NodeContext.M((Object)"0m\u0015)\u0003l\u0001e\u0018j\u0010}\u0018f\u001f)\u0016{\u001e|\u0001)\u0003l\u0000|\u0014z\u0005)\u0003l\u0012l\u0018\u007f\u0014mQo\u001e{Q{\u0014y\u001d`\u0012h\u0005`\u001egQn\u0003f\u0004yK)\nt"), (Object)replicationGroupJSON.getName());
            if (!replicationGroupJSON.hasRoles()) {
                throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_CREATION_NOT_ALLOWED, ClusterUpdatesRestController.M((Object)"\u001bR>\u0016;BzZ?W)BzY4SzX5R?\u0016<Y(\u0016.^?\u0016;F*Z3U;B3Y4\u0016=D5C*"));
            }
            return a5.M(replicationGroupJSON, (Authentication)new PrincipalAuthentication(a2)).thenReturn((Object)a5.M(NodeContext.M((Object)"H\u0012j\u0014y\u0005l\u0015)\u0012{\u0014h\u0005lQ{\u0014x\u0004l\u0002}"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
        });
    }

    @PostMapping(path={"replicationgroups/{replicationgroup}/{node}"})
    public Mono<ResponseEntity<RestResponse>> M(@PathVariable(value="replicationgroup") String name, @PathVariable(value="node") String node, @RequestParam(value="role", required=false, defaultValue="PRIMARY") String role, @Parameter(hidden=true) Principal a2) {
        return Mono.defer(() -> {
            ReplicationGroupRestController a7;
            ReplicationGroupRestController replicationGroupRestController = a7;
            replicationGroupRestController.I.info(ClusterUpdatesRestController.M((Object)"w>RzX5R?\u0016(S+C?E.\u0016(S9S3@?RzP5DzX5R?\fzM'\u0016w\u0016;X>\u00169Y4B?N.\fzM'"), (Object)node, (Object)name);
            return replicationGroupRestController.M(name, node, role, (Authentication)new PrincipalAuthentication(a2)).thenReturn((Object)a7.M(NodeContext.M((Object)"H\u0012j\u0014y\u0005l\u0015)\u0010m\u0015)\u001ff\u0015lQ{\u0014x\u0004l\u0002}"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
        });
    }

    @NotNull
    private /* synthetic */ Mono<Void> M(String a2, boolean a3, Authentication a4) {
        ReplicationGroupRestController a5;
        return a5.L.deleteReplicationGroup((RemoveReplicationGroup)new i(a5, a2, a3), a4);
    }

    @GetMapping(path={"replicationgroups/roles"})
    public Set<String> M(@Parameter(hidden=true) Principal a3) {
        D.info(ClusterUpdatesRestController.M((Object)"\u0001M'kzd?G/S)BzB5\u00166_)BzD?F6_9W._5XzQ(Y/FzD5Z?Et"), (Object)AuditLog.username((Principal)a3));
        return Arrays.stream(Role.values()).filter(a2 -> {
            if (!Role.UNRECOGNIZED.equals(a2)) {
                return true;
            }
            return false;
        }).map(Enum::name).collect(Collectors.toSet());
    }

    private /* synthetic */ ResponseEntity<RestResponse> M(String a2) {
        return ResponseEntity.accepted().body((Object)new RestResponse(true, a2));
    }

    @NotNull
    private /* synthetic */ Mono<Void> M(String a2, String a3, boolean a4, Authentication a5) {
        ReplicationGroupRestController a6;
        return a6.L.removeNodeFromReplicationGroup((LeaveReplicationGroup)new d(a6, a3, a2, a4), a5);
    }

    @GetMapping(path={"public/replicationgroups"})
    public Flux<ReplicationGroupJSON> M(@Parameter(hidden=true) Principal a3) {
        return this.L.getReplicationGroups((Authentication)new PrincipalAuthentication(a3)).map(a2 -> {
            ReplicationGroupRestController a3;
            ReplicationGroupJSON replicationGroupJSON = new ReplicationGroupJSON(a2.name());
            ReplicationGroupOverview replicationGroupOverview = a2;
            replicationGroupJSON.setChangePending(replicationGroupOverview.changePending());
            if (replicationGroupOverview.pendingSince() != null) {
                replicationGroupJSON.setPendingSince(a2.pendingSince().getTime());
            }
            ReplicationGroupJSON replicationGroupJSON2 = replicationGroupJSON;
            ReplicationGroupOverview replicationGroupOverview2 = a2;
            replicationGroupJSON2.setLeader(a3.l.getLeader(replicationGroupOverview2.name()));
            replicationGroupJSON2.setRoles(replicationGroupOverview2.members().stream().map(NodeAndRole::new).sorted().collect(Collectors.toList()));
            if (a2.members().stream().anyMatch(AdminReplicationGroupMember::isPendingDelete)) {
                replicationGroupJSON.setChangePending(true);
            }
            replicationGroupJSON.setContexts(a2.contexts().stream().map(ContextJSON::new).collect(Collectors.toList()));
            return replicationGroupJSON;
        }).sort(Comparator.comparing(ReplicationGroupJSON::getName));
    }

    @NotNull
    private /* synthetic */ Mono<Void> M(ReplicationGroupJSON a2, Authentication a3) {
        ReplicationGroupRestController a4;
        return a4.L.createReplicationGroup((ReplicationGroup)new I(a4, a2), a3);
    }

    @DeleteMapping(path={"replicationgroups/{name}"})
    public Mono<ResponseEntity<RestResponse>> M(@PathVariable(value="name") String name, @RequestParam(value="preserveEventStore", required=false, defaultValue="false") boolean preserveEventStore, @Parameter(hidden=true) Principal a3) {
        return this.M(name, preserveEventStore, (Authentication)new PrincipalAuthentication(a3)).thenReturn((Object)this.M(ClusterUpdatesRestController.M((Object)"\u001bU9S*B?RzR?Z?B?\u0016(S+C?E."))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
    }

    private /* synthetic */ Mono<Void> M(String a2, String a3, String a4, Authentication a5) {
        ReplicationGroupRestController a6;
        return a6.L.addNodeToReplicationGroup((JoinReplicationGroup)new j(a6, a3, a2, a4), a5);
    }

    public ReplicationGroupRestController(ReplicationLeaderProvider a2, ReplicationGroupAdminService a3) {
        ReplicationGroupRestController a4;
        ReplicationGroupRestController replicationGroupRestController = a4;
        a4.I = LoggerFactory.getLogger(ReplicationGroupRestController.class);
        replicationGroupRestController.l = a2;
        replicationGroupRestController.L = a3;
    }
}

