/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest;

import io.axoniq.axonserver.AxonServerEnterpriseGrpcMetricsConfig;
import io.axoniq.axonserver.access.roles.RoleController;
import io.axoniq.axonserver.admin.user.api.UserAdminService;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.configuration.admin.AdminUserRole;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.file.multitier.LowerTierEventStoreFactory;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.transport.rest.PrincipalAuthentication;
import io.axoniq.axonserver.transport.rest.UserRestController;
import io.axoniq.axonserver.transport.rest.g;
import io.swagger.v3.oas.annotations.Parameter;
import java.security.Principal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="UserRestController")
@CrossOrigin
@RequestMapping(value={"/v1"})
public class UserRestController {
    private final UserAdminService D;
    private final RoleController l;
    private static final Logger I;
    private static final Logger L;

    @DeleteMapping(path={"users/{name}"})
    public void M(@PathVariable(value="name") String name, @Parameter(hidden=true) Principal a2) {
        try {
            this.D.deleteUser(name, (Authentication)new PrincipalAuthentication(a2));
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a2);
            objectArray[1] = name;
            objectArray[2] = exception.getMessage();
            I.error(AxonServerEnterpriseGrpcMetricsConfig.M((Object)"\bF.`sy6Q6I6\u001d&N6OsF.\u001d5\\:Q6Ys\u0010sF."), objectArray);
            throw new MessagingPlatformException(ErrorCode.OTHER, exception.getMessage());
        }
    }

    @PostMapping(value={"users"})
    public void M(@RequestBody @Valid UserJson userJson, @Parameter(hidden=true) Principal a3) {
        if (a3 != null && userJson.userName.equals(a3.getName())) {
            throw new MessagingPlatformException(ErrorCode.AUTHENTICATION_INVALID_TOKEN, LowerTierEventStoreFactory.M((Object)"\r&7i\"%/&4,'i7&c*+(-.&i:&6;c&4'c*1,',-=*(/:"));
        }
        Set<Object> set = new HashSet();
        if (userJson.roles != null) {
            set = Arrays.stream(userJson.roles).map(AdminUserRole::parse).collect(Collectors.toSet());
        }
        UserJson userJson2 = userJson;
        this.D.createOrUpdateUser(userJson2.userName, userJson2.password, set.stream().map(a2 -> {
            UserRestController a3;
            return new g(a3, a2);
        }).collect(Collectors.toSet()), (Authentication)new PrincipalAuthentication(a3));
    }

    public UserRestController(UserAdminService a2, RoleController a3) {
        UserRestController a4;
        UserRestController userRestController = a4;
        userRestController.D = a2;
        userRestController.l = a3;
    }

    static {
        L = LoggerFactory.getLogger(UserRestController.class);
        I = AuditLog.getLogger();
    }

    @GetMapping(value={"public/users"})
    public List<UserJson> M(@Parameter(hidden=true) Principal a2) {
        try {
            return this.D.users((Authentication)new PrincipalAuthentication(a2)).stream().map(UserJson::new).sorted(Comparator.comparing(UserJson::getUserName)).collect(Collectors.toList());
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a2);
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            L.info(AxonServerEnterpriseGrpcMetricsConfig.M((Object)"\bF.`sq:N'\u001d&N6O \u001d5\\:Q6Ys\u0010sF."), objectArray);
            throw new MessagingPlatformException(ErrorCode.OTHER, exception.getMessage());
        }
    }
}

