/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import io.axoniq.axonserver.admin.replicationgroup.api.RemoveReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroupAdminService;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroupOverview;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.component.version.ClientVersionsCache;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.localstorage.file.EventSourceNotFoundException;
import io.axoniq.axonserver.transport.rest.PrincipalAuthentication;
import io.axoniq.axonserver.transport.rest.v2.I;
import io.axoniq.axonserver.transport.rest.v2.ReplicationGroupRestControllerV2;
import io.axoniq.axonserver.transport.rest.v2.URIUtils;
import io.axoniq.axonserver.transport.rest.v2.i;
import io.axoniq.axonserver.transport.rest.v2.j;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.net.URI;
import java.security.Principal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@CrossOrigin(origins={"*"}, methods={RequestMethod.GET, RequestMethod.POST, RequestMethod.DELETE, RequestMethod.PUT})
@RestController
@RequestMapping(value={"v2/replicationgroups"})
public class ReplicationGroupRestControllerV2 {
    private final ReplicationGroupAdminService L;

    @PutMapping(consumes={"application/json"}, produces={"text/plain"}, path={"{name}"})
    @Operation(responses={@ApiResponse(responseCode="200"), @ApiResponse(responseCode="201")})
    public Mono<ResponseEntity<Object>> M(@PathVariable(value="name") String name, @RequestBody ReplicationGroupType replicationGroupType, @RequestParam(value="preserveEventStore", required=false, defaultValue="false") boolean preserve, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest a4) {
        principal = new PrincipalAuthentication(principal);
        return this.L.getReplicationGroup(name, (Authentication)principal).flatMap(arg_0 -> this.M(replicationGroupType, preserve, (PrincipalAuthentication)principal, arg_0)).map(a3 -> ((ResponseEntity.BodyBuilder)ResponseEntity.accepted().location(URIUtils.M((StringBuffer)new StringBuffer(a4.getRequestURL().substring(0, a4.getRequestURL().indexOf(a4.getServletPath()))).append(EventSourceNotFoundException.M((Object)"i\u001etG2\t5\u00035G")), (String)a3))).build()).onErrorResume(a2 -> ErrorCode.REPLICATION_GROUP_NOT_FOUND.equals((Object)ErrorCode.fromException((Throwable)a2)), arg_0 -> this.M(name, replicationGroupType, (PrincipalAuthentication)principal, a4, arg_0));
    }

    private /* synthetic */ Mono<String> M(ReplicationGroupOverview a2, List<NodesType> a3, Boolean a4, Authentication a5) {
        ReplicationGroupRestControllerV2 a6;
        return a6.L.updateReplicationGroup(a6.M(a2.name(), a3), a4.booleanValue(), a5);
    }

    public ReplicationGroupRestControllerV2(ReplicationGroupAdminService a2) {
        ReplicationGroupRestControllerV2 a3;
        a3.L = a2;
    }

    @DeleteMapping(value={"{name}"})
    @Operation(responses={@ApiResponse(responseCode="204")})
    public Mono<ResponseEntity<Void>> M(@PathVariable(value="name") String name, @RequestParam(value="preserveEventStore", required=false, defaultValue="false") boolean preserveEventStore, @Parameter(hidden=true) Principal a2) {
        a2 = new PrincipalAuthentication(a2);
        name = new i(this, name, preserveEventStore);
        return this.L.deleteReplicationGroup((RemoveReplicationGroup)name, (Authentication)a2).then(Mono.just((Object)ResponseEntity.noContent().build()));
    }

    private /* synthetic */ ReplicationGroup M(String a2, List<NodesType> a3) {
        ReplicationGroupRestControllerV2 a4;
        return new j(a4, a2, a3);
    }

    private /* synthetic */ Mono M(ReplicationGroupType a2, boolean a3, PrincipalAuthentication a4, ReplicationGroupOverview a5) {
        ReplicationGroupRestControllerV2 a6;
        return a6.M(a5, a2.nodes, Boolean.valueOf(a3), (Authentication)a4);
    }

    @GetMapping(produces={"application/json"})
    @Operation(responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ReplicationGroupType.class)))})})
    public Flux<ReplicationGroupType> M(@Parameter(hidden=true) Principal a2) {
        return this.L.getReplicationGroups((Authentication)new PrincipalAuthentication(a2)).map(ReplicationGroupType::new);
    }

    private /* synthetic */ Mono M(String a2, ReplicationGroupType a3, PrincipalAuthentication a4, HttpServletRequest a5, Throwable a6) {
        ReplicationGroupRestControllerV2 a7;
        return a7.L.createReplicationGroup((ReplicationGroup)new I(a2, a3.nodes), (Authentication)a4).then(Mono.just((Object)ResponseEntity.created((URI)URIUtils.M((StringBuffer)new StringBuffer(a5.getRequestURL().substring(0, a5.getRequestURL().lastIndexOf(ClientVersionsCache.M((Object)"T")))), (String)a2)).build()));
    }

    @PostMapping(consumes={"application/json"}, produces={"text/plain"})
    @Operation(responses={@ApiResponse(responseCode="201")})
    public Mono<ResponseEntity<Void>> M(@RequestBody ReplicationGroupType replicationGroup, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest a3) {
        if (replicationGroup.nodes.stream().noneMatch(a2 -> Role.valueOf((String)a2.role).equals((Object)Role.PRIMARY))) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_CREATION_NOT_ALLOWED, EventSourceNotFoundException.M((Object)"\b\u0007f\u0006)\f#\u001bf\u001f/\u001c.H6\u001a/\u0005'\u001a?H4\u0007*\rf\u001b6\r%\u0001 \u0001#\f"));
        }
        ReplicationGroupType replicationGroupType = replicationGroup;
        return this.L.createReplicationGroup((ReplicationGroup)new I(replicationGroupType.replicationGroupName, replicationGroupType.nodes), (Authentication)new PrincipalAuthentication(principal)).then(Mono.just((Object)ResponseEntity.created((URI)URIUtils.M((StringBuffer)a3.getRequestURL(), (String)replicationGroup.replicationGroupName)).build()));
    }

    @GetMapping(produces={"application/json"}, path={"{name}"})
    public Mono<ReplicationGroupType> M(@PathVariable(value="name") String name, @Parameter(hidden=true) Principal a2) {
        return this.L.getReplicationGroups((Authentication)new PrincipalAuthentication(a2)).filter(a3 -> a3.name().equals(name)).map(ReplicationGroupType::new).single();
    }
}

