/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import io.axoniq.axonserver.admin.user.api.UserAdminService;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.transport.rest.PrincipalAuthentication;
import io.axoniq.axonserver.transport.rest.v2.URIUtils;
import io.axoniq.axonserver.transport.rest.v2.UserRestControllerV2;
import io.axoniq.axonserver.transport.rest.v2.g;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.net.URI;
import java.security.Principal;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"v2/users"})
@CrossOrigin
public class UserRestControllerV2 {
    private final UserAdminService L;

    public UserRestControllerV2(UserAdminService a2) {
        UserRestControllerV2 a3;
        a3.L = a2;
    }

    @GetMapping(produces={"application/json"}, path={"/current"})
    @Operation(responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=UserType.class)))})})
    public UserType M(@Parameter(hidden=true) org.springframework.security.core.Authentication a2) {
        if (a2 == null) {
            return UserType.anonymousUser();
        }
        return new UserType(a2);
    }

    @DeleteMapping(value={"{user}"})
    @Operation(responses={@ApiResponse(responseCode="204", description="when a user is deleted")})
    public ResponseEntity<Void> M(@PathVariable(value="user") String user, @Parameter(hidden=true) Principal a2) {
        this.L.deleteUser(user, (Authentication)new PrincipalAuthentication(a2));
        return ResponseEntity.noContent().build();
    }

    @GetMapping(produces={"application/json"}, path={"{name}"})
    @Operation(responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=UserType.class)))})})
    public UserType M(@PathVariable(value="name") String name, @Parameter(hidden=true) Principal a2) {
        return this.L.users((Authentication)new PrincipalAuthentication(a2)).stream().filter(a3 -> a3.getUserName().equals(name)).map(UserType::new).findFirst().orElseThrow(() -> new MessagingPlatformException(ErrorCode.NO_SUCH_USER, name + ": user not found"));
    }

    @PutMapping(consumes={"application/json"}, produces={"text/plain"})
    @Operation(responses={@ApiResponse(responseCode="200", description="when a user is updated"), @ApiResponse(responseCode="201", description="when a new user is created")})
    public ResponseEntity<Void> M(@RequestBody UserType user, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest a2) {
        principal = new PrincipalAuthentication(principal);
        boolean bl = this.L.users((Authentication)principal).stream().anyMatch(a3 -> a3.getUserName().equals(user.getUserName()));
        HashSet hashSet = new HashSet();
        user.roles.forEach(a3 -> {
            UserRestControllerV2 a5;
            a3.roles.forEach(a4 -> {
                UserRestControllerV2 a5;
                hashSet.add(new g(a5, a4, a3));
            });
        });
        this.L.createOrUpdateUser(user.getUserName(), user.getPassword(), hashSet, (Authentication)principal);
        if (bl) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.created((URI)URIUtils.M((StringBuffer)a2.getRequestURL(), (String)user.getUserName())).build();
    }

    @GetMapping(produces={"application/json"})
    @Operation(responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=UserType.class)))})})
    public Flux<UserType> M(@Parameter(hidden=true) Principal a2) {
        return Flux.fromIterable((Iterable)this.L.users((Authentication)new PrincipalAuthentication(a2))).map(UserType::new);
    }
}

