/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.ui;

import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.taskscheduler.TransientException;
import io.axoniq.axonserver.ui.ClusterUpdatesService;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

@Service
public class ClusterUpdatesService {
    private final Sinks.Many<SimpleUpdate> l;
    private final Logger I = LoggerFactory.getLogger(ClusterUpdatesService.class);
    private static final Logger L = AuditLog.getLogger();

    @EventListener
    public void on(ClusterEvents.BecomeLeader a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.D, a2.replicationGroup(), SimpleUpdateState.l);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupUpdated a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.d, a2.replicationGroup(), SimpleUpdateState.l);
    }

    @EventListener
    public void on(ContextEvents.ContextUpdatedInAdmin a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.I, a2.M(), SimpleUpdateState.l);
    }

    public Flux<SimpleUpdate> subscribeToUpdates(@Nonnull Authentication a2) {
        return this.l.asFlux().publish().autoConnect().doFirst(() -> L.info(TransientException.M((Object)"x,^\n\u0003\u0004V5P4Q>A2GwW8\u00034L9W2[#\u0003\"S3B#F$\r"), (Object)AuditLog.username((String)a2.username())));
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupDeleted a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.d, a2.replicationGroup(), SimpleUpdateState.L);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeDeleted a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.C, a2.node(), SimpleUpdateState.B);
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.B, a2.f(), SimpleUpdateState.D);
    }

    @EventListener
    public void on(ContextEvents.ContextUnregisteredInAdmin a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.I, a2.context(), SimpleUpdateState.L);
    }

    @EventListener
    public void on(ContextEvents.ContextRegisteredInAdmin a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.I, a2.context(), SimpleUpdateState.C);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerInstanceDisconnected a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.k, a2.getNodeName(), SimpleUpdateState.D);
    }

    private /* synthetic */ void M(UpdateType a4, String a5, SimpleUpdateState a6) {
        ClusterUpdatesService a7;
        a7.l.emitNext((Object)new SimpleUpdate(a4, a5 + ":" + a6.name()), (a2, a3) -> {
            if (a3 == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
                return true;
            }
            return false;
        });
    }

    @EventListener
    public void on(ClusterEvents.LeaderStepDown a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.D, a2.replicationGroup(), SimpleUpdateState.l);
    }

    @EventListener
    public void on(ClusterEvents.LeaderConfirmation a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.D, a2.replicationGroup(), SimpleUpdateState.l);
    }

    public ClusterUpdatesService() {
        ClusterUpdatesService a2;
        a2.l = Sinks.many().multicast().onBackpressureBuffer();
    }

    @EventListener
    public void on(TopologyEvents.ApplicationConnected a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.B, a2.m(), SimpleUpdateState.B);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerInstanceConnected a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.k, a2.getNodeName(), SimpleUpdateState.B);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeConnected a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.C, a2.getNodeInfo().getHostName(), SimpleUpdateState.B);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupCreated a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.d, a2.replicationGroup(), SimpleUpdateState.C);
    }
}

