/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.jar;

import java.nio.charset.StandardCharsets;
import org.springframework.boot.loader.jar.StringSequence;

final class AsciiBytes {
    private static final String EMPTY_STRING = "";
    private static final int[] INITIAL_BYTE_BITMASK = new int[]{127, 31, 15, 7};
    private static final int SUBSEQUENT_BYTE_BITMASK = 63;
    private final byte[] bytes;
    private final int offset;
    private final int length;
    private String string;
    private int hash;

    AsciiBytes(String string) {
        this(string.getBytes(StandardCharsets.UTF_8));
        this.string = string;
    }

    AsciiBytes(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    AsciiBytes(byte[] bytes, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > bytes.length) {
            throw new IndexOutOfBoundsException();
        }
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    int length() {
        return this.length;
    }

    boolean startsWith(AsciiBytes prefix) {
        if (this == prefix) {
            return true;
        }
        if (prefix.length > this.length) {
            return false;
        }
        for (int i2 = 0; i2 < prefix.length; ++i2) {
            if (this.bytes[i2 + this.offset] == prefix.bytes[i2 + prefix.offset]) continue;
            return false;
        }
        return true;
    }

    boolean endsWith(AsciiBytes postfix) {
        if (this == postfix) {
            return true;
        }
        if (postfix.length > this.length) {
            return false;
        }
        for (int i2 = 0; i2 < postfix.length; ++i2) {
            if (this.bytes[this.offset + (this.length - 1) - i2] == postfix.bytes[postfix.offset + (postfix.length - 1) - i2]) continue;
            return false;
        }
        return true;
    }

    AsciiBytes substring(int beginIndex) {
        return this.substring(beginIndex, this.length);
    }

    AsciiBytes substring(int beginIndex, int endIndex) {
        int length = endIndex - beginIndex;
        if (this.offset + length > this.bytes.length) {
            throw new IndexOutOfBoundsException();
        }
        return new AsciiBytes(this.bytes, this.offset + beginIndex, length);
    }

    boolean matches(CharSequence name, char suffix) {
        int charIndex = 0;
        int nameLen = name.length();
        int totalLen = nameLen + (suffix != '\u0000' ? 1 : 0);
        for (int i2 = this.offset; i2 < this.offset + this.length; ++i2) {
            int b2 = this.bytes[i2];
            int remainingUtfBytes = this.getNumberOfUtfBytes(b2) - 1;
            b2 &= INITIAL_BYTE_BITMASK[remainingUtfBytes];
            for (int j2 = 0; j2 < remainingUtfBytes; ++j2) {
                b2 = (b2 << 6) + (this.bytes[++i2] & 0x3F);
            }
            char c2 = this.getChar(name, suffix, charIndex++);
            if (b2 <= 65535) {
                if (c2 == b2) continue;
                return false;
            }
            if (c2 != (b2 >> 10) + 55232) {
                return false;
            }
            if ((c2 = this.getChar(name, suffix, charIndex++)) == (b2 & 0x3FF) + 56320) continue;
            return false;
        }
        return charIndex == totalLen;
    }

    private char getChar(CharSequence name, char suffix, int index) {
        if (index < name.length()) {
            return name.charAt(index);
        }
        if (index == name.length()) {
            return suffix;
        }
        return '\u0000';
    }

    private int getNumberOfUtfBytes(int b2) {
        if ((b2 & 0x80) == 0) {
            return 1;
        }
        int numberOfUtfBytes = 0;
        while ((b2 & 0x80) != 0) {
            b2 <<= 1;
            ++numberOfUtfBytes;
        }
        return numberOfUtfBytes;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj.getClass() == AsciiBytes.class) {
            AsciiBytes other = (AsciiBytes)obj;
            if (this.length == other.length) {
                for (int i2 = 0; i2 < this.length; ++i2) {
                    if (this.bytes[this.offset + i2] == other.bytes[other.offset + i2]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = this.hash;
        if (hash == 0 && this.bytes.length > 0) {
            for (int i2 = this.offset; i2 < this.offset + this.length; ++i2) {
                int b2 = this.bytes[i2];
                int remainingUtfBytes = this.getNumberOfUtfBytes(b2) - 1;
                b2 &= INITIAL_BYTE_BITMASK[remainingUtfBytes];
                for (int j2 = 0; j2 < remainingUtfBytes; ++j2) {
                    b2 = (b2 << 6) + (this.bytes[++i2] & 0x3F);
                }
                if (b2 <= 65535) {
                    hash = 31 * hash + b2;
                    continue;
                }
                hash = 31 * hash + ((b2 >> 10) + 55232);
                hash = 31 * hash + ((b2 & 0x3FF) + 56320);
            }
            this.hash = hash;
        }
        return hash;
    }

    public String toString() {
        if (this.string == null) {
            this.string = this.length == 0 ? EMPTY_STRING : new String(this.bytes, this.offset, this.length, StandardCharsets.UTF_8);
        }
        return this.string;
    }

    static String toString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    static int hashCode(CharSequence charSequence) {
        if (charSequence instanceof StringSequence) {
            return charSequence.hashCode();
        }
        return charSequence.toString().hashCode();
    }

    static int hashCode(int hash, char suffix) {
        return suffix != '\u0000' ? 31 * hash + suffix : hash;
    }
}

