/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.migration.destination.remote;

import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"axoniq.migration.destination"}, havingValue="AXONSERVER", matchIfMissing=true)
public class RemoteEventStoreConfiguration {
    private final ApplicationContext applicationContext;

    @Bean
    public AxonServerConfiguration axonServerConfiguration() {
        AxonServerConfiguration configuration = new AxonServerConfiguration();
        configuration.setComponentName(this.clientName(this.applicationContext.getId()));
        return configuration;
    }

    private String clientName(String id) {
        if (id == null) {
            return "AxonServerMigration";
        }
        if (id.contains(":")) {
            return id.substring(0, id.indexOf(58));
        }
        return id;
    }

    @Bean
    public AxonServerConnectionManager axonServerConnectionManager(AxonServerConfiguration axonServerConfiguration) {
        return AxonServerConnectionManager.builder().axonServerConfiguration(axonServerConfiguration).build();
    }

    public RemoteEventStoreConfiguration(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

