/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.migration.migrators.db;

import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.boot.orm.jpa.hibernate.SpringImplicitNamingStrategy;
import org.springframework.boot.orm.jpa.hibernate.SpringPhysicalNamingStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableJpaRepositories(basePackages={"io.axoniq.axonserver.migration.migrators.db"}, entityManagerFactoryRef="migrationEntityManagerFactory")
@EnableTransactionManagement
public class MigrationDBConfiguration {
    @Bean
    @Qualifier(value="migrationEntityManagerFactory")
    public LocalContainerEntityManagerFactoryBean migrationEntityManagerFactory(EntityManagerFactoryBuilder builder) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.hbm2ddl.auto", "update");
        properties.put("hibernate.physical_naming_strategy", SpringPhysicalNamingStrategy.class.getName());
        properties.put("hibernate.implicit_naming_strategy", SpringImplicitNamingStrategy.class.getName());
        return builder.dataSource(this.migrationDataSource()).packages(new String[]{"io.axoniq.axonserver.migration.migrators.db"}).persistenceUnit("migration").properties(properties).build();
    }

    @Bean
    @ConfigurationProperties(value="axoniq.datasource.migration")
    public DataSourceProperties migrationDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    public DataSource migrationDataSource() {
        return this.migrationDataSourceProperties().initializeDataSourceBuilder().build();
    }

    @Bean(name={"transactionManager"})
    public PlatformTransactionManager readingTransactionManager(@Qualifier(value="migrationEntityManagerFactory") EntityManagerFactory migrationEntityManagerFactory) {
        return new JpaTransactionManager(migrationEntityManagerFactory);
    }
}

