/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.cli;

import io.axoniq.cli.AxonIQCliCommand;
import io.axoniq.cli.CommandOptions;
import io.axoniq.cli.json.PluginInfo;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.http.impl.client.CloseableHttpClient;

/*
 * Exception performing whole class analysis ignored.
 */
public class ListPlugins
extends AxonIQCliCommand {
    public static void run(String[] args) throws IOException {
        CommandLine commandLine = ListPlugins.processCommandLine((String)args[0], (String[])args, (Option[])new Option[]{CommandOptions.TOKEN});
        String url = ListPlugins.createUrl((CommandLine)commandLine, (String)"/v1/plugins", (Option[])new Option[0]);
        try (CloseableHttpClient httpclient = ListPlugins.createClient((CommandLine)commandLine);){
            if (ListPlugins.jsonOutput((CommandLine)commandLine)) {
                System.out.println((String)ListPlugins.getJSON((CloseableHttpClient)httpclient, (String)url, String.class, (int)200, (String)ListPlugins.getToken((CommandLine)commandLine)));
            } else {
                PluginInfo[] extensions = (PluginInfo[])ListPlugins.getJSON((CloseableHttpClient)httpclient, (String)url, PluginInfo[].class, (int)200, (String)ListPlugins.getToken((CommandLine)commandLine));
                ListPlugins.showExtensionsAsTable((PluginInfo[])extensions);
            }
        }
    }

    private static void showExtensionsAsTable(PluginInfo[] plugins) {
        System.out.printf("%-30s %-15s %-20s %-10s%n", "Name", "Version", "Context", "Status");
        for (PluginInfo pluginInfo : plugins) {
            if (pluginInfo.getContextInfoList().length == 0) {
                System.out.printf("%-30s %-15s%n", pluginInfo.getName(), pluginInfo.getVersion());
                continue;
            }
            for (int i = 0; i < pluginInfo.getContextInfoList().length; ++i) {
                PluginInfo.PluginContextInfo contextInfo = pluginInfo.getContextInfoList()[i];
                System.out.printf("%-30s %-15s %-20s %-10s%n", i == 0 ? pluginInfo.getName() : "", i == 0 ? pluginInfo.getVersion() : "", contextInfo.getContext(), contextInfo.isActive() ? "Active" : "Registered");
            }
        }
    }
}

