/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.cli;

import io.axoniq.cli.AxonIQCliCommand;
import io.axoniq.cli.CommandExecutionException;
import io.axoniq.cli.CommandOptions;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;

/*
 * Exception performing whole class analysis ignored.
 */
public class UploadPlugin
extends AxonIQCliCommand {
    public static void run(String[] args) throws IOException {
        CommandLine commandLine = UploadPlugin.processCommandLine((String)args[0], (String[])args, (Option[])new Option[]{CommandOptions.PLUGIN_FILE, CommandOptions.TOKEN});
        String url = UploadPlugin.createUrl((CommandLine)commandLine, (String)"/v1/plugins", (Option[])new Option[0]);
        File file = new File(commandLine.getOptionValue(CommandOptions.PLUGIN_FILE.getOpt()));
        if (!file.exists() || !file.canRead()) {
            throw new CommandExecutionException(404, url, file.getAbsolutePath() + ": File does not exists");
        }
        String token = UploadPlugin.getToken((CommandLine)commandLine);
        try (CloseableHttpClient httpclient = UploadPlugin.createClient((CommandLine)commandLine);){
            HttpPost uploadFile = new HttpPost(url);
            if (token != null) {
                uploadFile.addHeader("AxonIQ-Access-Token", token);
            }
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addBinaryBody("bundle", file, ContentType.APPLICATION_OCTET_STREAM, file.getName());
            HttpEntity multipart = builder.build();
            uploadFile.setEntity(multipart);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)uploadFile);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new CommandExecutionException(response.getStatusLine().getStatusCode(), url, response.getStatusLine().toString() + " - " + UploadPlugin.responseBody((CloseableHttpResponse)response));
            }
            System.out.println(UploadPlugin.responseBody((CloseableHttpResponse)response));
        }
    }
}

