/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.access.application;

import io.axoniq.axonserver.access.application.AccessController;
import io.axoniq.axonserver.access.application.ApplicationNotFoundException;
import io.axoniq.axonserver.access.application.Hasher;
import io.axoniq.axonserver.configuration.admin.AdminApplication;
import io.axoniq.axonserver.configuration.admin.AdminApplicationContext;
import io.axoniq.axonserver.configuration.admin.AdminApplications;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import java.util.stream.Stream;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller
public class AdminApplicationController {
    private static final int H = 8;
    private final AdminApplications m;
    private final Hasher h;
    private final AccessController b;
    private final AdminConfigurationFactory I;

    @Transactional
    public void removeRolesForContext(String a2) {
        AdminApplicationController a4;
        a4.m.findAllByContextsContext(a2).forEach(a3 -> a3.removeContext(a2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional
    public void synchronize(AdminApplication a2) {
        AdminApplicationController a4;
        AdminApplications adminApplications = a4.m;
        synchronized (adminApplications) {
            AdminApplication adminApplication;
            AdminApplication adminApplication2 = a4.m.findFirstByName(a2.getName());
            if (adminApplication2 == null) {
                adminApplication = adminApplication2 = a4.I.application(a2.getName(), a2.getDescription(), a2.getTokenPrefix(), a2.getHashedToken(), new AdminApplicationContext[0]);
            } else {
                adminApplication = adminApplication2;
                AdminApplication adminApplication3 = adminApplication2;
                AdminApplication adminApplication4 = a2;
                adminApplication2.clearContexts();
                adminApplication2.setHashedToken(adminApplication4.getHashedToken());
                adminApplication3.setTokenPrefix(adminApplication4.getTokenPrefix());
                adminApplication3.setDescription(a2.getDescription());
            }
            AdminApplication adminApplication5 = adminApplication;
            a2.getContexts().forEach(a3 -> {
                AdminApplicationController a4;
                adminApplication5.addContext(a4.I.applicationContext(a3.getContext(), a3.getRoles()));
            });
            adminApplication5.setMetaDataMap(a2.getMetaDataMap());
            a4.m.save(adminApplication2);
            AdminApplicationController adminApplicationController = a4;
            adminApplicationController.m.flush();
            adminApplicationController.b.invalidateTokens(a2.getTokenPrefix());
            return;
        }
    }

    @Transactional
    public void clearApplications() {
        AdminApplicationController a2;
        a2.m.deleteAll();
    }

    public static String tokenPrefix(String a2) {
        if (a2 == null) {
            return null;
        }
        return a2.substring(0, Math.min(a2.length(), 8));
    }

    public Stream<AdminApplication> getApplications() {
        AdminApplicationController a2;
        return a2.m.findAll();
    }

    public AdminApplicationController(AdminApplications a2, AdminConfigurationFactory a3, Hasher a4, AccessController a5) {
        AdminApplicationController a6;
        AdminApplicationController adminApplicationController = a6;
        AdminApplicationController adminApplicationController2 = a6;
        adminApplicationController2.m = a2;
        adminApplicationController2.I = a3;
        adminApplicationController.h = a4;
        adminApplicationController.b = a5;
    }

    public long count() {
        AdminApplicationController a2;
        return a2.m.count();
    }

    public long countWithout(String a2) {
        AdminApplicationController a4;
        return a4.m.findAll().filter(a3 -> {
            if (!a3.getName().equals(a2)) {
                return true;
            }
            return false;
        }).count();
    }

    public AdminApplication get(String a2) {
        AdminApplicationController a3;
        AdminApplication adminApplication = a3.m.findFirstByName(a2);
        if (adminApplication == null) {
            throw new ApplicationNotFoundException(a2);
        }
        return adminApplication;
    }

    public String hash(String a2) {
        AdminApplicationController a3;
        return a3.h.hash(a2);
    }

    public void delete(String a2) {
        AdminApplicationController a3;
        if ((a2 = a3.m.findFirstByName(a2)) == null) {
            return;
        }
        AdminApplicationController adminApplicationController = a3;
        adminApplicationController.m.delete((AdminApplication)a2);
        adminApplicationController.b.invalidateTokens(a2.getTokenPrefix());
    }

    public static String g(Object a2) {
        a2 = (String)a2;
        int n = ((String)a2).length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = 4 << 4 ^ 4 << 1;
        int cfr_ignored_0 = 4 << 3 ^ 2;
        int n4 = n2;
        int n5 = 4 << 3 ^ (2 ^ 5);
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(((String)a2).charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(((String)a2).charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }
}

