/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.admin.application.requestprocessor;

import io.axoniq.axonserver.access.application.AdminApplicationController;
import io.axoniq.axonserver.access.roles.RoleController;
import io.axoniq.axonserver.admin.application.api.ApplicationAdminService;
import io.axoniq.axonserver.admin.application.api.ApplicationContextRoleRequest;
import io.axoniq.axonserver.admin.application.api.ApplicationOverview;
import io.axoniq.axonserver.admin.application.api.ApplicationRequest;
import io.axoniq.axonserver.admin.application.api.ConnectedApplicationOverview;
import io.axoniq.axonserver.admin.application.requestprocessor.ContextStateProvider;
import io.axoniq.axonserver.admin.application.requestprocessor.K;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.configuration.common.Role;
import io.axoniq.axonserver.enterprise.cluster.MetricsEvents;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ApplicationProtoConverter;
import io.axoniq.axonserver.grpc.internal.Application;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.logging.AuditLog;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class ApplicationAdminRequestProcessor
implements ApplicationAdminService {
    private final AdminApplicationController c;
    private final Logger j;
    private final RaftConfigServiceFactory H;
    private final RoleController m;
    private static final String h = "/\\%;";
    private final ContextStateProvider b;
    private static final Logger I = AuditLog.getLogger();

    private /* synthetic */ void g(List<ApplicationContextRoleRequest> a2) {
        ApplicationAdminRequestProcessor a3;
        Set set = a3.m.listRoles().stream().map(Role::getRole).collect(Collectors.toSet());
        for (String string : a2.stream().map(ApplicationContextRoleRequest::roles).flatMap(Collection::stream).distinct().collect(Collectors.toList())) {
            if (set.contains(string)) continue;
            throw new MessagingPlatformException(ErrorCode.UNKNOWN_ROLE, string + ": Role unknown");
        }
    }

    private /* synthetic */ void g(String a2) {
        int n;
        char[] cArray = a2.toCharArray();
        int n2 = cArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            char c2 = cArray[n];
            if (h.indexOf(c2) >= 0) {
                Object[] objectArray = new Object[2];
                objectArray[0] = a2;
                objectArray[1] = Character.valueOf(c2);
                throw new MessagingPlatformException(ErrorCode.INVALID_NAME, String.format(SerializedEvent.g((Object)"B-]~\u000e0\u0011?\u000b7\u0003~\u00046\u0006,\u0006=\u0013;\u0015~O{\u0014wG7\t~\t?\n;"), objectArray));
            }
            n3 = ++n;
        }
    }

    @Nonnull
    public Mono<ConnectedApplicationOverview> getConnectedApplicationsByContext(@Nonnull String contextName, @Nonnull Authentication a2) {
        return Mono.fromCallable(() -> {
            ApplicationAdminRequestProcessor a3;
            return a3.b.getCurrentState(contextName);
        }).doFirst(() -> {
            if (I.isInfoEnabled()) {
                I.info(SerializedEvent.g((Object)"<%\u001a\u0003G\f\u0002/\u0012;\u0014*G*\b~\u0000;\u0013~\u00041\t0\u0002=\u0013;\u0003~\u0006.\u00172\u000e=\u0006*\u000e1\t-G%\u001ap"), (Object)AuditLog.username((String)a2.username()), (Object)contextName);
            }
        }).doOnSubscribe(a3 -> {
            ApplicationAdminRequestProcessor a4;
            a4.j.info(MetricsEvents.g((Object)"Cdp!gnjoabpd`!eqtmmbeumnj!vdutarp!vdgdmwae$gks$bkopd|u>!\u007f|"), (Object)contextName);
        }).doOnError(a3 -> {
            ApplicationAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = contextName;
            a4.g(a3, SerializedEvent.g((Object)"%\u001adG\u001b\u0015,\b,G9\u0002*\u00137\t9G=\b0\t;\u0004*\u0002:G?\u0017.\u000b7\u0004?\u00137\b0"), objectArray);
        });
    }

    @Nonnull
    public Flux<ApplicationOverview> getApplications(@Nonnull Authentication a3) {
        return Flux.fromStream((Stream)this.c.getApplications()).map(a2 -> {
            ApplicationAdminRequestProcessor a3;
            return new K(a3, a2);
        }).doFirst(() -> {
            if (I.isInfoEnabled()) {
                I.info(MetricsEvents.g((Object)"_zy\\$Sapqdwu$uk!hhwu$`tqhhg`phkow!eo`!piahv!vnhdw/"), (Object)AuditLog.username((String)a3.username()));
            }
        }).doOnSubscribe(a2 -> {
            ApplicationAdminRequestProcessor a3;
            a3.j.info(SerializedEvent.g((Object)"\u0019\u0002*G?\u0017.\u000b7\u0004?\u00137\b0\u0014~\u0015;\u0016+\u0002-\u0013~\u0015;\u0004;\u000e(\u0002:G8\b,G?\u0017.\u000b7\u0004?\u00137\b0"));
        }).doOnError(a2 -> {
            ApplicationAdminRequestProcessor a3;
            a3.g(a2, MetricsEvents.g((Object)"Asvnv!hhwumoc!eqtmmbeumnjr"), new Object[0]);
        });
    }

    @Nonnull
    public Mono<ApplicationOverview> getApplication(@Nonnull String applicationName, @Nonnull Authentication a2) {
        return Mono.fromCallable(() -> {
            ApplicationAdminRequestProcessor a3;
            ApplicationAdminRequestProcessor applicationAdminRequestProcessor = a3;
            return applicationAdminRequestProcessor.g(applicationAdminRequestProcessor.c.get(applicationName));
        }).doFirst(() -> {
            if (I.isInfoEnabled()) {
                I.info(SerializedEvent.g((Object)"\u0005\u001c#:~5;\u0016+\u0002-\u0013~\u00131G9\u0002*G?\u0017.\u000b7\u0004?\u00137\b0G%\u001a~\u00060\u0003~\u000e*\u0014~\u00151\u000b;\u0014p"), (Object)AuditLog.username((String)a2.username()), (Object)applicationName);
            }
        }).doOnSubscribe(a3 -> {
            ApplicationAdminRequestProcessor a4;
            a4.j.info(SerializedEvent.g((Object)" ;\u0013~\u0006.\u00172\u000e=\u0006*\u000e1\t~\u0015;\u0016+\u0002-\u0013~\u0015;\u0004;\u000e(\u0002:G8\b,G?\u0017.\u000b7\u0004?\u00137\b0]~\u001c#"), (Object)applicationName);
        }).doOnError(a3 -> {
            ApplicationAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = applicationName;
            a4.g(a3, MetricsEvents.g((Object)"zy;$Dvsks$fauphjf$`tqhhg`phko"), objectArray);
        });
    }

    private /* synthetic */ void g(Throwable a2, String a3, Object ... a4) {
        ApplicationAdminRequestProcessor a5;
        if (MessagingPlatformException.isClientException((Throwable)a2)) {
            a5.j.info(a3, (Object)a4, (Object)a2);
            return;
        }
        a5.j.warn(a3, (Object)a4, (Object)a2);
    }

    @Nonnull
    public Mono<Void> deleteApplication(@Nonnull String applicationName, @Nonnull Authentication a2) {
        return Mono.fromRunnable(() -> {
            ApplicationAdminRequestProcessor a3;
            a3.H.getRaftConfigService().deleteApplication(Application.newBuilder().setName(applicationName).build());
        }).doFirst(() -> {
            if (I.isInfoEnabled()) {
                I.info(SerializedEvent.g((Object)"<%\u001a\u0003G\f\u0002/\u0012;\u0014*G*\b~\u0003;\u000b;\u0013;G?\u0017.\u000b7\u0004?\u00137\b0G%\u001ap"), (Object)AuditLog.username((String)a2.username()), (Object)applicationName);
            }
        }).doOnSubscribe(a3 -> {
            ApplicationAdminRequestProcessor a4;
            a4.j.info(MetricsEvents.g((Object)"Eamaua!eqtmmbeumnj!vdutarp!vdgdmwae$gks$`tqhhg`phko>!\u007f|"), (Object)applicationName);
        }).doOnError(a3 -> {
            ApplicationAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = applicationName;
            a4.g(a3, MetricsEvents.g((Object)"\u007f|>!Asvnv!`dhdphjf$`tqhhg`phko"), objectArray);
        });
    }

    @Nonnull
    public Mono<String> createOrUpdateApplication(@Nonnull ApplicationRequest application, @Nonnull Authentication a2) {
        return Mono.fromCallable(() -> {
            ApplicationAdminRequestProcessor a3;
            return a3.H.getRaftConfigService().updateApplication(ApplicationProtoConverter.createApplication((ApplicationRequest)application)).getToken();
        }).doFirst(() -> {
            if (I.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a2.username());
                objectArray[1] = application.name();
                objectArray[2] = application.rolesPerContext();
                I.info(MetricsEvents.g((Object)"_zy\\$Sapqdwu$uk!gsa`pd$`tqhhg`phko$#\u007f|&!shpi$skmar$zy/"), objectArray);
            }
        }).doFirst(() -> {
            ApplicationAdminRequestProcessor a3;
            ApplicationAdminRequestProcessor applicationAdminRequestProcessor = a3;
            applicationAdminRequestProcessor.g(application.name());
            applicationAdminRequestProcessor.g(application.rolesPerContext());
        }).doOnSubscribe(a3 -> {
            ApplicationAdminRequestProcessor a4;
            a4.j.info(MetricsEvents.g((Object)"Bvdeua!eqtmmbeumnj!vdutarp!vdgdmwae$gks$`tqhhg`phko>!\u007f|"), (Object)application.name());
        }).doOnError(a3 -> {
            ApplicationAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = application.name();
            a4.g(a3, SerializedEvent.g((Object)"%\u001adG\u001b\u0015,\b,G=\u0015;\u0006*\u000e0\u0000q\u0012.\u0003?\u00137\t9G?\u0017.\u000b7\u0004?\u00137\b0"), objectArray);
        });
    }

    @Nonnull
    public Mono<String> refreshToken(@Nonnull String applicationName, @Nonnull Authentication a2) {
        return Mono.fromCallable(() -> {
            ApplicationAdminRequestProcessor a3;
            return a3.H.getRaftConfigService().refreshToken(Application.newBuilder().setName(applicationName).build()).getToken();
        }).doFirst(() -> {
            if (I.isInfoEnabled()) {
                I.info(MetricsEvents.g((Object)"Z\u007f|Y!Vdutarp!pn$saoav$ukjao$gks$`tqhhg`phko$zy/"), (Object)AuditLog.username((String)a2.username()), (Object)applicationName);
            }
        }).doOnSubscribe(a3 -> {
            ApplicationAdminRequestProcessor a4;
            a4.j.info(SerializedEvent.g((Object)"\u001a\u00022\u0002*\u0002~\u0006.\u00172\u000e=\u0006*\u000e1\t~\u0015;\u0016+\u0002-\u0013~\u0015;\u0004;\u000e(\u0002:G8\b,G?\u0017.\u000b7\u0004?\u00137\b0]~\u001c#"), (Object)applicationName);
        }).doOnError(a3 -> {
            ApplicationAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = applicationName;
            a4.g(a3, MetricsEvents.g((Object)"\u007f|>!Asvnv!vdbsarlhjf$ukjao"), objectArray);
        });
    }

    public ApplicationAdminRequestProcessor(RaftConfigServiceFactory a2, AdminApplicationController a3, RoleController a4, ContextStateProvider a5) {
        ApplicationAdminRequestProcessor a6;
        ApplicationAdminRequestProcessor applicationAdminRequestProcessor = a6;
        ApplicationAdminRequestProcessor applicationAdminRequestProcessor2 = a6;
        a6.j = LoggerFactory.getLogger(ApplicationAdminRequestProcessor.class);
        applicationAdminRequestProcessor2.H = a2;
        applicationAdminRequestProcessor2.c = a3;
        applicationAdminRequestProcessor.m = a4;
        applicationAdminRequestProcessor.b = a5;
    }
}

