/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.admin.context.requestprocessor;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.admin.context.api.ContextAdminService;
import io.axoniq.axonserver.admin.context.api.ContextOverview;
import io.axoniq.axonserver.admin.context.api.ContextPropertiesUpdate;
import io.axoniq.axonserver.admin.context.api.ContextUpdate;
import io.axoniq.axonserver.admin.context.api.ContextUpdateState;
import io.axoniq.axonserver.admin.context.api.RemoveContext;
import io.axoniq.axonserver.admin.context.api.ReplicationGroupContext;
import io.axoniq.axonserver.admin.context.requestprocessor.C;
import io.axoniq.axonserver.admin.context.requestprocessor.ContextFilter;
import io.axoniq.axonserver.admin.context.requestprocessor.K;
import io.axoniq.axonserver.admin.context.requestprocessor.TierConfiguration;
import io.axoniq.axonserver.admin.context.requestprocessor.VisibleContextCache;
import io.axoniq.axonserver.admin.tier.api.LocalTierInfo;
import io.axoniq.axonserver.admin.tier.requestprocessor.LocalTierAdminRequestProcessor;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.component.processor.ClientEventProcessorInfo;
import io.axoniq.axonserver.config.ExternalLogin;
import io.axoniq.axonserver.configuration.admin.AdminContext;
import io.axoniq.axonserver.configuration.admin.AdminContexts;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.licensing.Limits;
import io.axoniq.axonserver.localstorage.ContextPropertyDefinition;
import io.axoniq.axonserver.localstorage.file.EmbeddedDBPropertiesProvider;
import io.axoniq.axonserver.logging.AuditLog;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.util.retry.Retry;

@Service
public class ContextAdminRequestProcessor
implements ContextAdminService {
    private final ClusterController F;
    private final Sinks.Many<ContextUpdate> E;
    private final LocalTierAdminRequestProcessor i;
    private final ContextFilter G;
    private final VisibleContextCache f;
    private final EmbeddedDBPropertiesProvider c;
    private final Logger j;
    private static final Logger H = AuditLog.getLogger();
    private final AdminContexts m;
    private final Limits h;
    private final RaftConfigServiceFactory b;
    private final Predicate<String> I;

    @Nonnull
    public Flux<ContextOverview> getContexts(@Nonnull Authentication a4) {
        return Flux.defer(() -> {
            ContextAdminRequestProcessor a2;
            if (!a2.F.isAdminNode()) {
                throw new MessagingPlatformException(ErrorCode.UNSUPPORTED_INSTRUCTION, ClientEventProcessorInfo.g((Object)"u{_q\u001b}H4U{O4Zz\u001bKZpV}U4U{_q"));
            }
            return Flux.fromIterable((Iterable)a2.m.findAll());
        }).filter(a3 -> {
            ContextAdminRequestProcessor a4;
            return a4.G.hasAccess(a3.getName(), a4);
        }).map(a2 -> {
            ContextAdminRequestProcessor a3;
            return new K(a3, a2);
        }).doFirst(() -> H.info(ClientEventProcessorInfo.g((Object)"`oFI\u001bF^eNqH`\u001b`T4W}H`\u001bwTzOqC`H:"), (Object)AuditLog.username((String)a4.username()))).doOnError(a2 -> {
            ContextAdminRequestProcessor a3;
            a3.g(a2, ExternalLogin.g((Object)"\u00182\u001e/\r>\u0014%\u0013j\n\"\u0014&\u0018j\u000f/\t8\u0014/\u000b#\u0013-])\u0012$\t/\u0005>\u000e"), new Object[0]);
        });
    }

    private /* synthetic */ void g(String a4, Map<String, String> a5, Authentication a6) {
        ContextAdminRequestProcessor a7;
        TierConfiguration tierConfiguration = new TierConfiguration(a5);
        a6 = a7.i.getLocalTiers(a6).stream().map(LocalTierInfo::id).collect(Collectors.toList());
        if (a7.g(tierConfiguration) && !a7.K(tierConfiguration)) {
            throw new IllegalArgumentException(ClientEventProcessorInfo.g((Object)"YNxO}\u0016`RqI4H`TfZs^4Rg\u001b{UxB4ZxW{Lq_4L}O|\u001bu\u001bbZxRp\u001bxRw^zHq"));
        }
        tierConfiguration.K((List)a6);
        a5.entrySet().stream().filter(a2 -> ((String)a2.getKey()).startsWith("event.storage")).map(Map.Entry::getValue).forEach(a3 -> {
            ContextAdminRequestProcessor a4;
            a4.c.getEventProperties(a4).getStorage(a3);
        });
        a5.entrySet().stream().filter(a2 -> ((String)a2.getKey()).startsWith("snapshot.storage")).map(Map.Entry::getValue).forEach(a3 -> {
            ContextAdminRequestProcessor a4;
            a4.c.getSnapshotProperties(a4).getStorage(a3);
        });
    }

    @Nonnull
    public Mono<Void> initCluster(@Nonnull List<String> contexts, @Nonnull Authentication a3) {
        return Mono.fromRunnable(() -> {
            ContextAdminRequestProcessor a3;
            a3.b.getLocalRaftConfigService().init(contexts);
        }).doFirst(() -> H.info(ClientEventProcessorInfo.g((Object)"`oFI\u001bF^eNqH`\u001b`T4RzR`RuW}Aq\u001bwWaH`^f\u001boF:"), (Object)AuditLog.username((String)a3.username()), (Object)contexts)).doOnError(a2 -> {
            ContextAdminRequestProcessor a3;
            a3.g(a2, ClientEventProcessorInfo.g((Object)"qCw^dO}Tz\u001b}U4RzR`\u001bwWaH`^f"), new Object[0]);
        });
    }

    @NotNull
    public Mono<Void> updateContext(@NotNull ContextPropertiesUpdate request, @Nonnull Authentication a2) {
        return Mono.fromFuture(() -> {
            ContextAdminRequestProcessor a3;
            ContextAdminRequestProcessor contextAdminRequestProcessor = a3;
            contextAdminRequestProcessor.j.info(ClientEventProcessorInfo.g((Object)"AKpZ`^4X{U`^lO4IqJa^gO4IqXqRb^p\u001brTf\u001bwTzOqC`\u00014@i"), (Object)request.contextName());
            return contextAdminRequestProcessor.b.getRaftConfigService().updateContext(request.contextName(), request.metaDataMap());
        }).doFirst(() -> {
            ContextAdminRequestProcessor a4;
            H.info(ExternalLogin.g((Object)"\u0011\u00067 j//\f?\u00189\tj\t%]?\r.\u001c>\u0018j\u001e%\u0013>\u00182\tj\u00067S"), (Object)AuditLog.username((String)a2.username()), (Object)request.contextName());
            ContextAdminRequestProcessor contextAdminRequestProcessor = a4;
            contextAdminRequestProcessor.g(request.metaDataMap());
            contextAdminRequestProcessor.g(request.contextName(), request.metaDataMap(), a2);
        }).doOnError(a3 -> {
            ContextAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = request.contextName();
            a4.g(a3, ClientEventProcessorInfo.g((Object)"@i\u00014^lXqK`R{U4L|Rx^4Nd_uO}Us\u001bwTzOqC`"), objectArray);
        });
    }

    private /* synthetic */ void g(Throwable a2, String a3, Object ... a4) {
        ContextAdminRequestProcessor a5;
        if (MessagingPlatformException.isClientException((Throwable)a2)) {
            a5.j.info(a3, (Object)a4, (Object)a2);
            return;
        }
        a5.j.warn(a3, (Object)a4, (Object)a2);
    }

    private /* synthetic */ boolean K(TierConfiguration a2) {
        block4: {
            block3: {
                block2: {
                    if (a2.K().size() <= 1) break block2;
                    if (((TierConfiguration.Tier)a2.K().get(1)).g(ClientEventProcessorInfo.g((Object)"YxZwPKS{Wq"))) break block3;
                }
                if (a2.g().size() <= 1) break block4;
                if (!((TierConfiguration.Tier)a2.g().get(1)).g(ExternalLogin.g((Object)"(\u0011+\u001e!\"\"\u0012&\u0018"))) break block4;
            }
            return true;
        }
        return false;
    }

    @EventListener
    public void on(ContextEvents.ContextUpdatedInAdmin a4) {
        ContextAdminRequestProcessor a5;
        a5.E.emitNext((Object)new C(a4.g(), ContextUpdateState.I), (a2, a3) -> {
            if (a3 == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
                return true;
            }
            return false;
        });
    }

    private /* synthetic */ void g(String a2) {
        ContextAdminRequestProcessor a3;
        if (!a3.I.test(a2)) {
            throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, ExternalLogin.g((Object)"\u0003\u0013<\u001c&\u0014.])\u0012$\t/\u0005>]$\u001c'\u0018"));
        }
    }

    @Nonnull
    public Mono<Void> createContext(@Nonnull ReplicationGroupContext request, @Nonnull Authentication a2) {
        return Mono.fromFuture(() -> {
            ContextAdminRequestProcessor a3;
            ContextAdminRequestProcessor contextAdminRequestProcessor = a3;
            contextAdminRequestProcessor.j.info(ExternalLogin.g((Object)">8\u0018+\t/])\u0012$\t/\u0005>]8\u0018;\b/\u000e>]8\u0018)\u0018#\u000b/\u0019j\u001b%\u000fj\u001e%\u0013>\u00182\tp]1\u0000"), (Object)request.contextName());
            return contextAdminRequestProcessor.b.getRaftConfigService().addContext(request.replicationGroupName(), request.contextName(), request.metaDataMap());
        }).doFirst(() -> {
            ContextAdminRequestProcessor a4;
            H.info(ExternalLogin.g((Object)"&1\u0000\u0017]\u0018\u0018;\b/\u000e>]>\u0012j\u001c.\u0019j\u001e%\u0013>\u00182\tj\u00067S"), (Object)AuditLog.username((String)a2.username()), (Object)request.contextName());
            ContextAdminRequestProcessor contextAdminRequestProcessor = a4;
            ReplicationGroupContext replicationGroupContext = request;
            a4.g(replicationGroupContext.contextName());
            contextAdminRequestProcessor.g(replicationGroupContext.metaDataMap());
            contextAdminRequestProcessor.g(request.contextName(), request.metaDataMap(), a2);
        }).doOnError(a3 -> {
            ContextAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = request.contextName();
            a4.g(a3, ClientEventProcessorInfo.g((Object)"@i\u00014^lXqK`R{U4L|Rx^4Xf^uO}Us\u001bwTzOqC`"), objectArray);
        });
    }

    @Nonnull
    public Mono<ContextOverview> getContext(@Nonnull String contextName, @Nonnull Authentication a4) {
        return Mono.fromCallable(() -> {
            ContextAdminRequestProcessor a3;
            if (!a3.F.isAdminNode()) {
                throw new MessagingPlatformException(ErrorCode.UNSUPPORTED_INSTRUCTION, ClientEventProcessorInfo.g((Object)"u{_q\u001b}H4U{O4Zz\u001bKZpV}U4U{_q"));
            }
            return a3.m.findById(contextName);
        }).map(a2 -> (AdminContext)a2.orElseThrow(() -> new MessagingPlatformException(ErrorCode.CONTEXT_NOT_FOUND, ExternalLogin.g((Object)">%\u0013>\u00182\tj\u0013%\tj\u001b%\b$\u0019")))).filter(a3 -> {
            ContextAdminRequestProcessor a4;
            return a4.G.hasAccess(a3.getName(), a4);
        }).switchIfEmpty(Mono.error(() -> new MessagingPlatformException(ErrorCode.AUTHENTICATION_INVALID_TOKEN, ExternalLogin.g((Object)"4$\u000b+\u0011#\u0019j\t%\u0016/\u0013")))).retryWhen((Retry)Retry.backoff((long)2L, (Duration)Duration.ofSeconds(1L)).onRetryExhaustedThrow((a2, a3) -> a3.failure())).map(a2 -> {
            ContextAdminRequestProcessor a3;
            return new K(a3, a2);
        }).doOnError(a3 -> {
            ContextAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = contextName;
            a4.g(a3, ClientEventProcessorInfo.g((Object)"@i\u00014^lXqK`R{U4L|Rx^4IqOfRqM}Us\u001bwTzOqC`"), objectArray);
        });
    }

    @Nonnull
    public Flux<String> getVisibleContexts(boolean includeAdmin, @Nonnull Authentication a2) {
        return Flux.fromIterable((Iterable)this.f.apply(a2)).filter(a3 -> {
            if (includeAdmin || !RaftAdminGroup.g((String)a3)) {
                return true;
            }
            return false;
        });
    }

    @EventListener
    public void on(ContextEvents.ContextRegisteredInAdmin a4) {
        ContextAdminRequestProcessor a5;
        a5.E.emitNext((Object)new C(a4.context(), ContextUpdateState.H), (a2, a3) -> {
            if (a3 == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
                return true;
            }
            return false;
        });
    }

    private /* synthetic */ void g(@NotNull Map<String, String> a2) {
        for (Map.Entry entry : a2.entrySet()) {
            try {
                ContextPropertyDefinition contextPropertyDefinition = ContextPropertyDefinition.g((String)((String)entry.getKey()));
                if (contextPropertyDefinition == null) continue;
                contextPropertyDefinition.g((String)entry.getValue());
            }
            catch (Exception exception) {
                throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, exception.getMessage());
            }
        }
    }

    @Nonnull
    public Flux<ContextUpdate> subscribeContextUpdates(@Nonnull Authentication a4) {
        return this.E.asFlux().publish().autoConnect().filter(a3 -> {
            ContextAdminRequestProcessor a4;
            return a4.G.hasAccess(a3.name(), a4);
        }).doOnCancel(() -> {
            ContextAdminRequestProcessor a2;
            a2.j.info(ClientEventProcessorInfo.g((Object)"GNvHwI}Yq_4H`Td\u001bf^w^}M}Us\u001bwTzOqC`\u001baKpZ`^g"));
        }).doOnError(a2 -> {
            ContextAdminRequestProcessor a3;
            a3.g(a2, ExternalLogin.g((Object)"/\u0005)\u0018:\t#\u0012$]=\u0015#\u0011/]&\u00149\t/\u0013#\u0013-]>\u0012j\u001e%\u0013>\u00182\tj\b:\u0019+\t/\u000e"), new Object[0]);
        }).doFirst(() -> {
            ContextAdminRequestProcessor a3;
            if (!a3.F.isAdminNode()) {
                throw new MessagingPlatformException(ErrorCode.UNSUPPORTED_INSTRUCTION, ExternalLogin.g((Object)"\u0004\u0012.\u0018j\u00149]$\u0012>]+\u0013j\"+\u0019'\u0014$]$\u0012.\u0018"));
            }
            H.info(ClientEventProcessorInfo.g((Object)"O@if4haYgXfRv^p\u001b`T4X{U`^lO4Nd_uOqH:"), (Object)AuditLog.username((String)a4.username()));
            a3.j.info(ExternalLogin.g((Object)"3/\nj\u000e?\u001f9\u001e8\u0014(\u00188]>\u0012j\u001e%\u0013>\u00182\tj\b:\u0019+\t/\u000e"));
        });
    }

    public ContextAdminRequestProcessor(RaftConfigServiceFactory a2, ClusterController a3, AdminContexts a4, ContextFilter a5, Limits a6, VisibleContextCache a7, LocalTierAdminRequestProcessor a8, EmbeddedDBPropertiesProvider a9) {
        ContextAdminRequestProcessor a10;
        ContextAdminRequestProcessor contextAdminRequestProcessor = a10;
        ContextAdminRequestProcessor contextAdminRequestProcessor2 = a10;
        ContextAdminRequestProcessor contextAdminRequestProcessor3 = a10;
        ContextAdminRequestProcessor contextAdminRequestProcessor4 = a10;
        a10.j = LoggerFactory.getLogger(ContextAdminRequestProcessor.class);
        ContextAdminRequestProcessor contextAdminRequestProcessor5 = a10;
        a10.I = new ContextNameValidation();
        contextAdminRequestProcessor5.E = Sinks.many().multicast().onBackpressureBuffer();
        contextAdminRequestProcessor4.b = a2;
        contextAdminRequestProcessor4.F = a3;
        contextAdminRequestProcessor3.m = a4;
        contextAdminRequestProcessor3.G = a5;
        contextAdminRequestProcessor2.h = a6;
        contextAdminRequestProcessor2.f = a7;
        contextAdminRequestProcessor.i = a8;
        contextAdminRequestProcessor.c = a9;
    }

    private /* synthetic */ boolean g(TierConfiguration a2) {
        block2: {
            block3: {
                ContextAdminRequestProcessor a3;
                if (a3.h.multitier()) break block2;
                if (a2.K().size() > 1) break block3;
                if (a2.g().size() <= 1) break block2;
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public Mono<Void> deleteContext(@Nonnull RemoveContext request, @Nonnull Authentication a2) {
        return Mono.fromRunnable(() -> {
            ContextAdminRequestProcessor a3;
            RemoveContext removeContext = request;
            a3.j.info(ClientEventProcessorInfo.g((Object)"P^x^`^4X{U`^lO4IqJa^gO4IqXqRb^p\u001brTf\u001bwTzOqC`\u00014@i"), (Object)removeContext.name());
            if (removeContext.name().startsWith(ExternalLogin.g((Object)"\""))) {
                Object[] objectArray = new Object[1];
                objectArray[0] = request.name();
                throw new MessagingPlatformException(ErrorCode.CANNOT_DELETE_INTERNAL_CONTEXT, String.format(ClientEventProcessorInfo.g((Object)"WZzU{O4_qWqOq\u001b}U`^fUuW4X{U`^lO4\u001eg"), objectArray));
            }
            a3.b.getRaftConfigService().deleteContext(request.name(), request.preserveEventStore());
        }).doFirst(() -> {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((String)a2.username());
            objectArray[1] = request.name();
            objectArray[2] = request.preserveEventStore();
            H.info(ExternalLogin.g((Object)"\u0011\u00067 j//\f?\u00189\tj\t%].\u0018&\u0018>\u0018j\u001e%\u0013>\u00182\tj\u00067]:\u000f/\u000e/\u000f<\u0018j\u0018<\u0018$\tj\u000e>\u00128\u0018j\u00067S"), objectArray);
        }).doOnError(a3 -> {
            ContextAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = request.name();
            a4.g(a3, ExternalLogin.g((Object)"1\u0000p]/\u0005)\u0018:\t#\u0012$]=\u0015#\u0011/].\u0018&\u0018>\u0014$\u001aj\u001e%\u0013>\u00182\t"), objectArray);
        });
    }

    @EventListener
    public void on(ContextEvents.ContextUnregisteredInAdmin a4) {
        ContextAdminRequestProcessor a5;
        a5.E.emitNext((Object)new C(a4.context(), ContextUpdateState.b), (a2, a3) -> {
            if (a3 == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
                return true;
            }
            return false;
        });
    }
}

