/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.admin.eventprocessor.requestprocessor;

import io.axoniq.axonserver.AxonServerEnterpriseGrpcMetricsConfig;
import io.axoniq.axonserver.admin.Instruction;
import io.axoniq.axonserver.admin.InstructionCache;
import io.axoniq.axonserver.admin.eventprocessor.api.EventProcessor;
import io.axoniq.axonserver.admin.eventprocessor.api.EventProcessorAdminService;
import io.axoniq.axonserver.admin.eventprocessor.api.EventProcessorId;
import io.axoniq.axonserver.admin.eventprocessor.api.Result;
import io.axoniq.axonserver.admin.eventprocessor.requestprocessor.DistributedEventProcessor;
import io.axoniq.axonserver.admin.eventprocessor.requestprocessor.E;
import io.axoniq.axonserver.admin.eventprocessor.requestprocessor.InstructionInformation;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.component.processor.EventProcessorIdentifier;
import io.axoniq.axonserver.component.processor.ProcessorEventPublisher;
import io.axoniq.axonserver.component.processor.balancing.LoadBalancingStrategy;
import io.axoniq.axonserver.component.processor.balancing.strategy.LoadBalanceStrategyRepository;
import io.axoniq.axonserver.component.processor.listener.ClientProcessor;
import io.axoniq.axonserver.component.processor.listener.ClientProcessors;
import io.axoniq.axonserver.configuration.common.CommonConfigurationFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ClientContext;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.rest.json.CommandRequestJson;
import io.axoniq.axonserver.util.ConstraintCache;
import io.axoniq.axonserver.util.StringUtils;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
public class LocalEventProcessorsAdminService
implements EventProcessorAdminService {
    private final Logger c;
    protected final Flux<ClientProcessor> j;
    private final ProcessorEventPublisher H;
    private final CommonConfigurationFactory m;
    protected final LoadBalanceStrategyRepository h;
    protected static final Logger b = AuditLog.getLogger();
    private final ConstraintCache<String, Instruction> I;

    @Nonnull
    public Flux<EventProcessor> eventProcessors(@Nonnull Authentication a3) {
        return this.j.transform(a2 -> a2.groupBy(EventProcessorIdentifier::new).flatMap(a4 -> a4.timeout(Duration.ofMillis(100L)).onErrorResume(a2 -> Flux.empty()).collectList().map(a3 -> new DistributedEventProcessor((EventProcessorId)a4.key(), a3))));
    }

    @Autowired
    public LocalEventProcessorsAdminService(ProcessorEventPublisher a2, ClientProcessors a3, InstructionCache a4, LoadBalanceStrategyRepository a5, CommonConfigurationFactory a6) {
        a7(a2, Flux.fromIterable((Iterable)a3), (ConstraintCache)a4, a5, a6);
        LocalEventProcessorsAdminService a7;
    }

    public LocalEventProcessorsAdminService(ProcessorEventPublisher a2, Flux<ClientProcessor> a3, ConstraintCache<String, Instruction> a4, LoadBalanceStrategyRepository a5, CommonConfigurationFactory a6) {
        LocalEventProcessorsAdminService a7;
        LocalEventProcessorsAdminService localEventProcessorsAdminService = a7;
        LocalEventProcessorsAdminService localEventProcessorsAdminService2 = a7;
        LocalEventProcessorsAdminService localEventProcessorsAdminService3 = a7;
        localEventProcessorsAdminService3.c = LoggerFactory.getLogger(LocalEventProcessorsAdminService.class);
        localEventProcessorsAdminService3.H = a2;
        localEventProcessorsAdminService2.j = a3;
        localEventProcessorsAdminService2.I = a4;
        localEventProcessorsAdminService.h = a5;
        localEventProcessorsAdminService.m = a6;
    }

    private /* synthetic */ boolean K(EventProcessorIdentifier a2, ClientProcessor a3) {
        LocalEventProcessorsAdminService a4;
        return a4.g(a3, (EventProcessorId)a2);
    }

    @Nonnull
    public Iterable<LoadBalancingStrategy> getBalancingStrategies(@Nonnull Authentication a2) {
        b.debug(AxonServerEnterpriseGrpcMetricsConfig.g((Object)"\u001bt=R`]%~5j3{`{//,f3{`c/n$\"\"n,n.l)a'/3{2n4j'f%|n"), (Object)AuditLog.username((String)a2.username()));
        return this.h.findAll();
    }

    private /* synthetic */ void g(String a2, int a3, String a4, ClientProcessor a5) {
        LocalEventProcessorsAdminService a6;
        a6.H.releaseSegment(a5.context(), a5.clientId(), a2, a3, a4);
    }

    @Nonnull
    public Mono<Result> split(@Nonnull EventProcessorId identifier, @Nonnull Authentication a5) {
        String string = identifier.name();
        String string2 = "Split " + string;
        String string3 = identifier.tokenStoreIdentifier();
        return this.j.doFirst(() -> {
            if (b.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a5.username());
                objectArray[1] = StringUtils.sanitize((String)string);
                objectArray[2] = StringUtils.sanitize((String)string3);
                b.info(CommandRequestJson.g((Object)"\u0004E\"c\u007fl:O*[,J\u007fJ0\u001e,N3W+\u001e>\u001e,[8S:P+\u001e0X\u007f{)[1J\u007fN-Q<[,M0L\u007f\u001c$C\u001fE\"\u001cq"), objectArray);
            }
        }).filter(a3 -> {
            LocalEventProcessorsAdminService a4;
            return a4.g(a3, identifier);
        }).flatMap(a2 -> Flux.fromIterable((Iterable)a2.eventProcessorInfo().getSegmentStatusList()).map(a3 -> new E(a2.clientId(), a2.context(), a3.getSegmentId(), a3.getOnePartOf()))).reduce((a2, a3) -> {
            if (a2.h < a3.h) {
                return a2;
            }
            return a3;
        }).switchIfEmpty(Mono.error((Throwable)new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_NOT_FOUND, CommandRequestJson.g((Object)"\u001aH:P+\u001e/L0]:M,Q-\u001e1Q+\u001e9Q*P;")))).flatMap(a4 -> {
            LocalEventProcessorsAdminService a6;
            return Mono.create(a5 -> {
                LocalEventProcessorsAdminService a6;
                String string = UUID.randomUUID().toString();
                a6.I.put((Object)string, (Object)new InstructionInformation(a5, string, string2, Collections.singleton(a3.b)));
                E e2 = a4;
                a6.H.splitSegment(e2.m, e2.b, string, a3.I, string);
            });
        }).doOnError(a3 -> {
            LocalEventProcessorsAdminService a4;
            a4.K(string2, a3);
        });
    }

    @Nonnull
    public Mono<Result> merge(@Nonnull EventProcessorId identifier, @Nonnull Authentication a5) {
        String string = identifier.name();
        String string2 = "Merge " + string;
        String string3 = identifier.tokenStoreIdentifier();
        return this.j.doFirst(() -> {
            if (b.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a5.username());
                objectArray[1] = StringUtils.sanitize((String)string);
                objectArray[2] = StringUtils.sanitize((String)string3);
                b.info(AxonServerEnterpriseGrpcMetricsConfig.g((Object)"\u001bt=R`]%~5j3{`{//-j2h%/!/3j'b%a4//i`J6j.{`\u007f2`#j3|/}`-;r\u0000t=-n"), objectArray);
            }
        }).filter(a3 -> {
            LocalEventProcessorsAdminService a4;
            return a4.g(a3, identifier);
        }).flatMap(a2 -> Flux.fromIterable((Iterable)a2.eventProcessorInfo().getSegmentStatusList()).map(a3 -> new E(a2.clientId(), a2.context(), a3.getSegmentId(), a3.getOnePartOf()))).collectList().flatMap(a4 -> {
            LocalEventProcessorsAdminService a5;
            return Mono.create(a8 -> {
                LocalEventProcessorsAdminService a9;
                String string = UUID.randomUUID().toString();
                E e2 = (E)a4.stream().reduce((a2, a3) -> {
                    if (a2.h > a3.h) {
                        return a2;
                    }
                    return a3;
                }).orElseThrow(() -> new IllegalArgumentException("No segments found for processor name [" + string + "]"));
                int a42 = a9.g(e2);
                a4.stream().map(a2 -> {
                    E e2 = a2;
                    return new ClientContext(e2.b, e2.m);
                }).distinct().filter(a3 -> {
                    if (!a2.b.equals(a3.clientId())) {
                        return true;
                    }
                    return false;
                }).forEach(a5 -> {
                    LocalEventProcessorsAdminService a6;
                    a6.H.releaseSegment(a5.context(), a5.clientId(), string, a42, string);
                });
                a9.I.put((Object)string, (Object)new InstructionInformation(a8, string, string2, Collections.singleton(e2.b)));
                E e3 = e2;
                a9.H.mergeSegment(e3.m, e3.b, string, e2.I, string);
            });
        }).doOnError(a3 -> {
            LocalEventProcessorsAdminService a4;
            a4.K(string2, a3);
        });
    }

    @Nonnull
    public Mono<Result> start(@Nonnull EventProcessorId identifier, @Nonnull Authentication a2) {
        String string = identifier.name();
        String string2 = "Start " + string;
        return this.j.doFirst(() -> {
            if (b.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a2.username());
                objectArray[1] = StringUtils.sanitize((String)string);
                objectArray[2] = StringUtils.sanitize((String)identifier.tokenStoreIdentifier());
                b.info(CommandRequestJson.g((Object)"e$C\u0002\u001e\r[.K:M+\u001e+Q\u007fM+_-J\u007f{)[1J\u007fN-Q<[,M0L\u007f\u001c$C\u001fE\"\u001cq"), objectArray);
            }
        }).filter(a3 -> {
            LocalEventProcessorsAdminService a4;
            return a4.g(a3, identifier);
        }).collectList().flatMap(a4 -> {
            LocalEventProcessorsAdminService a5;
            return Mono.create(a6 -> {
                LocalEventProcessorsAdminService a7;
                if (a4.isEmpty()) {
                    a6.error((Throwable)new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_NOT_FOUND, CommandRequestJson.g((Object)"\u001aH:P+\u001e/L0]:M,Q-\u001e1Q+\u001e9Q*P;")));
                    return;
                }
                String string = UUID.randomUUID().toString();
                Set set = a4.stream().map(ClientProcessor::clientId).collect(Collectors.toSet());
                LocalEventProcessorsAdminService localEventProcessorsAdminService = a7;
                localEventProcessorsAdminService.I.put((Object)string, (Object)new InstructionInformation(a6, string, string2, set));
                a4.forEach(a4 -> {
                    LocalEventProcessorsAdminService a5;
                    a5.H.startProcessorRequest(a4.context(), a4.clientId(), string, string);
                });
            });
        }).doOnError(a3 -> {
            LocalEventProcessorsAdminService a4;
            a4.K(string2, a3);
        });
    }

    @Nonnull
    public Mono<Void> loadBalance(@Nonnull EventProcessorId processor, @Nonnull String strategy, @Nonnull Authentication a2) {
        return this.j.filter(a3 -> {
            LocalEventProcessorsAdminService a4;
            return a4.g(a3, processor);
        }).map(a3 -> {
            LocalEventProcessorsAdminService a4;
            return a4.m.trackingEventProcessor(processor.name(), a3.context(), processor.tokenStoreIdentifier());
        }).flatMap(a3 -> {
            LocalEventProcessorsAdminService a4;
            return Mono.fromRunnable(() -> {
                LocalEventProcessorsAdminService a4;
                a4.h.findByName(strategy).balance(a3).perform();
            }).subscribeOn(Schedulers.boundedElastic());
        }).then().doFirst(() -> {
            if (b.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a2.username());
                objectArray[1] = processor;
                objectArray[2] = strategy;
                b.info(CommandRequestJson.g((Object)"\u0004E\"c\u007fl:O*[,J\u007fJ0\u001e,[+\u001e3Q>Zr\\>R>P<W1Y\u007fM+L>J:Y&\u001e9Q-\u001e/L0]:M,Q-\u001e}E\"\u001c\u007fJ0\u001e}E\"\u001cq"), objectArray);
            }
        });
    }

    @Nonnull
    public Mono<Void> setAutoLoadBalanceStrategy(@Nonnull EventProcessorId processor, @Nonnull String strategy, @Nonnull Authentication a2) {
        return Mono.error((Throwable)new UnsupportedOperationException(CommandRequestJson.g((Object)"\u007f*J0\u001e3Q>Z\u007f\\>R>P<W1Y\u007fW,\u001e1Q+\u001e,K/N0L+[;")));
    }

    private /* synthetic */ boolean g(EventProcessorIdentifier a2, ClientProcessor a3) {
        LocalEventProcessorsAdminService a4;
        return a4.g(a3, (EventProcessorId)a2);
    }

    private /* synthetic */ void K(String a2, Throwable a3) {
        LocalEventProcessorsAdminService a4;
        if (ErrorCode.fromException((Throwable)a3).isClientException()) {
            a4.c.info(CommandRequestJson.g((Object)"$C\u007fX>W3[;"), (Object)a2, (Object)a3);
            return;
        }
        a4.c.warn(AxonServerEnterpriseGrpcMetricsConfig.g((Object)";r`i!f,j$"), (Object)a2, (Object)a3);
    }

    private /* synthetic */ int g(E a22) {
        E e2 = a22;
        int a22 = e2.h >>> 1;
        return e2.I ^ a22;
    }

    @Nonnull
    public Flux<String> clientsBy(@Nonnull EventProcessorId identifier, @Nonnull Authentication a2) {
        EventProcessorId eventProcessorId = identifier;
        String string = eventProcessorId.name();
        String string2 = eventProcessorId.tokenStoreIdentifier();
        if (b.isInfoEnabled()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((String)a2.username());
            objectArray[1] = StringUtils.sanitize((String)string);
            objectArray[2] = StringUtils.sanitize((String)string2);
            b.info(AxonServerEnterpriseGrpcMetricsConfig.g((Object)"T;r\u001d/\u0012j1z%|4/&`2/!/,f3{``&/#c)j.{3/4g!{`l/a4n)a3/4g%/0}/l%|3`2/bt=-`O`-;rb"), objectArray);
        }
        identifier = new EventProcessorIdentifier(string, identifier.context(), string2);
        return this.j.filter(arg_0 -> this.K((EventProcessorIdentifier)identifier, arg_0)).map(ClientProcessor::clientId).distinct();
    }

    @Nonnull
    public Flux<EventProcessor> eventProcessorsByComponent(@Nonnull String component, @Nonnull Authentication a3) {
        if (b.isInfoEnabled()) {
            b.debug(AxonServerEnterpriseGrpcMetricsConfig.g((Object)"T;r\u001d/\u0012j1z%|4/4``c)|4/\u0005y%a4/0}/l%|3`2|`f./#`-\u007f/a%a4/bt=-n"), (Object)AuditLog.username((String)a3.username()), (Object)StringUtils.sanitize((String)component));
        }
        return this.j.filterWhen(a4 -> {
            LocalEventProcessorsAdminService a5;
            return a5.j.filter(a3 -> a3.belongsToComponent(component)).map(EventProcessorIdentifier::new).map(a3 -> a3.g((EventProcessorId)new EventProcessorIdentifier(a4))).reduce(Boolean::logicalOr);
        }).transform(a2 -> a2.groupBy(EventProcessorIdentifier::new).flatMap(a4 -> a4.timeout(Duration.ofMillis(100L)).onErrorResume(a2 -> Flux.empty()).collectList().map(a3 -> new DistributedEventProcessor((EventProcessorId)a4.key(), a3))));
    }

    private /* synthetic */ boolean g(ClientProcessor a2, EventProcessorId a3) {
        if (a2.eventProcessorInfo().getProcessorName().equals(a3.name()) && a2.eventProcessorInfo().getTokenStoreIdentifier().equals(a3.tokenStoreIdentifier()) && a2.context().equals(a3.context())) {
            return true;
        }
        return false;
    }

    @Nonnull
    public Mono<Result> move(@Nonnull EventProcessorId identifier, int segment, @Nonnull String target, @Nonnull Authentication a2) {
        EventProcessorId eventProcessorId = identifier;
        String string = eventProcessorId.name();
        String string2 = eventProcessorId.tokenStoreIdentifier();
        String string3 = "Move " + string;
        string2 = new EventProcessorIdentifier(string, identifier.context(), string2);
        return this.j.doFirst(() -> {
            if (b.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a2.username());
                objectArray[1] = StringUtils.sanitize((String)string);
                objectArray[2] = StringUtils.sanitize((String)identifier.tokenStoreIdentifier());
                b.info(CommandRequestJson.g((Object)"e$C\u0002\u001e\r[.K:M+\u001e+Q\u007fM+_-J\u007f{)[1J\u007fN-Q<[,M0L\u007f\u001c$C\u001fE\"\u001cq"), objectArray);
            }
        }).filter(arg_0 -> this.g((EventProcessorIdentifier)string2, arg_0)).collectList().flatMap(a6 -> {
            LocalEventProcessorsAdminService a7;
            return Mono.create(a8 -> {
                LocalEventProcessorsAdminService a9;
                Object object = a6.stream().filter(a3 -> target.equals(a3.clientId())).findFirst();
                if (!((Optional)object).isPresent()) {
                    a8.error((Throwable)new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_MOVE_UNKNOWN_TARGET, AxonServerEnterpriseGrpcMetricsConfig.g((Object)"\u0014n2h%{`i/}`b/y%/.`4/&`5a$")));
                    return;
                }
                Object object2 = ((Optional)object).get().eventProcessorInfo().getSegmentStatusList();
                if (object2.stream().anyMatch(a3 -> {
                    if (a3.getSegmentId() == segment) {
                        return true;
                    }
                    return false;
                })) {
                    a8.success();
                    return;
                }
                if (((Optional)object).get().eventProcessorInfo().getAvailableThreads() < 1) {
                    a8.error((Throwable)new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_MOVE_NO_AVAILBLE_THREADS, CommandRequestJson.g((Object)"p0\u001e>H>W3_=R:\u001e+V-[>Z,\u001e0P\u007fJ>L8[+")));
                    return;
                }
                object2 = UUID.randomUUID().toString();
                object = a6.stream().map(ClientProcessor::clientId).filter(a3 -> {
                    if (!target.equals(a3)) {
                        return true;
                    }
                    return false;
                }).collect(Collectors.toSet());
                if (object.isEmpty()) {
                    a8.error((Throwable)new MessagingPlatformException(ErrorCode.OTHER, AxonServerEnterpriseGrpcMetricsConfig.g((Object)"\u000e```4g%}`l,f%a4/(n3/#c!f-j$/4g%/3j'b%a4")));
                    return;
                }
                a9.I.put(object2, (Object)new InstructionInformation(a8, (String)object2, string3, (Set)object));
                a6.stream().filter(a3 -> {
                    if (!target.equals(a3.clientId())) {
                        return true;
                    }
                    return false;
                }).forEach(arg_0 -> a9.g(string, segment, (String)object2, arg_0));
            });
        }).doOnError(a3 -> {
            LocalEventProcessorsAdminService a4;
            a4.K(string3, a3);
        });
    }

    @Nonnull
    public Mono<Result> pause(@Nonnull EventProcessorId identifier, @Nonnull Authentication a2) {
        String string = identifier.name();
        String string2 = "Pause " + string;
        return this.j.doFirst(() -> {
            if (b.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a2.username());
                objectArray[1] = StringUtils.sanitize((String)string);
                objectArray[2] = StringUtils.sanitize((String)identifier.tokenStoreIdentifier());
                b.info(AxonServerEnterpriseGrpcMetricsConfig.g((Object)"T;r\u001d/\u0012j1z%|4/4``\u007f!z3j`J6j.{`\u007f2`#j3|/}`-;r\u0000t=-n"), objectArray);
            }
        }).filter(a3 -> {
            LocalEventProcessorsAdminService a4;
            return a4.g(a3, identifier);
        }).collectList().flatMap(a4 -> {
            LocalEventProcessorsAdminService a5;
            return Mono.create(a6 -> {
                LocalEventProcessorsAdminService a7;
                if (a4.isEmpty()) {
                    a6.error((Throwable)new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_NOT_FOUND, AxonServerEnterpriseGrpcMetricsConfig.g((Object)"\u0005y%a4/0}/l%|3`2/.`4/&`5a$")));
                    return;
                }
                String string = UUID.randomUUID().toString();
                Set set = a4.stream().map(ClientProcessor::clientId).collect(Collectors.toSet());
                LocalEventProcessorsAdminService localEventProcessorsAdminService = a7;
                localEventProcessorsAdminService.I.put((Object)string, (Object)new InstructionInformation(a6, string, string2, set));
                a4.forEach(a4 -> {
                    LocalEventProcessorsAdminService a5;
                    a5.H.pauseProcessorRequest(a4.context(), a4.clientId(), string, string);
                });
            });
        }).doOnError(a3 -> {
            LocalEventProcessorsAdminService a4;
            a4.K(string2, a3);
        });
    }
}

