/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.admin.replicationgroup.requestprocessor;

import io.axoniq.axonserver.admin.replicationgroup.api.JoinReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.LeaveReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.NodeOverviewInfo;
import io.axoniq.axonserver.admin.replicationgroup.api.RemoveReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroupAdminService;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroupMember;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroupOverview;
import io.axoniq.axonserver.admin.replicationgroup.api.Role;
import io.axoniq.axonserver.admin.replicationgroup.requestprocessor.G;
import io.axoniq.axonserver.admin.replicationgroup.requestprocessor.K;
import io.axoniq.axonserver.admin.replicationgroup.requestprocessor.UpdateReplicationGroupPayload;
import io.axoniq.axonserver.admin.replicationgroup.requestprocessor.UpdateReplicationGroupTask;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.configuration.AdminUtils;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroups;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.AdminReplicationGroupController;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ReplicationGroupMemberConverter;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.plugin.PluginConfigurationManager;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.axoniq.axonserver.taskscheduler.task.AddNodeToExistingReplicationGroupTask;
import io.axoniq.axonserver.taskscheduler.task.PrepareDeleteNodeFromContextTask;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ReplicationGroupAdminRequestProcessor
implements ReplicationGroupAdminService {
    private final TaskPublisher i;
    private static final Logger G = AuditLog.getLogger();
    private final AdminReplicationGroupController f;
    private final Logger c;
    private final AddNodeToExistingReplicationGroupTask j;
    private final ClusterController H;
    private final Predicate<String> m;
    private final AdminReplicationGroups h;
    private final RaftConfigServiceFactory b;
    private final PrepareDeleteNodeFromContextTask I;

    private /* synthetic */ Role g(io.axoniq.axonserver.grpc.cluster.Role a2) {
        return Role.valueOf((String)a2.name());
    }

    @Nonnull
    public Mono<ReplicationGroupOverview> getReplicationGroup(@Nonnull String replicationGroupName, @Nonnull Authentication a2) {
        return Mono.fromCallable(() -> {
            ReplicationGroupAdminRequestProcessor a5;
            if (G.isInfoEnabled()) {
                G.info(PluginConfigurationManager.g((Object)"^Pxv%y`ZpNv_%_j\u000biBv_%Y`[iBfJqBjE%LwDp[v\u0005"), (Object)AuditLog.username((String)a2.username()));
            }
            return a5.h.findByName(replicationGroupName).map(a2 -> ReplicationGroupAdminRequestProcessor.g((AdminReplicationGroup)a2)).orElseThrow(() -> new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, PluginConfigurationManager.g((Object)"y`[iBfJqBjE%LwDp[%Ej_%Mj^kO")));
        });
    }

    @Nonnull
    public Mono<Void> addNodeToReplicationGroup(@Nonnull JoinReplicationGroup request, @Nonnull Authentication a4) {
        return Mono.defer(() -> {
            ReplicationGroupAdminRequestProcessor a4;
            if (G.isInfoEnabled()) {
                Object[] objectArray = new Object[4];
                objectArray[0] = AuditLog.username((String)a4.username());
                objectArray[1] = request.node();
                objectArray[2] = request.replicationGroup();
                objectArray[3] = request.role();
                G.info(PluginConfigurationManager.g((Object)"p~VX\u000bWNt^`Xq\u000bqD%JaO%EjO`\u000b~V%_j\u000bwNuGlHd_lDk\u000bbYj^u\u000b~V%\\l_m\u000bwDiN%Px\u0005"), objectArray);
            }
            JoinReplicationGroup joinReplicationGroup = request;
            a4 = joinReplicationGroup.node();
            String string = joinReplicationGroup.replicationGroup();
            Object[] objectArray = new Object[3];
            objectArray[0] = a4;
            objectArray[1] = string;
            objectArray[2] = request.role();
            a4.c.info(TaskPublisher.g((Object)"\u001a)?m5\"?({?><.((9{?>.>$-(?m=\")m5\"?(am 0{`{,5){?>=7$8,/$4#{*)\".=am 0{`{:293m)\"7(am 0u"), objectArray);
            if (!a4.f.findByName(string).isPresent()) {
                String string2 = "[" + ErrorCode.REPLICATION_GROUP_NOT_FOUND + "] Replication group " + string + " not found";
                return Mono.error((Throwable)new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, string2));
            }
            ClusterNode clusterNode = a4.H.getNode((String)a4);
            if (clusterNode == null) {
                String string3 = "[" + ErrorCode.NO_SUCH_NODE + "] Node " + (String)a4 + " not found";
                return Mono.error((Throwable)new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, string3));
            }
            if (clusterNode.getReplicatorGroupNames().contains(string)) {
                String string4 = "Replication group " + string + " already contains node " + (String)a4;
                return Mono.error((Throwable)new IllegalStateException(string4));
            }
            io.axoniq.axonserver.grpc.cluster.Role role = request.role() == null ? io.axoniq.axonserver.grpc.cluster.Role.PRIMARY : io.axoniq.axonserver.grpc.cluster.Role.valueOf((String)Objects.requireNonNull(request.role()).name());
            return Mono.fromCompletionStage((CompletionStage)a4.j.addNode((String)a4, string, role));
        }).then().doOnError(a3 -> {
            ReplicationGroupAdminRequestProcessor a4;
            Object[] objectArray = new Object[2];
            objectArray[0] = request.replicationGroup();
            objectArray[1] = request.node();
            a4.g(a3, TaskPublisher.g((Object)" 0am>?)\")m,%2!>m:)?$5*{6&"), objectArray);
        }).onErrorMap(a2 -> MessagingPlatformException.create((Throwable)a2));
    }

    private /* synthetic */ void g(Throwable a2, String a3, Object ... a4) {
        ReplicationGroupAdminRequestProcessor a5;
        if (MessagingPlatformException.isClientException((Throwable)a2)) {
            a5.c.info(a3, (Object)a4, (Object)a2);
            return;
        }
        a5.c.warn(a3, (Object)a4, (Object)a2);
    }

    @Nonnull
    public Mono<Void> removeNodeFromReplicationGroup(@Nonnull LeaveReplicationGroup request, @Nonnull Authentication a4) {
        return Mono.defer(() -> {
            ReplicationGroupAdminRequestProcessor a4;
            if (G.isInfoEnabled()) {
                Object[] objectArray = new Object[4];
                objectArray[0] = AuditLog.username((String)a4.username());
                objectArray[1] = request.node();
                objectArray[2] = request.replicationGroup();
                objectArray[3] = request.preserveEventStore();
                G.info(TaskPublisher.g((Object)"\u0016 0\u0006m\t(*8>>/m/\"{)>!>9>m5\"?({6&m=?4 {?>=7$8,/$4#{*)\".={6&m+?>>>?-({(-(59(m(94?>>{m 0u"), objectArray);
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = request.node();
            objectArray[1] = request.replicationGroup();
            objectArray[2] = request.preserveEventStore() ? TaskPublisher.g((Object)"vm\u0010(>=2#<m>;>#/m(94?>") : "";
            a4.c.info(PluginConfigurationManager.g((Object)"ANiNqN%EjO`\u000bwNt^`Xq\u000bwNfNl]`O%MjY%EjO`\u0011%Px\u000b(\u000bdEa\u000bwNuGlHd_lDk\u000bbYj^u\u0011%Px\u000b~V"), objectArray);
            return Mono.fromCompletionStage((CompletionStage)a4.I.prepareDeleteNodeFromContext(request.replicationGroup(), request.node(), request.preserveEventStore()));
        }).then().doOnError(a3 -> {
            ReplicationGroupAdminRequestProcessor a4;
            Object[] objectArray = new Object[2];
            objectArray[0] = request.replicationGroup();
            objectArray[1] = request.node();
            a4.g(a3, TaskPublisher.g((Object)" 0am>?)\")m,%2!>m)(6\"-$5*{6&"), objectArray);
        }).onErrorMap(a2 -> MessagingPlatformException.create((Throwable)a2));
    }

    private static /* synthetic */ void g(Map a2, ClusterNode a3) {
        a2.put(a3.getName(), a3);
    }

    private static /* synthetic */ boolean g(Map a2, String a3) {
        if (!a2.containsKey(a3)) {
            return true;
        }
        return false;
    }

    @Nonnull
    public Mono<Void> createReplicationGroup(@Nonnull ReplicationGroup request, @Nonnull Authentication a2) {
        return Mono.fromRunnable(() -> {
            ReplicationGroupAdminRequestProcessor a4;
            if (G.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a2.username());
                objectArray[1] = request.name();
                objectArray[2] = request.members();
                G.info(PluginConfigurationManager.g((Object)"^Pxv%y`ZpNv_%_j\u000bfY`JqN%Y`[iBfJqBjE%LwDp[%Px\u000brBqC%EjO`X%Px\u0005"), objectArray);
            }
            ReplicationGroupAdminRequestProcessor replicationGroupAdminRequestProcessor = a4;
            replicationGroupAdminRequestProcessor.c.info(TaskPublisher.g((Object)"\u0018?>,/({?><.((9{?>.>$-(?m=\")m)(+!2.:92\"5m<?48+w{6&"), (Object)request.name());
            if (!replicationGroupAdminRequestProcessor.m.test(request.name())) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, PluginConfigurationManager.g((Object)"LEsJiBa\u000bwNuGlHd_lDk\u000bbYj^u\u000bkJhN"));
            }
            if (!request.members().isEmpty()) {
                a2 = new HashMap();
                a4.H.activeNodes().forEach(arg_0 -> ReplicationGroupAdminRequestProcessor.g((Map)a2, arg_0));
                a2 = request.members().stream().map(ReplicationGroupMember::nodeName).filter(arg_0 -> ReplicationGroupAdminRequestProcessor.g((Map)a2, arg_0)).collect(Collectors.toSet());
                if (!a2.isEmpty()) {
                    throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_CREATION_NOT_ALLOWED, "Node is not active: " + (Set)a2);
                }
            } else {
                throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_CREATION_NOT_ALLOWED, TaskPublisher.g((Object)"\u001a)?m:9{!>,(9{\"5({#4)>m=\")m/%>m:=+!2.:92\"5m<?48+"));
            }
            a4.b.getRaftConfigService().createReplicationGroup(request.name(), (Collection)request.members().stream().map(ReplicationGroupMemberConverter::asReplicationGroupMember).collect(Collectors.toList()));
        }).doOnError(a3 -> {
            ReplicationGroupAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = request.name();
            a4.g(a3, PluginConfigurationManager.g((Object)"~V?\u000b@YwDw\u000brClG`\u000bfY`JqBkL%Y`[iBfJqBjE%LwDp["), objectArray);
        });
    }

    @Nonnull
    public Flux<NodeOverviewInfo> getNodes(@Nonnull Authentication a3) {
        return Flux.fromStream((Stream)this.H.nodes()).doFirst(() -> {
            if (G.isInfoEnabled()) {
                G.info(TaskPublisher.g((Object)"\u00006&\u0010{\u001f><.((9{94m7$(9{,7!{#4)>>{$5+4?6,/$4#u"), (Object)AuditLog.username((String)a3.username()));
            }
        }).map(a2 -> {
            ReplicationGroupAdminRequestProcessor a3;
            return new K(a3, a2);
        });
    }

    @NotNull
    public Mono<String> updateReplicationGroup(@NotNull ReplicationGroup updated, boolean preserve, @NotNull Authentication a4) {
        Object object = (AdminReplicationGroup)this.f.findByName(updated.name()).orElseThrow(() -> new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, updated.name() + ": not found"));
        HashMap<String, Role> hashMap = new HashMap<String, Role>();
        object.getMembers().forEach(a3 -> {
            ReplicationGroupAdminRequestProcessor a4;
            hashMap.put(a3.getClusterNode().getName(), a4.g(a3.getRole()));
        });
        object = new ArrayList();
        ArrayList arrayList = new ArrayList();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        if (updated.members().stream().noneMatch(a2 -> a2.role().equals((Object)Role.c))) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_CREATION_NOT_ALLOWED, TaskPublisher.g((Object)"\u00034m5\"?((m,$/%{=)$6,)4{?4!>m(=>.2+2(?"));
        }
        updated.members().forEach(arg_0 -> ReplicationGroupAdminRequestProcessor.g(hashMap, (List)object, arrayList, hashMap2, hashMap3, arg_0));
        hashMap.forEach((a5, a6) -> {
            if (a6.equals((Object)Role.c)) {
                hashMap2.put(a5, preserve);
                return;
            }
            hashMap3.put(a5, preserve);
        });
        UpdateReplicationGroupPayload updateReplicationGroupPayload = preserve = new UpdateReplicationGroupPayload();
        preserve.setReplicationGroup(updated.name());
        updateReplicationGroupPayload.setAddPrimaryNodes((List)object);
        updateReplicationGroupPayload.setDeleteNodes(hashMap3.entrySet().stream().map(a2 -> new UpdateReplicationGroupPayload.DeleteNode((String)a2.getKey(), ((Boolean)a2.getValue()).booleanValue())).collect(Collectors.toList()));
        preserve.setDeletePrimaryNodes(hashMap2.entrySet().stream().map(a2 -> new UpdateReplicationGroupPayload.DeleteNode((String)a2.getKey(), ((Boolean)a2.getValue()).booleanValue())).collect(Collectors.toList()));
        UpdateReplicationGroupPayload updateReplicationGroupPayload2 = preserve;
        updateReplicationGroupPayload2.setAddNodes(arrayList);
        updateReplicationGroupPayload2.setPrincipal(a4.username());
        return Mono.fromFuture(() -> {
            ReplicationGroupAdminRequestProcessor a3;
            return a3.i.publishScheduledTask(AdminUtils.getAdmin(), UpdateReplicationGroupTask.class.getName(), (Object)updateReplicationGroupPayload2, Duration.ZERO);
        });
    }

    @Nonnull
    public Flux<ReplicationGroupOverview> getReplicationGroups(@Nonnull Authentication a2) {
        return Flux.defer(() -> {
            ReplicationGroupAdminRequestProcessor a3;
            return Flux.fromStream((Stream)a3.h.findAll()).map(a2 -> new G(a2)).onErrorMap(a2 -> MessagingPlatformException.create((Throwable)a2));
        }).doFirst(() -> G.info(PluginConfigurationManager.g((Object)"^Pxv%y`ZpNv_`O%_j\u000biBv_%JiG%Y`[iBfJqBjE%LwDp[v\u0005"), (Object)AuditLog.username((String)a2.username())));
    }

    public ReplicationGroupAdminRequestProcessor(RaftConfigServiceFactory a2, ClusterController a3, PrepareDeleteNodeFromContextTask a4, AdminReplicationGroups a5, AdminReplicationGroupController a6, AddNodeToExistingReplicationGroupTask a7, TaskPublisher a8) {
        ReplicationGroupAdminRequestProcessor a9;
        ReplicationGroupAdminRequestProcessor replicationGroupAdminRequestProcessor = a9;
        ReplicationGroupAdminRequestProcessor replicationGroupAdminRequestProcessor2 = a9;
        ReplicationGroupAdminRequestProcessor replicationGroupAdminRequestProcessor3 = a9;
        ReplicationGroupAdminRequestProcessor replicationGroupAdminRequestProcessor4 = a9;
        replicationGroupAdminRequestProcessor4.c = LoggerFactory.getLogger(ReplicationGroupAdminRequestProcessor.class);
        ReplicationGroupAdminRequestProcessor replicationGroupAdminRequestProcessor5 = a9;
        replicationGroupAdminRequestProcessor4.m = new ContextNameValidation();
        replicationGroupAdminRequestProcessor4.b = a2;
        replicationGroupAdminRequestProcessor3.H = a3;
        replicationGroupAdminRequestProcessor3.I = a4;
        replicationGroupAdminRequestProcessor2.h = a5;
        replicationGroupAdminRequestProcessor2.f = a6;
        replicationGroupAdminRequestProcessor.j = a7;
        replicationGroupAdminRequestProcessor.i = a8;
    }

    @Nonnull
    public Mono<Void> deleteReplicationGroup(@Nonnull RemoveReplicationGroup request, @Nonnull Authentication a4) {
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((String)a4.username());
        objectArray[1] = request.name();
        objectArray[2] = request.preserveEventStore();
        G.info(PluginConfigurationManager.g((Object)"p~VX\u000bWNt^`Xq\u000bqD%O`G`_`\u000bwNuGlHd_lDk\u000bbYj^u\u000b~V%[wNvNw]`\u000b`]`Eq\u000bv_jY`X%Px\u0005"), objectArray);
        return Mono.fromRunnable(() -> {
            ReplicationGroupAdminRequestProcessor a3;
            a3.b.getRaftConfigService().deleteReplicationGroup(request.name(), request.preserveEventStore());
        }).doFirst(() -> {
            if (request.name().startsWith(TaskPublisher.g((Object)"\u0004"))) {
                Object[] objectArray = new Object[1];
                objectArray[0] = request.name();
                throw new MessagingPlatformException(ErrorCode.CANNOT_DELETE_INTERNAL_CONTEXT, String.format(PluginConfigurationManager.g((Object)"hdEkDq\u000baNiNqN%Bk_`YkJi\u000bfDk_`Sq\u000b X"), objectArray));
            }
        }).doFirst(() -> {
            ReplicationGroupAdminRequestProcessor a3;
            a3.c.info(PluginConfigurationManager.g((Object)"o`G`_`\u000bwNt^`Xq\u000bwNfNl]`O%MjY%Y`[iBfJqBjE%LwDp[?\u000b~V"), (Object)request.name());
        }).doOnError(a3 -> {
            ReplicationGroupAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = request.name();
            a4.g(a3, TaskPublisher.g((Object)"6&w{()?4?{:3$7({)>!>92#<m)(+!2.:92\"5m<?48+"), objectArray);
        }).onErrorMap(a2 -> MessagingPlatformException.create((Throwable)a2));
    }

    private static /* synthetic */ void g(Map a2, List a3, List a4, Map a5, Map a6, ReplicationGroupMember a7) {
        Role role = a7.role();
        Role role2 = (Role)a2.remove(a7.nodeName());
        if (role2 == null) {
            if (role.equals((Object)Role.c)) {
                a3.add(a7.nodeName());
                return;
            }
            a4.add(new UpdateReplicationGroupPayload.AddNode(a7));
            return;
        }
        if (!role2.equals((Object)role)) {
            if (role2.equals((Object)Role.c)) {
                a5.put(a7.nodeName(), true);
                a4.add(new UpdateReplicationGroupPayload.AddNode(a7));
                return;
            }
            a6.put(a7.nodeName(), true);
            if (role.equals((Object)Role.c)) {
                a3.add(a7.nodeName());
                return;
            }
            a4.add(new UpdateReplicationGroupPayload.AddNode(a7));
        }
    }
}

