/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.admin.user.requestprocessor;

import io.axoniq.axonserver.access.roles.RoleController;
import io.axoniq.axonserver.admin.context.requestprocessor.VisibleContextCache;
import io.axoniq.axonserver.admin.user.api.UserAdminService;
import io.axoniq.axonserver.admin.user.api.UserRole;
import io.axoniq.axonserver.admin.user.requestprocessor.UserController;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.component.processor.ClientEventProcessorInfo;
import io.axoniq.axonserver.configuration.admin.AdminUser;
import io.axoniq.axonserver.configuration.common.Role;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.User;
import io.axoniq.axonserver.grpc.internal.UserContextRole;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.springframework.security.crypto.password.PasswordEncoder;

public class RaftUserAdminService
implements UserAdminService {
    private final PasswordEncoder j;
    private final RaftConfigServiceFactory H;
    private static final String m = "/\\%;";
    private final RoleController h;
    private final UserController b;
    private static final Logger I = AuditLog.getLogger();

    public void createOrUpdateUser(@Nonnull String userName, @Nonnull String password, @Nonnull Set<? extends UserRole> roles, @Nonnull Authentication a3) {
        if (I.isInfoEnabled()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((String)a3.username());
            objectArray[1] = StringUtils.sanitize((String)userName);
            objectArray[2] = roles.stream().map(a2 -> a2.role() + "@" + a2.context()).map(StringUtils::sanitize).collect(Collectors.toSet());
            I.info(ClientEventProcessorInfo.g((Object)"O@if4iqJa^gO4O{\u001bwIqZ`^4Ng^f\u001b6@i\u00194L}O|\u001bfTx^g\u001boF:"), objectArray);
        }
        this.g(userName);
        this.g(roles);
        if (!StringUtils.isEmpty((String)password)) {
            password = this.j.encode((CharSequence)password);
        }
        this.H.getRaftConfigService().updateUser(User.newBuilder().setName(userName).setPassword(StringUtils.getOrDefault((String)password, (String)"")).addAllRoles(this.g(roles)).build());
    }

    @Nonnull
    public List<AdminUser> users(@Nonnull Authentication a2) {
        I.info(VisibleContextCache.g((Object)"V\u007fpY-Vhuxa~p-pb$am~p-q~a\u007fw-ec`-peadv-vbhhw#"), (Object)AuditLog.username((String)a2.username()));
        return this.b.getUsers();
    }

    private /* synthetic */ void g(String a2) {
        int n;
        char[] cArray = a2.toCharArray();
        int n2 = cArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            char c2 = cArray[n];
            if (m.indexOf(c2) >= 0) {
                Object[] objectArray = new Object[2];
                objectArray[0] = a2;
                objectArray[1] = Character.valueOf(c2);
                throw new MessagingPlatformException(ErrorCode.INVALID_NAME, String.format(ClientEventProcessorInfo.g((Object)"\u001eg\u00014RzMuW}_4X|ZfZwOqI4\u00131H=\u001b}U4UuVq"), objectArray));
            }
            n3 = ++n;
        }
    }

    public void deleteUser(@Nonnull String name, @Nonnull Authentication a2) {
        I.info(VisibleContextCache.g((Object)"V\u007fpY-Vhuxa~p-pb$iaaaya-q~a\u007f$/\u007fp&#"), (Object)AuditLog.username((String)a2.username()), (Object)name);
        this.H.getRaftConfigService().deleteUser(User.newBuilder().setName(name).build());
    }

    private /* synthetic */ void g(Set<? extends UserRole> a2) {
        RaftUserAdminService a3;
        Set set = a3.h.listRoles().stream().map(Role::getRole).collect(Collectors.toSet());
        for (String string : a2.stream().map(UserRole::role).distinct().collect(Collectors.toList())) {
            if (set.contains(string)) continue;
            throw new MessagingPlatformException(ErrorCode.UNKNOWN_ROLE, string + ": Role unknown");
        }
    }

    public RaftUserAdminService(UserController a2, PasswordEncoder a3, RaftConfigServiceFactory a4, RoleController a5) {
        RaftUserAdminService a6;
        RaftUserAdminService raftUserAdminService = a6;
        RaftUserAdminService raftUserAdminService2 = a6;
        raftUserAdminService2.b = a2;
        raftUserAdminService2.j = a3;
        raftUserAdminService.H = a4;
        raftUserAdminService.h = a5;
    }

    private /* synthetic */ Iterable<? extends UserContextRole> g(Set<? extends UserRole> a2) {
        ArrayList arrayList = new ArrayList();
        a2.forEach(a3 -> arrayList.add(UserContextRole.newBuilder().setContext(a3.context()).setRole(a3.role()).build()));
        return arrayList;
    }
}

