/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.config;

import io.axoniq.axonserver.access.roles.RoleController;
import io.axoniq.axonserver.admin.user.api.UserAdminService;
import io.axoniq.axonserver.admin.user.requestprocessor.RaftUserAdminService;
import io.axoniq.axonserver.admin.user.requestprocessor.UserController;
import io.axoniq.axonserver.component.processor.balancing.strategy.AdminProcessorLoadBalancingService;
import io.axoniq.axonserver.config.AxonServerStandardConfiguration;
import io.axoniq.axonserver.config.DefaultSSLConnectorCustomizer;
import io.axoniq.axonserver.config.EnterpriseVersionInfoProvider;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.runtime.RuntimeConfigurationFactory;
import io.axoniq.axonserver.configuration.runtime.Tasks;
import io.axoniq.axonserver.enterprise.cluster.ClusterMetricTarget;
import io.axoniq.axonserver.enterprise.cluster.raftfacade.RaftProcessorLoadBalancingControllerFacade;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftController;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.enterprise.replication.group.ReplicationGroupController;
import io.axoniq.axonserver.exception.CriticalEventException;
import io.axoniq.axonserver.licensing.LicenseManager;
import io.axoniq.axonserver.localstorage.EventStoreFactory;
import io.axoniq.axonserver.localstorage.StorageResolver;
import io.axoniq.axonserver.localstorage.file.ClusterTransactionManagerFactory;
import io.axoniq.axonserver.localstorage.file.DatafileEventStoreFactory;
import io.axoniq.axonserver.localstorage.file.DefaultMultiContextEventTransformerFactory;
import io.axoniq.axonserver.localstorage.file.EmbeddedDBPropertiesProvider;
import io.axoniq.axonserver.localstorage.file.LocalTierFactoryRegistry;
import io.axoniq.axonserver.localstorage.file.MultiContextEventTransformerFactory;
import io.axoniq.axonserver.localstorage.transaction.StorageTransactionManagerFactory;
import io.axoniq.axonserver.localstorage.transformation.EventTransformerFactory;
import io.axoniq.axonserver.message.query.MetricsBasedQueryHandlerSelector;
import io.axoniq.axonserver.message.query.QueryHandlerSelector;
import io.axoniq.axonserver.message.query.QueryMetricsRegistry;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricCollector;
import io.axoniq.axonserver.rest.ProcessorLoadBalancingControllerFacade;
import io.axoniq.axonserver.taskscheduler.ScheduledTaskExecutor;
import io.axoniq.axonserver.taskscheduler.StandaloneTaskManager;
import io.axoniq.axonserver.taskscheduler.TaskPayloadSerializer;
import io.axoniq.axonserver.version.VersionInfoProvider;
import java.time.Clock;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.firewall.StrictHttpFirewall;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@AutoConfigureBefore(value={AxonServerStandardConfiguration.class})
public class AxonServerEnterpriseConfiguration {
    @Bean
    public MetricCollector metricCollector() {
        return new ClusterMetricTarget();
    }

    @Bean
    @ConditionalOnMissingBean(value={MultiContextEventTransformerFactory.class})
    public MultiContextEventTransformerFactory multiContextEventTransformerFactory(EventTransformerFactory a2) {
        return new DefaultMultiContextEventTransformerFactory(a2);
    }

    @Bean
    @ConditionalOnMissingBean(value={EventStoreFactory.class})
    public EventStoreFactory eventStoreFactory(EmbeddedDBPropertiesProvider a2, LocalTierFactoryRegistry a3, StorageResolver a4) {
        return new DatafileEventStoreFactory(a2, a3, a4);
    }

    @Bean
    public HttpFirewall allowUrlEncodedSlashHttpFirewall() {
        StrictHttpFirewall strictHttpFirewall = new StrictHttpFirewall();
        strictHttpFirewall.setAllowUrlEncodedSlash(true);
        return strictHttpFirewall;
    }

    @Autowired
    public void g(ServletWebServerFactory a2) {
        if (a2 instanceof TomcatServletWebServerFactory) {
            TomcatConnectorCustomizer[] tomcatConnectorCustomizerArray = new TomcatConnectorCustomizer[1];
            tomcatConnectorCustomizerArray[0] = new DefaultSSLConnectorCustomizer();
            ((TomcatServletWebServerFactory)a2).addConnectorCustomizers(tomcatConnectorCustomizerArray);
        }
    }

    public AxonServerEnterpriseConfiguration() {
        AxonServerEnterpriseConfiguration a2;
    }

    @Bean
    @ConditionalOnMissingBean(value={UserAdminService.class})
    public UserAdminService userControllerFacade(UserController a2, PasswordEncoder a3, RaftConfigServiceFactory a4, RoleController a5) {
        return new RaftUserAdminService(a2, a3, a4, a5);
    }

    @Bean
    @ConditionalOnMissingBean(value={StorageResolver.class})
    public StorageResolver storageResolver(ReplicationGroupController a2, EmbeddedDBPropertiesProvider a3) {
        return new StorageResolver(a2, arg_0 -> ((EmbeddedDBPropertiesProvider)a3).getProperties(arg_0));
    }

    @Bean
    @ConditionalOnMissingBean(value={VersionInfoProvider.class})
    public VersionInfoProvider versionInfoProvider(LicenseManager a2) {
        return new EnterpriseVersionInfoProvider(a2);
    }

    @Bean
    @ConditionalOnMissingBean(value={StorageTransactionManagerFactory.class})
    public StorageTransactionManagerFactory storageTransactionManagerFactory(GrpcRaftController a2, MessagingPlatformConfiguration a3) {
        return new ClusterTransactionManagerFactory(a2, a3);
    }

    @Bean
    public StandaloneTaskManager localTaskManager(ScheduledTaskExecutor taskExecutor, Tasks taskRepository, TaskPayloadSerializer taskPayloadSerializer, PlatformTransactionManager platformTransactionManager, @Qualifier(value="taskScheduler") ScheduledExecutorService scheduler, MeterFactory meterFactory, Clock clock, RuntimeConfigurationFactory a2) {
        return new StandaloneTaskManager(CriticalEventException.g((Object)"F|vsx|"), taskExecutor, taskRepository, taskPayloadSerializer, platformTransactionManager, a2, scheduler, meterFactory, clock);
    }

    @Bean
    @ConditionalOnMissingBean(value={ProcessorLoadBalancingControllerFacade.class})
    public ProcessorLoadBalancingControllerFacade processorLoadBalancingControllerFacade(AdminProcessorLoadBalancingService a2, RaftConfigServiceFactory a3) {
        return new RaftProcessorLoadBalancingControllerFacade(a2, a3);
    }

    @Bean
    @ConditionalOnProperty(name={"axoniq.axonserver.query-handler-selector"}, havingValue="metrics", matchIfMissing=true)
    public QueryHandlerSelector queryHandlerSelector(QueryMetricsRegistry metricsRegistry, @Value(value="${axoniq.axonserver.metrics-query-handler-selector.min-requests:20}") int a2) {
        return new MetricsBasedQueryHandlerSelector(metricsRegistry, a2);
    }
}

