/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.config;

import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.config.HealthStatus;
import io.axoniq.axonserver.enterprise.cluster.internal.LicenseMetrics;
import io.axoniq.axonserver.taskscheduler.TransientException;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.DiskSpaceMetrics;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.system.DiskSpaceHealthIndicatorProperties;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.system.DiskSpaceHealthIndicator;
import org.springframework.context.annotation.Configuration;

@Configuration(value="diskSpace")
public class FileSystemMonitor
extends DiskSpaceHealthIndicator {
    private final DiskSpaceHealthIndicatorProperties H;
    public static final String m = "ROOT";
    private final Map<String, Path> h;
    private final MeterRegistry b;
    private final Logger I = LoggerFactory.getLogger(FileSystemMonitor.class);

    public List<Details> paths() {
        FileSystemMonitor a3;
        return a3.h.entrySet().stream().map(a2 -> {
            try {
                FileSystemMonitor a3;
                FileStore fileStore = Files.getFileStore((Path)a2.getValue());
                return new Details((String)a2.getKey(), a3.g((Path)a2.getValue()).toString(), fileStore.getUsableSpace(), fileStore.getTotalSpace());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }).collect(Collectors.toList());
    }

    private /* synthetic */ void g(Path a22) {
        FileSystemMonitor a3;
        try {
            a22 = a3.g(a22);
            File file = new File(a22.toString());
            new DiskSpaceMetrics(file).bindTo(a3.b);
            return;
        }
        catch (Exception a22) {
            a3.I.error(LicenseMetrics.g((Object)"h\u0014G\u0019K\u0011\u000e\u0001AUL\u001c@\u0011\u000e\u0011G\u0006EUC\u0010Z\u0007G\u0016]T"), (Throwable)a22);
            return;
        }
    }

    public void registerPath(String a2, Path a3) {
        FileSystemMonitor a4;
        FileSystemMonitor fileSystemMonitor = a4;
        fileSystemMonitor.I.info(TransientException.g((Object)"=\u0018\u001e\u001e\u0004\u0018\u0002\u001e\u001e\u0010P\u0011\u0019\u001b\u0015W\u0003\u0003\u001f\u0005\u0015WW\f\rPP\u0016\u0004W\u0000\u0016\u0004\u001fPP\u000b\nW"), (Object)a2, (Object)a3);
        fileSystemMonitor.h.put(a2, a3);
        a4.g(a3);
    }

    private /* synthetic */ Path g(Path a2) throws IOException {
        Path path;
        Path path2;
        Path path3 = a2;
        a2 = Files.getFileStore(path3);
        Path path4 = path2 = (path = path3.toAbsolutePath());
        while ((path = path4.getParent()) != null && a2.equals(Files.getFileStore(path))) {
            path4 = path;
        }
        return path2.normalize();
    }

    public Map<String, Path> getRegisteredPaths() {
        FileSystemMonitor a2;
        return a2.h;
    }

    public FileSystemMonitor(DiskSpaceHealthIndicatorProperties a2, MeterRegistry a3) {
        super(null, null);
        FileSystemMonitor a4;
        FileSystemMonitor fileSystemMonitor = a4;
        a4.h = new ConcurrentHashMap();
        a4.H = a2;
        a4.b = a3;
        a4.h.put(m, Paths.get("", new String[0]));
    }

    protected void doHealthCheck(Health.Builder a2) {
        FileSystemMonitor a5;
        a2.up();
        a5.h.forEach((a3, a4) -> {
            FileSystemMonitor a5;
            try {
                if (!m.equals(a3)) {
                    FileStore fileStore;
                    FileStore fileStore2 = fileStore = Files.getFileStore(a4);
                    long l2 = fileStore2.getUsableSpace();
                    long l3 = a5.H.getThreshold().toBytes();
                    if (fileStore2.getUsableSpace() < l3) {
                        Object[] objectArray = new Object[3];
                        objectArray[0] = a4.toString();
                        objectArray[1] = l2;
                        objectArray[2] = l3;
                        a5.I.warn(String.format(LicenseMetrics.g((Object)"h\u0007K\u0010\u000e\u0011G\u0006EU]\u0005O\u0016KUO\u0001\u000e\u0005O\u0001FU\tP]R\u000e\u001c]UL\u0010B\u001aYUZ\u001d\\\u0010]\u001dA\u0019J[\u000e4X\u0014G\u0019O\u0017B\u0010\u0014U\u000b\u0011\u000e\u0017W\u0001K\u0006\u000e]Z\u001d\\\u0010]\u001dA\u0019JO\u000eP]\\"), objectArray));
                        a2.status(HealthStatus.I);
                    }
                    String string = a3;
                    String string2 = a3;
                    a2.withDetail(string2, (Object)new Details(string2, a5.g(a4).toString(), fileStore.getUsableSpace(), fileStore.getTotalSpace()));
                    a2.withDetail(TransientException.g((Object)"\u0004\u001f\u0002\u0012\u0003\u001f\u001f\u001b\u0014"), (Object)l3);
                    return;
                }
            }
            catch (Exception exception) {
                a5.I.error(LicenseMetrics.g((Object)"h\u0014G\u0019K\u0011\u000e\u0001AU\\\u0010Z\u0007G\u0010X\u0010\u000e\u0013G\u0019KU]\u0001A\u0007KUH\u001a\\UU\b"), a4, (Object)exception);
                a2.down();
                a2.withDetail(TransientException.g((Object)"\u0007\u0011\u0003\u0018"), (Object)a4.toString());
            }
        });
    }

    public void unregisterPath(String a2) {
        FileSystemMonitor a3;
        FileSystemMonitor fileSystemMonitor = a3;
        fileSystemMonitor.I.info(LicenseMetrics.g((Object)"}\u0001A\u0005^\u0010JUC\u001a@\u001cZ\u001a\\\u001c@\u0012\u000e\u0013G\u0019KU]\u0001A\u0007KU\t\u000eSR"), (Object)a2);
        fileSystemMonitor.h.remove(a2);
    }
}

