/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.config;

import io.axoniq.axonserver.config.AccessControlConfiguration;
import io.axoniq.axonserver.config.EventTransformationConfiguration;
import io.axoniq.axonserver.config.SslConfiguration;
import io.axoniq.axonserver.config.SystemInfoProvider;
import io.axoniq.axonserver.enterprise.context.AdminContextController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.interceptor.PluginRemovedEvent;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.replication.ServerProperties;
import io.axoniq.axonserver.util.StringUtils;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

@Configuration
@ConfigurationProperties(prefix="axoniq.axonserver")
public class MessagingPlatformConfiguration
implements ServerProperties {
    private int port;
    private int eventStoreProcessorsThreadCount;
    private String internalHostname;
    @NestedConfigurationProperty
    private SslConfiguration ssl;
    private String webSocketAllowedOrigins;
    private String hostname;
    private int executorThreadCount;
    private static final Logger auditLog;
    private String domain;
    private static final int RESERVED = 10000;
    private Duration metricsInterval;
    public static final int DEFAULT_INTERNAL_GRPC_PORT = 8224;
    private final SystemInfoProvider systemInfoProvider;
    private int grpcBufferedMessages;
    private Duration keepAliveTimeout;
    private String pluginCacheDirectory;
    private String pluginCleanPolicy;
    private String controldbBackupLocation;
    private String name;
    private static final int DEFAULT_MAX_TRANSACTION_SIZE = 4184304;
    private int metricsSynchronizationRate;
    private Duration minKeepAliveTime;
    @NestedConfigurationProperty
    private EventTransformationConfiguration eventTransformation;
    private int internalPort;
    private Duration keepAliveTime;
    @NestedConfigurationProperty
    private AccessControlConfiguration accesscontrol;
    private int maxMessageSize;
    private final Map<String, Boolean> preview;
    @Value(value="${spring.datasource.url:#{null}}")
    private String datasourceUrl;
    private String internalDomain;
    private int httpPort;
    private String pidFileLocation;
    private int clusterExecutorThreadCount;
    private int eventStoreBackgroundThreadCount;
    private boolean pluginsEnabled;
    private boolean setWebSocketAllowedOrigins;
    private String pluginPackageDirectory;
    private static final Logger logger;
    private boolean forceConnectionToPrimaryOrMessagingNode;

    @PostConstruct
    public void postConstruct() {
        MessagingPlatformConfiguration a4;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a4;
        messagingPlatformConfiguration.g(a4.getHostname(), messagingPlatformConfiguration.getDomain(), false, (a2, a3) -> {
            MessagingPlatformConfiguration a4;
            MessagingPlatformConfiguration messagingPlatformConfiguration = a4;
            messagingPlatformConfiguration.setHostname(a2);
            messagingPlatformConfiguration.setDomain(a3);
        });
        MessagingPlatformConfiguration messagingPlatformConfiguration2 = a4;
        messagingPlatformConfiguration2.g(a4.getInternalHostname(), messagingPlatformConfiguration2.getInternalDomain(), true, (a2, a3) -> {
            MessagingPlatformConfiguration a4;
            MessagingPlatformConfiguration messagingPlatformConfiguration = a4;
            messagingPlatformConfiguration.setInternalHostname(a2);
            messagingPlatformConfiguration.setInternalDomain(a3);
        });
        if (a4.datasourceUrl != null && !a4.datasourceUrl.contains(PluginRemovedEvent.g((Object)"}o\"o}")) && !a4.datasourceUrl.contains(AdminContextController.g((Object)"\u001c\n\u0012\u001c\u000e\u0017\u000f\u0004\u0018\u0000P\u0011\u0012\u001c\u001b\u001b\u001a\u0016\u001f"))) {
            throw new FailedToStartException(PluginRemovedEvent.g((Object)"\u0013j\"\"#c3c%c4ggl&o\"\"!m5\"\u0006z(lgQ\"p1g5\"*w4vg`\"\"`c?m)q\"p1g5/$m)d.e#``,gK!\">m2\"&p\"\"*k p&v.l \"!p(ogc)\"(n#g5\"1g5q.m)\"\"l4w5ggv/c3\"3j\"\"\u0004m)v5m+\"\u0003@gk4\".lg%&z(l4g5t\"pja(l3p(n#``\"&l#\"2r#c3ggv/ggq7p.l ,#c3c4m2p$giw5ngr5m7g5v>\"3mgw4ggf&v&`&q\"\")c*gg%&z(l4g5t\"pja(l!k f%%i"));
        }
        if (auditLog.isInfoEnabled()) {
            auditLog.info(AdminContextController.g((Object)"1\u0012\u001c\u001b\u001b\u001a\u0007\u000f\u0013\t\u001b\u0012\u001c]\u001b\u0013\u001b\t\u001b\u001c\u001e\u0014\b\u0018\u0016]\u0005\u0014\u0006\u0015R.!1R\u0006\u000f]\u0013\u0013\u0016]\u0013\u001e\u0011\u0018\u0001\u000eR\u001e\u001d\u0013\u0006\u000f\u001d\u0011R\u0006\u000fS"), (Object)AuditLog.enablement((boolean)a4.ssl.isEnabled()), (Object)AuditLog.enablement((boolean)a4.accesscontrol.isEnabled()));
        }
    }

    public String getDomain() {
        MessagingPlatformConfiguration a2;
        if (a2.domain == null) {
            block4: {
                String string = a2.systemInfoProvider.getHostName();
                int n = string.indexOf(46);
                if (n == -1) break block4;
                a2.domain = string.substring(n + 1);
            }
            try {
                a2.domain = "";
            }
            catch (UnknownHostException unknownHostException) {
                logger.warn(PluginRemovedEvent.g((Object)"A(w+fgl(vgf\"v\"p*k)ggj(q3l&o\"\"!p(ogk)g3\"&f#p\"q48gy:"), (Object)unknownHostException.getMessage());
            }
        }
        return a2.domain;
    }

    public String getFullyQualifiedHostname() {
        MessagingPlatformConfiguration a2;
        String string = a2.getDomain();
        if (!StringUtils.isEmpty((String)string)) {
            return a2.getHostname() + "." + string;
        }
        return a2.getHostname();
    }

    public int getClusterExecutorThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.clusterExecutorThreadCount;
    }

    public void setKeepAliveTime(Duration a2) {
        a.keepAliveTime = a2;
    }

    public long getKeepAliveTimeout() {
        MessagingPlatformConfiguration a2;
        return a2.keepAliveTimeout.toMillis();
    }

    public void setAccesscontrol(AccessControlConfiguration a2) {
        block3: {
            MessagingPlatformConfiguration messagingPlatformConfiguration;
            MessagingPlatformConfiguration a3;
            block1: {
                block2: {
                    if (!auditLog.isInfoEnabled()) break block1;
                    if (a2 != null) break block2;
                    if (a3.accesscontrol == null) break block1;
                    auditLog.info(AdminContextController.g((Object)"<\u0011\u001e\u0017\u000e\u0001]\u0011\u0012\u001c\t\u0000\u0012\u001e]\u0011\u0012\u001c\u001b\u001b\u001a\u0007\u000f\u0013\t\u001b\u0012\u001c] 8?2$86S"));
                    messagingPlatformConfiguration = a3;
                    break block3;
                }
                if (a3.accesscontrol == null || a2.isEnabled() != a3.accesscontrol.isEnabled()) {
                    auditLog.info(PluginRemovedEvent.g((Object)"\u0006a$g4qga(l3p(ngk4\")m0\"<\u007fi"), (Object)AuditLog.enablement((boolean)a2.isEnabled()));
                }
            }
            messagingPlatformConfiguration = a3;
        }
        messagingPlatformConfiguration.accesscontrol = a2;
    }

    public int getGrpcBufferedMessages() {
        MessagingPlatformConfiguration a2;
        return a2.grpcBufferedMessages;
    }

    public void setMaxMessageSize(DataSize a2) {
        Assert.isTrue((a2.toBytes() >= 0L ? 1 : 0) != 0, (String)AdminContextController.g((Object)"0\u0013\u0005R\u0010\u0017\u000e\u0001\u001c\u0015\u0018R\u000e\u001b\u0007\u0017]\u001f\b\u0001\tR\u001f\u0017]\u0015\u000f\u0017\u001c\u0006\u0018\u0000]\u0006\u0015\u0013\u0013RM"));
        Assert.isTrue((a2.toBytes() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)PluginRemovedEvent.g((Object)"\nc?\"*g4q&e\"\"4k=ggo2q3\"%ggn\"q4\"3j&lg0v6p6\u007f1q6p"));
        a.maxMessageSize = (int)a2.toBytes();
    }

    public MessagingPlatformConfiguration(SystemInfoProvider a2) {
        MessagingPlatformConfiguration a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration2 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration3 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration4 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration5 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration6 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration7 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration8 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration9 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration10 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration11 = a3;
        a3.port = 8124;
        messagingPlatformConfiguration11.internalPort = 8224;
        messagingPlatformConfiguration11.keepAliveTimeout = Duration.ofMillis(5000L);
        messagingPlatformConfiguration10.keepAliveTime = Duration.ofMillis(2500L);
        messagingPlatformConfiguration10.minKeepAliveTime = Duration.ofMillis(1000L);
        messagingPlatformConfiguration9.setWebSocketAllowedOrigins = false;
        messagingPlatformConfiguration9.webSocketAllowedOrigins = "*";
        MessagingPlatformConfiguration messagingPlatformConfiguration12 = a3;
        messagingPlatformConfiguration9.ssl = new SslConfiguration();
        MessagingPlatformConfiguration messagingPlatformConfiguration13 = a3;
        messagingPlatformConfiguration8.accesscontrol = new AccessControlConfiguration();
        MessagingPlatformConfiguration messagingPlatformConfiguration14 = a3;
        messagingPlatformConfiguration8.eventTransformation = new EventTransformationConfiguration();
        messagingPlatformConfiguration8.forceConnectionToPrimaryOrMessagingNode = true;
        messagingPlatformConfiguration7.metricsInterval = Duration.ofMinutes(15L);
        messagingPlatformConfiguration7.controldbBackupLocation = ".";
        messagingPlatformConfiguration6.maxMessageSize = 0x400000;
        messagingPlatformConfiguration6.pidFileLocation = ".";
        messagingPlatformConfiguration5.grpcBufferedMessages = 500;
        messagingPlatformConfiguration5.executorThreadCount = 4;
        messagingPlatformConfiguration4.clusterExecutorThreadCount = 4;
        messagingPlatformConfiguration4.eventStoreBackgroundThreadCount = 8;
        messagingPlatformConfiguration3.eventStoreProcessorsThreadCount = 8;
        messagingPlatformConfiguration3.pluginsEnabled = true;
        messagingPlatformConfiguration2.pluginCacheDirectory = "plugins/cache";
        messagingPlatformConfiguration2.pluginPackageDirectory = "plugins/bundles";
        messagingPlatformConfiguration.pluginCleanPolicy = "onFirstInit";
        MessagingPlatformConfiguration messagingPlatformConfiguration15 = a3;
        messagingPlatformConfiguration.preview = new HashMap();
        messagingPlatformConfiguration.systemInfoProvider = a2;
    }

    public void setMinKeepAliveTime(Duration a2) {
        a.minKeepAliveTime = a2;
    }

    public int getInternalPort() {
        MessagingPlatformConfiguration a2;
        return a2.internalPort;
    }

    public String getWebSocketAllowedOrigins() {
        MessagingPlatformConfiguration a2;
        return a2.webSocketAllowedOrigins;
    }

    public String getFullyQualifiedInternalHostname() {
        MessagingPlatformConfiguration a2;
        String string = a2.getInternalDomain();
        if (!StringUtils.isEmpty((String)string)) {
            return a2.getInternalHostname() + "." + string;
        }
        return a2.getInternalHostname();
    }

    public String getPluginPackageDirectory() {
        MessagingPlatformConfiguration a2;
        return a2.pluginPackageDirectory;
    }

    public void setPluginsEnabled(boolean a2) {
        a.pluginsEnabled = a2;
    }

    public String getInternalDomain() {
        MessagingPlatformConfiguration a2;
        if (a2.internalDomain == null) {
            a2.internalDomain = a2.getDomain();
        }
        return a2.internalDomain;
    }

    public void setPluginCacheDirectory(String a2) {
        a.pluginCacheDirectory = a2;
    }

    public void setClusterExecutorThreadCount(int a2) {
        a.clusterExecutorThreadCount = a2;
    }

    public void setPluginPackageDirectory(String a2) {
        a.pluginPackageDirectory = a2;
    }

    public void setPluginCleanPolicy(String a2) {
        a.pluginCleanPolicy = a2;
    }

    public void setPort(int a2) {
        a.port = a2;
    }

    public void setSetWebSocketAllowedOrigins(boolean a2) {
        a.setWebSocketAllowedOrigins = a2;
    }

    public Duration getMetricsInterval() {
        MessagingPlatformConfiguration a2;
        return a2.metricsInterval;
    }

    public int getExecutorThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.executorThreadCount;
    }

    public boolean isForceConnectionToPrimaryOrMessagingNode() {
        MessagingPlatformConfiguration a2;
        return a2.forceConnectionToPrimaryOrMessagingNode;
    }

    public void setHostname(String a2) {
        a.hostname = a2;
    }

    public int getEventStoreProcessorsThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.eventStoreProcessorsThreadCount;
    }

    public void setExecutorThreadCount(int a2) {
        a.executorThreadCount = a2;
    }

    public void setName(String a2) {
        a.name = a2;
    }

    public boolean isSetWebSocketAllowedOrigins() {
        MessagingPlatformConfiguration a2;
        return a2.setWebSocketAllowedOrigins;
    }

    public String getPluginCleanPolicy() {
        MessagingPlatformConfiguration a2;
        return a2.pluginCleanPolicy;
    }

    public int getMaxTransactionSize() {
        MessagingPlatformConfiguration a2;
        if (a2.maxMessageSize == 0) {
            return 4184304;
        }
        return a2.maxMessageSize - 10000;
    }

    public String getInternalHostname() {
        MessagingPlatformConfiguration a2;
        if (StringUtils.isEmpty((String)a2.internalHostname)) {
            a2.internalHostname = a2.getHostname();
        }
        return a2.internalHostname;
    }

    public void setInternalPort(int a2) {
        a.internalPort = a2;
    }

    private /* synthetic */ void g(String a2, String a3, boolean a4, BiConsumer<String, String> a5) {
        String string = a4 = a4 ? AdminContextController.g((Object)"\u0014\u001c\t\u0017\u000f\u001c\u001c\u001e]") : "";
        if (StringUtils.isEmpty((String)a2)) {
            logger.error(PluginRemovedEvent.g((Object)"\u0004m2n#\")m3\"#g3g5o.l\"\"&\"1c+k#\"<\u007f/m4v)c*gi"), (Object)a4);
            throw new MessagingPlatformException(ErrorCode.VALIDATION_FAILED, "No " + a4 + "hostname set and system could not provide one.");
        }
        if (Character.isDigit(a2.charAt(0))) {
            logger.warn(AdminContextController.g((Object)"&\u0015\u0017]\t\u0000\u001a\u0012\u0001\t\u001c\u001c\u001f\u0018R\u0015\u0013\u000eR\u001f\u0017\u0018\u001c]\u0001\u0018\u0006]\u0013\u000eR\u001c\u001c];-R\u001c\u0016\u0019\u0000\u0018\u0001\u000e\\]&\u0015\u001b\u000eR\u0010\u0013\u0004R\r\u0000\u0012\u0016\b\u0011\u0018R\b\u001c\n\u0013\u0013\u0006\u0018\u0016]\u0000\u0018\u0001\b\u001e\t\u0001S"), (Object)a4);
            return;
        }
        int n = a2.indexOf(46);
        if (n != -1) {
            String string2 = a2;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (StringUtils.isEmpty((String)a3)) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a4;
                objectArray[1] = string3;
                objectArray[2] = string4;
                logger.info(PluginRemovedEvent.g((Object)"\u0004m)d.e2p.l \"#m*c.lgd5m*\"<\u007f/m4v)c*ggr5m7g5v>8gj(q3l&o\"?<\u007fk\"#m*c.lzy:"), objectArray);
                a5.accept(string3, string4);
                return;
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = a4;
            objectArray[1] = a2;
            objectArray[2] = string3;
            objectArray[3] = a3;
            logger.warn(AdminContextController.g((Object)"4\u0015\u0013\u001d\u000f\u001b\u0013\u0015]\u0016\u0012\u001f\u001c\u001b\u0013R\r\u0013\u000f\u0006]\u001d\u001bR\t\u001a\u0018R\u0006\u000f\u0015\u001d\u000e\u0006\u0013\u0013\u0010\u0017]U\u0006\u000fZH]\u001a\u0012\u0001\t\u001c\u001c\u001f\u0018O\u0006\u000fQR\u0019\u001d\u0010\u0013\u0014\u001c@\t\u0000"), objectArray);
            a5.accept(string3, a3);
        }
    }

    public boolean isPluginsEnabled() {
        MessagingPlatformConfiguration a2;
        return a2.pluginsEnabled;
    }

    public Map<String, Boolean> getPreview() {
        MessagingPlatformConfiguration a2;
        return a2.preview;
    }

    public void setInternalHostname(String a2) {
        a.internalHostname = a2;
    }

    public void setControldbBackupLocation(String a2) {
        a.controldbBackupLocation = a2;
    }

    public String getPidFileLocation() {
        MessagingPlatformConfiguration a2;
        return a2.pidFileLocation;
    }

    public int getHttpPort() {
        MessagingPlatformConfiguration a2;
        if (a2.httpPort == 0) {
            a2.httpPort = a2.systemInfoProvider.getPort();
        }
        return a2.httpPort;
    }

    public void setKeepAliveTimeout(Duration a2) {
        a.keepAliveTimeout = a2;
    }

    public void setEventTransformation(EventTransformationConfiguration a2) {
        a.eventTransformation = a2;
    }

    public EventTransformationConfiguration getEventTransformation() {
        MessagingPlatformConfiguration a2;
        return a2.eventTransformation;
    }

    @PostConstruct
    public void init() {
        if (auditLog.isInfoEnabled()) {
            MessagingPlatformConfiguration a4;
            a4.preview.forEach((a2, a3) -> {
                if (Boolean.TRUE.equals(a3)) {
                    auditLog.info(AdminContextController.g((Object)"\"\u000f\u0017\u000b\u001b\u0018\u0005]\u001d\u001bR\u001b\u0017\u001c\u0006\b\u0000\u0018R\u0006\u000f]\u0017\u0013\u0013\u001f\u001e\u0018\u0016S"), a2);
                }
            });
        }
    }

    public SslConfiguration getSsl() {
        MessagingPlatformConfiguration a2;
        return a2.ssl;
    }

    public int getPort() {
        MessagingPlatformConfiguration a2;
        return a2.port;
    }

    public void setEventStoreBackgroundThreadCount(int a2) {
        a.eventStoreBackgroundThreadCount = a2;
    }

    public long getMinKeepAliveTime() {
        MessagingPlatformConfiguration a2;
        return a2.minKeepAliveTime.toMillis();
    }

    public void setWebSocketAllowedOrigins(String a2) {
        a.webSocketAllowedOrigins = a2;
    }

    public void setEventStoreProcessorsThreadCount(int a2) {
        a.eventStoreProcessorsThreadCount = a2;
    }

    public boolean isExperimentalFeatureEnabled(String a2) {
        MessagingPlatformConfiguration a3;
        return a3.preview.getOrDefault(a2, false);
    }

    public int getMaxMessageSize() {
        MessagingPlatformConfiguration a2;
        return a2.maxMessageSize;
    }

    static {
        logger = LoggerFactory.getLogger(MessagingPlatformConfiguration.class);
        auditLog = AuditLog.getLogger();
    }

    public void setSsl(SslConfiguration a2) {
        block3: {
            MessagingPlatformConfiguration messagingPlatformConfiguration;
            MessagingPlatformConfiguration a3;
            block1: {
                block2: {
                    if (!auditLog.isInfoEnabled()) break block1;
                    if (a2 != null) break block2;
                    if (a3.ssl == null) break block1;
                    auditLog.info(PluginRemovedEvent.g((Object)"Q\u0014Nga(l!k w5c3k(lgP\u0002O\bT\u0002Fi"));
                    messagingPlatformConfiguration = a3;
                    break block3;
                }
                if (a3.ssl == null || a2.isEnabled() != a3.ssl.isEnabled()) {
                    auditLog.info(AdminContextController.g((Object)"!.>]\u001b\u000eR\u0013\u001d\nR\u0006\u000fS"), (Object)AuditLog.enablement((boolean)a2.isEnabled()));
                }
            }
            messagingPlatformConfiguration = a3;
        }
        messagingPlatformConfiguration.ssl = a2;
    }

    public long getKeepAliveTime() {
        MessagingPlatformConfiguration a2;
        return a2.keepAliveTime.toMillis();
    }

    public int getEventStoreBackgroundThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.eventStoreBackgroundThreadCount;
    }

    public String getHostname() {
        MessagingPlatformConfiguration a2;
        if (StringUtils.isEmpty((String)a2.hostname)) {
            try {
                MessagingPlatformConfiguration messagingPlatformConfiguration = a2;
                messagingPlatformConfiguration.hostname = messagingPlatformConfiguration.systemInfoProvider.getHostName();
                if (!StringUtils.isEmpty((String)messagingPlatformConfiguration.domain)) {
                    MessagingPlatformConfiguration messagingPlatformConfiguration2 = a2;
                    if (messagingPlatformConfiguration2.hostname.endsWith("." + messagingPlatformConfiguration2.domain)) {
                        a2.hostname = a2.hostname.substring(0, a2.hostname.length() - a2.domain.length() - 1);
                    }
                }
            }
            catch (UnknownHostException unknownHostException) {
                logger.warn(PluginRemovedEvent.g((Object)"A(w+fgl(vgf\"v\"p*k)ggj(q3l&o\"\"!p(ogk)g3\"&f#p\"q48gy:"), (Object)unknownHostException.getMessage());
            }
        }
        return a2.hostname;
    }

    public void setGrpcBufferedMessages(int a2) {
        a.grpcBufferedMessages = a2;
    }

    public String getName() {
        MessagingPlatformConfiguration a2;
        if (a2.name == null) {
            a2.name = a2.getHostname();
        }
        return a2.name;
    }

    public void setMetricsInterval(Duration a2) {
        a.metricsInterval = a2;
    }

    public void setInternalDomain(String a2) {
        a.internalDomain = a2;
    }

    public String getControldbBackupLocation() {
        MessagingPlatformConfiguration a2;
        return a2.controldbBackupLocation;
    }

    public void setForceConnectionToPrimaryOrMessagingNode(boolean a2) {
        a.forceConnectionToPrimaryOrMessagingNode = a2;
    }

    public AccessControlConfiguration getAccesscontrol() {
        MessagingPlatformConfiguration a2;
        return a2.accesscontrol;
    }

    public String getPluginCacheDirectory() {
        MessagingPlatformConfiguration a2;
        return a2.pluginCacheDirectory;
    }

    public void setDomain(String a2) {
        a.domain = a2;
    }

    public void setMetricsSynchronizationRate(int a2) {
        a.metricsSynchronizationRate = a2;
    }

    public void setPidFileLocation(String a2) {
        a.pidFileLocation = a2;
    }
}

