/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.tags.ClientTagsCache;
import io.axoniq.axonserver.enterprise.cluster.NodeSelector;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.ReadyForConnections;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.localstorage.transaction.PreparedTransaction;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.transport.rest.v2.ClusterUpdatesRestController;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class AutoRebalancing {
    private final NodeSelector j;
    private final Logger H;
    private final ClientTagsCache m;
    private final PlatformService h;
    private final boolean b;
    private final NavigableSet<PlatformService.ClientComponent> I;

    @EventListener
    public void on(ClusterEvents.AxonServerNodeHealthChanged a2) {
        AutoRebalancing a3;
        AutoRebalancing autoRebalancing = a3;
        autoRebalancing.H.debug(ClusterUpdatesRestController.g((Object)"Gqvq|bpp5|puy`}4v|tzrqq4s{g4ni"), (Object)a2.getNode());
        autoRebalancing.I.clear();
        autoRebalancing.I.addAll(a3.h.getConnectedClients());
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected a2) {
        AutoRebalancing a3;
        AutoRebalancing autoRebalancing = a3;
        autoRebalancing.H.debug(PreparedTransaction.g((Object)"2\u0019\u0003\u0005\u001a\n\u0012\u001d\u001a\u0006\u001dI7\u0000\u0000\n\u001c\u0007\u001d\f\u0010\u001d\u0016\rII\b\u0014"), (Object)a2.i());
        a2 = new PlatformService.ClientComponent(a2.i(), a2.G(), a2.f(), a2.K());
        autoRebalancing.I.remove(a2);
        a3.H.debug(ClusterUpdatesRestController.g((Object)"C}}aqy}f`/4ni"), (Object)a3.I);
    }

    private /* synthetic */ Map<String, String> g(String a2, String a3) {
        AutoRebalancing a4;
        return a4.m.apply(new ClientStreamIdentification(a2, a3));
    }

    public AutoRebalancing(PlatformService platformService, ClientTagsCache clientsTags, NodeSelector nodeSelector, @Value(value="${axoniq.axonserver.cluster.auto-balancing:true}") boolean a2) {
        AutoRebalancing autoRebalancing = this;
        AutoRebalancing autoRebalancing2 = this;
        this.H = LoggerFactory.getLogger(AutoRebalancing.class);
        AutoRebalancing autoRebalancing3 = this;
        this.I = new ConcurrentSkipListSet();
        autoRebalancing2.h = platformService;
        autoRebalancing2.m = clientsTags;
        autoRebalancing.j = nodeSelector;
        autoRebalancing.b = a2;
    }

    private /* synthetic */ void g(PlatformService.ClientComponent a2) {
        AutoRebalancing a3;
        AutoRebalancing autoRebalancing = a3;
        autoRebalancing.H.info(PreparedTransaction.g((Object)";\u0016\u0018\u0006\f\u0000\u001d\u001a\u0007\u0014I\u0001\f\u0010\u0006\u001d\u0007\u0016\n\u0007I\u0015\u0006\u0001I\b\u0014"), (Object)a2.getClientStreamId());
        autoRebalancing.h.requestReconnect(a2, ClusterUpdatesRestController.g((Object)"fpwzz{qv`5fpe`qf`pp5vl4taa{5vtxtzv}{s"));
    }

    @EventListener
    public void on(ReadyForConnections a2) {
        if (a2.ready()) {
            AutoRebalancing a3;
            AutoRebalancing autoRebalancing = a3;
            autoRebalancing.I.clear();
            autoRebalancing.I.addAll(a3.h.getConnectedClients());
        }
    }

    @Scheduled(fixedRateString="${axoniq.axonserver.cluster.balancing-rate:15000}")
    protected void g() {
        boolean bl;
        AutoRebalancing a2;
        if (!a2.b) {
            return;
        }
        a2.H.debug(PreparedTransaction.g((Object)";\u0016\u000b\u0012\u0005\u0012\u0007\u0010\fII\b\u0014"), (Object)a2.I);
        boolean bl2 = false;
        do {
            PlatformService.ClientComponent clientComponent;
            if ((clientComponent = (PlatformService.ClientComponent)a2.I.pollFirst()) != null && a2.j.canRebalance(clientComponent.getClientId(), clientComponent.getComponent(), clientComponent.getContext(), a2.g(clientComponent.getContext(), clientComponent.getClientStreamId()))) {
                bl = bl2;
                a2.g(clientComponent);
                continue;
            }
            bl = bl2 = clientComponent != null;
        } while (bl);
    }
}

