/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.ClusterTagsCache;
import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.cluster.util.AxonThreadFactory;
import io.axoniq.axonserver.config.ClusterConfiguration;
import io.axoniq.axonserver.config.FlowControl;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterEvent;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.events.serializer.XStreamEventSerializer;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnection;
import io.axoniq.axonserver.enterprise.cluster.internal.StubFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ChannelExceptionHandler;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.internal.DeleteNode;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.Limits;
import io.axoniq.axonserver.managed.ManagedAxonServerEventStoreStatusService;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.message.query.QueryDispatcher;
import io.axoniq.axonserver.rest.svg.mapping.AxonServers;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller(value="ClusterController")
public class ClusterController
implements SmartLifecycle,
ApplicationContextAware {
    private final ConcurrentMap<String, ClusterNode> e;
    private final ClientIdRegistry a;
    private final QueryDispatcher B;
    private final ChannelExceptionHandler D;
    private final ClusterConfiguration J;
    private final ClusterTagsCache g;
    private final List<Consumer<ClusterEvent>> K;
    private final CommandDispatcher A;
    private final ScheduledExecutorService C;
    private final AtomicBoolean l;
    private final Logger F;
    private final ConcurrentMap<String, RemoteConnection> E;
    private volatile boolean i;
    private final Limits G;
    private final AdminConfigurationFactory f;
    private final StubFactory c;
    private final MessagingPlatformConfiguration j;
    private final ApplicationEventPublisher H;
    private final XStreamEventSerializer m;
    private ApplicationContext h;
    private final AtomicBoolean b;
    private final AdminNodes I;

    public void requestDelete(String a2) {
        ClusterController a3;
        a3.H.publishEvent((Object)DeleteNode.newBuilder().setNodeName(a2).build());
    }

    public String getName() {
        ClusterController a2;
        return a2.j.getName();
    }

    public ClusterNode getMe() {
        ClusterController a3;
        ClusterController clusterController = a3;
        return clusterController.I.findById(clusterController.j.getName()).map(a2 -> {
            ClusterController a3;
            ClusterNode clusterNode = a2;
            clusterNode.setTags(a3.g.getClusterTags().getOrDefault(clusterNode.getName(), Collections.emptyMap()));
            return a2;
        }).orElseThrow(() -> new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, AxonServers.g((Object)"{\u001cJ\u001b]\u0007LIV\u0006\\\f\u0018\u0007W\u001d\u0018\u000fW\u001cV\r")));
    }

    @Transactional
    public synchronized ClusterNode addConnection(NodeInfo a2) {
        ClusterController a3;
        NodeInfo nodeInfo = a2;
        a3.g(nodeInfo.getNodeName());
        if (nodeInfo.getNodeName().equals(a3.j.getName())) {
            ClusterController clusterController = a3;
            clusterController.F.info(ManagedAxonServerEventStoreStatusService.g((Object)"\u0014\u001a9\u0001.\u000f`\u001c/H*\u0007)\u0006`\u001f)\u001c(H#\u001d2\u001a%\u00064H.\u0007$\r`\u0006!\u0005%R`\u0013="), (Object)a2.getNodeName());
            return clusterController.getMe();
        }
        if (a2.getInternalHostName().equals(a3.j.getInternalHostname()) && a2.getGrpcInternalPort() == a3.j.getInternalPort()) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, AxonServers.g((Object)"{\bV\u0007W\u001d\u0018\u0003W\u0000VI[\u0005M\u001aL\fJIO\u0000L\u0001\u0018\u001aY\u0004]IP\u0006K\u001dV\bU\f\u0018\bV\r\u0018\u0000V\u001d]\u001bV\bTIH\u0006J\u001d"));
        }
        ClusterController clusterController = a3;
        if (!clusterController.E.containsKey((a2 = clusterController.g(a2)).getName())) {
            ClusterController clusterController2 = a3;
            clusterController2.g((ClusterNode)a2, false);
            clusterController2.K.forEach(arg_0 -> ClusterController.g((ClusterNode)a2, arg_0));
        }
        return a2;
    }

    public void closeConnection(String a2) {
        ClusterController a3;
        if (a3.E.containsKey(a2)) {
            ((RemoteConnection)a3.E.get(a2)).G();
        }
    }

    public void connect(Node a2) {
        ClusterController a3;
        if (!a3.I.findById(a2.getNodeName()).isPresent()) {
            ClusterController clusterController = a3;
            clusterController.g(clusterController.f.clusterNode(a2), true);
        }
    }

    private static /* synthetic */ void g(ClusterNode a2, Consumer a3) {
        a3.accept(new ClusterEvent(ClusterEvent.EventType.h, a2));
    }

    @Transactional
    public void sendDeleteNode(String a2) {
        ClusterController a3;
        a3.deleteNode(a2);
    }

    Stream<RemoteConnection> activeConnections() {
        ClusterController a2;
        return a2.E.values().stream().filter(RemoteConnection::K);
    }

    public boolean isRunning() {
        ClusterController a2;
        return a2.i;
    }

    public int getPhase() {
        return 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public synchronized void deleteNode(String a4) {
        ClusterController a5;
        ClusterController clusterController = a5;
        clusterController.F.info(ManagedAxonServerEventStoreStatusService.g((Object)"\u0004\r,\r4\r`\u0006/\f%R`\u0013="), (Object)a4);
        clusterController.H.publishEvent((Object)new ClusterEvents.AxonServerNodeDeletionRequested(a4));
        ConcurrentMap concurrentMap = clusterController.E;
        synchronized (concurrentMap) {
            RemoteConnection remoteConnection;
            if (a5.j.getName().equals(a4)) {
                a5.E.forEach((a2, a3) -> a3.i());
                ClusterController clusterController2 = a5;
                clusterController2.E.clear();
                clusterController2.I.deleteAllByNameNot(a4);
            }
            if ((remoteConnection = (RemoteConnection)a5.E.remove(a4)) != null) {
                a5.I.findById(a4).ifPresent(a3 -> {
                    ClusterController a4;
                    a4.I.deleteById(a4);
                });
                remoteConnection.i();
                a5.K.forEach(a3 -> a3.accept(new ClusterEvent(ClusterEvent.EventType.b, remoteConnection.g())));
                a5.e.remove(a4);
            }
        }
        a5.H.publishEvent((Object)new ClusterEvents.AxonServerNodeDeleted(a4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void g(ClusterNode a2, boolean a3) {
        ClusterController a4;
        if (a2.getName().equals(a4.j.getName())) {
            return;
        }
        ConcurrentMap concurrentMap = a4.E;
        synchronized (concurrentMap) {
            if (!a4.E.containsKey(a2.getName())) {
                ClusterController clusterController = a4;
                ClusterController clusterController2 = a4;
                ClusterController clusterController3 = a4;
                RemoteConnection remoteConnection = new RemoteConnection(clusterController, a2, a4.c, clusterController.B, clusterController2.A, clusterController2.a, clusterController3.D, clusterController3.m, a4.l.get());
                a4.E.put(a2.getName(), remoteConnection);
                if (a3) {
                    remoteConnection.g();
                }
            }
            return;
        }
    }

    public Set<String> remoteNodeNames() {
        ClusterController a2;
        return a2.E.keySet();
    }

    public ClusterNode getNode(String a3) {
        ClusterController a4;
        if ((a3 = a4.e.computeIfAbsent(a3, a2 -> {
            ClusterController a3;
            return a3.I.findById(a2).orElse(null);
        })) == null) {
            return null;
        }
        return a4.g((ClusterNode)a3);
    }

    public FlowControl getQueryFlowControl() {
        ClusterController a2;
        return a2.J.getQueryFlowControl();
    }

    public Stream<ClusterNode> nodes() {
        ClusterController a3;
        return a3.I.findAll().peek(a2 -> {
            ClusterController a3;
            ClusterNode clusterNode = a2;
            clusterNode.setTags(a3.g.getClusterTags().getOrDefault(clusterNode.getName(), Collections.emptyMap()));
            return a2;
        });
    }

    public long getConnectionWaitTime() {
        ClusterController a2;
        return a2.J.getConnectionWaitTime();
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupDeleted a2) {
        ClusterController a3;
        a3.e.clear();
        if (RaftAdminGroup.g((String)a2.replicationGroup())) {
            a3.b.set(false);
        }
    }

    public void setReadyForConnections(boolean a2) {
        ClusterController a5;
        ClusterController clusterController = a5;
        clusterController.l.set(a2);
        clusterController.E.forEach((a3, a4) -> a4.g(a2));
    }

    private /* synthetic */ void g(String a2) {
        ClusterController a4;
        if (a4.E.containsKey(a2) || a4.j.getName().equals(a2)) {
            return;
        }
        a4.G.getMaxClusterSize().ifPresent(a3 -> {
            ClusterController a4;
            if (a4.E.size() + 1 >= a3) {
                throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached " + a2);
            }
        });
    }

    public Collection<RemoteConnection> getRemoteConnections() {
        ClusterController a2;
        return a2.E.values();
    }

    private /* synthetic */ void K() {
        ClusterController a2;
        ClusterController clusterController = a2;
        Object object = clusterController.I.findById(clusterController.j.getName());
        if (!((Optional)object).isPresent()) {
            if (a2.I.findAll().findAny().isPresent()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = a2.j.getName();
                String string = String.format(ManagedAxonServerEventStoreStatusService.g((Object)"+5\u001a2\r.\u001c`\u0006/\f%H.\t-\r`\u0000!\u001b`\u000b(\t.\u000f%\flH.\r7H.\t-\r`M3F`;4\t2\u001c`)8\u0007.;%\u001a6\r2H7\u00014\u0000`\u001a%\u000b/\u001e%\u001a9H&\u0001,\rn"), objectArray);
                throw new FailedToStartException(string);
            }
            ClusterController clusterController2 = a2;
            ClusterNode clusterNode = clusterController2.f.clusterNode(clusterController2.j.getName(), a2.j.getFullyQualifiedHostname(), a2.j.getFullyQualifiedInternalHostname(), a2.j.getPort(), a2.j.getInternalPort(), a2.j.getHttpPort());
            clusterController2.I.save(clusterNode);
            return;
        }
        ClusterNode clusterNode = (ClusterNode)((Optional)object).get();
        if (!clusterNode.getInternalHostName().equals(a2.j.getFullyQualifiedInternalHostname()) || !clusterNode.getGrpcInternalPort().equals(a2.j.getInternalPort())) {
            Object[] objectArray = new Object[4];
            objectArray[0] = clusterNode.getInternalHostName();
            objectArray[1] = clusterNode.getGrpcInternalPort();
            objectArray[2] = a2.j.getFullyQualifiedInternalHostname();
            objectArray[3] = a2.j.getInternalPort();
            object = String.format(AxonServers.g((Object)"{\u001cJ\u001b]\u0007LIV\u0006\\\f\u001f\u001a\u0018\u0000V\u001d]\u001bV\bTIP\u0006K\u001dV\bU\f\u0017\u0019W\u001bLI\u0010LKS\u001d\r\u0011IP\bKI[\u0001Y\u0007_\f\\E\u0018IV\fOIN\bT\u001c]\u001a\u0018LKS\u001d\r\u0016Ik\u001dY\u001bLIy\u0011W\u0007k\fJ\u001f]\u001b\u0018\u001eQ\u001dPIJ\f[\u0006N\fJ\u0010\u0018\u000fQ\u0005]G"), objectArray);
            throw new FailedToStartException((String)object);
        }
        a2.b.set(clusterNode.isAdmin());
    }

    public ClusterController(MessagingPlatformConfiguration messagingPlatformConfiguration, ClusterConfiguration clusterConfiguration, AdminNodes clusterNodeRepository, AdminConfigurationFactory adminConfigurationFactory, ClusterTagsCache clusterTagsCache, StubFactory stubFactory, QueryDispatcher queryDispatcher, CommandDispatcher commandDispatcher, ClientIdRegistry clientIdRegistry, @Qualifier(value="localEventPublisher") ApplicationEventPublisher applicationEventPublisher, Limits limits, ChannelExceptionHandler channelExceptionHandler, XStreamEventSerializer a2) {
        ClusterController clusterController = this;
        ClusterController clusterController2 = this;
        ClusterController clusterController3 = this;
        ClusterController clusterController4 = this;
        ClusterController clusterController5 = this;
        ClusterController clusterController6 = this;
        ClusterController clusterController7 = this;
        ClusterController clusterController8 = this;
        this.F = LoggerFactory.getLogger(ClusterController.class);
        ClusterController clusterController9 = this;
        clusterController8.C = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new AxonThreadFactory(ManagedAxonServerEventStoreStatusService.g((Object)"#\u00045\u001b4\r2E2\r#\u0007.\u0006%\u000b4")));
        ClusterController clusterController10 = this;
        clusterController9.K = new CopyOnWriteArrayList();
        ClusterController clusterController11 = this;
        clusterController8.E = new ConcurrentHashMap();
        ClusterController clusterController12 = this;
        clusterController8.e = new ConcurrentHashMap();
        ClusterController clusterController13 = this;
        clusterController7.l = new AtomicBoolean();
        ClusterController clusterController14 = this;
        clusterController7.b = new AtomicBoolean();
        clusterController7.j = messagingPlatformConfiguration;
        clusterController6.J = clusterConfiguration;
        clusterController6.I = clusterNodeRepository;
        clusterController5.f = adminConfigurationFactory;
        clusterController5.g = clusterTagsCache;
        clusterController4.c = stubFactory;
        clusterController4.B = queryDispatcher;
        clusterController3.A = commandDispatcher;
        clusterController3.a = clientIdRegistry;
        clusterController2.H = applicationEventPublisher;
        clusterController2.G = limits;
        clusterController.D = channelExceptionHandler;
        clusterController.m = a2;
    }

    public void stop() {
        ClusterController a4;
        ClusterController clusterController = a4;
        clusterController.C.shutdown();
        clusterController.E.forEach((a2, a3) -> a3.i());
        a4.i = false;
    }

    public boolean isAdminNode() {
        ClusterController a2;
        return a2.b.get();
    }

    @EventListener
    @Transactional
    public void on(DeleteNode a2) {
        ClusterController a3;
        a3.deleteNode(a2.getNodeName());
    }

    public FlowControl getCommandFlowControl() {
        ClusterController a2;
        return a2.J.getCommandFlowControl();
    }

    public boolean isActive(String a2) {
        ClusterController a3;
        if (a2.equals(a3.j.getName()) || a3.E.get(a2) != null && ((RemoteConnection)a3.E.get(a2)).K()) {
            return true;
        }
        return false;
    }

    public Stream<ClusterNode> activeNodes() {
        ClusterController a3;
        return a3.nodes().filter(a2 -> {
            ClusterController a3;
            return a3.isActive(a2.getName());
        });
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupUpdated a2) {
        ClusterController a3;
        a3.e.clear();
        if (RaftAdminGroup.g((String)a2.replicationGroup())) {
            a3.b.set(a3.getMe().isAdmin());
        }
    }

    @Transactional
    public void start() {
        ClusterController a3;
        ClusterController clusterController = a3;
        clusterController.K();
        clusterController.F.debug(AxonServers.g((Object)"k\u001dY\u001bLI[\u0005M\u001aL\fJI[\u0006V\u001dJ\u0006T\u0005]\u001b"));
        clusterController.nodes().forEach(a2 -> {
            ClusterController a3;
            a3.g(a2, true);
        });
        a3.C.scheduleWithFixedDelay(() -> {
            ClusterController a2;
            a2.E.values().forEach(RemoteConnection::f);
        }, a3.J.getConnectionCheckDelay(), a3.J.getConnectionCheckInterval(), TimeUnit.MILLISECONDS);
        a3.i = true;
    }

    public void setApplicationContext(@Nonnull ApplicationContext a2) {
        this.h = a2;
    }

    public Optional<RemoteConnection> getRemoteConnection(String a2) {
        ClusterController a3;
        return Optional.ofNullable((RemoteConnection)a3.E.get(a2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ ClusterNode g(NodeInfo a2) {
        ClusterController a3;
        AdminNodes adminNodes = a3.I;
        synchronized (adminNodes) {
            ClusterNode clusterNode;
            ClusterController clusterController;
            Optional optional = a3.I.findById(a2.getNodeName());
            if (!optional.isPresent()) {
                optional = a3.I.findFirstByInternalHostNameAndGrpcInternalPort(a2.getInternalHostName(), a2.getGrpcInternalPort());
                if (optional.isPresent()) {
                    a3.I.delete((ClusterNode)optional.get());
                    RemoteConnection remoteConnection = (RemoteConnection)a3.E.remove(((ClusterNode)optional.get()).getName());
                    if (remoteConnection != null) {
                        remoteConnection.i();
                    }
                }
                ClusterController clusterController2 = a3;
                clusterController = clusterController2;
                clusterNode = clusterController2.f.clusterNode(a2);
            } else {
                clusterNode = (ClusterNode)optional.get();
                clusterController = a3;
                ClusterNode clusterNode2 = clusterNode;
                NodeInfo nodeInfo = a2;
                ClusterNode clusterNode3 = clusterNode;
                clusterNode3.setGrpcInternalPort(Integer.valueOf(a2.getGrpcInternalPort()));
                clusterNode3.setGrpcPort(Integer.valueOf(a2.getGrpcPort()));
                clusterNode.setHostName(nodeInfo.getHostName());
                clusterNode2.setHttpPort(Integer.valueOf(nodeInfo.getHttpPort()));
                clusterNode2.setInternalHostName(a2.getInternalHostName());
            }
            return clusterController.I.save(clusterNode);
        }
    }

    public void publishEvent(Object a2) {
        ClusterController a3;
        a3.H.publishEvent(a2);
    }

    public void addNodeListener(Consumer<ClusterEvent> a2) {
        ClusterController a3;
        a3.K.add(a2);
    }

    @Transactional
    public synchronized void handleRemoteConnection(NodeInfo a2) {
        Object object;
        ClusterController a3;
        Object object2 = a2.getNodeName();
        ClusterNode clusterNode = a3.getNode((String)object2);
        if (clusterNode == null) {
            ClusterController clusterController = a3;
            clusterNode = clusterController.addConnection(a2);
            object = (RemoteConnection)clusterController.E.remove(object2);
            if (object != null) {
                object.i();
            }
        }
        if (!a3.E.containsKey(object2)) {
            ClusterController clusterController = a3;
            clusterController.g(clusterNode, false);
            object = clusterController.K.iterator();
            Iterator iterator = object;
            while (iterator.hasNext()) {
                object2 = (Consumer)object.next();
                iterator = object;
                object2.accept(new ClusterEvent(ClusterEvent.EventType.h, clusterNode));
            }
        }
        a3.H.publishEvent((Object)new ClusterEvents.AxonServerNodeConnected(a2));
    }
}

