/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster.internal;

import io.axoniq.axonserver.cluster.grpc.LeaderElectionService;
import io.axoniq.axonserver.cluster.grpc.LogReplicationService;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.diagnostics.DiagnosticsOptions;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalAuthenticationInterceptor;
import io.axoniq.axonserver.enterprise.cluster.internal.ReplicationServerStarted;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AxonServerInternalService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.logging.PluginEventsLogger;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.Epoll;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component(value="MessagingClusterServer")
public class MessagingClusterServer
implements SmartLifecycle {
    private final ExecutorService E;
    private final LeaderElectionService i;
    private Server G;
    private final LogReplicationService f;
    private final Supplier<ScheduledExecutorService> c;
    private final ApplicationEventPublisher j;
    private AdvancedTlsX509KeyManager.Closeable H;
    private boolean m;
    private final Logger h;
    private final List<AxonServerInternalService> b;
    private final MessagingPlatformConfiguration I;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        try {
            MessagingClusterServer messagingClusterServer;
            NettyServerBuilder nettyServerBuilder;
            NettyServerBuilder nettyServerBuilder2;
            MessagingClusterServer a2;
            String string = PluginEventsLogger.g((Object)"q\u007f?CL\\");
            if (a2.I.getSsl() != null && a2.I.getSsl().isEnabled()) {
                Object object = a2.I.getSsl().getInternalCertChainFile();
                if (object == null) {
                    throw new RuntimeException(DiagnosticsOptions.g((Object)"u*{<}#:3l=z!q b7f|g!x|w7f&91|3}<94}>qrz=`rg7`"));
                }
                Object object2 = a2.I.getSsl().getInternalPrivateKeyFile();
                if (object2 == null) {
                    throw new RuntimeException(PluginEventsLogger.g((Object)"~hp~va1qg\u007fqczbium>lcs>obvf~dz=tuf=yysu?~pd?czd"));
                }
                object2 = new File((String)object2);
                object = new File((String)object);
                if (!((File)object2).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object2).getCanonicalPath());
                }
                if (!((File)object).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object).getCanonicalPath());
                }
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                a2.H = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile((File)object2, (File)object, 1L, TimeUnit.MINUTES, (ScheduledExecutorService)a2.c.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                object = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                nettyServerBuilder2 = NettyServerBuilder.forPort((int)a2.I.getInternalPort(), (ServerCredentials)object);
                string = DiagnosticsOptions.g((Object)"G\u0001Xrq<u0x7p");
                nettyServerBuilder = nettyServerBuilder2;
            } else {
                nettyServerBuilder = nettyServerBuilder2 = NettyServerBuilder.forPort((int)a2.I.getInternalPort());
            }
            nettyServerBuilder.permitKeepAliveTime(a2.I.getMinKeepAliveTime(), TimeUnit.MILLISECONDS).permitKeepAliveWithoutCalls(true);
            if (a2.I.getMaxMessageSize() > 0) {
                nettyServerBuilder2.maxInboundMessageSize(a2.I.getMaxMessageSize());
            }
            nettyServerBuilder2.intercept((ServerInterceptor)new InternalAuthenticationInterceptor(a2.I));
            a2.b.forEach(a3 -> {
                LinkedList<ContextInterceptor> linkedList = new LinkedList<ContextInterceptor>(a3.interceptors());
                if (a3.requiresContextInterceptor()) {
                    linkedList.add(new ContextInterceptor());
                }
                nettyServerBuilder2.addService(ServerInterceptors.intercept((BindableService)a3, linkedList));
            });
            MessagingClusterServer messagingClusterServer2 = a2;
            nettyServerBuilder2.addService((BindableService)a2.i);
            nettyServerBuilder2.addService((BindableService)messagingClusterServer2.f);
            if (messagingClusterServer2.I.getKeepAliveTime() > 0L) {
                nettyServerBuilder2.keepAliveTime(a2.I.getKeepAliveTime(), TimeUnit.MILLISECONDS);
                nettyServerBuilder2.keepAliveTimeout(a2.I.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            nettyServerBuilder2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(a2.I.getGrpcBufferedMessages()));
            nettyServerBuilder2.executor((Executor)a2.E);
            if (Epoll.isAvailable()) {
                messagingClusterServer = a2;
                nettyServerBuilder2.bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(PluginEventsLogger.g((Object)"sseldzb2rpcl="))));
                nettyServerBuilder2.workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(DiagnosticsOptions.g((Object)"w>a!`7f\u007fc=f9q 9"))));
                nettyServerBuilder2.channelType(EpollServerSocketChannel.class);
            } else {
                nettyServerBuilder2.bossEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(PluginEventsLogger.g((Object)"sseldzb2rpcl="))));
                nettyServerBuilder2.workerEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(DiagnosticsOptions.g((Object)"w>a!`7f\u007fc=f9q 9"))));
                nettyServerBuilder2.channelType(NioServerSocketChannel.class);
                messagingClusterServer = a2;
            }
            messagingClusterServer.G = nettyServerBuilder2.build();
            a2.G.start();
            a2.h.info(PluginEventsLogger.g((Object)"Qg\u007fq0Lumfzb?Sseldzb?Czbium0ld~bku{0p~?`pbk*?kb020dm"), (Object)a2.I.getInternalPort(), (Object)string);
            a2.j.publishEvent((Object)new ReplicationServerStarted());
            a2.m = true;
            return;
        }
        catch (Exception exception) {
            throw new FailedToStartException(DiagnosticsOptions.g((Object)"G&u `;z54\u0013l=zrG7f$q 4\u0011x'g&q 4\u0001q b7frr3}>q64"), (Throwable)exception);
        }
    }

    public boolean isRunning() {
        MessagingClusterServer a2;
        return a2.m;
    }

    public void stop() {
        MessagingClusterServer a2;
        if (a2.H != null) {
            a2.H.close();
        }
        a2.E.shutdown();
        try {
            if (!a2.G.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                MessagingClusterServer messagingClusterServer = a2;
                messagingClusterServer.h.debug(PluginEventsLogger.g((Object)"Y\u007fmszvj|si?ck\u007fo`v~x0\\|jckum0Lumfzb"));
                messagingClusterServer.G.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            a2.h.debug(DiagnosticsOptions.g((Object)"\u001bz&q f'd&q646a }<srg:a&p=c<4=rr}<`7f<u>4\u0013l=z\u0001q b7f"), (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        a2.m = false;
        a2.h.info(PluginEventsLogger.g((Object)"^hp~?Czbium0\\|jckum0Lumfzb?ck\u007fo`zt"));
    }

    public int getPhase() {
        return 50;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public MessagingClusterServer(MessagingPlatformConfiguration a2, LogReplicationService a3, LeaderElectionService a4, List<AxonServerInternalService> a5, Supplier<ScheduledExecutorService> a6, ApplicationEventPublisher a7) {
        MessagingClusterServer a8;
        MessagingClusterServer messagingClusterServer = a8;
        MessagingClusterServer messagingClusterServer2 = a8;
        MessagingClusterServer messagingClusterServer3 = a8;
        MessagingClusterServer messagingClusterServer4 = a8;
        messagingClusterServer4.h = LoggerFactory.getLogger(MessagingClusterServer.class);
        messagingClusterServer4.I = a2;
        messagingClusterServer3.f = a3;
        messagingClusterServer3.i = a4;
        messagingClusterServer2.b = a5;
        messagingClusterServer2.c = a6;
        messagingClusterServer.j = a7;
        messagingClusterServer.E = Executors.newFixedThreadPool(a2.getClusterExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(DiagnosticsOptions.g((Object)"w>a!`7f\u007fq*q1a&{ 9")));
    }
}

