/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication;

import io.axoniq.axonserver.LifecycleController;
import io.axoniq.axonserver.cluster.RaftGroup;
import io.axoniq.axonserver.cluster.RaftNode;
import io.axoniq.axonserver.cluster.StateChanged;
import io.axoniq.axonserver.cluster.grpc.RaftGroupManager;
import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.config.MaintenanceExecutors;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.RaftProperties;
import io.axoniq.axonserver.enterprise.cluster.GrpcRaftGroupFactory;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftGroup;
import io.axoniq.axonserver.enterprise.replication.RaftGroupRepositoryManager;
import io.axoniq.axonserver.enterprise.replication.group.ReplicationGroupController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.rest.svg.mapping.AxonServers;
import io.axoniq.axonserver.util.StringUtils;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;

@Controller
public class GrpcRaftController
implements SmartLifecycle,
RaftGroupManager {
    private volatile boolean C;
    private final RaftGroupRepositoryManager l;
    private final ApplicationEventPublisher F;
    public static final String E = "replication-logs";
    private final RaftProperties i;
    private final ReplicationGroupController G;
    private final GrpcRaftGroupFactory f;
    private final MessagingPlatformConfiguration c;
    private final FileSystemMonitor j;
    private final Map<String, RaftGroup> H;
    private final AtomicBoolean m;
    private final Logger h;
    private final LifecycleController b;
    private final Map<String, Long> I;

    public void prepareDeleteNodeFromReplicationGroup(String a2, String a3) {
        GrpcRaftController a4;
        GrpcRaftController grpcRaftController = a4;
        grpcRaftController.l.prepareDeleteNodeFromReplicationGroup(a2, a3);
        grpcRaftController.F.publishEvent((Object)new ClusterEvents.DeleteNodeFromReplicationGroupRequested(a2, a3));
    }

    public int getPhase() {
        return 100;
    }

    public Optional<RaftNode> raftNode(String a2) {
        GrpcRaftController a3;
        if ((a2 = (RaftGroup)a3.H.get(a2)) != null) {
            return Optional.of(a2.localNode());
        }
        return Optional.empty();
    }

    public String getMyLabel(List<Node> a2) {
        a2 = a2.iterator();
        while (a2.hasNext()) {
            GrpcRaftController a3;
            Node node = (Node)a2.next();
            if (!node.getNodeName().equals(a3.c.getName())) continue;
            return node.getNodeId();
        }
        throw new RuntimeException(MaintenanceExecutors.g((Object)"j9\\:MvG9]vO?G2\t5\\$[3G\"\t8F2Lv@8\t8F2L%"));
    }

    public boolean isHealthy(String a2) {
        GrpcRaftController a3;
        return a3.getRaftNodeForContext(a2).g();
    }

    public RaftNode waitForLeader(RaftGroup a2) {
        RaftGroup raftGroup = a2;
        while (!raftGroup.localNode().G() || a2.logEntryProcessor().G() == 0L) {
            try {
                Thread.sleep(100L);
                raftGroup = a2;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(AxonServers.g((Object)"q\u0007L\fJ\u001bM\u0019LIO\u0001Q\u0005]IO\bQ\u001dQ\u0007_IL\u0006\u0018\u000b]\nW\u0004]IT\fY\r]\u001b"));
            }
        }
        return a2.localNode();
    }

    public int electionTimeout() {
        GrpcRaftController a2;
        return a2.i.getMaxElectionTimeout();
    }

    public boolean isRunning() {
        GrpcRaftController a2;
        return a2.C;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ RaftGroup g(String a2, String a3) {
        GrpcRaftController a4;
        Map map = a4.H;
        synchronized (map) {
            block4: {
                GrpcRaftController grpcRaftController = a4;
                grpcRaftController.h.info(MaintenanceExecutors.g((Object)"R+\u0013v@8@\"\t$L&E?J7]?F8\t1[9\\&"), (Object)a2);
                RaftGroup raftGroup = (RaftGroup)grpcRaftController.H.get(a2);
                if (raftGroup == null) break block4;
                return raftGroup;
            }
            a3 = a4.f.create(a2, a3);
            a3.localNode().g(arg_0 -> a4.g((RaftGroup)a3, arg_0));
            a4.H.put(a2, a3);
            return a3;
        }
    }

    public String getMyName() {
        GrpcRaftController a2;
        return a2.c.getName();
    }

    private /* synthetic */ void g(String a2) {
        GrpcRaftController a3;
        a3.I.put(a2, System.currentTimeMillis() + 2L * (long)a3.i.getMaxElectionTimeout());
    }

    public void stop() {
        GrpcRaftController a4;
        GrpcRaftController grpcRaftController = a4;
        grpcRaftController.j.unregisterPath(E);
        grpcRaftController.H.forEach((a2, a3) -> a3.stop());
        a4.C = false;
    }

    private /* synthetic */ void g(RaftGroup a2, StateChanged a3) {
        GrpcRaftController a4;
        a4.g(a2.localNode(), a3);
    }

    private /* synthetic */ boolean g(String a2) {
        GrpcRaftController a3;
        if (a3.I.getOrDefault(a2, 0L) > System.currentTimeMillis()) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaftNode getOrCreateRaftNode(String a2, String a3) {
        GrpcRaftController a4;
        if (!a4.C) {
            throw new IllegalStateException(AxonServers.g((Object)":]\u001bN\fJIK\u001dY\u001bL\u001cHFK\u0001M\u001d\\\u0006O\u0007\u0018\u0000VIH\u001bW\u000eJ\fK\u001a"));
        }
        RaftGroup raftGroup = (RaftGroup)a4.H.get(a2);
        if (raftGroup != null) {
            return raftGroup.localNode();
        }
        Map map = a4.H;
        synchronized (map) {
            raftGroup = (RaftGroup)a4.H.get(a2);
            if (raftGroup == null) {
                if (a4.g(a2)) {
                    throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, MaintenanceExecutors.g((Object)"{3Y:@5H\"@9GvN$F#YvM3E3]?F8\t?GvY$F1[3Z%"));
                }
                raftGroup = a4.g(a2, a3);
                raftGroup.startAndWait(null);
            }
        }
        return raftGroup.localNode();
    }

    @Scheduled(fixedDelay=1000L)
    public void syncStore() {
        GrpcRaftController a4;
        if (a4.C) {
            a4.H.forEach((a2, a3) -> ((GrpcRaftGroup)a3).g());
        }
    }

    public RaftNode getRaftNode(String a2) {
        GrpcRaftController a3;
        if (!a3.C) {
            throw new IllegalStateException(AxonServers.g((Object)"q\u0007Q\u001dQ\bT\u0000B\bL\u0000W\u0007\u0018\u0006JIK\u0001M\u001d\\\u0006O\u0007\u0018\u0000VIH\u001bW\u000eJ\fK\u001a"));
        }
        if (!a3.H.containsKey(a2)) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.c.getName() + ": Not a member of " + a2);
        }
        return ((RaftGroup)a3.H.get(a2)).localNode();
    }

    public boolean ready() {
        GrpcRaftController a2;
        return a2.m.get();
    }

    public RaftGroup getRaftGroup(String a2) {
        GrpcRaftController a3;
        return (RaftGroup)a3.H.get(a2);
    }

    public void delete(String a2, boolean a3) {
        GrpcRaftController a4;
        if (!a3) {
            a4.g(a2);
        }
        a4.H.remove(a2);
        GrpcRaftController grpcRaftController = a4;
        grpcRaftController.G.deleteReplicationGroup(a2, a3);
        grpcRaftController.F.publishEvent((Object)new ClusterEvents.ReplicationGroupDeleted(a2, a3));
    }

    private /* synthetic */ void g(RaftNode a2, StateChanged a3) {
        GrpcRaftController a4;
        StateChanged stateChanged = a3;
        String string = stateChanged.K();
        long l2 = a2.f();
        if (stateChanged.L() && !a3.G()) {
            a4.F.publishEvent((Object)new ClusterEvents.LeaderStepDown(string, l2));
            return;
        }
        if (a3.G() && !a3.L()) {
            a4.F.publishEvent((Object)new ClusterEvents.BecomeLeader(string, () -> ((RaftNode)a2).g(), l2));
            return;
        }
        if (a3.K()) {
            a4.F.publishEvent((Object)new ClusterEvents.LeaderConfirmation(string, null, l2));
            return;
        }
        if (!StringUtils.isEmpty((String)a2.K())) {
            a4.F.publishEvent((Object)new ClusterEvents.LeaderConfirmation(string, a2.K(), l2));
        }
    }

    public void start() {
        GrpcRaftController a4;
        Object object = new File(a4.i.getLogStorageFolder());
        GrpcRaftController grpcRaftController = a4;
        FileUtils.g((File)object);
        grpcRaftController.j.registerPath(E, ((File)object).toPath());
        object = grpcRaftController.l.getMyReplicationGroups();
        object.forEach(a2 -> {
            GrpcRaftController a3;
            a3.g(a2.groupId(), a2.nodeId());
        });
        a4.C = true;
        AtomicInteger atomicInteger = new AtomicInteger(object.size());
        object.forEach(a3 -> {
            GrpcRaftController a6;
            try {
                GrpcRaftController grpcRaftController = a6;
                grpcRaftController.h.info(MaintenanceExecutors.g((Object)"R+\u0013v{3Y:@5H\"@9GvN$F#YvZ\"H$]?G1"), (Object)a3.groupId());
                ((RaftGroup)grpcRaftController.H.get(a3.groupId())).start(a3.role()).whenComplete((a4, a5) -> {
                    GrpcRaftController a6;
                    if (a5 == null) {
                        a6.h.info(MaintenanceExecutors.g((Object)"-Tl\t\u0004L&E?J7]?F8\t1[9\\&\t%]7[\"L2"), (Object)a3.groupId());
                        if (atomicInteger.decrementAndGet() == 0) {
                            GrpcRaftController grpcRaftController = a6;
                            grpcRaftController.b.setCleanShutdown();
                            grpcRaftController.m.set(true);
                            return;
                        }
                    } else {
                        a6.h.warn(AxonServers.g((Object)"C\u0014\u0002Ij\fH\u0005Q\nY\u001dQ\u0006VI_\u001bW\u001cHIK\u001dY\u001bLI^\bQ\u0005]\r"), (Object)a3.groupId(), a5);
                    }
                });
                return;
            }
            catch (Exception a22) {
                a6.h.warn(AxonServers.g((Object)"\u0012ES\u0018/Y\u0000T\f\\IL\u0006\u0018\u0000V\u0000L\u0000Y\u0005Q\u0013]IJ\fH\u0005Q\nY\u001dQ\u0006V.J\u0006M\u0019"), (Object)a3.groupId(), (Object)a22);
                return;
            }
        });
        a4.h.info(MaintenanceExecutors.g((Object)"{3Y:@5H\"@9GvN$F#YvJ9G\"[9E:L$\t$\\8G?G1"));
        if (object.isEmpty()) {
            a4.m.set(true);
        }
    }

    public Iterable<String> getAllNonAdminContexts() {
        GrpcRaftController a2;
        return a2.l.contexts();
    }

    public Set<String> raftGroups() {
        GrpcRaftController a2;
        return a2.H.keySet();
    }

    public RaftNode getRaftNodeForContext(String a2) {
        GrpcRaftController a3;
        return a3.G.findReplicationGroupByContext(a2).map(arg_0 -> a3.getRaftNode(arg_0)).orElseThrow(() -> {
            GrpcRaftController a3;
            return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.c.getName() + ": Not a member of " + a2);
        });
    }

    public Collection<String> getRaftGroups() {
        GrpcRaftController a2;
        return a2.H.keySet();
    }

    public RaftGroup initRaftGroup(String a2, String a3, String a4) {
        GrpcRaftController a5;
        a4 = Node.newBuilder().setNodeId(a3).setHost(a5.c.getFullyQualifiedInternalHostname()).setPort(a5.c.getInternalPort()).setNodeName(a4).setRole(Role.PRIMARY).build();
        GrpcRaftController grpcRaftController = a5;
        a3 = grpcRaftController.g(a2, a3);
        a3.raftConfiguration().update(Collections.singletonList(a4));
        grpcRaftController.h.debug(AxonServers.g((Object)":L\bJ\u001d\u0018\u000fJ\u0006UIQ\u0007Q\u001dj\b^\u001d\u007f\u001bW\u001cHIC\u0014"), (Object)a2);
        String string = a3;
        string.startAndWait(Role.PRIMARY);
        return string;
    }

    public GrpcRaftController(MessagingPlatformConfiguration a2, RaftProperties a3, RaftGroupRepositoryManager a4, ApplicationEventPublisher a5, ReplicationGroupController a6, GrpcRaftGroupFactory a7, FileSystemMonitor a8, LifecycleController a9) {
        GrpcRaftController a10;
        GrpcRaftController grpcRaftController = a10;
        GrpcRaftController grpcRaftController2 = a10;
        GrpcRaftController grpcRaftController3 = a10;
        GrpcRaftController grpcRaftController4 = a10;
        GrpcRaftController grpcRaftController5 = a10;
        a10.h = LoggerFactory.getLogger(GrpcRaftController.class);
        GrpcRaftController grpcRaftController6 = a10;
        grpcRaftController5.H = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController7 = a10;
        grpcRaftController6.I = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController8 = a10;
        grpcRaftController5.m = new AtomicBoolean();
        grpcRaftController4.c = a2;
        grpcRaftController4.l = a4;
        grpcRaftController3.G = a6;
        grpcRaftController3.i = a3;
        grpcRaftController2.F = a5;
        grpcRaftController2.f = a7;
        grpcRaftController.j = a8;
        grpcRaftController.b = a9;
    }
}

