/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication;

import io.axoniq.axonserver.cluster.util.RoleUtils;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.runtime.Context;
import io.axoniq.axonserver.configuration.runtime.Contexts;
import io.axoniq.axonserver.configuration.runtime.ReplicationGroupMember;
import io.axoniq.axonserver.configuration.runtime.ReplicationGroupMembers;
import io.axoniq.axonserver.configuration.runtime.RuntimeConfigurationFactory;
import io.axoniq.axonserver.enterprise.replication.C;
import io.axoniq.axonserver.enterprise.replication.ContextReplicationGroupProvider;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.cluster.Role;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class RaftGroupRepositoryManager {
    private final ReplicationGroupMembers c;
    private final RuntimeConfigurationFactory j;
    private final ContextReplicationGroupProvider H;
    private final MessagingPlatformConfiguration m;
    private final Contexts h;
    private final Map<String, Role> b;
    private final Map<String, Map<Role, Set<String>>> I;

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ Role f(String a2) {
        RaftGroupRepositoryManager a3;
        a2 = a3.g(a2);
        switch (C.I[a2.ordinal()]) {
            case 1: 
            case 2: {
                return Role.SECONDARY;
            }
        }
        return Role.UNRECOGNIZED;
    }

    public List<Node> get(String a2) {
        RaftGroupRepositoryManager a3;
        return a3.c.findByGroupId(a2).stream().map(ReplicationGroupMember::asNode).collect(Collectors.toList());
    }

    public boolean containsStorageContext(String a2) {
        RaftGroupRepositoryManager a3;
        return a3.storageContexts().contains(a2);
    }

    private /* synthetic */ Role g(String a3) {
        RaftGroupRepositoryManager a4;
        return a4.b.computeIfAbsent(a3, a2 -> {
            RaftGroupRepositoryManager a3;
            return a3.c.findByGroupIdAndNodeName(a2, a3.m.getName()).map(ReplicationGroupMember::role).orElse(Role.UNRECOGNIZED);
        });
    }

    public Set<ReplicationGroupMember> findByGroupId(String a2) {
        RaftGroupRepositoryManager a3;
        return a3.c.findByGroupId(a2);
    }

    public Set<ReplicationGroupMember> getMyReplicationGroups() {
        RaftGroupRepositoryManager a2;
        RaftGroupRepositoryManager raftGroupRepositoryManager = a2;
        return raftGroupRepositoryManager.findByNodeName(raftGroupRepositoryManager.m.getName());
    }

    public Set<String> storageContexts() {
        RaftGroupRepositoryManager a2;
        RaftGroupRepositoryManager raftGroupRepositoryManager = a2;
        return raftGroupRepositoryManager.g(raftGroupRepositoryManager.H.getAll(), RoleUtils::K);
    }

    @Transactional
    public void update(String a2, List<Node> a4) {
        RaftGroupRepositoryManager a6;
        RaftGroupRepositoryManager raftGroupRepositoryManager = a6;
        raftGroupRepositoryManager.c.deleteAllByGroupId(a2);
        a4.forEach(a3 -> {
            RaftGroupRepositoryManager a4;
            RaftGroupRepositoryManager raftGroupRepositoryManager = a4;
            a2 = raftGroupRepositoryManager.j.replicationGroupMember(a2, a3);
            raftGroupRepositoryManager.c.save((ReplicationGroupMember)a2);
        });
        EnumMap enumMap = new EnumMap(Role.class);
        a4.forEach(a5 -> {
            RaftGroupRepositoryManager a6;
            enumMap.computeIfAbsent(a5.getRole(), a2 -> new HashSet()).add(a5.getNodeName());
            if (a5.getNodeName().equals(a6.m.getName())) {
                a6.b.put(a2, a5.getRole());
            }
        });
        a6.I.put(a2, enumMap);
    }

    public Set<ReplicationGroupMember> nodesByContext(String a2) {
        RaftGroupRepositoryManager a3;
        RaftGroupRepositoryManager raftGroupRepositoryManager = a3;
        return raftGroupRepositoryManager.findByGroupId(raftGroupRepositoryManager.g(a2));
    }

    private /* synthetic */ String g(String a2) {
        RaftGroupRepositoryManager a3;
        return a3.H.get(a2);
    }

    public void prepareDeleteNodeFromReplicationGroup(String a3, String a4) {
        RaftGroupRepositoryManager a5;
        a5.c.findByGroupIdAndNodeName(a3, a4).ifPresent(a2 -> {
            RaftGroupRepositoryManager a3;
            a2.pendingDelete(true);
            a3.c.save(a2);
        });
    }

    public RaftGroupRepositoryManager(@Qualifier(value="inMemoryContextsGroupProvider") ContextReplicationGroupProvider replicationGroupProvider, ReplicationGroupMembers raftGroupNodeRepository, Contexts contexts, RuntimeConfigurationFactory runtimeConfigurationFactory, MessagingPlatformConfiguration a2) {
        RaftGroupRepositoryManager raftGroupRepositoryManager = this;
        RaftGroupRepositoryManager raftGroupRepositoryManager2 = this;
        RaftGroupRepositoryManager raftGroupRepositoryManager3 = this;
        RaftGroupRepositoryManager raftGroupRepositoryManager4 = this;
        raftGroupRepositoryManager3.I = new ConcurrentHashMap();
        RaftGroupRepositoryManager raftGroupRepositoryManager5 = this;
        raftGroupRepositoryManager3.b = new ConcurrentHashMap();
        raftGroupRepositoryManager3.H = replicationGroupProvider;
        raftGroupRepositoryManager2.c = raftGroupNodeRepository;
        raftGroupRepositoryManager2.h = contexts;
        raftGroupRepositoryManager.j = runtimeConfigurationFactory;
        raftGroupRepositoryManager.m = a2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int tier(String a2) {
        RaftGroupRepositoryManager a3;
        RaftGroupRepositoryManager raftGroupRepositoryManager = a3;
        a2 = raftGroupRepositoryManager.g(raftGroupRepositoryManager.g(a2));
        switch (C.I[a2.ordinal()]) {
            case 1: 
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public Set<String> nextTierEventStores(String a3) {
        RaftGroupRepositoryManager a4;
        RaftGroupRepositoryManager raftGroupRepositoryManager = a4;
        Role role = raftGroupRepositoryManager.f(a3 = raftGroupRepositoryManager.g(a3));
        if (Role.UNRECOGNIZED.equals((Object)role)) {
            return Collections.emptySet();
        }
        return a4.I.computeIfAbsent(a3, a2 -> {
            RaftGroupRepositoryManager a3;
            EnumMap<Role, Set<String>> enumMap = new EnumMap<Role, Set<String>>(Role.class);
            a3.c.findByGroupId(a2).forEach(a4 -> enumMap.computeIfAbsent(a4.role(), a2 -> new HashSet()).add(a4.nodeName()));
            return enumMap;
        }).getOrDefault(role, Collections.emptySet());
    }

    public Set<String> contextsPerReplicationGroup(String a2) {
        RaftGroupRepositoryManager a3;
        return a3.h.findByReplicationGroupName(a2).stream().map(Context::getName).collect(Collectors.toSet());
    }

    public Set<ReplicationGroupMember> findByNodeName(String a2) {
        RaftGroupRepositoryManager a3;
        return new HashSet<ReplicationGroupMember>(a3.c.findByNodeName(a2));
    }

    private /* synthetic */ Set<String> g(Map<String, String> a2, Predicate<Role> a3) {
        RaftGroupRepositoryManager a6;
        HashSet<String> hashSet = new HashSet<String>();
        a2.forEach((a4, a5) -> {
            RaftGroupRepositoryManager a6;
            if (a3.test(a6.g(a5))) {
                hashSet.add((String)a4);
            }
        });
        return hashSet;
    }

    public Set<String> contexts() {
        RaftGroupRepositoryManager a2;
        return a2.H.getAll().keySet();
    }

    public boolean hasLowerTier(String a2) {
        RaftGroupRepositoryManager a3;
        if (!a3.nextTierEventStores(a2).isEmpty()) {
            return true;
        }
        return false;
    }
}

