/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication;

import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.cluster.grpc.RaftGroupManager;
import io.axoniq.axonserver.cluster.replication.EntryIterator;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.E;
import io.axoniq.axonserver.enterprise.replication.RaftGroupRepositoryManager;
import io.axoniq.axonserver.enterprise.replication.SnapshotDataProviders;
import io.axoniq.axonserver.enterprise.replication.admin.AdminReplicationGroupController;
import io.axoniq.axonserver.replication.ReplicationLeaderProvider;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
public class RaftLeaderProviderImpl
implements ReplicationLeaderProvider {
    private final String f;
    private final RaftGroupManager c;
    private final Map<String, String> j;
    private static final EntryIterator H = new E();
    private final Set<Consumer<String>> m;
    private final ApplicationEventPublisher h;
    private final Function<String, Set<String>> b;
    private final Logger I;

    @EventListener
    public void on(ClusterEvents.LeaderStepDown a2) {
        RaftLeaderProviderImpl a3;
        long l2 = a3.c.currentTerm(a2.replicationGroup()).orElse(-1L);
        RaftLeaderProviderImpl raftLeaderProviderImpl = a3;
        raftLeaderProviderImpl.j.remove(a2.replicationGroup());
        ((Set)raftLeaderProviderImpl.b.apply(a2.replicationGroup())).forEach(a4 -> {
            RaftLeaderProviderImpl a5;
            a5.h.publishEvent((Object)new ClusterEvents.ContextLeaderStepDown(a4, a2.replicationGroup(), l2));
        });
        a3.g(a2.replicationGroup());
    }

    public String getLeader(String a2) {
        RaftLeaderProviderImpl a3;
        return (String)a3.j.get(a2);
    }

    @EventListener
    public void on(ContextEvents.ContextDeleted a2) {
        RaftLeaderProviderImpl a5;
        long l2 = a5.c.currentTerm(a2.replicationGroup()).orElse(-1L);
        ((Set)a5.b.apply(a2.replicationGroup())).stream().filter(a3 -> a3.equals(a2.context())).forEach(a4 -> {
            RaftLeaderProviderImpl a5;
            a5.h.publishEvent((Object)new ClusterEvents.ContextLeaderConfirmation(a4, a2.replicationGroup(), (String)a5.j.get(a2.replicationGroup()), l2));
        });
    }

    private /* synthetic */ void g(String a2) {
        RaftLeaderProviderImpl a4;
        a4.m.forEach(a3 -> a3.accept(a2));
    }

    @EventListener
    public void on(ClusterEvents.LeaderConfirmation a2) {
        RaftLeaderProviderImpl raftLeaderProviderImpl;
        RaftLeaderProviderImpl a3;
        long l2 = a3.c.currentTerm(a2.replicationGroup()).orElse(-1L);
        if (a2.term() < l2) {
            return;
        }
        if (a2.node() == null) {
            RaftLeaderProviderImpl raftLeaderProviderImpl2 = a3;
            raftLeaderProviderImpl = raftLeaderProviderImpl2;
            raftLeaderProviderImpl2.j.remove(a2.replicationGroup());
        } else {
            RaftLeaderProviderImpl raftLeaderProviderImpl3 = a3;
            raftLeaderProviderImpl = raftLeaderProviderImpl3;
            raftLeaderProviderImpl3.j.put(a2.replicationGroup(), a2.node());
        }
        ((Set)raftLeaderProviderImpl.b.apply(a2.replicationGroup())).forEach(a4 -> {
            RaftLeaderProviderImpl a5;
            a5.h.publishEvent((Object)new ClusterEvents.ContextLeaderConfirmation(a4, a2.replicationGroup(), a2.node(), l2));
        });
    }

    public Set<String> leaderFor() {
        RaftLeaderProviderImpl a2;
        return a2.j.keySet().stream().filter(arg_0 -> a2.isLeader(arg_0)).collect(Collectors.toSet());
    }

    public void registerLeaderChangeListener(Consumer<String> a2) {
        RaftLeaderProviderImpl a3;
        a3.m.add(a2);
    }

    @EventListener
    @Order(value=100)
    public void on(ContextEvents.ContextCreated a2) {
        RaftLeaderProviderImpl a3;
        String string = (String)a3.j.get(a2.replicationGroup());
        Optional optional = a3.c.currentTerm(a2.replicationGroup());
        if (!optional.isPresent()) {
            return;
        }
        if (a3.f.equals(string)) {
            a3.h.publishEvent((Object)new ClusterEvents.BecomeContextLeader(a2.context(), a2.replicationGroup(), () -> H, ((Long)optional.get()).longValue()));
            return;
        }
        a3.h.publishEvent((Object)new ClusterEvents.ContextLeaderConfirmation(a2.context(), a2.replicationGroup(), string, ((Long)optional.get()).longValue()));
    }

    @EventListener
    public void on(ClusterEvents.LeaderNotification a2) {
        RaftLeaderProviderImpl a3;
        long l2 = a3.c.currentTerm(a2.replicationGroup()).orElse(-1L);
        if (a2.term() < l2) {
            return;
        }
        if (!a2.node().equals(a3.j.get(a2.replicationGroup()))) {
            RaftLeaderProviderImpl raftLeaderProviderImpl = a3;
            raftLeaderProviderImpl.j.put(a2.replicationGroup(), a2.node());
            ((Set)raftLeaderProviderImpl.b.apply(a2.replicationGroup())).forEach(a4 -> {
                RaftLeaderProviderImpl a5;
                a5.h.publishEvent((Object)new ClusterEvents.ContextLeaderConfirmation(a4, a2.replicationGroup(), a2.node(), l2));
            });
            a3.g(a2.replicationGroup());
        }
    }

    public boolean isLeader(String a2) {
        RaftLeaderProviderImpl a3;
        String string = (String)a3.j.get(a2);
        a3.I.debug(SnapshotDataProviders.g((Object)"]f\u001c;EsCxMrH|\u0006wCzB~T;]f"), (Object)a2, (Object)string);
        if (string != null && string.equals(a3.f)) {
            return true;
        }
        return false;
    }

    @EventListener
    @Order(value=10)
    public void on(ClusterEvents.BecomeLeader a2) {
        RaftLeaderProviderImpl a3;
        long l2 = a3.c.currentTerm(a2.replicationGroup()).orElse(-1L);
        if (a2.term() < l2) {
            return;
        }
        RaftLeaderProviderImpl raftLeaderProviderImpl = a3;
        raftLeaderProviderImpl.j.put(a2.replicationGroup(), a3.f);
        ((Set)raftLeaderProviderImpl.b.apply(a2.replicationGroup())).forEach(a4 -> {
            RaftLeaderProviderImpl a5;
            a5.h.publishEvent((Object)new ClusterEvents.BecomeContextLeader(a4, a2.replicationGroup(), a2.unappliedEntriesSupplier(), l2));
        });
        RaftLeaderProviderImpl raftLeaderProviderImpl2 = a3;
        raftLeaderProviderImpl2.h.publishEvent((Object)new ClusterEvents.LeaderNotification(a2.replicationGroup(), a3.f, l2));
        raftLeaderProviderImpl2.g(a2.replicationGroup());
    }

    @Autowired
    public RaftLeaderProviderImpl(MessagingPlatformConfiguration a2, RaftGroupRepositoryManager a3, AdminReplicationGroupController a5, ApplicationEventPublisher a6, RaftGroupManager a7) {
        a8(a2.getName(), a4 -> {
            Set set = a3.contextsPerReplicationGroup(a4);
            if (set.isEmpty()) {
                set = a5.contextsPerReplicationGroup(a4);
            }
            return set;
        }, a6, a7);
        RaftLeaderProviderImpl a8;
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupUpdated a2) {
        RaftLeaderProviderImpl a3;
        if (a3.j.containsKey(a2.replicationGroup())) {
            long l2 = a3.c.currentTerm(a2.replicationGroup()).orElse(-1L);
            ((Set)a3.b.apply(a2.replicationGroup())).forEach(a4 -> {
                RaftLeaderProviderImpl a5;
                a5.h.publishEvent((Object)new ClusterEvents.ContextLeaderConfirmation(a4, a2.replicationGroup(), (String)a5.j.get(a2.replicationGroup()), l2));
            });
        }
    }

    RaftLeaderProviderImpl(String a2, Function<String, Set<String>> a3, ApplicationEventPublisher a4, RaftGroupManager a5) {
        RaftLeaderProviderImpl a6;
        RaftLeaderProviderImpl raftLeaderProviderImpl = a6;
        RaftLeaderProviderImpl raftLeaderProviderImpl2 = a6;
        a6.I = LoggerFactory.getLogger(RaftLeaderProviderImpl.class);
        RaftLeaderProviderImpl raftLeaderProviderImpl3 = a6;
        a6.j = new ConcurrentHashMap();
        RaftLeaderProviderImpl raftLeaderProviderImpl4 = a6;
        raftLeaderProviderImpl3.m = new CopyOnWriteArraySet();
        raftLeaderProviderImpl2.f = a2;
        raftLeaderProviderImpl2.b = a3;
        raftLeaderProviderImpl.h = a4;
        raftLeaderProviderImpl.c = a5;
    }
}

