/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication.admin;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.access.application.AdminApplicationController;
import io.axoniq.axonserver.admin.user.requestprocessor.UserController;
import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.component.processor.balancing.strategy.AdminProcessorLoadBalancingService;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminContext;
import io.axoniq.axonserver.configuration.admin.AdminContexts;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroups;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatMonitor;
import io.axoniq.axonserver.grpc.internal.Context;
import io.axoniq.axonserver.grpc.internal.ContextConfiguration;
import io.axoniq.axonserver.grpc.internal.NodeInfoWithLabel;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupConfiguration;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupContexts;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.plugin.AdminPluginContextManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AdminReplicationGroupController {
    private final UserController i;
    private final AdminContexts G;
    private final AdminPluginContextManager f;
    private final AdminReplicationGroups c;
    private final ApplicationEventPublisher j;
    private final Logger H;
    private final ClusterController m;
    private final AdminConfigurationFactory h;
    private final AdminApplicationController b;
    private final AdminProcessorLoadBalancingService I;

    public int count() {
        AdminReplicationGroupController a2;
        return (int)a2.c.count();
    }

    private static /* synthetic */ AdminContext g(AdminReplicationGroup a2, ContextConfiguration a3) {
        return a2.addContext(a3.getContext());
    }

    @Transactional
    public void unregisterAllContexts() {
        AdminReplicationGroupController a2;
        a2.G.deleteAll();
    }

    private /* synthetic */ boolean g(AdminReplicationGroup a2, String a4) {
        return a2.getContexts().stream().anyMatch(a3 -> a3.getName().equals(a4));
    }

    private /* synthetic */ void g(Map a2, ReplicationGroupConfiguration a3, AdminReplicationGroup a4, String a5, ClusterNode a6) {
        if (!a2.containsKey(a5)) {
            AdminReplicationGroupController a7;
            a7.H.debug(HeartbeatMonitor.g((Object)"L3\rny!S+\u0017 X:\u0017'YnY+@nT!Y(^)B<V:^!YnL3"), (Object)a3.getReplicationGroupName(), (Object)a5);
            a6.removeReplicationGroup(a4);
        }
    }

    public Optional<AdminReplicationGroup> findByName(String a2) {
        AdminReplicationGroupController a3;
        return a3.c.findByName(a2);
    }

    public Stream<AdminReplicationGroup> findAll() {
        AdminReplicationGroupController a2;
        return a2.c.findAll();
    }

    @Transactional
    public AdminReplicationGroup updateReplicationGroup(ReplicationGroupConfiguration a2) {
        Iterator iterator;
        AdminReplicationGroupController a4;
        Optional optional = a4.c.findByName(a2.getReplicationGroupName());
        if (!a2.getPending() && a2.getNodesCount() == 0) {
            optional.ifPresent(a3 -> {
                AdminReplicationGroupController a4;
                HashSet hashSet = new HashSet(a3.getContexts());
                AdminReplicationGroupController adminReplicationGroupController = a4;
                adminReplicationGroupController.c.delete(a3);
                hashSet.forEach(a2 -> {
                    AdminReplicationGroupController a3;
                    AdminReplicationGroupController adminReplicationGroupController = a3;
                    adminReplicationGroupController.i.removeRolesForContext(a2.getName());
                    adminReplicationGroupController.b.removeRolesForContext(a2.getName());
                    adminReplicationGroupController.I.deleteByContext(a2.getName());
                    adminReplicationGroupController.f.delete(a2.getName());
                });
            });
            return null;
        }
        optional = optional.orElseGet(() -> {
            AdminReplicationGroupController a3;
            AdminReplicationGroupController adminReplicationGroupController = a3;
            a2 = adminReplicationGroupController.h.adminReplicationGroup(a2.getReplicationGroupName());
            return adminReplicationGroupController.c.save((AdminReplicationGroup)a2);
        });
        optional.setChangePending(a2.getPending());
        HashMap<String, ClusterNode> hashMap = new HashMap<String, ClusterNode>();
        optional.getMembers().forEach(a3 -> hashMap.put(a3.getClusterNode().getName(), a3.getClusterNode()));
        HashMap<String, NodeInfoWithLabel> hashMap2 = new HashMap<String, NodeInfoWithLabel>();
        a2.getNodesList().forEach(a3 -> hashMap2.put(a3.getNode().getNodeName(), (NodeInfoWithLabel)a3));
        HashMap<String, ClusterNode> hashMap3 = new HashMap<String, ClusterNode>();
        Iterator iterator2 = iterator = a2.getNodesList().iterator();
        while (iterator2.hasNext()) {
            NodeInfoWithLabel nodeInfoWithLabel = (NodeInfoWithLabel)iterator.next();
            String string = nodeInfoWithLabel.getNode().getNodeName();
            ClusterNode clusterNode = a4.m.getNode(string);
            if (clusterNode == null) {
                AdminReplicationGroupController adminReplicationGroupController = a4;
                adminReplicationGroupController.H.debug(SerializedEvent.g((Object)"%\u001adG\u001d\u0015;\u0006*\u000e0\u0000~\t;\u0010~\u00041\t0\u0002=\u00137\b0G*\b~\u001c#"), (Object)a2.getReplicationGroupName(), (Object)nodeInfoWithLabel.getNode().getNodeName());
                clusterNode = adminReplicationGroupController.m.addConnection(nodeInfoWithLabel.getNode());
            }
            hashMap3.put(string, clusterNode);
            iterator2 = iterator;
        }
        hashMap.forEach((arg_0, arg_1) -> a4.g(hashMap2, a2, (AdminReplicationGroup)optional, arg_0, arg_1));
        hashMap2.forEach((arg_0, arg_1) -> a4.g(hashMap, a2, hashMap3, (AdminReplicationGroup)optional, arg_0, arg_1));
        a4.j.publishEvent((Object)new ClusterEvents.ReplicationGroupUpdated(optional.getName()));
        return optional;
    }

    public Set<String> contextsPerReplicationGroup(String a3) {
        AdminReplicationGroupController a4;
        return a4.c.findByName(a3).map(a2 -> a2.getContexts().stream().map(AdminContext::getName).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    @EventListener
    @Transactional
    public void on(ClusterEvents.DeleteNodeFromReplicationGroupRequested a2) {
        AdminReplicationGroupController a3;
        a3.c.findByName(a2.replicationGroup()).ifPresent(a4 -> {
            AdminReplicationGroupController a5;
            a4.getMember(a2.node()).ifPresent(a3 -> {
                AdminReplicationGroupController a4;
                a3.setPendingDelete(true);
                a4.c.save(a4);
            });
        });
    }

    @Transactional
    public void updateContext(String a2, Map<String, String> a3) {
        AdminReplicationGroupController a5;
        a5.G.findById(a2).ifPresent(a4 -> {
            AdminReplicationGroupController a5;
            a4.setMetaDataMap(a3);
            a5.G.save(a4);
            a5.j.publishEvent((Object)new ContextEvents.ContextUpdatedInAdmin(a2));
        });
    }

    public Collection<String> getNodeNames(String a2) {
        AdminReplicationGroupController a3;
        return a3.c.findByName(a2).map(AdminReplicationGroup::getMemberNames).orElse(Collections.emptyList());
    }

    @Transactional
    public void registerContext(String a2, String a3, Map<String, String> a4) {
        AdminReplicationGroupController a6;
        a6.c.findByName(a2).ifPresent(a5 -> {
            AdminReplicationGroupController a6;
            if (!a6.g(a5, a3)) {
                AdminReplicationGroupController adminReplicationGroupController = a6;
                AdminContext adminContext = adminReplicationGroupController.h.adminContext(a3);
                AdminReplicationGroup adminReplicationGroup = a5;
                adminContext.setMetaDataMap(a4);
                adminContext.setReplicationGroup(adminReplicationGroup);
                adminReplicationGroup.addContext(adminContext);
                adminReplicationGroupController.j.publishEvent((Object)new ClusterEvents.ReplicationGroupUpdated(a2));
                adminReplicationGroupController.j.publishEvent((Object)new ContextEvents.ContextRegisteredInAdmin(a3));
            }
        });
    }

    public AdminReplicationGroupController(AdminReplicationGroups a2, AdminContexts a3, AdminApplicationController a4, UserController a5, ClusterController a6, AdminProcessorLoadBalancingService a7, AdminPluginContextManager a8, AdminConfigurationFactory a9, ApplicationEventPublisher a10) {
        AdminReplicationGroupController a11;
        AdminReplicationGroupController adminReplicationGroupController = a11;
        AdminReplicationGroupController adminReplicationGroupController2 = a11;
        AdminReplicationGroupController adminReplicationGroupController3 = a11;
        AdminReplicationGroupController adminReplicationGroupController4 = a11;
        AdminReplicationGroupController adminReplicationGroupController5 = a11;
        adminReplicationGroupController5.H = LoggerFactory.getLogger(AdminReplicationGroupController.class);
        adminReplicationGroupController5.c = a2;
        adminReplicationGroupController4.G = a3;
        adminReplicationGroupController4.b = a4;
        adminReplicationGroupController3.i = a5;
        adminReplicationGroupController3.m = a6;
        adminReplicationGroupController2.I = a7;
        adminReplicationGroupController2.f = a8;
        adminReplicationGroupController.h = a9;
        adminReplicationGroupController.j = a10;
    }

    public int nrOfNodesInRole(Role a4, Set<String> a5) {
        AdminReplicationGroupController a6;
        return (int)a6.c.findAll().flatMap(a2 -> a2.getMembers().stream()).filter(a3 -> a4.equals((Object)a3.getRole())).map(a2 -> a2.getClusterNode().getName()).filter(a3 -> {
            if (!a5.contains(a3)) {
                return true;
            }
            return false;
        }).distinct().count();
    }

    @Transactional
    public void registerReplicationGroup(ReplicationGroupConfiguration a2) {
        Iterator iterator;
        AdminReplicationGroupController a3;
        AdminReplicationGroup adminReplicationGroup = a3.h.adminReplicationGroup(a2.getReplicationGroupName());
        Iterator iterator2 = iterator = a2.getNodesList().iterator();
        while (iterator2.hasNext()) {
            NodeInfoWithLabel nodeInfoWithLabel = (NodeInfoWithLabel)iterator.next();
            String string = nodeInfoWithLabel.getNode().getNodeName();
            iterator2 = iterator;
            a3.m.getNode(string).addReplicationGroup(adminReplicationGroup, nodeInfoWithLabel.getLabel(), nodeInfoWithLabel.getRole());
        }
        a3.c.save(adminReplicationGroup);
        a3.j.publishEvent((Object)new ClusterEvents.ReplicationGroupCreated(a2.getReplicationGroupName()));
    }

    @Transactional
    public void updateReplicationGroup(ContextConfiguration a2) {
        AdminReplicationGroupController a3;
        ReplicationGroupConfiguration replicationGroupConfiguration = ReplicationGroupConfiguration.newBuilder().setReplicationGroupName(a2.getContext()).addAllNodes((Iterable)a2.getNodesList()).build();
        AdminReplicationGroupController adminReplicationGroupController = a3;
        replicationGroupConfiguration = adminReplicationGroupController.updateReplicationGroup(replicationGroupConfiguration);
        adminReplicationGroupController.G.findById(a2.getContext()).orElseGet(() -> AdminReplicationGroupController.g((AdminReplicationGroup)replicationGroupConfiguration, a2)).setMetaDataMap(a2.getMetaDataMap());
    }

    @EventListener
    @Transactional
    public void on(ClusterEvents.ReplicationGroupDeleted a2) {
        if (RaftAdminGroup.g((String)a2.replicationGroup())) {
            AdminReplicationGroupController a3;
            a3.unregisterAllAdminData();
        }
    }

    @Transactional
    public void unregisterContext(String a3, String a4) {
        AdminReplicationGroupController a5;
        a5.G.findById(a4).ifPresent(a2 -> a2.getReplicationGroup().removeContext(a2));
        AdminReplicationGroupController adminReplicationGroupController = a5;
        adminReplicationGroupController.b.removeRolesForContext(a4);
        adminReplicationGroupController.i.removeRolesForContext(a4);
        adminReplicationGroupController.I.deleteByContext(a4);
        adminReplicationGroupController.f.delete(a4);
        adminReplicationGroupController.j.publishEvent((Object)new ClusterEvents.ReplicationGroupUpdated(a3));
        adminReplicationGroupController.j.publishEvent((Object)new ContextEvents.ContextUnregisteredInAdmin(a4));
    }

    @Transactional
    public void unregisterAllAdminData() {
        AdminReplicationGroupController a2;
        AdminReplicationGroupController adminReplicationGroupController = a2;
        adminReplicationGroupController.H.debug(HeartbeatMonitor.g((Object)"t\"R/E'Y)\u0017/S#^ \u0017<R>['T/C'X \u0017)E!B>\u0017*R(^ ^:^!Y="));
        adminReplicationGroupController.c.deleteAll();
        adminReplicationGroupController.i.deleteAll();
        adminReplicationGroupController.b.clearApplications();
        adminReplicationGroupController.G.deleteAll();
        adminReplicationGroupController.f.deleteAll();
        adminReplicationGroupController.I.deleteAll();
    }

    private /* synthetic */ void g(Map a2, ReplicationGroupConfiguration a3, Map a4, AdminReplicationGroup a5, String a6, NodeInfoWithLabel a7) {
        if (!a2.containsKey(a6)) {
            AdminReplicationGroupController a8;
            a8.H.debug(SerializedEvent.g((Object)"\u001c#]~)1\u0003;G0\b*G7\t~\u0004+\u0015,\u00020\u0013~\u00041\t8\u000e9\u0012,\u0006*\u000e1\t~\u001c#"), (Object)a3.getReplicationGroupName(), (Object)a6);
            ((ClusterNode)a4.get(a6)).addReplicationGroup(a5, a7.getLabel(), a7.getRole());
        }
    }

    @Transactional
    public void registerContexts(ReplicationGroupContexts a2) {
        Iterator iterator;
        Iterator iterator2 = iterator = a2.getContextList().iterator();
        while (iterator2.hasNext()) {
            AdminReplicationGroupController a3;
            Context context = (Context)iterator.next();
            iterator2 = iterator;
            a3.registerContext(a2.getReplicationGroupName(), context.getContextName(), context.getMetaDataMap());
        }
    }
}

