/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication.group;

import io.axoniq.axonserver.cluster.RaftGroup;
import io.axoniq.axonserver.cluster.RaftNode;
import io.axoniq.axonserver.cluster.util.AxonThreadFactory;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftController;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupService;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ReplicationGroupMemberConverter;
import io.axoniq.axonserver.grpc.cluster.ConfigChangeResult;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.grpc.internal.NodeInfoWithLabel;
import io.axoniq.axonserver.grpc.internal.ReplicationGroup;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupConfiguration;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupMember;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupUpdateConfirmation;
import io.axoniq.axonserver.grpc.internal.State;
import io.axoniq.axonserver.licensing.LicenseException;
import io.axoniq.axonserver.rest.svg.jsfunction.ShowDetail;
import io.axoniq.axonserver.util.CompetableFutureUtils;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class LocalRaftGroupService
implements RaftGroupService {
    private final GrpcRaftController h;
    private final ExecutorService b;
    private final Logger I;

    public CompletableFuture<Void> prepareDeleteNodeFromReplicationGroup(String a2, String a3) {
        LocalRaftGroupService a4;
        a4.h.prepareDeleteNodeFromReplicationGroup(a2, a3);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> appendEntry(String a2, String a3, byte[] a4) {
        LocalRaftGroupService a5;
        if ((a2 = a5.h.getRaftNode(a2)) == null) {
            CompletableFuture<Void> completableFuture;
            CompletableFuture<Void> completableFuture2 = completableFuture = new CompletableFuture<Void>();
            completableFuture2.completeExceptionally(new MessagingPlatformException(ErrorCode.OTHER, ShowDetail.g((Object)"\u0011k<d=~rl;d6*<e6orl=xri=d&o*~")));
            return completableFuture2;
        }
        return a2.g(a3, a4);
    }

    @PreDestroy
    public void stop() {
        LocalRaftGroupService a2;
        a2.b.shutdown();
    }

    public CompletableFuture<ReplicationGroupUpdateConfirmation> deleteServer(String a2, String a3) {
        LocalRaftGroupService a4;
        CompletableFuture<ReplicationGroupUpdateConfirmation> completableFuture = new CompletableFuture<ReplicationGroupUpdateConfirmation>();
        RaftNode raftNode = a4.h.getRaftNode(a2);
        try {
            raftNode.g(a3).whenComplete((a6, a7) -> {
                LocalRaftGroupService a8;
                if (a7 != null) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a2;
                    objectArray[1] = a3;
                    objectArray[2] = a7;
                    a8.I.error(LicenseException.g((Object)"fm'0Xh~umdt\u007fs0jxt|x0yuquiysw=~rtx0fm"), objectArray);
                }
                try {
                    raftNode = a8.g(raftNode, a6, a7);
                    completableFuture.complete((ReplicationGroupUpdateConfirmation)raftNode);
                    return;
                }
                catch (Exception a42) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a2;
                    objectArray[1] = a3;
                    objectArray[2] = a42;
                    a8.I.error(ShowDetail.g((Object)")wh*\u0017r1o\"~;e<*%b;f7*6o>o&c<mrd=n7*)w"), objectArray);
                    completableFuture.completeExceptionally(a42);
                    return;
                }
            });
            return completableFuture;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2;
            objectArray[1] = a3;
            objectArray[2] = exception;
            a4.I.error(LicenseException.g((Object)"fm'0Xh~umdt\u007fs0jxt|x0yuquiysw=~rtx0fm"), objectArray);
            CompletableFuture<ReplicationGroupUpdateConfirmation> completableFuture2 = completableFuture;
            completableFuture2.completeExceptionally(exception);
            return completableFuture2;
        }
    }

    public CompletableFuture<ReplicationGroupUpdateConfirmation> addServer(String a2, Node a3) {
        LocalRaftGroupService a4;
        CompletableFuture<ReplicationGroupUpdateConfirmation> completableFuture = new CompletableFuture<ReplicationGroupUpdateConfirmation>();
        RaftNode raftNode = a4.h.getRaftNode(a2);
        if (raftNode.g().stream().map(Node::getNodeName).collect(Collectors.toSet()).contains(a3.getNodeName())) {
            completableFuture.complete(ReplicationGroupUpdateConfirmation.newBuilder().setSuccess(true).addAllMembers((Iterable)raftNode.g().stream().map(ReplicationGroupMemberConverter::asContextMember).collect(Collectors.toList())).build());
            return completableFuture;
        }
        a4.b.submit(() -> {
            LocalRaftGroupService a6;
            a6.g(a2, a3, completableFuture, raftNode);
        });
        return completableFuture;
    }

    @Transactional
    public CompletableFuture<Void> deleteReplicationGroup(String a2, boolean a3) {
        LocalRaftGroupService a5;
        RaftNode raftNode = null;
        try {
            raftNode = a5.h.getRaftNode(a2);
        }
        catch (MessagingPlatformException messagingPlatformException) {
            return CompletableFuture.completedFuture(null);
        }
        return raftNode.K().thenAccept(a4 -> {
            LocalRaftGroupService a5;
            a5.h.delete(a2, a3);
        });
    }

    public CompletableFuture<Void> transferLeadership(String a22) {
        try {
            LocalRaftGroupService a3;
            a22 = a3.h.getRaftNode(a22);
            return a22.g();
        }
        catch (MessagingPlatformException a22) {
            return CompletableFuture.completedFuture(null);
        }
    }

    public LocalRaftGroupService(GrpcRaftController a2) {
        LocalRaftGroupService a3;
        LocalRaftGroupService localRaftGroupService = a3;
        localRaftGroupService.I = LoggerFactory.getLogger(LocalRaftGroupService.class);
        LocalRaftGroupService localRaftGroupService2 = a3;
        localRaftGroupService.b = Executors.newCachedThreadPool((ThreadFactory)new AxonThreadFactory(ShowDetail.g((Object)"x3l&'3y+d1'")));
        localRaftGroupService.h = a2;
    }

    public CompletableFuture<Void> getStatus(Consumer<ReplicationGroup> a2) {
        LocalRaftGroupService a4;
        a4.h.raftGroups().forEach(a3 -> {
            LocalRaftGroupService a4;
            a2.accept(a4.getStatus(a3));
        });
        return CompletableFuture.completedFuture(null);
    }

    @NotNull
    private /* synthetic */ ReplicationGroupUpdateConfirmation g(RaftNode a2, ConfigChangeResult a4, Throwable a5) {
        LocalRaftGroupService a6;
        ReplicationGroupUpdateConfirmation.Builder builder;
        ReplicationGroupUpdateConfirmation.Builder builder2 = ReplicationGroupUpdateConfirmation.newBuilder();
        a2.g().forEach(a3 -> builder2.addMembers(ReplicationGroupMemberConverter.asContextMember((Node)a3)));
        builder2.setPending(a2.K());
        if (a5 != null) {
            ReplicationGroupUpdateConfirmation.Builder builder3 = builder2;
            builder2.setSuccess(false);
            builder = builder3;
            builder3.setMessage(((Throwable)a5).getMessage());
        } else if (a4.hasNotLeader()) {
            a5 = a2.g() + ": not in leader state while receiving config change request.";
            a6.I.error((String)a5);
            ReplicationGroupUpdateConfirmation.Builder builder4 = builder2;
            builder2.setSuccess(false);
            builder = builder4;
            builder4.setMessage((String)a5);
        } else if (a4.hasFailure()) {
            a6.I.error(LicenseException.g((Object)"fm'0Xh~umdt\u007fs0jxt|x0~x|~zysw=sr~{yzeoqiyr~'0fm"), (Object)a2.g(), (Object)a4.getFailure());
            ReplicationGroupUpdateConfirmation.Builder builder5 = builder2;
            builder2.setSuccess(false);
            builder = builder5;
            builder5.setMessage(a4.getFailure().getError().getMessage());
        } else {
            ReplicationGroupUpdateConfirmation.Builder builder6 = builder2;
            builder = builder6;
            builder6.setSuccess(true);
            builder2.setPending(false);
        }
        return builder.build();
    }

    public CompletableFuture<ReplicationGroupConfiguration> initReplicationGroup(String a2, List<Node> a4) {
        LocalRaftGroupService a5;
        try {
            LocalRaftGroupService localRaftGroupService = a5;
            RaftGroup raftGroup = localRaftGroupService.h.initRaftGroup(a2, a5.h.getMyLabel(a4), a5.h.getMyName());
            RaftNode raftNode = localRaftGroupService.h.waitForLeader(raftGroup);
            a4.forEach(a3 -> CompetableFutureUtils.g((CompletableFuture)raftNode.g(a3)));
            return CompletableFuture.completedFuture(a5.g(a2));
        }
        catch (Exception exception) {
            a5.I.error(ShowDetail.g((Object)"q/0ri o3~7* o\"f;i3~;e<*5x=\u007f\"*4k;f7n"), (Object)a2, (Object)exception);
            CompletableFuture<ReplicationGroupConfiguration> completableFuture = new CompletableFuture<ReplicationGroupConfiguration>();
            completableFuture.completeExceptionally(exception);
            return completableFuture;
        }
    }

    private /* synthetic */ void g(String a2, Node a3, CompletableFuture<ReplicationGroupUpdateConfirmation> a4, RaftNode a5) {
        LocalRaftGroupService a8;
        a5.g(a3).whenComplete((a6, a7) -> {
            LocalRaftGroupService a8;
            if (a7 != null) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a2;
                objectArray[1] = a3.getNodeName();
                objectArray[2] = a7;
                a8.I.warn(LicenseException.g((Object)"fm'0Xh~umdt\u007fs0jxt|x0|tyysw=~rtx0fm"), objectArray);
            }
            a2 = a8.g(a5, a6, a7);
            a4.complete((ReplicationGroupUpdateConfirmation)a2);
        });
    }

    @Nullable
    private /* synthetic */ ReplicationGroupConfiguration g(String a2) {
        LocalRaftGroupService a3;
        Object object = a3.h.getRaftGroup(a2);
        if (object == null) {
            return null;
        }
        object = object.localNode();
        a2 = ReplicationGroupConfiguration.newBuilder().setReplicationGroupName(a2).setPending(object.K());
        object = object.g().iterator();
        Iterator iterator = object;
        while (iterator.hasNext()) {
            Node node = (Node)object.next();
            iterator = object;
            a2.addNodes(NodeInfoWithLabel.newBuilder().setLabel(node.getNodeId()).setRole(node.getRole()).setNode(NodeInfo.newBuilder().setNodeName(node.getNodeName()).setInternalHostName(node.getHost()).setGrpcInternalPort(node.getPort()).build()).build());
        }
        return a2.build();
    }

    public void stepDown(String a2) {
        LocalRaftGroupService a3;
        if ((a2 = a3.h.getRaftNode(a2)) != null) {
            a2.f();
        }
    }

    public CompletableFuture<ReplicationGroupConfiguration> configuration(String a2) {
        LocalRaftGroupService a3;
        CompletableFuture<ReplicationGroupConfiguration> completableFuture = new CompletableFuture<ReplicationGroupConfiguration>();
        ReplicationGroupConfiguration replicationGroupConfiguration = a3.g(a2);
        if (replicationGroupConfiguration == null) {
            completableFuture.completeExceptionally(new RuntimeException("Context not found: " + a2));
            return completableFuture;
        }
        CompletableFuture<ReplicationGroupConfiguration> completableFuture2 = completableFuture;
        completableFuture2.complete(replicationGroupConfiguration);
        return completableFuture2;
    }

    public ReplicationGroup getStatus(String a2) {
        LocalRaftGroupService a4;
        a2 = a4.h.getRaftGroup(a2).localNode();
        String string = a2.f();
        return ReplicationGroup.newBuilder().setName(a2.g()).addAllMembers((Iterable)a2.g().stream().map(a3 -> ReplicationGroupMember.newBuilder().setNodeId(a3.getNodeId()).setNodeName(a3.getNodeName()).setState(a3.getNodeId().equals(string) ? State.LEADER : State.VOTING).build()).collect(Collectors.toList())).build();
    }
}

