/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.admin.application.api.ApplicationContextRoleRequest;
import io.axoniq.axonserver.admin.application.api.ApplicationRequest;
import io.axoniq.axonserver.configuration.admin.AdminApplication;
import io.axoniq.axonserver.configuration.admin.AdminApplicationContext;
import io.axoniq.axonserver.grpc.ApplicationProtoConverter;
import io.axoniq.axonserver.grpc.internal.Application;
import io.axoniq.axonserver.grpc.internal.ApplicationContextRole;
import io.axoniq.axonserver.rest.ApplicationJSON;
import java.util.List;
import java.util.stream.Collectors;

public class ApplicationProtoConverter {
    public static AdminApplicationContext createJpaApplicationContext(ApplicationContextRole a2) {
        return new ReadOnlyAdminApplicationContext(a2.getContext(), (List)a2.getRolesList());
    }

    public static ApplicationContextRole createApplicationContextRole(ApplicationJSON.ApplicationRoleJSON a2) {
        a2.toApplicationRole();
        List list = a2.toApplicationRole().getRoles();
        return ApplicationContextRole.newBuilder().setContext(a2.getContext()).addAllRoles((Iterable)list).build();
    }

    public static Application createApplication(ApplicationJSON a2) {
        Application.Builder builder = Application.newBuilder().setName(a2.getName());
        if (a2.getDescription() != null) {
            builder.setDescription(a2.getDescription());
        }
        if (a2.getToken() != null) {
            builder.setToken(a2.getToken());
        }
        a2.getRoles().stream().map(ApplicationProtoConverter::createApplicationContextRole).forEach(arg_0 -> ((Application.Builder)builder).addRolesPerContext(arg_0));
        if (a2.getMetaData() != null) {
            builder.putAllMetaData(a2.getMetaData());
        }
        return builder.build();
    }

    public static Application createApplication(AdminApplication a2) {
        Application.Builder builder = Application.newBuilder().setName(a2.getName());
        if (a2.getDescription() != null) {
            builder.setDescription(a2.getDescription());
        }
        if (a2.getHashedToken() != null) {
            builder.setToken(a2.getHashedToken());
        }
        if (a2.getTokenPrefix() != null) {
            builder.setTokenPrefix(a2.getTokenPrefix());
        }
        builder.putAllMetaData(a2.getMetaDataMap());
        a2.getContexts().stream().map(ApplicationProtoConverter::createApplicationContextRole).forEach(arg_0 -> ((Application.Builder)builder).addRolesPerContext(arg_0));
        return builder.build();
    }

    public static AdminApplication createJpaApplication(Application a2) {
        List list = a2.getRolesPerContextList().stream().map(ApplicationProtoConverter::createJpaApplicationContext).collect(Collectors.toList());
        return new ReadonlyAdminApplication(a2.getName(), a2.getDescription(), a2.getTokenPrefix(), a2.getToken(), list, a2.getMetaDataMap());
    }

    public static ApplicationContextRole createApplicationContextRole(ApplicationContextRoleRequest a2) {
        List list = a2.roles();
        return ApplicationContextRole.newBuilder().setContext(a2.context()).addAllRoles((Iterable)list).build();
    }

    public static ApplicationContextRole createApplicationContextRole(AdminApplicationContext a2) {
        List list = a2.getRoles();
        return ApplicationContextRole.newBuilder().setContext(a2.getContext()).addAllRoles((Iterable)list).build();
    }

    public ApplicationProtoConverter() {
        ApplicationProtoConverter a2;
    }

    public static Application createApplication(ApplicationRequest a2) {
        Application.Builder builder = Application.newBuilder().setName(a2.name());
        if (a2.description() != null) {
            builder.setDescription(a2.description());
        }
        if (a2.token() != null) {
            builder.setToken(a2.token());
        }
        a2.rolesPerContext().stream().map(ApplicationProtoConverter::createApplicationContextRole).forEach(arg_0 -> ((Application.Builder)builder).addRolesPerContext(arg_0));
        if (a2.metaData() != null) {
            builder.putAllMetaData(a2.metaData());
        }
        return builder.build();
    }
}

