/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.component.query.DefaultQueries;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.internal.ManagedChannelHelper;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ChannelExceptionHandler;
import io.axoniq.axonserver.grpc.ChannelManager;
import io.axoniq.axonserver.grpc.ChannelProvider;
import io.axoniq.axonserver.grpc.GrpcChannelProvider;
import io.axoniq.axonserver.rest.svg.mapping.AxonServers;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.TlsChannelCredentials;
import io.grpc.util.AdvancedTlsX509TrustManager;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.TrustManager;
import org.springframework.context.Lifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component
public class ChannelManager
implements ChannelProvider,
GrpcChannelProvider,
ChannelExceptionHandler,
Lifecycle {
    private final Supplier<ScheduledExecutorService> f;
    private volatile boolean c;
    private AdvancedTlsX509TrustManager.Closeable j;
    private final MessagingPlatformConfiguration H;
    private ChannelCredentials m;
    private final ExecutorService h;
    private final Map<ChannelKey, ManagedChannel> b;
    private final AdminNodes I;

    public void handleChannelException(String a22, int a3, Throwable a4) {
        if ((a4 = Status.fromThrowable((Throwable)a4).getCode()).equals(Status.Code.UNAVAILABLE) || a4.equals(Status.Code.INTERNAL)) {
            ChannelManager a5;
            a22 = new ChannelKey(a22, a3);
            if ((a22 = (ManagedChannel)a5.b.remove(a22)) != null) {
                try {
                    if (!a22.shutdown().awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                        a22.shutdownNow();
                        return;
                    }
                }
                catch (InterruptedException a22) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        ChannelManager channelManager;
        ChannelManager a2;
        if (a2.g()) {
            try {
                TlsChannelCredentials.Builder builder;
                TlsChannelCredentials.Builder builder2 = TlsChannelCredentials.newBuilder();
                AdvancedTlsX509TrustManager advancedTlsX509TrustManager = AdvancedTlsX509TrustManager.newBuilder().setVerification(a2.H.getSsl().getTrustManagerVerification()).build();
                if (a2.H.getSsl().getInternalTrustManagerFile() != null) {
                    a2.j = advancedTlsX509TrustManager.updateTrustCredentialsFromFile(new File(a2.H.getSsl().getInternalTrustManagerFile()), 1L, TimeUnit.MINUTES, (ScheduledExecutorService)a2.f.get());
                    builder = builder2;
                } else {
                    advancedTlsX509TrustManager.useSystemDefaultTrustCerts();
                    builder = builder2;
                }
                TrustManager[] trustManagerArray = new TrustManager[1];
                trustManagerArray[0] = advancedTlsX509TrustManager;
                builder.trustManager(trustManagerArray);
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray2[0] = advancedTlsX509TrustManager;
                a2.m = builder2.trustManager(trustManagerArray2).build();
                channelManager = a2;
            }
            catch (Exception exception) {
                throw new FailedToStartException(AxonServers.g((Object)"<V\bZ\u0005]IL\u0006\u0018\nJ\fY\u001d]I{\u0001Y\u0007V\fT$Y\u0007Y\u000e]\u001b"), (Throwable)exception);
            }
        } else {
            channelManager = a2;
        }
        channelManager.c = true;
    }

    public Channel channelForAddress(String a2, int a3) {
        ChannelManager a4;
        return a4.get(a2, a3);
    }

    public Channel channelForNode(String a2) {
        ChannelManager a3;
        a2 = (ClusterNode)a3.I.findById(a2).orElseThrow(() -> new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, a2 + ": Node not found"));
        return a3.get(a2.getInternalHostName(), a2.getGrpcInternalPort().intValue());
    }

    public boolean isRunning() {
        ChannelManager a2;
        return a2.c;
    }

    public void stop() {
        ChannelManager a2;
        if (a2.j != null) {
            a2.j.close();
        }
        ChannelManager channelManager = a2;
        channelManager.h.shutdown();
        channelManager.b.forEach((a22, a3) -> {
            if (!a3.isShutdown()) {
                try {
                    ChannelManager a4;
                    a3.shutdown().awaitTermination(100L, TimeUnit.MILLISECONDS);
                    a4.b.remove(a22, a3);
                    return;
                }
                catch (InterruptedException a22) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        a2.c = false;
    }

    private /* synthetic */ boolean g() {
        ChannelManager a2;
        if (a2.H.getSsl() != null && a2.H.getSsl().isEnabled()) {
            return true;
        }
        return false;
    }

    public Channel get(String a3, int a4) {
        ChannelManager a5;
        a3 = new ChannelKey(a3, a4);
        return (Channel)a5.b.computeIfAbsent(a3, a2 -> {
            ChannelManager a3;
            ChannelManager channelManager = a3;
            ChannelKey channelKey = a2;
            return ManagedChannelHelper.g((ExecutorService)channelManager.h, (MessagingPlatformConfiguration)channelManager.H, (String)channelKey.b, (int)channelKey.I, (ChannelCredentials)a3.m);
        });
    }

    public ChannelManager(MessagingPlatformConfiguration a2, AdminNodes a3, Supplier<ScheduledExecutorService> a4) {
        ChannelManager a5;
        ChannelManager channelManager = a5;
        ChannelManager channelManager2 = a5;
        ChannelManager channelManager3 = a5;
        channelManager3.b = new ConcurrentHashMap();
        channelManager2.H = a2;
        channelManager2.h = Executors.newFixedThreadPool(a2.getClusterExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(DefaultQueries.g((Object)"|fjykom'mon\u007fzyk'zrzij~px2")));
        channelManager.I = a3;
        channelManager.f = a4;
    }
}

