/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.version.ClientVersionsCache;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.grpc.AuthenticationProvider;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.CommandService;
import io.axoniq.axonserver.grpc.ContextProvider;
import io.axoniq.axonserver.grpc.GrpcCommandDispatcherListener;
import io.axoniq.axonserver.grpc.GrpcExceptionBuilder;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.InstructionAckSource;
import io.axoniq.axonserver.grpc.SerializedCommand;
import io.axoniq.axonserver.grpc.SerializedCommandProviderInbound;
import io.axoniq.axonserver.grpc.SerializedCommandResponse;
import io.axoniq.axonserver.grpc.command.CommandProviderOutbound;
import io.axoniq.axonserver.grpc.command.CommandServiceGrpc;
import io.axoniq.axonserver.grpc.heartbeat.ApplicationInactivityException;
import io.axoniq.axonserver.localstorage.file.multitier.LowerTierEventStoreFactory;
import io.axoniq.axonserver.message.ByteStringMarshaller;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.topology.Topology;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service(value="CommandService")
public class CommandService
implements AxonServerClientService {
    @Value(value="${axoniq.axonserver.command-threads:1}")
    private int l;
    private final Logger F;
    private final ClientIdRegistry E;
    private final ContextProvider i;
    private final AuthenticationProvider G;
    private final InstructionAckSource<SerializedCommandProviderInbound> f;
    private static final MethodDescriptor<ByteString, SerializedCommandResponse> c = CommandServiceGrpc.getDispatchMethod().toBuilder((MethodDescriptor.Marshaller)ByteStringMarshaller.g(), ProtoUtils.marshaller((Message)SerializedCommandResponse.getDefaultInstance())).build();
    private final ApplicationEventPublisher j;
    private final CommandDispatcher H;
    private final Topology m;
    private static final MethodDescriptor<CommandProviderOutbound, SerializedCommandProviderInbound> h = CommandServiceGrpc.getOpenStreamMethod().toBuilder(ProtoUtils.marshaller((Message)CommandProviderOutbound.getDefaultInstance()), ProtoUtils.marshaller((Message)SerializedCommandProviderInbound.getDefaultInstance())).build();
    private final Map<ClientStreamIdentification, GrpcCommandDispatcherListener> b;
    private final MeterFactory I;

    public Set<GrpcCommandDispatcherListener> listeners() {
        CommandService a2;
        return new HashSet<GrpcCommandDispatcherListener>(a2.b.values());
    }

    public CommandService(Topology topology, CommandDispatcher commandDispatcher, ContextProvider contextProvider, AuthenticationProvider authenticationProvider, ClientIdRegistry clientIdRegistry, MeterFactory meterFactory, ApplicationEventPublisher eventPublisher, @Qualifier(value="commandInstructionAckSource") InstructionAckSource<SerializedCommandProviderInbound> a2) {
        CommandService commandService = this;
        CommandService commandService2 = this;
        CommandService commandService3 = this;
        CommandService commandService4 = this;
        CommandService commandService5 = this;
        commandService5.F = LoggerFactory.getLogger(CommandService.class);
        CommandService commandService6 = this;
        commandService5.b = new ConcurrentHashMap();
        commandService5.l = 1;
        commandService4.m = topology;
        commandService4.H = commandDispatcher;
        commandService3.i = contextProvider;
        commandService3.G = authenticationProvider;
        commandService2.E = clientIdRegistry;
        commandService2.I = meterFactory;
        commandService.j = eventPublisher;
        commandService.f = a2;
    }

    private /* synthetic */ boolean g(InstructionAck a2) {
        if (a2.hasError() && a2.getError().getErrorCode().equals(ErrorCode.UNSUPPORTED_INSTRUCTION.getCode())) {
            return true;
        }
        return false;
    }

    public final ServerServiceDefinition bindService() {
        CommandService a2;
        return ServerServiceDefinition.builder((String)LowerTierEventStoreFactory.g((Object)"v 1.g q&na~7p!l*m9z=1(m?|a| r\"~!{a\\ r\"~!{\u001cz=i&|*")).addMethod(h, ServerCalls.asyncBidiStreamingCall(arg_0 -> a2.openStream(arg_0))).addMethod(c, ServerCalls.asyncUnaryCall((arg_0, arg_1) -> a2.dispatch(arg_0, arg_1))).build();
    }

    public void completeStreamForInactivity(String a2, ClientStreamIdentification a3) {
        CommandService a4;
        if (a4.b.containsKey(a3)) {
            String string = "Command stream inactivity for " + a3.K();
            string = new ApplicationInactivityException(string);
            ((GrpcCommandDispatcherListener)a4.b.remove(a3)).cancelAndCompleteStreamExceptionally((Throwable)((Object)string));
            CommandService commandService = a4;
            commandService.F.debug(ClientVersionsCache.g((Object)"m\u001fC\u001dO\u001eJP}\u0004\\\u0015O\u001d\u000e\u0013B\u001f]\u0015JPH\u001f\\PM\u001cG\u0015@\u0004\u0014PU\r"), (Object)a3);
            commandService.j.publishEvent((Object)new TopologyEvents.CommandHandlerDisconnected(a3.g(), a2, a3.K()));
        }
    }

    private /* synthetic */ void g(String a2, SerializedCommandResponse a32, StreamObserver<SerializedCommandResponse> a4) {
        try {
            StreamObserver<SerializedCommandResponse> streamObserver = a4;
            streamObserver.onNext((Object)a32);
            streamObserver.onCompleted();
            return;
        }
        catch (RuntimeException a32) {
            CommandService a5;
            a5.F.debug(LowerTierEventStoreFactory.g((Object)"M*l?p!l*?;po|#v*q;?4boy.v#z+"), (Object)a2, (Object)a32);
            return;
        }
    }

    public StreamObserver<CommandProviderOutbound> openStream(StreamObserver<SerializedCommandProviderInbound> a2) {
        CommandService a3;
        String string = a3.i.getContext();
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        1 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
        CommandService commandService = a3;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @PreDestroy
    public void cleanup() {
        CommandService a4;
        a4.b.forEach((a2, a3) -> a3.cancel());
        a4.b.clear();
    }

    public void dispatch(ByteString a22, StreamObserver<SerializedCommandResponse> a3) {
        CommandService a5;
        a22 = new SerializedCommand(a22);
        String string = a22.wrapped().getClientId();
        if (a5.F.isTraceEnabled()) {
            a5.F.trace(ClientVersionsCache.g((Object)"U\r\u0014P|\u0015M\u0015G\u0006K\u0014\u000e\u0013A\u001dC\u0011@\u0014\u0014PU\r"), (Object)string, (Object)a22.wrapped().getName());
        }
        try {
            CommandService commandService = a5;
            commandService.H.dispatch(commandService.i.getContext(), (Authentication)a5.G.get(), (SerializedCommand)a22, a4 -> {
                CommandService a5;
                a5.g(string, a4, a3);
            });
            return;
        }
        catch (Exception a22) {
            Exception exception = a22;
            a5.F.warn(LowerTierEventStoreFactory.g((Object)"[&l?~;|'v!xoy.v#z+?8v;woj!z7o*|;z+?*m=p="), (Throwable)exception);
            a3.onError((Throwable)GrpcExceptionBuilder.build((Throwable)exception));
            return;
        }
    }
}

