/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.version.ClientVersionsCache;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.AuthenticationProvider;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.ContextProvider;
import io.axoniq.axonserver.grpc.GrpcExceptionBuilder;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.InstructionAckSource;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.grpc.SendingStreamObserver;
import io.axoniq.axonserver.grpc.control.ClientIdentification;
import io.axoniq.axonserver.grpc.control.NodeInfo;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformInfo;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformServiceGrpc;
import io.axoniq.axonserver.grpc.control.RequestReconnect;
import io.axoniq.axonserver.grpc.heartbeat.ApplicationInactivityException;
import io.axoniq.axonserver.localstorage.file.EventSourceNotFoundException;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.topology.AxonServerNode;
import io.axoniq.axonserver.topology.Topology;
import io.axoniq.axonserver.util.StreamObserverUtils;
import io.grpc.stub.StreamObserver;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service(value="PlatformService")
public class PlatformService
extends PlatformServiceGrpc.PlatformServiceImplBase
implements AxonServerClientService {
    private final AuthenticationProvider F;
    private final Map<ClientComponent, SendingStreamObserver<PlatformOutboundInstruction>> E;
    private static final Logger i = LoggerFactory.getLogger(PlatformService.class);
    private final Topology G;
    private final ContextProvider f;
    private final MeterFactory c;
    private final ApplicationEventPublisher j;
    private final Map<PlatformInboundInstruction.RequestCase, Deque<InstructionConsumer>> H;
    private final Map<String, Gauge> m;
    private final InstructionAckSource<PlatformOutboundInstruction> h;
    public static final String b = "component";
    private final ClientIdRegistry I;

    public void onInboundInstruction(PlatformInboundInstruction.RequestCase a3, InstructionConsumer a4) {
        PlatformService a5;
        a5.H.computeIfAbsent(a3, a2 -> new ArrayDeque()).add(a4);
    }

    public boolean requestReconnect(ClientComponent a2, String a3) {
        PlatformService a4;
        i.debug(ClientVersionsCache.g((Object)"|\u0015_\u0005K\u0003ZP\\\u0015M\u001f@\u001eK\u0013ZJ\u000e\u000bSP\u0003PU\r"), (Object)a2, (Object)a3);
        StreamObserver streamObserver = (StreamObserver)a4.E.get(a2);
        if (streamObserver != null) {
            ClientComponent clientComponent = a2;
            a4.j.publishEvent((Object)new TopologyEvents.ApplicationReconnectRequested(clientComponent.I, clientComponent.b, a2.h, a3));
            streamObserver.onNext((Object)PlatformOutboundInstruction.newBuilder().setRequestReconnect(RequestReconnect.newBuilder()).build());
            return true;
        }
        return false;
    }

    public void sendToClientStreamId(String a2, PlatformOutboundInstruction a4) {
        PlatformService a5;
        a5.E.entrySet().stream().filter(a3 -> a2.equals(((ClientComponent)a3.getKey()).m)).map(Map.Entry::getValue).collect(Collectors.toList()).forEach(a3 -> a3.onNext((Object)a4));
    }

    public boolean requestReconnect(String a2, String a4) {
        PlatformService a5;
        i.debug(EventSourceNotFoundException.g((Object)"<a\u001fq\u000bw\u001a$\u001ca\rk\u0000j\u000bg\u001a>N\u007f\u0013"), (Object)a2);
        return a5.E.keySet().stream().filter(a3 -> a3.b.equals(a2)).map(a3 -> {
            PlatformService a4;
            return a4.requestReconnect(a3, a4);
        }).findFirst().orElse(false);
    }

    public Set<ClientComponent> getConnectedClients() {
        PlatformService a2;
        return a2.E.keySet();
    }

    private /* synthetic */ void g(ClientComponent a2, long a3, String a4) {
        i.debug(ClientVersionsCache.g((Object)"4K]\\\u0015I\u0019]\u0004K\u0002K\u0014\u000e\u0013B\u0019K\u001eZP\u0014PU\r"), (Object)a2);
        if (a2 != null) {
            PlatformService a5;
            String[] stringArray = new String[4];
            stringArray[0] = "context";
            stringArray[1] = a2.getContext();
            stringArray[2] = b;
            stringArray[3] = a2.getComponent();
            Tags tags = Tags.of((String[])stringArray);
            a5.c.counter((MetricName)BaseMetricName.L, tags).increment();
            if (a3 > 0L) {
                a5.c.timer((MetricName)BaseMetricName.O, tags).record(System.currentTimeMillis() - a3, TimeUnit.MILLISECONDS);
            }
            if ((tags = (SendingStreamObserver)a5.E.remove(a2)) != null) {
                StreamObserverUtils.g((StreamObserver)tags);
            }
            a5.I.unregister(a2.m, ClientIdRegistry.ConnectionType.b);
            ClientComponent clientComponent = a2;
            ClientComponent clientComponent2 = a2;
            a5.j.publishEvent((Object)new TopologyEvents.ApplicationDisconnected(clientComponent.I, clientComponent.h, clientComponent2.m, clientComponent2.b, null, a4));
        }
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected a2) {
        PlatformService a3;
        StreamObserver streamObserver = (StreamObserver)a3.E.remove(new ClientComponent(a2.i(), a2.G(), a2.f(), a2.K()));
        i.debug(EventSourceNotFoundException.g((Object)"e\u001et\u0002m\re\u001am\u0001jN`\u0007w\rk\u0000j\u000bg\u001aa\n>N\u007f\u0013(Ng\u0001j\u0000a\rp\u0007k\u0000>N\u007f\u0013"), (Object)a2.i(), (Object)streamObserver);
        if (streamObserver != null) {
            try {
                streamObserver.onCompleted();
                return;
            }
            catch (Exception exception) {
                i.debug(ClientVersionsCache.g((Object)"k\u0002\\\u001f\\PY\u0018G\u001cKPM\u001cA\u0003G\u001eIPZ\u0002O\u0013E\u0019@\u0017\u000e\u0015X\u0015@\u0004\u000e\u0000\\\u001fM\u0015]\u0003A\u0002\u000e\u0013A\u001e@\u0015M\u0004G\u001f@PH\u0002A\u001d\u000e\u000bSP\u0003PU\r"), (Object)a2.i(), (Object)exception.getMessage());
            }
        }
    }

    private /* synthetic */ void g(ClientComponent a2, String a3, SendingStreamObserver<PlatformOutboundInstruction> a4) {
        PlatformService a5;
        i.debug(EventSourceNotFoundException.g((Object)"V\u000bc\u0007w\u001aa\u001ca\n$\rh\u0007a\u0000pN>N\u007f\u0013"), (Object)a2);
        a5.E.put(a2, a4);
        ClientComponent clientComponent = a2;
        ClientComponent clientComponent2 = a2;
        a5.j.publishEvent((Object)new TopologyEvents.ApplicationConnected(clientComponent.I, clientComponent.h, clientComponent2.m, clientComponent2.b, a3, null));
    }

    @EventListener
    public void on(TopologyEvents.RequestClientReconnect a2) {
        PlatformService a3;
        a3.requestReconnect(a2.g(), ClientVersionsCache.g((Object)"\"K\u0001[\u0015]\u0004K\u0014\u000e\u0012WP[\u0003K\u0002"));
    }

    private /* synthetic */ long g(String a2) {
        PlatformService a4;
        return a4.E.keySet().stream().filter(a3 -> a3.getContext().equals(a2)).count();
    }

    @EventListener
    public void on(TopologyEvents.ApplicationInactivityTimeout a2) {
        PlatformService a3;
        Object object = a2.g();
        a2 = new ClientComponent(object.K(), a2.g().clientId(), a2.g(), a2.g().context());
        object = "Platform stream inactivity for " + object.K();
        object = new ApplicationInactivityException((String)object);
        a3.g((ClientComponent)a2, (Throwable)object);
    }

    public void requestReconnectForContext(String a2, String a4) {
        PlatformService a5;
        a5.E.keySet().stream().filter(a3 -> a3.I.equals(a2)).collect(Collectors.toSet()).forEach(a3 -> {
            PlatformService a4;
            a4.requestReconnect(a3, a4);
        });
    }

    private /* synthetic */ boolean g(InstructionAck a2) {
        if (a2.hasError() && a2.getError().getErrorCode().equals(ErrorCode.UNSUPPORTED_INSTRUCTION.getCode())) {
            return true;
        }
        return false;
    }

    public PlatformService(Topology topology, ContextProvider contextProvider, AuthenticationProvider authenticationProvider, ClientIdRegistry clientIdRegistry, ApplicationEventPublisher eventPublisher, MeterFactory meterFactory, @Qualifier(value="platformInstructionAckSource") InstructionAckSource<PlatformOutboundInstruction> a4) {
        PlatformService platformService = this;
        PlatformService platformService2 = this;
        PlatformService platformService3 = this;
        PlatformService platformService4 = this;
        platformService4.E = new ConcurrentHashMap();
        PlatformService platformService5 = this;
        platformService3.m = new ConcurrentHashMap();
        PlatformService platformService6 = this;
        platformService3.H = new EnumMap(PlatformInboundInstruction.RequestCase.class);
        platformService3.G = topology;
        platformService2.f = contextProvider;
        platformService2.F = authenticationProvider;
        platformService.I = clientIdRegistry;
        platformService.j = eventPublisher;
        this.c = meterFactory;
        this.h = a4;
        this.onInboundInstruction(PlatformInboundInstruction.RequestCase.ACK, (a2, a3) -> {
            PlatformService a4;
            if (a4.g((InstructionAck)(a3 = a3.getAck()))) {
                ClientComponent clientComponent = a2;
                i.warn(ClientVersionsCache.g((Object)"{\u001e]\u0005^\u0000A\u0002Z\u0015JPG\u001e]\u0004\\\u0005M\u0004G\u001f@P]\u0015@\u0004\u000e\u0004APZ\u0018KPM\u001cG\u0015@\u0004\u000e\u000bSPA\u0016\u000e\u0013A\u001eZ\u0015V\u0004\u000e\u000bS^"), (Object)clientComponent.m, (Object)clientComponent.I);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.m;
            objectArray[1] = a2.I;
            objectArray[2] = a3;
            i.trace(EventSourceNotFoundException.g((Object)"<a\ra\u0007r\u000b`Nm\u0000w\u001av\u001bg\u001am\u0001jNe\roNb\u001ck\u0003$\u001al\u000b$\rh\u0007a\u0000pN\u007f\u0013$\u0001bNg\u0001j\u001aa\u0016pN\u007f\u0013*NV\u000bw\u001bh\u001a$\u0015y@"), objectArray);
        });
    }

    public StreamObserver<PlatformInboundInstruction> openStream(StreamObserver<PlatformOutboundInstruction> a2) {
        PlatformService a3;
        PlatformService platformService = a3;
        String string = platformService.f.getContext();
        a2 = new SendingStreamObserver(a2);
        Authentication authentication = (Authentication)platformService.F.get();
        if (i.isInfoEnabled()) {
            i.info(EventSourceNotFoundException.g((Object)"G\u0001j\u0000a\rp\u0007k\u0000$\u0001t\u000bj\u000b`Nb\u0001vN\u007f\u0013"), (Object)authentication.getName());
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private /* synthetic */ void g(ClientComponent a2, Throwable a3) {
        PlatformService a4;
        SendingStreamObserver sendingStreamObserver = (SendingStreamObserver)a4.E.remove(a2);
        if (sendingStreamObserver != null) {
            StreamObserverUtils.g((StreamObserver)sendingStreamObserver, (Throwable)a3);
        }
        a4.g(a2, 0L, a3.getMessage());
    }

    public void getPlatformServer(ClientIdentification a2, StreamObserver<PlatformInfo> a3) {
        PlatformService a4;
        String string = a4.f.getContext();
        try {
            AxonServerNode axonServerNode = a4.G.findNodeForClient(a2.getClientId(), a2.getComponentName(), string, a2.getTagsMap());
            StreamObserver<PlatformInfo> streamObserver = a3;
            streamObserver.onNext((Object)PlatformInfo.newBuilder().setSameConnection(axonServerNode.getName().equals(a4.G.getName())).setPrimary(NodeInfo.newBuilder().setNodeName(axonServerNode.getName()).setHostName(axonServerNode.getHostName()).setGrpcPort(axonServerNode.getGrpcPort().intValue()).setHttpPort(axonServerNode.getHttpPort().intValue())).build());
            streamObserver.onCompleted();
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.getClientId();
            objectArray[1] = string;
            objectArray[2] = messagingPlatformException.getMessage();
            i.info(ClientVersionsCache.g((Object)"5\\\u0002A\u0002\u000e\u0016G\u001eJ\u0019@\u0017\u000e\u0004O\u0002I\u0015ZPH\u001f\\PM\u001cG\u0015@\u0004\u000e\u000bS_U\r\u0014PU\r"), objectArray);
            a3.onError((Throwable)GrpcExceptionBuilder.build((Throwable)messagingPlatformException));
            return;
        }
        catch (RuntimeException runtimeException) {
            i.warn(EventSourceNotFoundException.g((Object)"A\u001cv\u0001vNt\u001ck\ra\u001dw\u0007j\t$\rh\u0007a\u0000pNv\u000bu\u001ba\u001dpN\u007f\u0013"), (Object)a2, (Object)runtimeException);
            a3.onError((Throwable)GrpcExceptionBuilder.build((Throwable)runtimeException));
            return;
        }
    }

    public void sendToClient(String a2, String a4, PlatformOutboundInstruction a5) {
        PlatformService a6;
        a6.E.entrySet().stream().filter(a3 -> ((ClientComponent)a3.getKey()).b.equals(a4)).filter(a3 -> ((ClientComponent)a3.getKey()).I.equals(a2)).map(Map.Entry::getValue).forEach(a3 -> a3.onNext((Object)a5));
    }
}

