/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.grpc.AuthenticationProvider;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.ContextProvider;
import io.axoniq.axonserver.grpc.GrpcFlowControlExecutorProvider;
import io.axoniq.axonserver.grpc.GrpcQueryDispatcherListener;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.InstructionAckSource;
import io.axoniq.axonserver.grpc.QueryService;
import io.axoniq.axonserver.grpc.SerializedQuery;
import io.axoniq.axonserver.grpc.SubscriptionQueryRequestTarget;
import io.axoniq.axonserver.grpc.heartbeat.ApplicationInactivityException;
import io.axoniq.axonserver.grpc.query.QueryProviderInbound;
import io.axoniq.axonserver.grpc.query.QueryProviderOutbound;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.grpc.query.QueryServiceGrpc;
import io.axoniq.axonserver.grpc.query.SubscriptionQuery;
import io.axoniq.axonserver.grpc.query.SubscriptionQueryRequest;
import io.axoniq.axonserver.grpc.query.SubscriptionQueryResponse;
import io.axoniq.axonserver.interceptor.SubscriptionQueryInterceptors;
import io.axoniq.axonserver.localstorage.file.EventSourceNotFoundException;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.query.QueryDispatcher;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.taskscheduler.task.AddNodeToReplicationGroup;
import io.axoniq.axonserver.topology.Topology;
import io.axoniq.flowcontrol.producer.grpc.FlowControlledOutgoingStream;
import io.grpc.stub.CallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

@Service(value="QueryService")
public class QueryService
extends QueryServiceGrpc.QueryServiceImplBase
implements AxonServerClientService {
    private final AuthenticationProvider l;
    private final Topology F;
    private final Map<ClientStreamIdentification, GrpcQueryDispatcherListener> E;
    private final Logger i;
    @Value(value="${axoniq.axonserver.query-threads:1}")
    private int G;
    private final MeterFactory f;
    private final SubscriptionQueryInterceptors c;
    private final ContextProvider j;
    private final InstructionAckSource<QueryProviderInbound> H;
    private final ClientIdRegistry m;
    private final ApplicationEventPublisher h;
    private final GrpcFlowControlExecutorProvider b;
    private final QueryDispatcher I;

    private /* synthetic */ boolean g(InstructionAck a2) {
        if (a2.hasError() && a2.getError().getErrorCode().equals(ErrorCode.UNSUPPORTED_INSTRUCTION.getCode())) {
            return true;
        }
        return false;
    }

    public StreamObserver<QueryProviderOutbound> openStream(StreamObserver<QueryProviderInbound> a2) {
        QueryService a3;
        String string = a3.j.getContext();
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        1 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
        QueryService queryService = a3;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void completeStreamForInactivity(String a2, ClientStreamIdentification a3) {
        QueryService a4;
        if (a4.E.containsKey(a3)) {
            String string = "Query stream inactivity for " + a3.K();
            string = new ApplicationInactivityException(string);
            ((GrpcQueryDispatcherListener)a4.E.remove(a3)).cancelAndCompleteStreamExceptionally((Throwable)((Object)string));
            QueryService queryService = a4;
            queryService.i.debug(EventSourceNotFoundException.g((Object)"U\u001ba\u001c}NW\u001av\u000be\u0003$\rh\u0001w\u000b`Nb\u0001vNg\u0002m\u000bj\u001a>N\u007f\u0013"), (Object)a3);
            queryService.h.publishEvent((Object)new TopologyEvents.QueryHandlerDisconnected(a3.g(), a2, a3.K()));
        }
    }

    public QueryService(Topology topology, QueryDispatcher queryDispatcher, ContextProvider contextProvider, AuthenticationProvider authenticationProvider, ClientIdRegistry clientIdRegistry, SubscriptionQueryInterceptors subscriptionQueryInterceptors, MeterFactory meterFactory, ApplicationEventPublisher eventPublisher, @Qualifier(value="queryInstructionAckSource") InstructionAckSource<QueryProviderInbound> instructionAckSource, GrpcFlowControlExecutorProvider a2) {
        QueryService queryService = this;
        QueryService queryService2 = this;
        QueryService queryService3 = this;
        QueryService queryService4 = this;
        QueryService queryService5 = this;
        QueryService queryService6 = this;
        queryService6.i = LoggerFactory.getLogger(QueryService.class);
        QueryService queryService7 = this;
        queryService6.E = new ConcurrentHashMap();
        queryService6.G = 1;
        queryService5.F = topology;
        queryService5.I = queryDispatcher;
        queryService4.j = contextProvider;
        queryService4.l = authenticationProvider;
        queryService3.m = clientIdRegistry;
        queryService3.c = subscriptionQueryInterceptors;
        queryService2.f = meterFactory;
        queryService2.h = eventPublisher;
        queryService.H = instructionAckSource;
        queryService.b = a2;
    }

    @NotNull
    private /* synthetic */ QueryProviderInbound g(String a2) {
        return QueryProviderInbound.newBuilder().setSubscriptionQueryRequest(SubscriptionQueryRequest.newBuilder().setUnsubscribe(SubscriptionQuery.newBuilder().setSubscriptionIdentifier(a2))).build();
    }

    public Set<GrpcQueryDispatcherListener> listeners() {
        QueryService a2;
        return new HashSet<GrpcQueryDispatcherListener>(a2.E.values());
    }

    @PreDestroy
    public void cleanup() {
        QueryService a4;
        a4.E.forEach((a2, a3) -> a3.cancel());
        a4.E.clear();
    }

    public StreamObserver<SubscriptionQueryRequest> subscription(StreamObserver<SubscriptionQueryResponse> a2) {
        QueryService a3;
        String string = a3.j.getContext();
        QueryService queryService = a3;
        return new SubscriptionQueryRequestTarget(string, (Authentication)a3.l.get(), a2, queryService.c, queryService.h);
    }

    public void query(QueryRequest a2, StreamObserver<QueryResponse> a3) {
        QueryService a5;
        if (a5.i.isTraceEnabled()) {
            a5.i.trace(AddNodeToReplicationGroup.g((Object)"\u0013hR5:p\u000bp\u0001c\rqHd\u001dp\u001alR5\u0013h"), (Object)a2.getClientId(), (Object)a2.getQuery());
        }
        a3 = a3;
        a3.setOnCancelHandler(() -> {
            QueryService a3;
            a3.I.cancel(a2.getMessageIdentifier());
        });
        new FlowControlledOutgoingStream((CallStreamObserver)new GrpcQueryResponseConsumer(a5, (CallStreamObserver)a3), a5.b.provide()).accept((Publisher)Flux.create(a4 -> {
            QueryService a5;
            SerializedQuery serializedQuery = new SerializedQuery(a5.j.getContext(), a2);
            a5.I.query(serializedQuery, (Authentication)a5.l.get(), arg_0 -> ((FluxSink)a4).next(arg_0), a3 -> a4.complete());
            a4.onRequest(a3 -> {
                QueryService a4;
                a4.I.flowControl(a2.getMessageIdentifier(), a3);
            });
        }).limitRate(32));
    }
}

