/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc.heartbeat;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.version.ClientVersionsCache;
import io.axoniq.axonserver.grpc.ClientContext;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.grpc.Publisher;
import io.axoniq.axonserver.grpc.control.Heartbeat;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatMonitor;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatPublisher;
import io.axoniq.axonserver.localstorage.file.EventIterator;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"axoniq.axonserver.heartbeat.enabled"})
public class HeartbeatMonitor {
    private final Map<ClientStreamIdentification, ClientInformation> c;
    private final Logger j = LoggerFactory.getLogger(HeartbeatMonitor.class);
    private final Map<ClientStreamIdentification, Instant> H;
    private final long m;
    private final Publisher<PlatformOutboundInstruction> h;
    private final ApplicationEventPublisher b;
    private final Clock I;

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-check-initial-delay:10000}", fixedRateString="${axoniq.axonserver.client-heartbeat-check-rate:1000}")
    public void checkClientsStillAlive() {
        HeartbeatMonitor a2;
        HeartbeatMonitor heartbeatMonitor = a2;
        heartbeatMonitor.j.debug(ClientVersionsCache.g((Object)"3F\u0015M\u001bG\u001eIPM\u001f@\u001eK\u0013Z\u0015JPM\u001cG\u0015@\u0004]PO\u0002KP]\u0004G\u001cBPO\u001cG\u0006K^\u0000^"));
        HeartbeatMonitor heartbeatMonitor2 = a2;
        Instant instant = Instant.now(heartbeatMonitor.I).minus(heartbeatMonitor2.m, ChronoUnit.MILLIS);
        heartbeatMonitor2.H.forEach((a3, a4) -> {
            HeartbeatMonitor a5;
            if (a4.isBefore(instant) && a5.c.containsKey(a3)) {
                ClientInformation clientInformation = (ClientInformation)a5.c.get(a3);
                String string = clientInformation.h;
                String string2 = clientInformation.b;
                Object[] objectArray = new Object[4];
                objectArray[0] = a5.m;
                objectArray[1] = a3;
                objectArray[2] = a4;
                objectArray[3] = instant;
                a5.j.info(ClientVersionsCache.g((Object)"3B\u0019K\u001eZPG\u001eO\u0013Z\u0019X\u0019Z\t\u000e\u0014K\u0004K\u0013Z\u0015JPH\u001f\\PC\u001f\\\u0015\u000e\u0004F\u0011@PU\r\u000e\u001dG\u001cB\u0019]\u0015M\u001f@\u0014]^\u000e3B\u0019K\u001eZJ\u000e\u000bS\\\u000e\u001cO\u0003Z1M\u0004G\u0006G\u0004WJ\u000e\u000bS\\\u000e\u0004G\u001dK\u001f[\u0004\u0014PU\r\u0000P"), objectArray);
                a5.b.publishEvent((Object)new TopologyEvents.ApplicationInactivityTimeout(a3, string, new ClientContext(string2, clientInformation.I)));
            }
        });
    }

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-initial-delay:5000}", fixedRateString="${axoniq.axonserver.client-heartbeat-frequency:500}")
    public void sendHeartbeat() {
        HeartbeatMonitor a2;
        a2.h.publish((Object)PlatformOutboundInstruction.newBuilder().setHeartbeat(Heartbeat.newBuilder()).build());
    }

    @EventListener
    public void on(TopologyEvents.ApplicationConnected a2) {
        HeartbeatMonitor a3;
        ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(a2.L(), a2.i());
        a3.c.put(clientStreamIdentification, new ClientInformation(a2.f(), a2.K(), a2.L()));
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected a2) {
        HeartbeatMonitor a3;
        a2 = new ClientStreamIdentification(a2.K(), a2.i());
        a3.H.remove(a2);
        a3.c.remove(a2);
        a3.j.debug(EventIterator.g((Object)"qoMk\u0002vMuKoMiKuE;J~CiVyGzV;DtP;AwK~Lo\u0002`_5"), (Object)a2);
    }

    public static String g(Object a2) {
        a2 = (String)a2;
        int n = ((String)a2).length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = (3 ^ 5) << 3 ^ (2 ^ 5);
        int cfr_ignored_0 = (3 ^ 5) << 4;
        int n4 = n2;
        int n5 = 4 << 4 ^ (2 ^ 5) << 1;
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(((String)a2).charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(((String)a2).charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    @Autowired
    public HeartbeatMonitor(PlatformService platformService, HeartbeatPublisher heartbeatPublisher, ApplicationEventPublisher eventPublisher, @Value(value="${axoniq.axonserver.client-heartbeat-timeout:5000}") long a2) {
        this(a5 -> platformService.onInboundInstruction(PlatformInboundInstruction.RequestCase.HEARTBEAT, (a3, a4) -> a5.accept(new ClientStreamIdentification(a3.getContext(), a3.getClientStreamId()), a4)), eventPublisher, (Publisher)heartbeatPublisher, a2, Clock.systemUTC());
    }

    public HeartbeatMonitor(Consumer<BiConsumer<ClientStreamIdentification, PlatformInboundInstruction>> a4, ApplicationEventPublisher a5, Publisher<PlatformOutboundInstruction> a6, long a7, Clock a8) {
        HeartbeatMonitor a9;
        HeartbeatMonitor heartbeatMonitor = a9;
        a9.c = new ConcurrentHashMap();
        HeartbeatMonitor heartbeatMonitor2 = a9;
        heartbeatMonitor.H = new ConcurrentHashMap();
        a4.accept((a2, a3) -> {
            HeartbeatMonitor a4;
            HeartbeatMonitor heartbeatMonitor = a4;
            heartbeatMonitor.j.trace(EventIterator.g((Object)"j~CiVYGzV;P~A~KmG\u007f\u0002}PtO;Yf"), a2);
            heartbeatMonitor.H.put(a2, Instant.now(a4.I));
        });
        HeartbeatMonitor heartbeatMonitor3 = a9;
        HeartbeatMonitor heartbeatMonitor4 = a9;
        heartbeatMonitor4.I = a8;
        heartbeatMonitor4.b = a5;
        heartbeatMonitor3.m = a7;
        heartbeatMonitor3.h = a6;
    }
}

