/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.licensing;

import io.axoniq.axonserver.config.AxonServerEnterpriseProperties;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.licensing.E;
import io.axoniq.axonserver.licensing.LicenseConfiguration;
import io.axoniq.axonserver.licensing.LicenseException;
import io.axoniq.axonserver.licensing.LicenseManager;
import io.axoniq.axonserver.localstorage.transaction.PreparedTransaction;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"axoniq.axonserver.marketplace"}, havingValue="false", matchIfMissing=true)
public class FileLicenseManager
implements LicenseManager {
    private static final String B = "MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA0xyNKA5aL42X7eXy1zwe\n9V6do3TYhrH7smWa6RBtCkhQ2holCEalrdiEX3LQoyhPmvV8lqWrDc9JHuYheWQL\npQXKB84sb9DCCWZWTPV0OZpe8nyotgmwBYohvEzTGLLRrAp+pM/J+/IVSiMyiP5E\nKf6ODcRWQH/us+4x4IsjTZC+o0HsYjSXG62Bo7pXFXLKjUqA3rpTyT1v3Yafgp4C\n78wHa/fqKCE562B2IEEhxWdsJl//wOsk/I8bYH+YoZtceGpRJlkMjK3t/KOExU61\nae5NJruyXbqRBWOtrcBb37b2cgykqaZlCwQczsZwl8Pglm1Yl0t8lTdTM+wxLErI\nAbxYE50UtvMLCaIG8lqT9W28UQgOr+RPdkEwUWYNeWWH2R0Kukva9loB+LBDe/Ce\nYhRvh41KpekJhU0NYjymCizNFohQ0rUDtt8p+i/IpIxfWBtgJODOrP2tbr8necX8\nX5oMyN4H/ar6favdWCHXi9FtTrHv1lchisXn3R9/obJptkxyZc8yvWuEBhXBFJ6H\nydOPNdbiWIH9TptZ2vaQrSFyaPR5yCoG/kyZ6o7TQE8lK6MrULiJNB/6ZKujri5x\nLovNJrtY/w69qVkC/8lIJhwJMSJKySeUYBhOjVN4f7vVEVYncYx8HJU2utQ1j6+e\n9T0pQ8CjhkOpmcTcaaMmU0UCAwEAAQ==";
    private static final String D = "product";
    private static final String J = "license";
    private static final String g = "clusterNodes";
    private static final String K = "expiry_date";
    private static final String A = "grace_date";
    private final AtomicReference<E> C;
    private final AtomicReference<Properties> l;
    private static final String F = "axoniq.license";
    private static final String E = "contexts";
    private static final Logger i;
    private static final Logger G;
    private static final String f = "license_key_id";
    private static final String c = "signature";
    private final AdminNodes j;
    private static final String H = "AxonServer";
    private static final String m = "AXONIQ_LICENSE";
    private static final String h = "issue_date";
    private static final String b = "licensee";
    private final String I;

    @EventListener
    @Order(value=-2147483648)
    public void on(ClusterEvents.LicenseUpdated a2) {
        FileLicenseManager a3;
        FileLicenseManager fileLicenseManager = a3;
        fileLicenseManager.g();
        fileLicenseManager.createOrUpdate(a2.getLicense());
    }

    public void validate(byte[] a2) {
        FileLicenseManager a3;
        FileLicenseManager fileLicenseManager = a3;
        fileLicenseManager.g(fileLicenseManager.g(a2));
    }

    public Properties readLicenseProperties() {
        FileLicenseManager a2;
        Properties properties = (Properties)a2.l.get();
        if (properties != null) {
            return properties;
        }
        FileLicenseManager fileLicenseManager = a2;
        properties = fileLicenseManager.g(fileLicenseManager.g());
        fileLicenseManager.g(properties);
        fileLicenseManager.l.set(properties);
        return properties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private /* synthetic */ Properties g(String a2) {
        i.debug(PreparedTransaction.g((Object)"%\u001c\b\u0017\u0000\u001d\u000eS\u0005\u001a\n\u0016\u0007\u0000\fS\u0019\u0001\u0006\u0003\f\u0001\u001d\u001a\f\u0000I\u0015\u001b\u001c\u0004S\u0012\u000eG]G"), a2);
        a2 = new File((String)a2);
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream((File)a2);
        try {
            properties.load(fileInputStream);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            try {
                fileInputStream.close();
                throwable2 = throwable;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                try {
                    Throwable throwable4 = throwable;
                    throwable2 = throwable4;
                    throwable4.addSuppressed(throwable3);
                    throw throwable2;
                }
                catch (IOException iOException) {
                    throw LicenseException.g((File)a2);
                }
            }
        }
        fileInputStream.close();
        return properties;
    }

    static {
        G = AuditLog.getLogger();
        i = LoggerFactory.getLogger(LicenseManager.class);
    }

    public boolean isEnterprise() {
        FileLicenseManager a2;
        return a2.g().isEnterprise();
    }

    public byte[] readLicense() {
        FileLicenseManager a2;
        i.info(ErrorMessageFactory.g((Object)"\u0015\u001d8\u00160\u001c>R5\u001b:\u00177\u0001<R:\u001d7\u0006<\u001c-\\w\\"));
        FileLicenseManager fileLicenseManager = a2;
        return fileLicenseManager.g(fileLicenseManager.g());
    }

    private /* synthetic */ void K(String a2) {
        FileLicenseManager a3;
        if (!E.b.equals((Object)a3.C.getAndSet(E.b))) {
            G.error(PreparedTransaction.g((Object)"?\u0000\u0010\f\u001d\u001a\u0016I\u0005\b\u001f\u0000\u0017\b\u0007\u0000\u001c\u0007S\u000f\u0012\u0000\u001f\f\u0017SS\u0012\u000eG"), (Object)a2);
            i.error(ErrorMessageFactory.g((Object)"\u0015\u001b:\u00177\u0001<R/\u00135\u001b=\u0013-\u001b6\u001cy\u00148\u001b5\u0017=Hy\t$\\"), (Object)a2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private /* synthetic */ byte[] g(String a2) {
        byte[] byArray;
        i.debug(PreparedTransaction.g((Object)"?\u0006\u0012\r\u001a\u0007\u0014I\u001f\u0000\u0010\f\u001d\u001a\u0016I\u0010\u0006\u001d\u001d\u0016\u0007\u0007I\u0015\u001b\u001c\u0004S\u0012\u000eG]G"), a2);
        a2 = new File((String)a2);
        FileInputStream fileInputStream = new FileInputStream((File)a2);
        try {
            byte[] byArray2 = new byte[Math.toIntExact(((File)a2).length())];
            fileInputStream.read(byArray2);
            byArray = byArray2;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            try {
                fileInputStream.close();
                throwable2 = throwable;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                try {
                    Throwable throwable4 = throwable;
                    throwable2 = throwable4;
                    throwable4.addSuppressed(throwable3);
                    throw throwable2;
                }
                catch (IOException iOException) {
                    throw LicenseException.g((File)a2);
                }
            }
        }
        fileInputStream.close();
        return byArray;
    }

    private /* synthetic */ Properties g(byte[] a22) {
        i.debug(ErrorMessageFactory.g((Object)">6\u0013=\u001b7\u0015y\u001e0\u0011<\u001c*\u0017y\u0014+\u001d4R:\u001d7\u0006<\u001c-\\w\\"));
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(a22));
            return properties;
        }
        catch (IOException a22) {
            throw LicenseException.g();
        }
    }

    private /* synthetic */ boolean g(String a2) {
        if (a2 != null && a2.contains(H)) {
            return true;
        }
        return false;
    }

    public boolean validateSilently() {
        FileLicenseManager a2;
        try {
            a2.g();
        }
        catch (Exception exception) {
            a2.K(exception.getMessage());
            return false;
        }
        return true;
    }

    public String property(String a2) {
        FileLicenseManager a3;
        return a3.readLicenseProperties().getProperty(a2);
    }

    public void createOrUpdate(byte[] a22) {
        File file;
        Object object;
        FileLicenseManager a3;
        i.debug(PreparedTransaction.g((Object)"?\u0012\u0005\u001a\r\u0012\u001d\u001a\u0007\u0014I\u001d\f\u0004I\u001f\u0000\u0010\f\u001d\u001a\u0016G]G"));
        FileLicenseManager fileLicenseManager = a3;
        Properties properties = fileLicenseManager.g(a22);
        fileLicenseManager.g(properties);
        String string = System.getProperty(J, System.getenv(m));
        if (StringUtils.isEmpty((String)string)) {
            object = new File(a3.I);
            if (!((File)object).exists() && !((File)object).mkdirs()) {
                throw new MessagingPlatformException(ErrorCode.OTHER, "Failed to create directory: " + ((File)object).getAbsolutePath());
            }
            file = new File((File)object, F);
        } else {
            file = new File(string);
        }
        object = new FileOutputStream(file);
        try {
            Object object2 = object;
            ((FileOutputStream)object2).write(a22);
            ((OutputStream)object2).flush();
        }
        catch (Throwable a22) {
            try {
                Throwable throwable;
                try {
                    ((FileOutputStream)object).close();
                    throwable = a22;
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = a22;
                    throwable = throwable3;
                    throwable3.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw LicenseException.g((String)file.getAbsolutePath(), (Throwable)iOException);
            }
        }
        ((FileOutputStream)object).close();
        i.info(ErrorMessageFactory.g((Object)"\u0017\u0017.R5\u001b:\u00177\u0001<R*\u0013/\u0017=R-\u001dy\t$\\"), (Object)file);
        FileLicenseManager fileLicenseManager2 = a3;
        fileLicenseManager2.C.set(E.h);
        fileLicenseManager2.g(properties.getProperty(D));
    }

    public long nodesCount() {
        FileLicenseManager a2;
        return a2.j.findAll().count();
    }

    @Scheduled(fixedRate=3600000L, initialDelay=3600000L)
    private /* synthetic */ void g() {
        FileLicenseManager a2;
        i.debug(PreparedTransaction.g((Object)":\u0007\u0005\b\u001f\u0000\u0017\b\u0007\u0000\u001d\u000eS\n\u0012\n\u001b\f\u0017I\u001f\u0000\u0010\f\u001d\u001a\u0016G]G"));
        a2.l.set(null);
    }

    public FileLicenseManager(AxonServerEnterpriseProperties a2, AdminNodes a3) {
        FileLicenseManager a4;
        FileLicenseManager fileLicenseManager = a4;
        FileLicenseManager fileLicenseManager2 = a4;
        fileLicenseManager.l = new AtomicReference();
        FileLicenseManager fileLicenseManager3 = a4;
        fileLicenseManager.C = new AtomicReference<E>(E.h);
        fileLicenseManager.I = a2.getLicenseDirectory() == null ? Paths.get("", new String[0]).toAbsolutePath().toString() : a2.getLicenseDirectory();
        a4.j = a3;
    }

    @NotNull
    private /* synthetic */ String g() {
        String string = System.getProperty(J, System.getenv(m));
        File file = null;
        if (string != null) {
            file = new File(string);
        }
        if (file == null || !file.exists()) {
            FileLicenseManager a2;
            file = new File(a2.I, F);
            if (!file.exists()) {
                throw LicenseException.g((File)file);
            }
            string = file.getAbsolutePath();
        }
        return string;
    }

    public int getClusterNodes() {
        FileLicenseManager a2;
        return a2.g().getClusterNodes();
    }

    public boolean validateSilently(byte[] a22) {
        FileLicenseManager a3;
        try {
            FileLicenseManager fileLicenseManager = a3;
            Properties properties = fileLicenseManager.g(a22);
            a22 = properties;
            fileLicenseManager.g(properties);
        }
        catch (Exception a22) {
            a3.K(a22.getMessage());
            return false;
        }
        i.debug(ErrorMessageFactory.g((Object)"\u0015\u001b:\u00177\u0001<R/\u00135\u001b=\u0013-\u0017=\\"));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void g(Properties a22) {
        String string;
        FileLicenseManager a3;
        try {
            Properties properties;
            block13: {
                Object object;
                KeyFactory keyFactory = KeyFactory.getInstance(PreparedTransaction.g((Object)"; ("));
                Object object2 = Base64.getMimeDecoder().decode(B);
                object2 = new X509EncodedKeySpec((byte[])object2);
                object2 = keyFactory.generatePublic((KeySpec)object2);
                Object object3 = Signature.getInstance(ErrorMessageFactory.g((Object)"!\u00113kGo\u00050\u00061 \n3"));
                ((Signature)object3).initVerify((PublicKey)object2);
                Object object4 = object2 = (Object)new ArrayList<String>(a22.stringPropertyNames());
                Collections.sort(object4);
                if (!object4.remove(c)) {
                    throw LicenseException.g((String)PreparedTransaction.g((Object)"\u001a\u001a\u000e\u001d\b\u0007\u001c\u0001\fS\u000f\u001a\f\u001f\rS\u0004\u001a\u001a\u0000\u0000\u001d\u000e"));
                }
                Object object5 = object2 = object2.iterator();
                while (object5.hasNext()) {
                    object = (String)object2.next();
                    object5 = object2;
                    Signature signature = object3;
                    signature.update(((String)object).getBytes(StandardCharsets.UTF_8));
                    signature.update(a22.getProperty((String)object, "").getBytes(StandardCharsets.UTF_8));
                }
                boolean bl = ((Signature)object3).verify(Base64.getDecoder().decode(a22.getProperty(c)));
                if (!bl) {
                    a3.K(ErrorMessageFactory.g((Object)">0\u0011<\u001c*\u0017y\u00010\u00157\u0013-\u0007+\u0017y\u001b*R0\u001c/\u00135\u001b=\\"));
                    throw LicenseException.g((String)PreparedTransaction.g((Object)"\u001a\u001a\u000e\u001d\b\u0007\u001c\u0001\fS\u0000\u001d\u001f\u0012\u0005\u001a\r"));
                }
                object = Objects.requireNonNull(a3.g(a22.getProperty(K)));
                LocalDate localDate = Objects.requireNonNull(a3.g(a22.getProperty(A)));
                object3 = LocalDate.now();
                if (((LocalDate)object3).isAfter((ChronoLocalDate)object)) {
                    if (((LocalDate)object3).isBefore(localDate)) {
                        G.warn(ErrorMessageFactory.g((Object)"\u0015\u001b:\u00177\u0001<R1\u0013*R<\n)\u001b+\u0017=^y3!\u001d7!<\u0000/\u0017+R.\u001b5\u001ey\u00116\u001c-\u001b7\u0007<R.\u001d+\u00190\u001c>R,\u001c-\u001b5R\"\u000f"), (Object)localDate);
                        i.warn(PreparedTransaction.g((Object)"?\u0000\u0010\f\u001d\u001a\u0016I\u001b\b\u0000I\u0016\u0011\u0003\u0000\u0001\f\u0017ES(\u000b\u0006\u001d:\u0016\u001b\u0005\f\u0001I\u0004\u0000\u001f\u0005S\n\u001c\u0007\u0007\u0000\u001d\u001c\u0016I\u0004\u0006\u0001\u0002\u001a\u0007\u0014I\u0006\u0007\u0007\u0000\u001fI\b\u0014"), (Object)localDate);
                        properties = a22;
                        break block13;
                    } else {
                        a3.K(ErrorMessageFactory.g((Object)"\u0018\n6\u001c\n\u0017+\u0004<\u0000y>0\u0011<\u001c*\u0017y\u001a8\u0001y\u0017!\u00020\u0000<\u0016"));
                        throw LicenseException.g((LocalDate)object);
                    }
                }
                properties = a22;
            }
            string = properties.getProperty(D);
            if (!a3.g(string)) {
                throw LicenseException.K((String)string);
            }
            int a22 = Integer.parseInt((String)a22.get(g));
            long l2 = a3.nodesCount();
            if (l2 > (long)a22) {
                Object[] objectArray = new Object[2];
                objectArray[0] = a22;
                objectArray[1] = l2;
                a3.K(String.format(PreparedTransaction.g((Object)"*\u001f\u001c\u0000\u001d\u0016\u001bS\u0005\u001a\u0004\u001a\u001d\u0016\rS\u001d\u001cIV\rS\u000b\u0006\u001dS\u000f\u001c\u001c\u001d\rSL\u0017I\u001d\u0006\u0017\f\u0000G"), objectArray));
                throw LicenseException.g((int)a22, (long)l2);
            }
        }
        catch (SignatureException signatureException) {
            a3.K(ErrorMessageFactory.g((Object)"\n\u001b>\u001c8\u0006,\u0000<R/\u00135\u001b=\u0013-\u001b6\u001cy\u00148\u001b5\u0017=\\"));
            throw LicenseException.g((String)("SignatureException: " + signatureException.getMessage()));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw new Error(PreparedTransaction.g((Object)"'\u0001\u001a\u001aS\u001a\u001b\u0006\u0006\u0005\u0017I\u001d\f\u0005\f\u0001I\u001b\b\u0003\u0019\u0016\u0007"), generalSecurityException);
        }
        a3.g(string);
    }

    private /* synthetic */ LocalDate g(String a2) {
        if (StringUtils.isEmpty((String)a2)) {
            return null;
        }
        return LocalDate.parse(a2);
    }

    public LocalDate getIssueDate() {
        FileLicenseManager a2;
        return a2.g().getIssueDate();
    }

    public LocalDate getExpiryDate() {
        FileLicenseManager a2;
        return a2.g().getExpiryDate();
    }

    public LocalDate getGraceDate() {
        FileLicenseManager a2;
        return a2.g().getGraceDate();
    }

    private /* synthetic */ LicenseConfiguration g() {
        FileLicenseManager a2;
        Properties properties = a2.readLicenseProperties();
        if (properties == null) {
            throw LicenseException.g();
        }
        properties = new LicenseConfiguration(a2.g(properties.getProperty(K)), properties.getProperty(ErrorMessageFactory.g((Object)"\u0017=\u001b-\u001b6\u001c")), properties.getProperty(f), Integer.parseInt(properties.getProperty(E, PreparedTransaction.g((Object)"X"))), Integer.parseInt(properties.getProperty(g, ErrorMessageFactory.g((Object)"A"))), properties.getProperty(b), a2.g(properties.getProperty(A)), a2.g(properties.getProperty(h)), properties);
        i.debug(PreparedTransaction.g((Object)"%\u001a\n\u0016\u0007\u0000\f\u0017I\u0007\u0006II\b\u0014"), (Object)properties.getLicensee());
        i.debug(ErrorMessageFactory.g((Object)" ,\u001c7\u001b7\u0015y\t$R4\u001d=\u0017"), (Object)properties.getEdition());
        i.debug(PreparedTransaction.g((Object)"%\u001a\n\u0016\u0007\u0000\fS\f\u000b\u0019\u001a\u001b\nI\u0017\b\u0007\fS\u0000\u0000I\b\u0014"), (Object)properties.getExpiryDate());
        return properties;
    }

    private /* synthetic */ void g(String a2) {
        FileLicenseManager a3;
        if (!E.I.equals((Object)a3.C.getAndSet(E.I))) {
            G.info(ErrorMessageFactory.g((Object)"\u0015\u001b:\u00177\u0001<R5\u001d8\u0016<\u0016y\u00137\u0016y\u00048\u001e0\u00168\u0006<\u0016y\u00146\u0000yU\"\u000f~\\"), (Object)a2);
        }
    }
}

