/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.EventStoreValidationException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.grpc.event.EventWithToken;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.localstorage.QueryOptions;
import io.axoniq.axonserver.localstorage.Registration;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.localstorage.SerializedEventWithToken;
import io.axoniq.axonserver.localstorage.SerializedTransactionWithToken;
import io.axoniq.axonserver.localstorage.file.A;
import io.axoniq.axonserver.localstorage.file.C;
import io.axoniq.axonserver.localstorage.file.EventInformation;
import io.axoniq.axonserver.localstorage.file.EventIterator;
import io.axoniq.axonserver.localstorage.file.EventSource;
import io.axoniq.axonserver.localstorage.file.EventSourceFlux;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntries;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.Segment;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.StorageTier;
import io.axoniq.axonserver.localstorage.file.TransactionIterator;
import io.axoniq.axonserver.localstorage.file.ValidationResult;
import io.axoniq.axonserver.localstorage.file.WritableFileStorageTier;
import io.axoniq.axonserver.localstorage.file.g;
import io.axoniq.axonserver.localstorage.transformation.EventTransformerFactory;
import io.axoniq.axonserver.message.command.CommandMetricsWebSocket;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.taskscheduler.task.NodeContext;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.CloseableIterator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FileEventStorageEngine
implements EventStorageEngine {
    public static final int A = Short.MAX_VALUE;
    private static final int C = 2;
    private final DistributionSummary l;
    private final String F;
    private final Set<BiConsumer<Long, List<Event>>> E;
    private final MeterFactory i;
    private final WritableFileStorageTier G;
    private static final Predicate<SerializedEvent> f;
    protected final Set<Runnable> c;
    protected static final Logger j;
    private final IndexManager H;
    private final EventTypeContext m;
    private final Gauge h;
    private final Timer b;
    private final Supplier<StorageProperties> I;

    public byte transactionVersion() {
        return 2;
    }

    public Optional<SerializedEvent> getLastEvent(String a2, long a3, long a4) {
        FileEventStorageEngine a5;
        if ((a2 = a5.H.lastIndexEntries(a2, a4)) == null) {
            return Optional.empty();
        }
        return a5.g(a3, a4, (SegmentIndexEntries)a2);
    }

    private /* synthetic */ TransactionIterator g(EventSource a2, long a3, boolean a4) {
        return a2.createTransactionIterator(a3, a4);
    }

    public int g() {
        FileEventStorageEngine a2;
        return a2.G.g();
    }

    private /* synthetic */ Mono<Void> g() {
        FileEventStorageEngine a3;
        return a3.g().flatMap(a2 -> {
            FileEventStorageEngine a3;
            return a3.g(a2).then(a3.H.activateVersion(a2)).then(Mono.fromRunnable(() -> {
                FileEventStorageEngine a3;
                a3.G.activateSegmentVersion(a2.g(), a2.g());
            }));
        }).then();
    }

    public long nextToken() {
        FileEventStorageEngine a2;
        return a2.G.K();
    }

    private /* synthetic */ Flux<Long> g(int a3, Flux<EventWithToken> a5) {
        FileEventStorageEngine a6;
        return Flux.usingWhen((Publisher)Mono.just((Object)new C(a2 -> {
            FileEventStorageEngine a4;
            return a4.G.allSegments().filter(a3 -> {
                if (a3 <= a2) {
                    return true;
                }
                return false;
            }).findFirst().orElse(-1L);
        }, a6.I, a3, a6.H, a2 -> {
            FileEventStorageEngine a3;
            FileEventStorageEngine fileEventStorageEngine = a3;
            fileEventStorageEngine.G.f(a2);
            return fileEventStorageEngine.g(a2, a2, false);
        }, a6.F)), a4 -> a5.concatMap(arg_0 -> ((C)a4).g(arg_0)).concatWith((Publisher)a4.G()).filter(a2 -> {
            if (a2 > 0L) {
                return true;
            }
            return false;
        }), a2 -> {
            FileEventStorageEngine a3;
            return a3.g();
        }, C::K, C::g);
    }

    public long getFirstCompletedSegment() {
        FileEventStorageEngine a2;
        return a2.G.g();
    }

    static {
        j = LoggerFactory.getLogger(FileEventStorageEngine.class);
        f = a2 -> true;
    }

    public long store(List<Event> a2, int a3) {
        FileEventStorageEngine a5;
        FileEventStorageEngine fileEventStorageEngine = a5;
        long l2 = fileEventStorageEngine.G.g(a2, a3);
        fileEventStorageEngine.E.forEach(a4 -> {
            FileEventStorageEngine a5;
            a5.g(a4, Long.valueOf(l2), a2);
        });
        return l2;
    }

    private /* synthetic */ Flux<SerializedEvent> g(FileVersion a2, IndexEntries a3, int a4) {
        FileEventStorageEngine a5;
        return new EventSourceFlux(a3, () -> {
            FileEventStorageEngine a3;
            return a3.G.eventSource(a2);
        }, a2.g(), a4).g().name(NodeContext.g((Object)"\u0013i\u0013q\u0002@\u0005k\u0004z\u0017r")).tag("context", a5.m.g()).tag("stream", CommandMetricsWebSocket.g((Object)"zI|\\~IzZ~q~X~@o]")).tag("origin", NodeContext.g((Object)"\u0013i\u0013q\u0002@\u0005p\u0003m\u0015z")).metrics();
    }

    public FileEventStorageEngine(EventTypeContext a2, IndexManager a3, EventTransformerFactory a4, Supplier<StorageProperties> a5, Supplier<StorageTier> a6, MeterFactory a7, FileSystemMonitor a8, ScheduledExecutorService a9, String a10) {
        FileEventStorageEngine a11;
        FileEventStorageEngine fileEventStorageEngine = a11;
        FileEventStorageEngine fileEventStorageEngine2 = a11;
        FileEventStorageEngine fileEventStorageEngine3 = a11;
        FileEventStorageEngine fileEventStorageEngine4 = a11;
        fileEventStorageEngine3.c = new CopyOnWriteArraySet();
        FileEventStorageEngine fileEventStorageEngine5 = a11;
        fileEventStorageEngine3.E = new CopyOnWriteArraySet();
        fileEventStorageEngine3.m = a2;
        fileEventStorageEngine2.H = a3;
        fileEventStorageEngine2.I = a5;
        fileEventStorageEngine.i = a7;
        FileEventStorageEngine fileEventStorageEngine6 = a11;
        fileEventStorageEngine.G = new WritableFileStorageTier(a2, a3, a5, a6, a7, a9, a10, a4, a8);
        fileEventStorageEngine.F = a10;
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a2.g();
        stringArray[2] = "type";
        stringArray[3] = a2.g().name();
        a2 = Tags.of((String[])stringArray);
        FileEventStorageEngine fileEventStorageEngine7 = a11;
        MeterFactory meterFactory = a7;
        a11.b = meterFactory.timer((MetricName)BaseMetricName.ba, (Tags)a2);
        fileEventStorageEngine7.l = meterFactory.distributionSummary((MetricName)BaseMetricName.N, (Tags)a2);
        fileEventStorageEngine7.h = a7.gauge((MetricName)BaseMetricName.Ja, (Tags)a2, () -> a11.size());
    }

    public void query(QueryOptions a4, Predicate<EventWithToken> a6) {
        FileEventStorageEngine a7;
        boolean bl = !a7.m.g();
        a7.G.allSegments().filter(a3 -> {
            if (a3 <= a4.K()) {
                return true;
            }
            return false;
        }).map(a2 -> {
            FileEventStorageEngine a3;
            return a3.G.eventSource(a2.longValue()).orElse(null);
        }).filter(Objects::nonNull).anyMatch(a5 -> {
            QueryOptions queryOptions;
            long l2;
            boolean bl;
            block10: {
                block8: {
                    bl = false;
                    l2 = Long.MAX_VALUE;
                    EventIterator eventIterator = a5.createEventIterator();
                    try {
                        while (!bl && eventIterator.hasNext()) {
                            EventInformation eventInformation = eventIterator.g();
                            l2 = Math.min(l2, eventInformation.g().getTimestamp());
                            if (eventInformation.g() > a4.K()) {
                                bl = true;
                            }
                            if (bl || eventInformation.g() < a4.g() || eventInformation.g().getTimestamp() < a4.f() || a6.test(eventInformation.g(bl))) continue;
                            bl = true;
                        }
                        if (eventIterator == null) break block8;
                        queryOptions = a4;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        block9: {
                            if (eventIterator != null) {
                                try {
                                    eventIterator.close();
                                    throwable2 = throwable;
                                    break block9;
                                }
                                catch (Throwable a32) {
                                    throwable.addSuppressed(a32);
                                }
                            }
                            throwable2 = throwable;
                        }
                        throw throwable2;
                    }
                    eventIterator.close();
                    break block10;
                }
                queryOptions = a4;
            }
            if (queryOptions.g() > a5.segment() || l2 < a4.f()) {
                bl = true;
            }
            return bl;
        });
    }

    public Flux<SerializedEvent> eventsPerAggregate(String a4, long a5, long a6, long a7) {
        FileEventStorageEngine a8;
        return Flux.defer(() -> {
            FileEventStorageEngine a6;
            j.debug(NodeContext.g((Object)"d\u000b%VM\u0013~\u0012v\u0018xVv\u0018{\u0013gVz\u0018k\u0004v\u0013lVy\u0019mV~\u0011x\u0004z\u0011~\u0002zVd\u000b?\u0005k\u0017m\u0002z\u00121"), (Object)a6.m, (Object)a4);
            SortedMap a32 = a6.H.lookupAggregate(a4, a5, a6, Long.MAX_VALUE, a7);
            FileEventStorageEngine fileEventStorageEngine = a6;
            j.debug(CommandMetricsWebSocket.g((Object)"`S!\u000eIKzJr@|\u000er@\u007fKc\u000e~@o\\rKh\u000e}Ai\u000ezI|\\~IzZ~\u000e`S;Hr@r]sK\u007f\u0000"), (Object)fileEventStorageEngine.m, (Object)a4);
            fileEventStorageEngine.l.record((double)a32.size());
            return Flux.fromIterable(a32.entrySet());
        }).flatMapSequential(a2 -> {
            FileEventStorageEngine a3;
            return a3.g((FileVersion)a2.getKey(), (IndexEntries)a2.getValue(), ((StorageProperties)a3.I.get()).getEventsPerSegmentPrefetch());
        }, 2, ((StorageProperties)a8.I.get()).getEventsPerSegmentPrefetch()).skipUntil(a3 -> {
            if (a3.f() >= a5) {
                return true;
            }
            return false;
        }).takeWhile(a3 -> {
            if (a3.f() < a6) {
                return true;
            }
            return false;
        }).name(CommandMetricsWebSocket.g((Object)"~X~@oqhZiKzC")).tag("context", a8.m.g()).tag("stream", NodeContext.g((Object)"\u0017x\u0011m\u0013x\u0017k\u0013@\u0013i\u0013q\u0002l")).tag("origin", CommandMetricsWebSocket.g((Object)"KmKuZD]t[iM~]")).metrics();
    }

    public long getFirstToken() {
        FileEventStorageEngine a4;
        return a4.G.allSegments().reduce((a2, a3) -> a3).orElse(-1L);
    }

    public void init(boolean a2, long a3) {
        FileEventStorageEngine a4;
        FileEventStorageEngine fileEventStorageEngine = a4;
        fileEventStorageEngine.G.g(Long.MAX_VALUE, a3);
        fileEventStorageEngine.g(a2 ? ((StorageProperties)a4.I.get()).getValidationSegments() : 2);
    }

    private /* synthetic */ void g(BiConsumer<Long, List<Event>> a22, Long a3, List<Event> a4) {
        try {
            a22.accept(a3, a4);
            return;
        }
        catch (Exception a22) {
            FileEventStorageEngine a5;
            Object[] objectArray = new Object[3];
            objectArray[0] = a5.m;
            objectArray[1] = a3;
            objectArray[2] = a22;
            j.debug(NodeContext.g((Object)"d\u000b%Vz\u0004m\u0019mVh\u001ev\u001azV|\u0017s\u001av\u0018xVz\u0000z\u0018kVs\u001fl\u0002z\u0018z\u0004?\u0010p\u0004?\u0002p\u001dz\u0018?\rb"), objectArray);
            return;
        }
    }

    private /* synthetic */ TransactionIterator g(long a2, long a3, boolean a5) {
        FileEventStorageEngine a6;
        return a6.G.eventSource(a2).map(a4 -> {
            FileEventStorageEngine a5;
            return a5.g(a4, a3, a5);
        }).orElseThrow(() -> {
            FileEventStorageEngine a4;
            Object[] objectArray = new Object[3];
            objectArray[0] = a4.m;
            objectArray[1] = a2;
            objectArray[2] = a3;
            return new MessagingPlatformException(ErrorCode.OTHER, String.format(CommandMetricsWebSocket.g((Object)">]!\u000en@zLwK;Zt\u000eiKzJ;ZiOu]zMoGt@h\u000e}Ai\u000ehK|C~@o\u000e>J7\u000eiKj[~]oK\u007f\u000eoApKu\u000e>J"), objectArray));
        });
    }

    private /* synthetic */ File g(FileVersion a2) {
        FileEventStorageEngine a3;
        return ((StorageProperties)a3.I.get()).transformedDataFile(a3.F, a2);
    }

    public void validateTransaction(long a2, List<Event> a32) {
        CloseableIterator closeableIterator;
        block9: {
            FileEventStorageEngine a4;
            block8: {
                long l2 = a2;
                closeableIterator = a4.transactionIterator(l2, l2 + (long)a32.size());
                try {
                    if (!closeableIterator.hasNext()) break block8;
                    SerializedTransactionWithToken serializedTransactionWithToken = (SerializedTransactionWithToken)closeableIterator.next();
                    if (!a4.g(serializedTransactionWithToken.g(), a32)) {
                        Object[] objectArray = new Object[3];
                        objectArray[0] = a4.m.g();
                        objectArray[1] = a4.m.g();
                        objectArray[2] = a2;
                        throw new EventStoreValidationException(String.format(CommandMetricsWebSocket.g((Object)">]!\u000eIKkBrMzZ~J;\u000bh\u000eo\\z@hOxZrAu\u000e>J;JtKh\u000euAo\u000evOoMs\u000ehZt\\~J;ZiOu]zMoGt@"), objectArray));
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block10: {
                        if (closeableIterator != null) {
                            try {
                                closeableIterator.close();
                                throwable2 = throwable;
                                break block10;
                            }
                            catch (Throwable a32) {
                                throwable.addSuppressed(a32);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = a4.m.g();
            objectArray[1] = a4.m.g();
            objectArray[2] = a2;
            throw new EventStoreValidationException(String.format(NodeContext.g((Object)"SlL?$z\u0006s\u001f|\u0017k\u0013{V:\u0005?\u0002m\u0017q\u0005~\u0015k\u001fp\u0018?S{Vq\u0019kVy\u0019j\u0018{"), objectArray));
        }
        if (closeableIterator != null) {
            closeableIterator.close();
            return;
        }
    }

    public void g(int a32) {
        int n;
        FileEventStorageEngine a4;
        List a32 = a4.G.allSegments().limit(a32).collect(Collectors.toSet()).parallelStream().map(arg_0 -> a4.g(arg_0)).collect(Collectors.toList());
        a32.stream().filter(a2 -> {
            if (!a2.g()) {
                return true;
            }
            return false;
        }).findFirst().ifPresent(a2 -> {
            throw new MessagingPlatformException(ErrorCode.VALIDATION_FAILED, a2.g());
        });
        a32.sort(Comparator.comparingLong(ValidationResult::K));
        int n2 = n = 0;
        while (true) {
            if (n2 >= a32.size() - 1) break;
            ValidationResult validationResult = (ValidationResult)a32.get(n);
            ValidationResult validationResult2 = (ValidationResult)a32.get(n + 1);
            if (validationResult.g() != validationResult2.K()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = validationResult.K();
                objectArray[1] = validationResult.g() - 1L;
                objectArray[2] = validationResult2.K();
                throw new MessagingPlatformException(ErrorCode.VALIDATION_FAILED, String.format(CommandMetricsWebSocket.g((Object)"xzBrJzZrAu\u000e~VxKkZrAu\u0014;]~IvKuZ;\u000b\u007f\u000e~@\u007fGuI;Oo\u000eoApKu\u0002;\u000b\u007f\u0002;@~Vo\u000ehK|C~@o\u000ehZz\\o];Oo\u000eoApKu\u000e>J"), objectArray));
            }
            n2 = ++n;
        }
    }

    public void close(boolean a22) {
        FileEventStorageEngine fileEventStorageEngine;
        FileEventStorageEngine a3;
        try {
            FileEventStorageEngine fileEventStorageEngine2 = a3;
            fileEventStorageEngine2.G.close(a22);
            fileEventStorageEngine2.c.forEach(Runnable::run);
            fileEventStorageEngine = a3;
        }
        catch (Exception a22) {
            j.warn(NodeContext.g((Object)"d\u000b%V|\u001ap\u0005zVy\u0017v\u001az\u0012?[?\rb"), (Object)a3.m, (Object)a22.getMessage());
            fileEventStorageEngine = a3;
        }
        fileEventStorageEngine.i.remove((Meter)a3.h);
        FileEventStorageEngine fileEventStorageEngine3 = a3;
        a3.i.remove((Meter)fileEventStorageEngine3.l);
        fileEventStorageEngine3.i.remove((Meter)a3.b);
    }

    public long getLastToken() {
        FileEventStorageEngine a2;
        return a2.G.f();
    }

    public EventTypeContext getType() {
        FileEventStorageEngine a2;
        return a2.m;
    }

    public void processEventsPerAggregateHighestFirst(String a2, long a3, long a5, int a6, Predicate<SerializedEvent> a7, Consumer<SerializedEvent> a8) {
        FileEventStorageEngine a9;
        a2 = a9.H.lookupAggregate((String)a2, a3, a5, (long)a6, 0L);
        ArrayList arrayList = new ArrayList(a2.keySet());
        Collections.reverse(arrayList);
        for (FileVersion fileVersion : arrayList) {
            Object object = (IndexEntries)a2.get(fileVersion);
            object = new ArrayList(object.positions());
            Collections.reverse(object);
            long l2 = a3;
            if ((a6 -= a9.g(fileVersion, (List)object, l2, a5, a4 -> {
                if (a4.f() >= l2 && a7.test((SerializedEvent)a4)) {
                    return true;
                }
                return false;
            }, a8, (long)a6)) > 0) continue;
            return;
        }
    }

    private /* synthetic */ Optional<SerializedEvent> g(long a2, long a3, SegmentIndexEntries a4) {
        FileEventStorageEngine a6;
        return a6.G.eventSource(a4.g()).map(a5 -> a5.readLastInRange(a2, a3, a4.g().positions()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Long> getLastSequenceNumber(String a2, EventStorageEngine.SearchHint a3, long a4) {
        FileEventStorageEngine a5;
        long l2 = System.currentTimeMillis();
        try {
            a2 = a5.H.getLastSequenceNumber((String)a2, a3, a4);
            return a2;
        }
        finally {
            a5.b.record(System.currentTimeMillis() - l2, TimeUnit.MILLISECONDS);
        }
    }

    private /* synthetic */ EventIterator g(long a2, long a4) {
        FileEventStorageEngine a5;
        return a5.G.eventSource(a2).map(a3 -> a3.createEventIterator(a4)).orElseThrow(() -> {
            FileEventStorageEngine a3;
            Object[] objectArray = new Object[2];
            objectArray[0] = a3.m;
            objectArray[1] = a4;
            return new MessagingPlatformException(ErrorCode.OTHER, String.format(NodeContext.g((Object)"SlL?\u0002p\u001dz\u0018?S{V}\u0013y\u0019m\u0013?\u0005k\u0017m\u0002?\u0019yVz\u0000z\u0018kVl\u0002p\u0004z"), objectArray));
        });
    }

    public Registration registerCloseListener(Runnable a2) {
        FileEventStorageEngine a3;
        FileEventStorageEngine fileEventStorageEngine = a3;
        fileEventStorageEngine.c.add(a2);
        return () -> {
            FileEventStorageEngine a3;
            a3.c.remove(a2);
        };
    }

    private /* synthetic */ boolean g(List<SerializedEvent> a2, List<Event> a3) {
        int n;
        int n2 = n = 0;
        while (n2 < a2.size()) {
            if (!a2.get(n).g().equals((Object)a3.get(n))) {
                return false;
            }
            n2 = ++n;
        }
        return true;
    }

    public Registration registerEventListener(BiConsumer<Long, List<Event>> a2) {
        FileEventStorageEngine a3;
        FileEventStorageEngine fileEventStorageEngine = a3;
        fileEventStorageEngine.E.add(a2);
        return () -> {
            FileEventStorageEngine a3;
            a3.E.remove(a2);
        };
    }

    public CloseableIterator<SerializedEventWithToken> getGlobalIterator(long a2) {
        FileEventStorageEngine a3;
        return new g(a3, a2);
    }

    public boolean validateSnapshot(SerializedEvent a2) {
        FileEventStorageEngine a3;
        if (a3.H.limitedSegmentChecks()) {
            long l2 = a3.getLastSequenceNumber(a2.L(), EventStorageEngine.SearchHint.b, Long.MAX_VALUE).orElse(-1L);
            boolean bl = l2 >= a2.f();
            if (!bl) {
                Object[] objectArray = new Object[4];
                objectArray[0] = a3.m.g();
                objectArray[1] = a2.f();
                objectArray[2] = a2.L();
                objectArray[3] = l2;
                j.error(NodeContext.g((Object)"d\u000b%Vv\u0018i\u0017s\u001f{Vl\u0018~\u0006l\u001ep\u0002?\u0001v\u0002wVl\u0013n\u0003z\u0018|\u0013?\u0018j\u001b}\u0013mVd\u000b?\u0010p\u0004?\u0017x\u0011m\u0013x\u0017k\u0013?\rbZ?\u001a~\u0005kVz\u0000z\u0018kVl\u0013n\u0003z\u0018|\u0013?\u0018j\u001b}\u0013mVv\u0005?\rb"), objectArray);
            }
            return bl;
        }
        return true;
    }

    public long size() {
        FileEventStorageEngine a2;
        return a2.G.size() + a2.H.size();
    }

    private /* synthetic */ int g(FileVersion a2, List<Integer> a3, long a4, long a5, Predicate<SerializedEvent> a6, Consumer<SerializedEvent> a7, long a8) {
        FileEventStorageEngine a9;
        a2 = a9.G.eventSource((FileVersion)a2);
        int n = 0;
        if (((Optional)a2).isPresent()) {
            int n2;
            SerializedEvent serializedEvent;
            a2 = ((EventSource)((Optional)a2).get()).reader();
            try {
                for (int j = 0; j < a3.size() && (long)j < a8; ++j) {
                    serializedEvent = a2.readEvent(a3.get(j).intValue());
                    if (a6.test(serializedEvent)) break block10;
                    n2 = Integer.MAX_VALUE;
                    if (a2 == null) break block11;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                block12: {
                    if (a2 != null) {
                        try {
                            a2.close();
                            throwable2 = throwable;
                            break block12;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throwable2 = throwable;
                }
                throw throwable2;
            }
            {
                block10: {
                    block11: {
                        a2.close();
                    }
                    return n2;
                }
                if (serializedEvent.f() >= a4 && serializedEvent.f() < a5) {
                    a7.accept(serializedEvent);
                }
                ++n;
                continue;
            }
            if (a2 != null) {
                a2.close();
                return n;
            }
        }
        return n;
    }

    public long getTokenAt(long a3) {
        FileEventStorageEngine a4;
        return a4.G.allSegments().map(a2 -> {
            FileEventStorageEngine a3;
            return a3.G.eventSource(a2.longValue()).orElse(null);
        }).filter(Objects::nonNull).map(a322 -> {
            Long l2;
            block5: {
                EventSource a322;
                EventSource eventSource = a322;
                a322 = eventSource.createEventIterator(eventSource.segment());
                try {
                    l2 = a322.g(a3);
                    if (a322 == null) break block5;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block6: {
                        if (a322 != null) {
                            try {
                                a322.close();
                                throwable2 = throwable;
                                break block6;
                            }
                            catch (Throwable a322) {
                                throwable.addSuppressed(a322);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                a322.close();
            }
            return l2;
        }).filter(Objects::nonNull).findFirst().orElseGet(() -> a4.getFirstToken());
    }

    public void g(Segment a2, Runnable a3) {
        FileEventStorageEngine a4;
        a4.G.handover(a2, a3);
    }

    public Stream<String> getBackupFilenames(long a2, int a3, boolean a4) {
        FileEventStorageEngine a5;
        return a5.G.g(a2, a3, a4);
    }

    public CloseableIterator<SerializedTransactionWithToken> transactionIterator(long a2, long a3) {
        FileEventStorageEngine a4;
        return new A(a4, a2, Long.valueOf(a3));
    }

    public Optional<Long> getLastSequenceNumber(String a2, EventStorageEngine.SearchHint[] a3) {
        FileEventStorageEngine a4;
        FileEventStorageEngine fileEventStorageEngine = a4;
        return fileEventStorageEngine.getLastSequenceNumber(a2, fileEventStorageEngine.g(a3) ? EventStorageEngine.SearchHint.I : EventStorageEngine.SearchHint.b, Long.MAX_VALUE);
    }

    public Flux<Long> transformContents(int a2, Flux<EventWithToken> a3) {
        FileEventStorageEngine a4;
        return a4.g(a2, a3);
    }

    public Mono<Void> deleteOldVersions() {
        FileEventStorageEngine a3;
        FileEventStorageEngine fileEventStorageEngine = a3;
        return fileEventStorageEngine.g(((StorageProperties)fileEventStorageEngine.I.get()).getEventsSuffix()).doOnNext(a2 -> {
            FileEventStorageEngine a3;
            j.debug(CommandMetricsWebSocket.g((Object)"`S;\u0014;MsKxE;J~B~Z~\u000emKi]rAu\u000e`S"), (Object)a3.m, a2);
        }).filter(a2 -> {
            FileEventStorageEngine a3;
            if (a3.G.currentSegmentVersion(Long.valueOf(a2.g())).intValue() != a2.g()) {
                return true;
            }
            return false;
        }).doOnNext(a2 -> {
            FileEventStorageEngine a3;
            j.debug(CommandMetricsWebSocket.g((Object)"Uf\u000e!\u000emKi]rAu\u000eoA;J~B~Z~\u000e`S"), (Object)a3.m, a2);
        }).flatMapSequential(a2 -> {
            FileEventStorageEngine a3;
            return Mono.fromRunnable(() -> {
                FileEventStorageEngine a3;
                if (!a3.G.removeSegment(a2.g(), a2.g())) {
                    throw new MessagingPlatformException(ErrorCode.OTHER, a3.m + ": Cannot remove segment " + a2);
                }
            }).retry(3L).then();
        }).then();
    }

    private /* synthetic */ Flux<FileVersion> g() {
        FileEventStorageEngine a2;
        String string = ((StorageProperties)a2.I.get()).getEventsSuffix() + ".transformed";
        return a2.g(string);
    }

    private /* synthetic */ boolean g(EventStorageEngine.SearchHint[] a2) {
        int n;
        int n2 = a2.length;
        int n3 = n = 0;
        while (n3 < n2) {
            if (a2[n].equals((Object)EventStorageEngine.SearchHint.I)) {
                return true;
            }
            n3 = ++n;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ ValidationResult g(long a) {
        block13: {
            block12: {
                v0 = new Object[3];
                v0[0] = a.m.g();
                v0[1] = a.m.g();
                v0[2] = a;
                FileEventStorageEngine.j.debug(NodeContext.g((Object)"d\u000b%VI\u0017s\u001f{\u0017k\u001fq\u0011?\rbVl\u0013x\u001bz\u0018kL?\rb"), v0);
                v1 = a;
                var3_2 = a.g(v1, v1, true);
                var4_4 = null;
                v2 = var3_2;
                while (v2.hasNext()) {
                    var4_4 = (SerializedTransactionWithToken)var3_2.next();
                    v2 = var3_2;
                }
                v3 = v4;
                v5 = v4;
                v6 = a;
                if (var4_4 != null) break block12;
                v7 = a;
                ** GOTO lbl39
            }
            v7 = var4_4.g() + (long)var4_4.g();
lbl39:
            // 2 sources

            v3(v6, v7);
            var5_6 = v5;
            if (var3_2 == null) break block13;
            {
                catch (Throwable var4_5) {
                    try {
                        block14: {
                            if (var3_2 != null) {
                                try {
                                    var3_2.close();
                                    v8 = var4_5;
                                    break block14;
                                }
                                catch (Throwable var5_7) {
                                    var4_5.addSuppressed(var5_7);
                                }
                            }
                            v8 = var4_5;
                        }
                        throw v8;
                    }
                    catch (Exception var3_3) {
                        return new ValidationResult(a, var3_3.getMessage());
                    }
                }
            }
            var3_2.close();
        }
        return var5_6;
    }

    public void processEventsPerAggregate(String a2, long a3, long a4, long a7, Consumer<SerializedEvent> a8) {
        FileEventStorageEngine a9;
        a9.H.lookupAggregate(a2, a3, a4, Long.MAX_VALUE, a7).forEach((a5, a6) -> {
            FileEventStorageEngine a7;
            a7.g(a5, a6.positions(), a3, a4, f, a8, Long.MAX_VALUE);
        });
    }

    private /* synthetic */ Mono<Void> g(FileVersion a2) {
        FileEventStorageEngine a3;
        FileVersion fileVersion = a2;
        return a3.G.renameTransformedSegmentIfNeeded(fileVersion, a3.g(fileVersion));
    }

    private /* synthetic */ Flux<FileVersion> g(String a2) {
        FileEventStorageEngine a3;
        return a3.G.fileVersions(a2);
    }
}

