/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.component.processor.balancing.SameProcessor;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.plugin.PluginConfigurationManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.scheduler.Schedulers;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class FileUtils {
    public static final Logger I = LoggerFactory.getLogger(FileUtils.class);

    public static void g(File a2) {
        if (a2.exists() && !a2.isDirectory()) {
            throw new MessagingPlatformException(ErrorCode.DIRECTORY_CREATION_FAILED, "Could not setup directory " + a2.getAbsolutePath());
        }
        if (!a2.exists() && !a2.mkdirs()) {
            throw new MessagingPlatformException(ErrorCode.DIRECTORY_CREATION_FAILED, "Could not setup directory " + a2.getAbsolutePath());
        }
    }

    public static String[] g(File a2, String a3) {
        if ((a3 = a2.list((arg_0, arg_1) -> FileUtils.g((String)a3, arg_0, arg_1))) == null) {
            throw new MessagingPlatformException(ErrorCode.DATAFILE_READ_ERROR, "Could not list files in " + a2.getAbsolutePath());
        }
        return a3;
    }

    public static Mono<Void> g(File a2, File a3) {
        return Mono.create(a4 -> {
            try {
                MonoSink monoSink;
                if (Files.getFileStore(a2.toPath()).equals(Files.getFileStore(a3.getParentFile().toPath()))) {
                    CopyOption[] copyOptionArray = new CopyOption[1];
                    copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.move(a2.toPath(), a3.toPath(), copyOptionArray);
                    monoSink = a4;
                } else {
                    File file = File.createTempFile(a3.getName(), SameProcessor.g((Object)"?a|e"), a3.getParentFile());
                    file.deleteOnExit();
                    CopyOption[] copyOptionArray = new CopyOption[1];
                    copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.copy(a2.toPath(), file.toPath(), copyOptionArray);
                    Files.delete(a2.toPath());
                    CopyOption[] copyOptionArray2 = new CopyOption[1];
                    copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.move(file.toPath(), a3.toPath(), copyOptionArray2);
                    monoSink = a4;
                }
                monoSink.success();
                return;
            }
            catch (Exception exception) {
                a4.error((Throwable)exception);
                return;
            }
        }).subscribeOn(Schedulers.boundedElastic());
    }

    private /* synthetic */ FileUtils() {
        FileUtils a2;
    }

    public static String g(File a2) {
        try {
            return a2.getCanonicalFile().getAbsolutePath();
        }
        catch (IOException iOException) {
            return a2.getAbsolutePath();
        }
    }

    public static boolean g(File a2) {
        if (!a2.exists()) {
            return true;
        }
        I.debug(PluginConfigurationManager.g((Object)"ANiNqN%MlG`\u000b~V"), (Object)a2.getAbsolutePath());
        try {
            Files.delete(a2.toPath());
        }
        catch (DirectoryNotEmptyException directoryNotEmptyException) {
            I.info(SameProcessor.g((Object)"Sp|}pu5ez1qtytat5u|cpra~gh/1nl91|e5xf1{~a1p|eel"), (Object)a2);
            return false;
        }
        catch (IOException iOException) {
            I.warn(PluginConfigurationManager.g((Object)"CJlG`O%_j\u000baNiNqN?\u000b~V"), (Object)a2, (Object)iOException);
            return false;
        }
        return true;
    }

    private static /* synthetic */ boolean g(String a2, File a3, String a4) {
        return a4.endsWith(a2);
    }

    public static FileVersion g(String a2) {
        String string = a2;
        String string2 = string.substring(0, string.indexOf(46));
        int n = string2.indexOf(95);
        if (n < 0) {
            return new FileVersion(Long.parseLong(string2), 0);
        }
        return new FileVersion(Long.parseLong(string2.substring(0, n)), Integer.parseInt(string2.substring(n + 1)));
    }
}

