/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventType;
import io.axoniq.axonserver.localstorage.StorageResolver;
import io.axoniq.axonserver.localstorage.file.AggregateIndexEntries;
import io.axoniq.axonserver.localstorage.file.F;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntries;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.IndexNotFoundException;
import io.axoniq.axonserver.localstorage.file.PersistedBloomFilter;
import io.axoniq.axonserver.localstorage.file.RemoteAggregateSequenceNumberResolver;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import io.axoniq.axonserver.localstorage.file.StandardIndexEntries;
import io.axoniq.axonserver.localstorage.file.StandardIndexEntriesSerializer;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.rest.ApplicationJSON;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class StandardIndexManager
implements IndexManager {
    private final MeterFactory.RateMeter D;
    private static final ScheduledExecutorService J;
    private final ConcurrentNavigableMap<Long, Map<String, IndexEntries>> g;
    private final ConcurrentNavigableMap<FileVersion, PersistedBloomFilter> K;
    protected final String A;
    private final AtomicLong C;
    private ScheduledFuture<?> l;
    private final Counter F;
    private final MeterFactory.RateMeter E;
    private final Counter i;
    private static final String G = "aggregateMap";
    private final Supplier<IndexManager> f;
    private static final Logger c;
    private final String j;
    private final EventType H;
    private final ConcurrentNavigableMap<Long, Integer> m;
    private final ConcurrentSkipListMap<FileVersion, F> h;
    protected final Supplier<StorageProperties> b;
    private final RemoteAggregateSequenceNumberResolver I;

    private /* synthetic */ IndexEntries g(FileVersion a2, String a3) {
        int n;
        StandardIndexManager a4;
        if (a4.g(a2, a3)) {
            return null;
        }
        RuntimeException runtimeException = new RuntimeException();
        int n2 = n = 0;
        while (true) {
            if (n2 >= 3) break;
            try {
                F f2 = a4.K(a2);
                return f2.g(a3);
            }
            catch (IndexNotFoundException indexNotFoundException) {
                return null;
            }
            catch (Exception exception) {
                runtimeException = new RuntimeException("Error happened while trying get positions for " + a2.g() + " segment.", exception);
                n2 = ++n;
                continue;
            }
            break;
        }
        throw runtimeException;
    }

    private /* synthetic */ F K(FileVersion a3) {
        StandardIndexManager a4;
        try {
            return a4.h.computeIfAbsent(a3, a2 -> {
                StandardIndexManager a3;
                return new F(a3, a2);
            }).g();
        }
        catch (IndexNotFoundException indexNotFoundException) {
            a3 = (F)a4.h.remove(a3);
            if (a3 != null) {
                a3.close();
            }
            throw indexNotFoundException;
        }
    }

    private /* synthetic */ Mono<Void> g(FileVersion a4, File a5) {
        StandardIndexManager a6;
        return Mono.fromSupplier(() -> {
            StandardIndexManager a3;
            return ((StorageProperties)a3.b.get()).index(a3.j, a4);
        }).filter(a2 -> {
            if (!a2.exists()) {
                return true;
            }
            return false;
        }).flatMap(a3 -> Mono.fromSupplier(() -> a5).filter(File::exists).switchIfEmpty(Mono.error((Throwable)new RuntimeException())).flatMap(a4 -> FileUtils.g((File)a5, (File)a3))).doOnSuccess(a3 -> {
            StandardIndexManager a4;
            a4.m.put(a4.g(), a4.g());
        });
    }

    public void addExistingIndex(FileVersion a2) {
        StandardIndexManager a3;
        a3.m.put(a2.g(), a2.g());
        a3.g();
    }

    private /* synthetic */ boolean g(long a2, long a3, IndexEntries a4) {
        if (!a4.isEmpty() && a2 >= a4.firstSequenceNumber() || a3 <= 0L) {
            return true;
        }
        return false;
    }

    public StandardIndexManager(String a2, Supplier<StorageProperties> a3, String a4, EventType a5, MeterFactory a6) {
        a7(a2, a3, a4, a5, null, a6, () -> null);
        StandardIndexManager a7;
    }

    public StandardIndexManager(String a2, Supplier<StorageProperties> a3, String a4, EventType a5, RemoteAggregateSequenceNumberResolver a6, MeterFactory a7, Supplier<IndexManager> a8) {
        StandardIndexManager a9;
        StandardIndexManager standardIndexManager = a9;
        StandardIndexManager standardIndexManager2 = a9;
        StandardIndexManager standardIndexManager3 = a9;
        StandardIndexManager standardIndexManager4 = a9;
        a9.g = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager5 = a9;
        standardIndexManager4.K = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager6 = a9;
        a9.h = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager7 = a9;
        standardIndexManager3.m = new ConcurrentSkipListMap(Comparator.reverseOrder());
        StandardIndexManager standardIndexManager8 = a9;
        standardIndexManager3.C = new AtomicLong();
        standardIndexManager3.b = a3;
        standardIndexManager2.j = a4;
        standardIndexManager2.A = a2;
        standardIndexManager.H = a5;
        standardIndexManager.I = a6;
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a2;
        stringArray[2] = "type";
        stringArray[3] = a5.name();
        a2 = Tags.of((String[])stringArray);
        StandardIndexManager standardIndexManager9 = a9;
        MeterFactory meterFactory = a7;
        a9.E = a7.rateMeter((MetricName)BaseMetricName.da, (Tags)a2);
        a9.D = meterFactory.rateMeter((MetricName)BaseMetricName.H, (Tags)a2);
        standardIndexManager9.F = meterFactory.counter((MetricName)BaseMetricName.E, (Tags)a2);
        standardIndexManager9.i = a7.counter((MetricName)BaseMetricName.v, (Tags)a2);
        J.scheduleAtFixedRate(() -> {
            Map.Entry entry;
            StandardIndexManager a2;
            StorageProperties storageProperties = (StorageProperties)a2.b.get();
            StandardIndexManager standardIndexManager = a2;
            while (standardIndexManager.h.size() > storageProperties.getMaxIndexesInMemory()) {
                entry = a2.h.pollFirstEntry();
                c.debug(ApplicationJSON.g((Object)"\u00135Rh+$\u0007;\u0001&\u000fh\u0001&\f-\u0010h\u00135"), (Object)a2.A, entry.getKey());
                a2.l = J.schedule(() -> ((F)entry.getValue()).close(), 2L, TimeUnit.SECONDS);
                standardIndexManager = a2;
            }
            StandardIndexManager standardIndexManager2 = a2;
            while (standardIndexManager2.K.size() > storageProperties.getMaxBloomFiltersInMemory()) {
                StandardIndexManager standardIndexManager3 = a2;
                standardIndexManager2 = standardIndexManager3;
                entry = standardIndexManager3.K.pollFirstEntry();
                StandardIndexManager standardIndexManager4 = a2;
                c.debug(StorageResolver.g((Object)":-{p\u00135,?75%p#<.?,p'9-$$\"a6.\"a+<p'\".=a=$=.\"8"), (Object)standardIndexManager4.A, entry.getKey());
                standardIndexManager4.i.increment();
            }
        }, 10L, 10L, TimeUnit.SECONDS);
        a9.f = a8;
    }

    public boolean validIndex(FileVersion a2) {
        block3: {
            boolean bl;
            block4: {
                StandardIndexManager a3;
                if (!a3.m.containsKey(a2.g()) || ((Integer)a3.m.get(a2.g())).intValue() != a2.g()) break block3;
                if (a3.g(a2) == null || a3.K(a2) == null) break block4;
                return true;
            }
            try {
                bl = false;
            }
            catch (Exception exception) {
                c.warn(StorageResolver.g((Object)"\u0016 9-5%p5?a& <(4 $$p(>%59p'?3p25&=$>5ja+<"), (Object)a2, (Object)exception);
            }
            return bl;
        }
        return false;
    }

    public Mono<Void> activateVersion(FileVersion a2) {
        StandardIndexManager a3;
        return Mono.defer(() -> {
            StandardIndexManager a3;
            File file = ((StorageProperties)a3.b.get()).transformedIndex(a3.j, a2);
            return a3.activateVersion(a2, file);
        });
    }

    private /* synthetic */ int g(long a2, long a3, SortedMap<FileVersion, IndexEntries> a4, FileVersion a5, IndexEntries a6) {
        StandardIndexManager a7;
        if (!(a6 = a6.range(a2, a3, EventType.h.equals((Object)a7.H))).isEmpty()) {
            a4.put(a5, a6);
        }
        return a6.size();
    }

    public void cleanup(boolean a4) {
        StandardIndexManager a5;
        StandardIndexManager standardIndexManager = a5;
        standardIndexManager.g.clear();
        standardIndexManager.K.clear();
        standardIndexManager.h.forEach((a2, a3) -> a3.close());
        StandardIndexManager standardIndexManager2 = a5;
        standardIndexManager2.h.clear();
        if (standardIndexManager2.l != null && !a5.l.isDone()) {
            a5.l.cancel(true);
        }
        if (a4) {
            a5.m.keySet().forEach(arg_0 -> a5.removeAllVersions(arg_0));
        }
        StandardIndexManager standardIndexManager3 = a5;
        standardIndexManager3.m.clear();
        IndexManager indexManager = (IndexManager)standardIndexManager3.f.get();
        if (indexManager != null) {
            indexManager.cleanup(a4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Optional<Long> g(String a2, int a3, long a4) {
        void var7_13;
        void var7_11;
        Map map;
        StandardIndexManager a5;
        int n = 0;
        for (Long optional2 : a5.g.descendingKeySet()) {
            if (n >= a3) {
                return Optional.empty();
            }
            if (optional2 > a4 || (map = (Map)a5.g.get(optional2)) == null) continue;
            IndexEntries indexEntries = (IndexEntries)map.get(a2);
            if (indexEntries != null) {
                return Optional.of(indexEntries.lastSequenceNumber());
            }
            ++n;
        }
        for (Map.Entry entry : a5.m.entrySet()) {
            if (n >= a3) {
                return Optional.empty();
            }
            if ((Long)entry.getKey() > a4) continue;
            map = a5.g(new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue()), a2);
            if (map != null) {
                return Optional.of(map.lastSequenceNumber());
            }
            ++n;
        }
        Iterator<Object> iterator = (StandardIndexManager)a5.f.get();
        Optional optional = Optional.empty();
        if (iterator != null) {
            Optional optional2 = iterator.g(a2, a3 - n, a4);
        }
        if (var7_11.isEmpty() && a5.I != null && n < a3 && !a5.m.isEmpty()) {
            StandardIndexManager standardIndexManager = a5;
            Optional optional3 = standardIndexManager.I.getLastSequenceNumber(standardIndexManager.A, a2, a3 - n, (Long)a5.m.keySet().last() - 1L);
        }
        return var7_13;
    }

    static {
        c = LoggerFactory.getLogger(StandardIndexManager.class);
        J = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory(ApplicationJSON.g((Object)"\u0001&\f-\u0010e\u0005)\u0006)\u000f-\u001ae")));
    }

    public void createNewVersion(long a2, int a52, Map<String, List<IndexEntry>> a6) {
        DBMaker.Maker maker;
        HTreeMap hTreeMap;
        StandardIndexManager a7;
        FileVersion a52;
        block12: {
            DBMaker.Maker maker2;
            block7: {
                DBMaker.Maker maker3;
                block11: {
                    block10: {
                        block9: {
                            a52 = new FileVersion(a2, a52);
                            if (a6 == null) {
                                a6 = Collections.emptyMap();
                            }
                            if (!FileUtils.g((File)(a2 = ((StorageProperties)a7.b.get()).transformedIndex(a7.j, a52)))) {
                                throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to delete temp index file:" + a2);
                            }
                            maker2 = DBMaker.fileDB((File)a2);
                            if (!((StorageProperties)a7.b.get()).isUseMmapIndex()) break block9;
                            maker2.fileMmapEnable();
                            if (!((StorageProperties)a7.b.get()).isForceCleanMmapIndex()) break block10;
                            DBMaker.Maker maker4 = maker2;
                            maker3 = maker4;
                            maker4.cleanerHackEnable();
                            break block11;
                        }
                        maker2.fileChannelEnable();
                    }
                    maker3 = maker2;
                }
                maker2 = maker3.make();
                hTreeMap = maker2.hashMap(G, (Serializer)Serializer.STRING, (Serializer)StandardIndexEntriesSerializer.g()).createOrOpen();
                try {
                    a6.forEach((a3, a4) -> {
                        int n;
                        IndexEntry indexEntry = (IndexEntry)a4.get(0);
                        Integer[] integerArray = new Integer[a4.size()];
                        int n2 = n = 0;
                        while (n2 < a4.size()) {
                            int n3 = n++;
                            integerArray[n3] = ((IndexEntry)a4.get(n3)).g();
                            n2 = n;
                        }
                        hTreeMap.put(a3, (Object)new StandardIndexEntries(indexEntry.g(), integerArray));
                    });
                    if (hTreeMap == null) break block7;
                    maker = maker2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block8: {
                        if (hTreeMap != null) {
                            try {
                                hTreeMap.close();
                                throwable2 = throwable;
                                break block8;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                hTreeMap.close();
                break block12;
            }
            maker = maker2;
        }
        maker.close();
        HTreeMap hTreeMap2 = hTreeMap = new PersistedBloomFilter(((StorageProperties)a7.b.get()).bloomFilter(a7.j, a52).getAbsolutePath(), a6.keySet().size(), ((StorageProperties)a7.b.get()).getBloomIndexFpp());
        hTreeMap2.K();
        hTreeMap2.g(a6.keySet());
        hTreeMap2.g();
    }

    private /* synthetic */ boolean g(FileVersion a2) {
        StandardIndexManager a3;
        return ((StorageProperties)a3.b.get()).dataFile(a3.j, a2).exists();
    }

    private /* synthetic */ boolean g(FileVersion a3, String a4) {
        StandardIndexManager a5;
        if ((a3 = a5.K.computeIfAbsent(a3, a2 -> {
            StandardIndexManager a3;
            c.debug(ApplicationJSON.g((Object)"\u00135Rh\u00078\r&H*\u0004'\u0007%H.\u0001$\u001c-\u001ah\u000e'\u001ah\u00135"), (Object)a3.A, (Object)a2.g());
            StorageProperties storageProperties = (StorageProperties)a3.b.get();
            a2 = new PersistedBloomFilter(storageProperties.bloomFilter(a3.j, a2).getAbsolutePath(), 0, 0.03f);
            if (!a2.g()) {
                return null;
            }
            a3.F.increment();
            FileVersion fileVersion = a2;
            fileVersion.f();
            return fileVersion;
        })) != null && !a3.g(a4)) {
            return true;
        }
        return false;
    }

    public void init() {
        int n;
        StandardIndexManager a2;
        StorageProperties storageProperties = (StorageProperties)a2.b.get();
        String[] stringArray = FileUtils.g((File)new File(a2.j), (String)storageProperties.getIndexSuffix());
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            FileVersion fileVersion = FileUtils.g((String)stringArray[n]);
            if (storageProperties.dataFile(a2.j, fileVersion).exists()) {
                a2.m.compute(fileVersion.g(), (a3, a4) -> a4 == null ? fileVersion.g() : Math.max(fileVersion.g(), a4));
            } else {
                a2.remove(fileVersion);
            }
            n3 = ++n;
        }
        a2.g();
    }

    public boolean remove(FileVersion a2) {
        StandardIndexManager a3;
        F f2 = (F)a3.h.remove(a2);
        if (f2 != null) {
            f2.close();
        }
        StandardIndexManager standardIndexManager = a3;
        standardIndexManager.K.remove(a2);
        if (FileUtils.g((File)((StorageProperties)standardIndexManager.b.get()).index(a3.j, a2)) && FileUtils.g((File)((StorageProperties)a3.b.get()).bloomFilter(a3.j, a2))) {
            return true;
        }
        return false;
    }

    public void addToActiveSegment(Long a2, Map<String, List<IndexEntry>> a3) {
        StandardIndexManager a4;
        if (a4.m.containsKey(a2)) {
            throw new IndexNotFoundException(a2 + ": already completed");
        }
        a3.forEach((a5, a6) -> {
            StandardIndexManager a7;
            a7.g.computeIfAbsent(a2, a2 -> new ConcurrentHashMap()).computeIfAbsent(a5, a3 -> new StandardIndexEntries(((IndexEntry)a6.get(0)).g())).addAll(a6);
        });
    }

    public Optional<Long> getLastSequenceNumber(String a2, EventStorageEngine.SearchHint a32, long a4) {
        StandardIndexManager a5;
        int a32 = a32.equals((Object)EventStorageEngine.SearchHint.I) ? ((StorageProperties)a5.b.get()).segmentsForSequenceNumberCheck() : Integer.MAX_VALUE;
        return a5.g(a2, a32, a4);
    }

    public SortedMap<FileVersion, IndexEntries> lookupAggregate(String a2, long a3, long a4, long a5, long a6) {
        Iterator iterator;
        StandardIndexManager a7;
        TreeMap<FileVersion, IndexEntries> treeMap = new TreeMap<FileVersion, IndexEntries>();
        Object[] objectArray = new Object[4];
        objectArray[0] = a7.A;
        objectArray[1] = a2;
        objectArray[2] = a3;
        objectArray[3] = a4;
        c.debug(StorageResolver.g((Object)"+<ja<.?*%1\u0011&735&155a+<p,9/\u0003$!45/3$\u001e4=#53p:-mp-12$\u001250%$>\"5\u000f%,2$\"a+<"), objectArray);
        long l2 = Long.MAX_VALUE;
        Iterator iterator2 = iterator = a7.g.descendingKeySet().iterator();
        while (iterator2.hasNext()) {
            Long l3 = (Long)iterator.next();
            if (l2 < a6) {
                return treeMap;
            }
            IndexEntries indexEntries = (IndexEntries)a7.g.getOrDefault(l3, Collections.emptyMap()).get(a2);
            if (indexEntries != null) {
                StandardIndexManager standardIndexManager = a7;
                int n = standardIndexManager.g(a3, a4, treeMap, new FileVersion(l3.longValue(), 0), indexEntries);
                if (standardIndexManager.g(a3, a5 -= (long)n, indexEntries)) {
                    return treeMap;
                }
            }
            l2 = l3;
            iterator2 = iterator;
        }
        TreeMap<FileVersion, IndexEntries> treeMap2 = treeMap;
        treeMap2.putAll(a7.lookupAggregateInClosedSegments(a2, a3, a4, a5, a6, l2));
        return treeMap2;
    }

    public boolean removeAllVersions(long a2) {
        Integer n;
        StandardIndexManager a3;
        StorageProperties storageProperties = (StorageProperties)a3.b.get();
        if (a3.g.remove(a2) == null && (n = (Integer)a3.m.remove(a2)) != null) {
            FileVersion fileVersion;
            int n2;
            int n3 = n2 = 0;
            while (n3 < n) {
                fileVersion = new FileVersion(a2, n2);
                if (storageProperties.index(a3.j, fileVersion).exists()) {
                    a3.remove(fileVersion);
                }
                n3 = ++n2;
            }
            FileVersion fileVersion2 = new FileVersion(a2, n.intValue());
            fileVersion = (F)a3.h.remove(fileVersion2);
            if (fileVersion != null) {
                fileVersion.close();
            }
            a3.K.remove(fileVersion2);
        }
        if (FileUtils.g((File)storageProperties.index(a3.j, a2)) && FileUtils.g((File)storageProperties.bloomFilter(a3.j, a2))) {
            return true;
        }
        return false;
    }

    public List<File> indexFiles(FileVersion a2) {
        StandardIndexManager a3;
        File[] fileArray = new File[2];
        fileArray[0] = ((StorageProperties)a3.b.get()).index(a3.j, a2);
        fileArray[1] = ((StorageProperties)a3.b.get()).bloomFilter(a3.j, a2);
        return Arrays.asList(fileArray);
    }

    private /* synthetic */ void g() {
        StandardIndexManager a2;
        StandardIndexManager standardIndexManager = a2;
        standardIndexManager.C.set(standardIndexManager.m.keySet().stream().skip(((StorageProperties)a2.b.get()).getMaxIndexesInMemory()).findFirst().orElse(-1L));
    }

    public SegmentIndexEntries lastIndexEntries(String a2, long a3) {
        StandardIndexManager a4;
        for (Long l2 : a4.g.descendingKeySet()) {
            IndexEntries indexEntries = (IndexEntries)((Map)a4.g.get(l2)).get(a2);
            if (indexEntries == null || indexEntries.firstSequenceNumber() >= a3) continue;
            IndexEntries indexEntries2 = indexEntries;
            return new SegmentIndexEntries(new FileVersion(l2.longValue(), 0), indexEntries2.range(indexEntries2.firstSequenceNumber(), a3, EventType.h.equals((Object)a4.H)));
        }
        if (!a4.m.isEmpty()) {
            return a4.lastIndexEntriesFromClosedSegments(a2, a3, ((Long)a4.m.keySet().first()).longValue());
        }
        return null;
    }

    public void K(FileVersion a2, Map<String, IndexEntries> a3) {
        StandardIndexManager a4;
        if (a4.g(a2)) {
            a4.g(a2, a3);
            return;
        }
        StandardIndexManager standardIndexManager = (StandardIndexManager)a4.f.get();
        if (standardIndexManager != null) {
            standardIndexManager.K(a2, a3);
        }
    }

    public Stream<File> getBackupFilenames(long a2, int a5) {
        StandardIndexManager a6;
        StorageProperties storageProperties = (StorageProperties)a6.b.get();
        return a6.m.entrySet().stream().filter(a4 -> {
            if ((Long)a4.getKey() > a2 || (Integer)a4.getValue() > a5) {
                return true;
            }
            return false;
        }).flatMap(a3 -> {
            StandardIndexManager a4;
            File[] fileArray = new File[2];
            fileArray[0] = storageProperties.index(a4.j, ((Long)a3.getKey()).longValue());
            fileArray[1] = storageProperties.bloomFilter(a4.j, ((Long)a3.getKey()).longValue());
            return Stream.of(fileArray);
        });
    }

    public long size() {
        return 0L;
    }

    private /* synthetic */ void g(FileVersion a2, Map<String, IndexEntries> a3) {
        DBMaker.Maker maker;
        HTreeMap hTreeMap;
        File file;
        StorageProperties storageProperties;
        StandardIndexManager a4;
        block14: {
            DBMaker.Maker maker2;
            block9: {
                DBMaker.Maker maker3;
                block13: {
                    block12: {
                        block11: {
                            storageProperties = (StorageProperties)a4.b.get();
                            if (a3 == null) {
                                a3 = Collections.emptyMap();
                            }
                            if (!FileUtils.g((File)(file = storageProperties.indexTemp(a4.j, a2.g())))) {
                                throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to delete temp index file:" + file);
                            }
                            maker2 = DBMaker.fileDB((File)file);
                            if (!storageProperties.isUseMmapIndex()) break block11;
                            maker2.fileMmapEnable();
                            if (!storageProperties.isForceCleanMmapIndex()) break block12;
                            DBMaker.Maker maker4 = maker2;
                            maker3 = maker4;
                            maker4.cleanerHackEnable();
                            break block13;
                        }
                        maker2.fileChannelEnable();
                    }
                    maker3 = maker2;
                }
                maker2 = maker3.make();
                hTreeMap = maker2.hashMap(G, (Serializer)Serializer.STRING, (Serializer)StandardIndexEntriesSerializer.g()).createOrOpen();
                try {
                    hTreeMap.putAll(a3);
                    if (hTreeMap == null) break block9;
                    maker = maker2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block10: {
                        if (hTreeMap != null) {
                            try {
                                hTreeMap.close();
                                throwable2 = throwable;
                                break block10;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                hTreeMap.close();
                break block14;
            }
            maker = maker2;
        }
        maker.close();
        try {
            CopyOption[] copyOptionArray = new CopyOption[1];
            copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
            Files.move(file.toPath(), storageProperties.index(a4.j, a2).toPath(), copyOptionArray);
        }
        catch (IOException iOException) {
            throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to rename index file" + storageProperties.index(a4.j, a2), (Throwable)iOException);
        }
        HTreeMap hTreeMap2 = hTreeMap = new PersistedBloomFilter(storageProperties.bloomFilter(a4.j, a2).getAbsolutePath(), a3.keySet().size(), storageProperties.getBloomIndexFpp());
        hTreeMap2.K();
        hTreeMap2.g(a3.keySet());
        hTreeMap2.g();
        a4.K.put(a2, hTreeMap);
        a4.m.put(a2.g(), a2.g());
        a4.K(a2);
    }

    public SegmentIndexEntries lastIndexEntriesFromClosedSegments(String a2, long a3, long a422) {
        StandardIndexManager a5;
        for (Map.Entry entry : a5.m.entrySet()) {
            FileVersion fileVersion = new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue());
            IndexEntries indexEntries = a5.g(fileVersion, a2);
            if (indexEntries == null || indexEntries.firstSequenceNumber() >= a3) continue;
            IndexEntries indexEntries2 = indexEntries;
            return new SegmentIndexEntries(fileVersion, indexEntries2.range(indexEntries2.firstSequenceNumber(), a3, EventType.h.equals((Object)a5.H)));
        }
        IndexManager a422 = (IndexManager)a5.f.get();
        if (a422 != null) {
            return a422.lastIndexEntriesFromClosedSegments(a2, a3, (Long)a5.m.keySet().last() - 1L);
        }
        return null;
    }

    public StandardIndexManager(String a2, Supplier<StorageProperties> a3, String a4, EventType a5, MeterFactory a6, Supplier<IndexManager> a7) {
        a8(a2, a3, a4, a5, null, a6, a7);
        StandardIndexManager a8;
    }

    public void createIndex(FileVersion a2, Map<String, List<IndexEntry>> a3) {
        StandardIndexManager a6;
        HashMap hashMap = new HashMap();
        a3.forEach((a4, a5) -> hashMap.computeIfAbsent(a4, a3 -> new StandardIndexEntries(((IndexEntry)a5.get(0)).g())).addAll(a5));
        a6.K(a2, hashMap);
    }

    public void complete(FileVersion a2) {
        StandardIndexManager a3;
        StandardIndexManager standardIndexManager = a3;
        standardIndexManager.g(a2, (Map)standardIndexManager.g.get(a2.g()));
        a3.g.remove(a2.g());
        a3.g();
    }

    public Mono<Void> activateVersion(FileVersion a2, File a3) {
        StandardIndexManager a4;
        if (a4.m.containsKey(a2.g())) {
            return a4.g(a2, a3);
        }
        IndexManager indexManager = (IndexManager)a4.f.get();
        if (indexManager != null) {
            return indexManager.activateVersion(a2, a3);
        }
        return Mono.empty();
    }

    public SortedMap<FileVersion, IndexEntries> lookupAggregateInClosedSegments(String a2, long a3, long a4, long a5, long a6, long a7) {
        StandardIndexManager a8;
        IndexManager indexManager;
        TreeMap<FileVersion, IndexEntries> treeMap = new TreeMap<FileVersion, IndexEntries>();
        IndexManager indexManager2 = indexManager = a8.m.entrySet().iterator();
        while (indexManager2.hasNext()) {
            Map.Entry entry = indexManager.next();
            if (a7 < a6) {
                return treeMap;
            }
            FileVersion fileVersion = new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue());
            IndexEntries indexEntries = a8.g(fileVersion, a2);
            Object[] objectArray = new Object[4];
            objectArray[0] = a8.A;
            objectArray[1] = a2;
            objectArray[2] = entry;
            objectArray[3] = indexEntries;
            c.debug(ApplicationJSON.g((Object)"3\u0015rH$\u0007'\u0003=\u0018\t\u000f/\u001a-\u000f)\u001c-H3\u0015h\u0001&H;\r/\u0005-\u0006<H3\u0015h\u000e'\u001d&\fh\u00135"), objectArray);
            if (indexEntries != null) {
                StandardIndexManager standardIndexManager = a8;
                int n = standardIndexManager.g(a3, a4, treeMap, fileVersion, indexEntries);
                if (standardIndexManager.g(a3, a5 -= (long)n, indexEntries)) {
                    return treeMap;
                }
            }
            a7 = (Long)entry.getKey();
            indexManager2 = indexManager;
        }
        indexManager = (IndexManager)a8.f.get();
        if (indexManager != null) {
            treeMap.putAll(indexManager.lookupAggregateInClosedSegments(a2, a3, a4, a5, a6, a7));
        }
        return treeMap;
    }

    public Stream<AggregateIndexEntries> latestSequenceNumbers(FileVersion a2) {
        StandardIndexManager a3;
        return a3.K(a2).g();
    }

    public void addToActiveSegment(long a4, String a5, IndexEntry a6) {
        StandardIndexManager a7;
        if (a7.m.containsKey(a4)) {
            throw new IndexNotFoundException(a4 + ": already completed");
        }
        a7.g.computeIfAbsent(a4, a2 -> new ConcurrentHashMap()).computeIfAbsent(a5, a3 -> new StandardIndexEntries(a6.g())).add(a6);
    }
}

