/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.LifecycleController;
import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.localstorage.file.AbstractFileStorageTier;
import io.axoniq.axonserver.localstorage.file.ByteBufferEventSource;
import io.axoniq.axonserver.localstorage.file.E;
import io.axoniq.axonserver.localstorage.file.EventInformation;
import io.axoniq.axonserver.localstorage.file.EventIterator;
import io.axoniq.axonserver.localstorage.file.EventSource;
import io.axoniq.axonserver.localstorage.file.EventSourceNotFoundException;
import io.axoniq.axonserver.localstorage.file.FilePreparedTransaction;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.Segment;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.StorageTier;
import io.axoniq.axonserver.localstorage.file.Synchronizer;
import io.axoniq.axonserver.localstorage.file.WritableEventSource;
import io.axoniq.axonserver.localstorage.file.WritePosition;
import io.axoniq.axonserver.localstorage.transformation.EventTransformer;
import io.axoniq.axonserver.localstorage.transformation.EventTransformerFactory;
import io.axoniq.axonserver.localstorage.transformation.ProcessedEvent;
import io.axoniq.axonserver.localstorage.transformation.WrappedEvent;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WritableFileStorageTier
extends AbstractFileStorageTier {
    protected final AtomicReference<WritePosition> f;
    private final FileSystemMonitor c;
    protected final ConcurrentNavigableMap<Long, ByteBufferEventSource> j;
    private final Gauge H;
    private final EventTransformer m;
    private static final Logger i = LoggerFactory.getLogger(WritableFileStorageTier.class);
    protected final AtomicLong h;
    private final Synchronizer b;
    private final MeterFactory I;

    public long g(List<Event> a2, int a32) {
        WritableFileStorageTier a4;
        HashMap hashMap = new HashMap();
        WritableFileStorageTier writableFileStorageTier = a4;
        a2 = writableFileStorageTier.g(a2, a32);
        WritePosition a32 = a2.g();
        writableFileStorageTier.g(a32, a2.g(), hashMap);
        writableFileStorageTier.l.addToActiveSegment(a32.c, hashMap);
        writableFileStorageTier.h.set(a32.H + (long)a2.g().size() - 1L);
        writableFileStorageTier.b.g(a32);
        return a32.H;
    }

    private /* synthetic */ FilePreparedTransaction g(List<Event> a3, int a42) {
        WritableFileStorageTier a5;
        a3 = a3.stream().map(a2 -> {
            WritableFileStorageTier a3;
            return new WrappedEvent(a2, a3.m);
        }).collect(Collectors.toList());
        WritableFileStorageTier writableFileStorageTier = a5;
        int n = writableFileStorageTier.g(a3);
        WritePosition a42 = writableFileStorageTier.g(n, a3.size(), a42);
        return new FilePreparedTransaction(a42, n, a3);
    }

    private /* synthetic */ String g() {
        WritableFileStorageTier a2;
        WritableFileStorageTier writableFileStorageTier = a2;
        return writableFileStorageTier.C + "-" + writableFileStorageTier.C.g().name().toLowerCase();
    }

    /*
     * Loose catch block
     */
    protected WritableEventSource g(FileVersion a2, int a32222, boolean a42222) {
        WritableEventSource a42222;
        FileChannel fileChannel;
        Object object;
        WritableFileStorageTier a5;
        block21: {
            StorageProperties storageProperties = (StorageProperties)a5.b.get();
            File file = storageProperties.dataFile(a5.D, a2);
            int n = Math.max(storageProperties.getSegmentSize(), a32222);
            if (file.exists()) {
                if (a42222 && file.length() < (long)a32222) {
                    object = (ByteBufferEventSource)a5.j.remove(a2.g());
                    if (object != null) {
                        object.g(0L);
                    }
                    FileUtils.g((File)file);
                } else {
                    n = (int)file.length();
                }
            } else if (a2.g() > 0) {
                object = storageProperties.dataFile(a5.D, new FileVersion(a2.g(), 0));
                if (((File)object).exists()) {
                    fileChannel = (ByteBufferEventSource)a5.j.remove(a2.g());
                    if (fileChannel != null) {
                        fileChannel.g(0L);
                    }
                    FileUtils.g((File)object);
                }
            }
            object = new RandomAccessFile(file, EventSourceNotFoundException.g((Object)"v\u0019"));
            fileChannel = ((RandomAccessFile)object).getChannel();
            i.info(LifecycleController.g((Object)"\u001d3\\n)>\u0003 \u000f \u0001n\u0000'\n+F5\u001b"), (Object)a5.C, (Object)file);
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, n);
            mappedByteBuffer.put((byte)2);
            mappedByteBuffer.putInt(storageProperties.getFlags());
            WritableEventSource a32222 = new WritableEventSource(file.getAbsolutePath(), (ByteBuffer)mappedByteBuffer, a2.g(), a2.g(), a5.m, storageProperties);
            a5.j.put(a2.g(), a32222);
            a42222 = a32222;
            if (fileChannel == null) break block21;
            fileChannel.close();
        }
        ((RandomAccessFile)object).close();
        return a42222;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        Throwable throwable2;
                        block22: {
                            if (fileChannel != null) {
                                try {
                                    fileChannel.close();
                                    throwable2 = throwable;
                                    break block22;
                                }
                                catch (Throwable a32222) {
                                    throwable.addSuppressed(a32222);
                                }
                            }
                            throwable2 = throwable;
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        Throwable throwable4;
                        try {
                            ((RandomAccessFile)object).close();
                            throwable4 = throwable3;
                        }
                        catch (Throwable throwable5) {
                            Throwable throwable6 = throwable3;
                            throwable4 = throwable6;
                            throwable6.addSuppressed(throwable5);
                        }
                        throw throwable4;
                    }
                }
                catch (Exception exception) {
                    throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, a5.C + ": Failed to create segment: " + a2, (Throwable)exception);
                }
            }
        }
    }

    public void activateSegmentVersion(long a2, int a3) {
        WritableFileStorageTier a5;
        a5.g((T a4) -> a4.activateSegmentVersion(a2, a3));
    }

    private /* synthetic */ void g(WritePosition a2, List<ProcessedEvent> a6, Map<String, List<IndexEntry>> a7) {
        WritableFileStorageTier a8;
        WritePosition writePosition = a2;
        a2.j.g(a6, writePosition.I, writePosition.H, (a3, a4, a5) -> {
            WritableFileStorageTier a6;
            a6.g(a3, a4, a5, a7);
        });
    }

    public long size() {
        WritableFileStorageTier a3;
        return a3.j.values().stream().mapToLong(a2 -> a2.c.capacity()).sum() + (Long)a3.g(StorageTier::size, (Object)0L);
    }

    protected Optional<EventSource> g(long a2) {
        WritableFileStorageTier a3;
        if (a3.j.containsKey(a2)) {
            return Optional.of((EventSource)a3.j.get(a2));
        }
        return Optional.empty();
    }

    protected Optional<EventSource> g(FileVersion a2) {
        WritableFileStorageTier a3;
        return a3.g(a2.g());
    }

    public boolean removeSegment(long a2, int a3) {
        WritableFileStorageTier a5;
        if (a5.j.containsKey(a2)) {
            return a5.g(a2, a3);
        }
        return (Boolean)a5.g((T a4) -> a4.removeSegment(a2, a3), (Object)true);
    }

    public void g(long a2, long a3) {
        WritableFileStorageTier a4;
        StorageProperties storageProperties = (StorageProperties)a4.b.get();
        File file = new File(a4.D);
        FileUtils.g((File)file);
        WritableFileStorageTier writableFileStorageTier = a4;
        writableFileStorageTier.l.init();
        writableFileStorageTier.g(a2, file, a3, storageProperties);
        writableFileStorageTier.c.registerPath(a4.g(), file.toPath());
    }

    public int g() {
        WritableFileStorageTier a2;
        return a2.j.size();
    }

    private static /* synthetic */ void g(FileVersion a2, StorageTier a3) {
        a3.initSegments(a2.g());
    }

    private /* synthetic */ void g(long a3, File a4, long a52, StorageProperties a6) {
        WritableFileStorageTier writableFileStorageTier;
        int n;
        EventIterator eventIterator;
        HashMap<String, List> a52;
        WritableFileStorageTier a7;
        block10: {
            block8: {
                WritableFileStorageTier writableFileStorageTier2 = a7;
                a4 = writableFileStorageTier2.g(a3, a4, new FileVersion(a52, 0), a6);
                writableFileStorageTier2.g(a4.g());
                a4 = writableFileStorageTier2.g((FileVersion)a4, a6);
                writableFileStorageTier2.g(arg_0 -> WritableFileStorageTier.g((FileVersion)a4, arg_0));
                WritableFileStorageTier writableFileStorageTier3 = a7;
                writableFileStorageTier3.g();
                a6 = writableFileStorageTier3.g((FileVersion)a4, a6.getSegmentSize(), false);
                writableFileStorageTier3.l.remove((FileVersion)a4);
                a3 = a4.g();
                a52 = new HashMap<String, List>();
                eventIterator = a6.createEventIterator();
                try {
                    EventIterator eventIterator2 = eventIterator;
                    while (eventIterator2.hasNext()) {
                        EventInformation eventInformation = eventIterator.g();
                        if (eventInformation.g()) {
                            IndexEntry indexEntry = new IndexEntry(eventInformation.g().getAggregateSequenceNumber(), eventInformation.g(), a3);
                            a52.computeIfAbsent(eventInformation.g().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                        }
                        ++a3;
                        eventIterator2 = eventIterator;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block9: {
                        if (eventIterator != null) {
                            try {
                                eventIterator.close();
                                throwable2 = throwable;
                                break block9;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                n = eventIterator.g();
                a7.h.set(a3 - 1L);
                if (eventIterator == null) break block8;
                writableFileStorageTier = a7;
                eventIterator.close();
                break block10;
            }
            writableFileStorageTier = a7;
        }
        writableFileStorageTier.l.addToActiveSegment(Long.valueOf(a4.g()), a52);
        a6.g(n, 0);
        eventIterator = new WritePosition(a3, n, a4.g(), (WritableEventSource)a6, Long.valueOf(a4.g()), 0);
        WritableFileStorageTier writableFileStorageTier4 = a7;
        writableFileStorageTier4.f.set(eventIterator);
        writableFileStorageTier4.b.K((WritePosition)eventIterator);
    }

    private /* synthetic */ int g(List<ProcessedEvent> a2) {
        long l2 = 0L;
        Object object = a2 = a2.iterator();
        while (object.hasNext()) {
            ProcessedEvent processedEvent = (ProcessedEvent)a2.next();
            l2 += (long)(4 + processedEvent.getSerializedSize());
            object = a2;
        }
        if (l2 > Integer.MAX_VALUE) {
            WritableFileStorageTier a3;
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, a3.C + ": Transaction size exceeds maximum size");
        }
        return (int)l2;
    }

    public Integer currentSegmentVersion(Long a2) {
        WritableFileStorageTier a4;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a4.j.get(a2);
        if (byteBufferEventSource != null) {
            return byteBufferEventSource.g();
        }
        return (Integer)a4.g((T a3) -> a3.currentSegmentVersion(a2), (Object)0);
    }

    public void f(long a22) {
        WritableFileStorageTier a4;
        if (!a4.j.containsKey(a22)) {
            return;
        }
        if (a22 == (Long)a4.j.firstKey()) {
            i.info(LifecycleController.g((Object)"5\u001btF\b\t<\u0005'\b)F \u00036\u0012n\u0015+\u0001#\u0003 \u0012n\u0012!F,\u0003n\u0005<\u0003/\u0012+\u0002"), (Object)a4.C);
            StorageProperties a22 = (StorageProperties)a4.b.get();
            WritePosition writePosition = (WritePosition)a4.f.getAndUpdate(a3 -> a3.g(0, a22.getSegmentSize(), 0));
            if (writePosition.f(a22.getSegmentSize())) {
                i.debug(EventSourceNotFoundException.g((Object)"\u0015yT$-v\u000be\u001am\u0000cNj\u000bsNw\u000bc\u0003a\u0000pN\u007f\u0013"), (Object)a4.C, (Object)writePosition.H);
                WritePosition writePosition2 = writePosition;
                writePosition2.j.g(writePosition2.I, -1);
                WritableFileStorageTier writableFileStorageTier = a4;
                WritableFileStorageTier writableFileStorageTier2 = a4;
                WritableEventSource writableEventSource = writableFileStorageTier.g(new FileVersion(writePosition.H, 0), a22.getSegmentSize(), false);
                a4.f.set(writePosition.g(writableEventSource, 0));
                writableFileStorageTier.b.g(new WritePosition(writePosition.H, 0, 0, writableEventSource, Long.valueOf(writePosition.H), writePosition.b));
            }
        }
        a4.K();
    }

    private /* synthetic */ void K() {
        WritableFileStorageTier a2;
        WritableFileStorageTier writableFileStorageTier = a2;
        while (true) {
            if (writableFileStorageTier.j.size() == 1) break;
            try {
                Thread.sleep(10L);
                writableFileStorageTier = a2;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new MessagingPlatformException(ErrorCode.OTHER, a2.C + ": Interrupted while waiting for completion", (Throwable)interruptedException);
            }
        }
    }

    public SortedSet<Long> getSegments() {
        WritableFileStorageTier a2;
        return a2.j.keySet();
    }

    public Optional<EventSource> eventSource(long a2) {
        WritableFileStorageTier a4;
        Optional optional = a4.g(a2);
        if (optional.isPresent()) {
            return optional;
        }
        return (Optional)a4.g((T a3) -> a3.eventSource(a2), Optional.empty());
    }

    public WritableFileStorageTier(EventTypeContext a3, IndexManager a4, Supplier<StorageProperties> a5, Supplier<StorageTier> a6, MeterFactory a7, ScheduledExecutorService a8, String a9, EventTransformerFactory a10, FileSystemMonitor a11) {
        WritableFileStorageTier a12;
        WritableFileStorageTier writableFileStorageTier = a12;
        WritableFileStorageTier writableFileStorageTier2 = a12;
        super(a3, a4, a5, a6, a7, a9);
        WritableFileStorageTier writableFileStorageTier3 = a12;
        writableFileStorageTier3.f = new AtomicReference();
        WritableFileStorageTier writableFileStorageTier4 = a12;
        writableFileStorageTier2.h = new AtomicLong(-1L);
        WritableFileStorageTier writableFileStorageTier5 = a12;
        writableFileStorageTier2.j = new ConcurrentSkipListMap(Comparator.reverseOrder());
        writableFileStorageTier2.I = a7;
        writableFileStorageTier.c = a11;
        writableFileStorageTier.m = a10.get(a5.get().getFlags());
        WritableFileStorageTier writableFileStorageTier6 = a12;
        writableFileStorageTier6.b = new Synchronizer(a3, a5.get(), a7, a8, a2 -> {
            WritableFileStorageTier a4;
            WritableFileStorageTier writableFileStorageTier = a4;
            writableFileStorageTier.l.complete(new FileVersion(a2.c.longValue(), 0));
            writableFileStorageTier.g((T a3) -> {
                WritableFileStorageTier a4;
                a3.handover((Segment)new E(a4, a2), () -> {
                    WritableFileStorageTier a3;
                    ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a3.j.remove(a2.c);
                    i.debug(EventSourceNotFoundException.g((Object)"L\u000fj\na\n$\u0001r\u000bvN\u007f\u0013(Nv\u000bi\u000fm\u0000m\u0000cNw\u000bc\u0003a\u0000p\u001d>N\u007f\u0013"), (Object)a2.c, (Object)a3.getSegments());
                    if (byteBufferEventSource != null) {
                        byteBufferEventSource.g((long)((StorageProperties)a3.b.get()).getPrimaryCleanupDelay());
                    }
                });
            });
        });
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a3.g();
        stringArray[2] = "type";
        stringArray[3] = a3.g().name();
        a12.H = a7.gauge((MetricName)BaseMetricName.K, Tags.of((String[])stringArray), (Object)a12.b, a2 -> {
            WritableFileStorageTier a3;
            return (double)a3.h.get() - (double)a2.g();
        });
    }

    private /* synthetic */ WritePosition g(int a2, int a3, int a4) {
        int n = (int)Math.ceil((double)a3 / 32767.0);
        if ((n = a2 + n * 11) > 0x7FFFFFF6 || a2 <= 0) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a2;
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, String.format(LifecycleController.g((Object)"\u0007\n\"\u0003)\u0007\"F:\u0014/\b=\u0007-\u0012'\t F=\u000f4\u0003tFk\u0002"), objectArray));
        }
        do {
            WritableFileStorageTier a6;
            if (!(a2 = (WritePosition)a6.f.getAndUpdate(a5 -> a5.g(a3, n, a4))).f(n) && !a2.g(a4)) continue;
            i.debug(EventSourceNotFoundException.g((Object)"\u0015yT$-v\u000be\u001am\u0000cNj\u000bsNw\u000bc\u0003a\u0000pN\u007f\u0013"), (Object)a6.C, (Object)a2.H);
            WritePosition writePosition = a2;
            writePosition.j.g(writePosition.I, -1);
            WritableEventSource writableEventSource = a6.g(new FileVersion(a2.H, a4), n + 5 + 4, true);
            a6.f.set(a2.g(writableEventSource, a4));
        } while (!a2.K(n) || a2.g(a4));
        return a2;
    }

    public long f() {
        WritableFileStorageTier a2;
        return a2.h.get();
    }

    private /* synthetic */ FileVersion g(long a2, File a4, FileVersion a5, StorageProperties a6) {
        return Arrays.stream(FileUtils.g((File)a4, (String)a6.getEventsSuffix())).map(FileUtils::g).filter(a3 -> {
            if (a3.g() < a2) {
                return true;
            }
            return false;
        }).max(FileVersion::g).orElse(a5);
    }

    public void handover(Segment a2, Runnable a3) {
        a3.run();
    }

    private /* synthetic */ void g() {
        WritableFileStorageTier a2;
        a2.segmentsWithoutIndex().forEach(a4 -> {
            HashMap<String, List> hashMap;
            WritableFileStorageTier a5;
            Optional optional = (Optional)a5.g((T a3) -> a3.eventSource(a4), Optional.empty());
            if (!optional.isPresent()) return;
            optional = ((EventSource)optional.get()).createEventIterator(a4.g());
            try {
                hashMap = new HashMap<String, List>();
                while (optional.hasNext()) {
                    EventInformation eventInformation = optional.g();
                    if (!eventInformation.g()) continue;
                    IndexEntry indexEntry = new IndexEntry(eventInformation.g().getAggregateSequenceNumber(), eventInformation.g(), eventInformation.g());
                    hashMap.computeIfAbsent(eventInformation.g().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (optional != null) {
                    try {
                        optional.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
            a5.l.createIndex(a4, hashMap);
            if (optional == null) return;
            optional.close();
        });
    }

    private /* synthetic */ void g(ProcessedEvent a3, long a4, int a5, Map<String, List<IndexEntry>> a6) {
        if (a3.isDomainEvent()) {
            a6.computeIfAbsent(a3.getAggregateIdentifier(), a2 -> new ArrayList()).add(new IndexEntry(a3.getAggregateSequenceNumber(), a5, a4));
        }
    }

    private /* synthetic */ void K(long a2) {
        WritableFileStorageTier a4;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a4.j.remove(a2);
        int n = 0;
        if (byteBufferEventSource != null) {
            ByteBufferEventSource byteBufferEventSource2 = byteBufferEventSource;
            n = byteBufferEventSource2.g();
            byteBufferEventSource2.g(0L);
        }
        a4.g(a2, n).forEach(a3 -> {
            WritableFileStorageTier a4;
            a4.g(a2, a3.intValue());
        });
    }

    public void initSegments(long a2) {
    }

    public Optional<EventSource> eventSource(FileVersion a2) {
        WritableFileStorageTier a4;
        Optional optional = a4.g(a2);
        if (optional.isPresent()) {
            return optional;
        }
        return (Optional)a4.g((T a3) -> a3.eventSource(a2), Optional.empty());
    }

    public Stream<String> g(long a3, int a5, boolean a6) {
        WritableFileStorageTier a7;
        if (a6) {
            return Stream.concat(a7.j.entrySet().stream().map(a2 -> {
                WritableFileStorageTier a3;
                return FileUtils.g((File)a3.K(new FileVersion(((Long)a2.getKey()).longValue(), ((ByteBufferEventSource)a2.getValue()).g())));
            }), (Stream)a7.g((T a4) -> a4.getBackupFilenames(a3, a5), Stream.empty()));
        }
        return (Stream)a7.g((T a4) -> a4.getBackupFilenames(a3, a5), Stream.empty());
    }

    public Flux<FileVersion> fileVersions(String a2) {
        WritableFileStorageTier a4;
        return (Flux)a4.g((T a3) -> a3.fileVersions(a2), (Object)Flux.empty());
    }

    public long K() {
        WritableFileStorageTier a2;
        return ((WritePosition)a2.f.get()).H;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ FileVersion g(FileVersion a2, StorageProperties a3) {
        WritableFileStorageTier writableFileStorageTier;
        EventIterator eventIterator;
        WritableFileStorageTier a4;
        if (!a4.l.validIndex(a2)) {
            return a2;
        }
        a3 = a4.g(a2, a3.getSegmentSize(), false);
        long l2 = a2.g();
        try {
            eventIterator = a3.createEventIterator(a2.g());
            try {
                while (eventIterator.hasNext()) {
                    eventIterator.g();
                    ++l2;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (eventIterator != null) {
                    try {
                        eventIterator.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
        }
        catch (Throwable throwable) {
            a4.j.remove(a2.g());
            a3.g(0L);
            throw throwable;
        }
        if (eventIterator != null) {
            writableFileStorageTier = a4;
            eventIterator.close();
        } else {
            writableFileStorageTier = a4;
        }
        writableFileStorageTier.j.remove(a2.g());
        a3.g(0L);
        return new FileVersion(l2, 0);
    }

    public SortedSet<FileVersion> segmentsWithoutIndex() {
        WritableFileStorageTier a2;
        return (SortedSet)a2.g(StorageTier::segmentsWithoutIndex, Collections.emptySortedSet());
    }

    private /* synthetic */ boolean g(long a2, int a3) {
        WritableFileStorageTier a4;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a4.j.remove(a2);
        if (byteBufferEventSource != null) {
            byteBufferEventSource.g(0L);
        }
        if (a4.l.remove(a3 = new FileVersion(a2, a3)) && FileUtils.g((File)a4.K(a3))) {
            return true;
        }
        return false;
    }

    public long g() {
        WritableFileStorageTier a3;
        return (Long)a3.g((T a2) -> a2.allSegments().findFirst().orElse(-1L), (Object)-1L);
    }

    public void close(boolean a2) {
        WritableFileStorageTier a5;
        File file = new File(a5.D);
        WritableFileStorageTier writableFileStorageTier = a5;
        WritableFileStorageTier writableFileStorageTier2 = a5;
        writableFileStorageTier.c.unregisterPath(writableFileStorageTier2.g());
        writableFileStorageTier.I.remove((Meter)a5.H);
        writableFileStorageTier2.b.K();
        writableFileStorageTier.j.forEach((a3, a4) -> {
            a4.g(0L);
            if (a2) {
                WritableFileStorageTier a5;
                a5.K(a3.longValue());
            }
        });
        a5.g((T a3) -> a3.close(a2));
        boolean bl = a2;
        a5.l.cleanup(bl);
        if (bl) {
            FileUtils.g((File)file);
        }
    }
}

