/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file.xref;

import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventType;
import io.axoniq.axonserver.localstorage.file.AggregateIndexEntries;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntries;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.IndexNotFoundException;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.xref.E;
import io.axoniq.axonserver.localstorage.file.xref.Index;
import io.axoniq.axonserver.localstorage.file.xref.JumpSkipIndexEntries;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.rest.svg.mapping.AxonServers;
import io.axoniq.axonserver.taskscheduler.task.NodeContext;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.mapdb.volume.FileChannelVol;
import org.mapdb.volume.Volume;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ReadOnlyJumpSkipIndexManager
implements IndexManager {
    protected final AtomicLong J;
    protected static final ScheduledExecutorService g;
    protected final ConcurrentNavigableMap<Long, Integer> K;
    protected final AtomicBoolean A;
    protected final MeterFactory.RateMeter C;
    protected final AtomicLong l;
    public static final String F = "index";
    protected final Supplier<IndexManager> E;
    protected final String i;
    protected final String G;
    protected final ConcurrentSkipListMap<FileVersion, Index> f;
    protected final String c;
    protected final MeterFactory.RateMeter j;
    private static final Logger H;
    protected static final Serializer<JumpSkipIndexEntries> m;
    protected final EventType h;
    protected final Supplier<StorageProperties> b;
    protected ScheduledFuture<?> I;

    public void cleanup(boolean a4) {
        ReadOnlyJumpSkipIndexManager a5;
        a5.f.forEach((a2, a3) -> a3.close());
        a5.f.clear();
        if (a4) {
            a5.K.keySet().forEach(arg_0 -> a5.removeAllVersions(arg_0));
        }
        if (a5.I != null && !a5.I.isDone()) {
            a5.I.cancel(true);
        }
        try {
            IndexManager indexManager = (IndexManager)a5.E.get();
            if (indexManager != null) {
                indexManager.cleanup(a4);
                return;
            }
        }
        catch (Exception exception) {
            H.info(NodeContext.g((Object)"d\u000b%V\\\u001az\u0017q\u0003oVp\u0010?\u001fq\u0012z\u000e?\u0010~\u001fs\u0013{"), (Object)a5.c, (Object)exception);
        }
    }

    public boolean remove(FileVersion a22) {
        ReadOnlyJumpSkipIndexManager a3;
        Index index = (Index)a3.f.remove(a22);
        if (index != null) {
            H.debug(AxonServers.g((Object)"{\u0005W\u001a]IQ\u0007\\\f@IC\u0014"), (Object)a22);
            index.close();
        }
        a3.K.remove(a22.g(), a22.g());
        if (H.isDebugEnabled()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a3.hashCode();
            objectArray[1] = a22;
            objectArray[2] = a3.K.keySet();
            H.debug(NodeContext.g((Object)"d\u000b%V[\u0013s\u0013k\u0013{Vl\u0013x\u001bz\u0018kVd\u000b3Vm\u0013r\u0017v\u0018v\u0018xVl\u0013x\u001bz\u0018k\u0005?\rb"), objectArray);
        }
        File file = ((StorageProperties)a3.b.get()).newIndex(a3.G, a22);
        long l2 = file.length();
        boolean a22 = FileUtils.g((File)file);
        if (a22) {
            a3.l.addAndGet(-l2);
        }
        return a22;
    }

    public void createNewVersion(long a2, int a322, Map<String, List<IndexEntry>> a4) {
        StorageProperties storageProperties;
        block10: {
            StorageProperties storageProperties2;
            block8: {
                ReadOnlyJumpSkipIndexManager a5;
                storageProperties2 = (StorageProperties)a5.b.get();
                Object a322 = new FileVersion(a2, a322);
                if (a4 == null) {
                    a4 = Collections.emptyMap();
                }
                Object[] objectArray = new Object[3];
                objectArray[0] = a322;
                objectArray[1] = storageProperties2.newIndex(a5.G, a2);
                objectArray[2] = a4.keySet();
                H.debug(AxonServers.g((Object)"C\u0014\u0002I[\u001b]\bL\f\u0018\u0012EE\u0018\u0002]\u0010KIC\u0014"), objectArray);
                a322 = storageProperties2.newTransformedIndex(a5.G, (FileVersion)a322);
                try {
                    Files.deleteIfExists(((File)a322).toPath());
                }
                catch (IOException iOException) {
                    throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, NodeContext.g((Object)"Y\u0017v\u001az\u0012?\u0002pV{\u0013s\u0013k\u0013?\u0002m\u0017q\u0005y\u0019m\u001bz\u0012?\u001fq\u0012z\u000e?\u0010v\u001az"), (Throwable)iOException);
                }
                storageProperties2 = DBMaker.fileDB((File)a322).fileMmapEnable().cleanerHackEnable().make();
                a322 = storageProperties2.hashMap(F, (Serializer)Serializer.STRING, m).createOrOpen();
                try {
                    Index index = a5.g(a2);
                    a4.forEach((arg_0, arg_1) -> ReadOnlyJumpSkipIndexManager.g(index, (HTreeMap)a322, arg_0, arg_1));
                    if (a322 == null) break block8;
                    storageProperties = storageProperties2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block9: {
                        if (a322 != null) {
                            try {
                                a322.close();
                                throwable2 = throwable;
                                break block9;
                            }
                            catch (Throwable a322) {
                                throwable.addSuppressed(a322);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                a322.close();
                break block10;
            }
            storageProperties = storageProperties2;
        }
        storageProperties.close();
    }

    MeterFactory.RateMeter g() {
        ReadOnlyJumpSkipIndexManager a2;
        return a2.C;
    }

    protected FileVersion g(long a2) {
        ReadOnlyJumpSkipIndexManager a3;
        NavigableSet<Long> navigableSet = a3.K.keySet().tailSet(a2, true);
        if (navigableSet.isEmpty()) {
            throw new IndexNotFoundException(a3.c + ": Index for token not found: " + a2);
        }
        return new FileVersion(((Long)navigableSet.first()).longValue(), ((Integer)a3.K.get(navigableSet.first())).intValue());
    }

    public Mono<Void> activateVersion(FileVersion a2, File a3) {
        ReadOnlyJumpSkipIndexManager a4;
        if (a4.K.containsKey(a2.g())) {
            return a4.g(a2, a3);
        }
        IndexManager indexManager = (IndexManager)a4.E.get();
        if (indexManager != null) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a4.c;
            objectArray[1] = a2.g();
            objectArray[2] = a2.g();
            H.debug(AxonServers.g((Object)"\u0012ES\u0018\b[\u001dQ\u001fY\u001d]IC\u0014\u0018\u000fW\u001b\u0018\u0012EIQ\u0007\u0018\u0007]\u0011LIL\u0000]\u001b"), objectArray);
            return indexManager.activateVersion(a2, a3);
        }
        return Mono.empty();
    }

    protected Index g(FileVersion a3) {
        ReadOnlyJumpSkipIndexManager a4;
        try {
            return a4.f.computeIfAbsent(a3, a2 -> {
                ReadOnlyJumpSkipIndexManager a3;
                return new Index(a3, a2);
            }).g();
        }
        catch (IndexNotFoundException indexNotFoundException) {
            a4.f.remove(a3);
            throw indexNotFoundException;
        }
    }

    public SortedMap<FileVersion, IndexEntries> lookupAggregate(String a2, long a3, long a4, long a5, long a6) {
        throw new UnsupportedOperationException(NodeContext.g((Object)"P\u0006z\u0004~\u0002v\u0019qVp\u0018s\u000f?\u0005j\u0006o\u0019m\u0002z\u0012?\u0019qVo\u0004v\u001b~\u0004fVv\u0018{\u0013gVr\u0017q\u0017x\u0013m"));
    }

    protected boolean g(long a2, long a3, IndexEntries a4) {
        if (a2 >= a4.firstSequenceNumber() || a3 <= 0L) {
            return true;
        }
        return false;
    }

    private /* synthetic */ void K(FileVersion a2, Map<String, JumpSkipIndexEntries> a32) {
        ReadOnlyJumpSkipIndexManager a4;
        Object[] objectArray = new Object[3];
        objectArray[0] = a4.c;
        objectArray[1] = a4.h;
        objectArray[2] = a2;
        H.info(AxonServers.g((Object)"C\u0014\u0002I[\u001b]\bL\f\u0018\u0012EIQ\u0007\\\f@I^\u0006JIC\u0014"), objectArray);
        StorageProperties storageProperties = (StorageProperties)a4.b.get();
        Object object = a32 == null ? Collections.emptyMap() : a32;
        a32 = a4.g(a2, object);
        object = storageProperties.newIndex(a4.G, a2);
        try {
            CopyOption[] copyOptionArray = new CopyOption[1];
            copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
            Files.move(((File)a32).toPath(), ((File)object).toPath(), copyOptionArray);
            a4.l.addAndGet(((File)object).length());
            a4.K.put(a2.g(), a2.g());
            return;
        }
        catch (IOException a32) {
            throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to rename index file" + storageProperties.index(a4.G, a2), (Throwable)a32);
        }
    }

    public void addExistingIndex(FileVersion a2) {
        ReadOnlyJumpSkipIndexManager a3;
        a3.K.put(a2.g(), a2.g());
        a3.K();
    }

    public boolean validIndex(FileVersion a2) {
        ReadOnlyJumpSkipIndexManager a3;
        boolean bl = false;
        try {
            StorageProperties storageProperties = (StorageProperties)a3.b.get();
            bl = storageProperties.newIndex(a3.G, a2).exists();
            return bl;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a3.c;
            objectArray[1] = a2;
            objectArray[2] = exception;
            H.warn(NodeContext.g((Object)"\rbL?0~\u001fs\u0013{Vk\u0019?\u0000~\u001av\u0012~\u0002zVv\u0018{\u0013gVy\u0019mVl\u0013x\u001bz\u0018kL?\rb"), objectArray);
            return bl;
        }
    }

    public void addToActiveSegment(Long a2, Map<String, List<IndexEntry>> a3) {
    }

    public void g(FileVersion a2, Map<String, JumpSkipIndexEntries> a3) {
        ReadOnlyJumpSkipIndexManager a4;
        if (a4.g(a2)) {
            a4.K(a2, a3);
            return;
        }
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = (ReadOnlyJumpSkipIndexManager)a4.E.get();
        if (readOnlyJumpSkipIndexManager != null) {
            readOnlyJumpSkipIndexManager.g(a2, a3);
        }
    }

    protected void K() {
        ReadOnlyJumpSkipIndexManager a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = a2;
        readOnlyJumpSkipIndexManager.J.set(readOnlyJumpSkipIndexManager.K.keySet().stream().skip(((StorageProperties)a2.b.get()).getMaxIndexesInMemory()).findFirst().orElse(-1L));
    }

    public void init() {
        ReadOnlyJumpSkipIndexManager a5;
        if (!a5.A.get()) {
            int n;
            File[] fileArray = new File(a5.G).listFiles(a2 -> {
                ReadOnlyJumpSkipIndexManager a3;
                return a2.getName().endsWith(a3.i);
            });
            if (fileArray == null) {
                return;
            }
            int n2 = fileArray.length;
            int n3 = n = 0;
            while (n3 < n2) {
                File file = fileArray[n];
                FileVersion fileVersion = FileUtils.g((String)file.getName());
                a5.K.compute(fileVersion.g(), (a3, a4) -> a4 == null ? fileVersion.g() : Math.max(fileVersion.g(), a4));
                a5.l.addAndGet(file.length());
                n3 = ++n;
            }
            ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = a5;
            readOnlyJumpSkipIndexManager.K();
            readOnlyJumpSkipIndexManager.A.set(true);
        }
    }

    public Stream<AggregateIndexEntries> latestSequenceNumbers(FileVersion a2) {
        ReadOnlyJumpSkipIndexManager a3;
        return a3.g(a2).g();
    }

    public Mono<Void> activateVersion(FileVersion a2) {
        ReadOnlyJumpSkipIndexManager a3;
        return Mono.defer(() -> {
            ReadOnlyJumpSkipIndexManager a3;
            File file = ((StorageProperties)a3.b.get()).newTransformedIndex(a3.G, a2);
            return a3.activateVersion(a2, file);
        });
    }

    public Optional<Long> getLastSequenceNumber(String a2, EventStorageEngine.SearchHint a3, long a4) {
        return Optional.empty();
    }

    public long size() {
        ReadOnlyJumpSkipIndexManager a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = (ReadOnlyJumpSkipIndexManager)a2.E.get();
        if (readOnlyJumpSkipIndexManager != null) {
            return a2.l.get() + readOnlyJumpSkipIndexManager.size();
        }
        return a2.l.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public SortedMap<FileVersion, IndexEntries> lookupAggregateInClosedSegments(String a2, long a3, long a4, long a5, long a6, long a7) {
        ReadOnlyJumpSkipIndexManager a8;
        TreeMap<FileVersion, IndexEntries> treeMap = new TreeMap<FileVersion, IndexEntries>();
        try {
            IndexManager indexManager;
            while (a7 >= a6 && a7 >= (Long)a8.K.lastKey()) {
                ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = a8;
                indexManager = readOnlyJumpSkipIndexManager.g(a7);
                JumpSkipIndexEntries jumpSkipIndexEntries = readOnlyJumpSkipIndexManager.g((FileVersion)indexManager).g(a2);
                if (jumpSkipIndexEntries != null) {
                    IndexEntries indexEntries = jumpSkipIndexEntries.range(a3, a4, EventType.h.equals((Object)a8.h));
                    if (!indexEntries.isEmpty()) {
                        treeMap.put((FileVersion)indexManager, indexEntries);
                        if (a8.g(a3, a5 -= (long)indexEntries.size(), (IndexEntries)jumpSkipIndexEntries)) {
                            return treeMap;
                        }
                    }
                    if (jumpSkipIndexEntries.g() >= indexManager.g()) {
                        Object[] objectArray = new Object[4];
                        objectArray[0] = a8.c;
                        objectArray[1] = a8.h;
                        objectArray[2] = a2;
                        objectArray[3] = indexManager;
                        throw new MessagingPlatformException(ErrorCode.INDEX_READ_ERROR, String.format(AxonServers.g((Object)"LKS\u0018 V\u001fY\u0005Q\r\u0018\u0000V\r]\u0011\u0018\fV\u001dJ\u0010\u0018\u000fW\u001b\u0018LKI\u001d\u001a\u0018\u0000VIK\f_\u0004]\u0007LI\u001d\u001a\u0014IT\u0000V\u0002KIL\u0006\u0018\u0007]\u001e]\u001b\u0018\u001dW\u0002]\u0007"), objectArray));
                    }
                    a7 = jumpSkipIndexEntries.g();
                    continue;
                }
                Object[] objectArray = new Object[3];
                objectArray[0] = a8.c;
                objectArray[1] = a2;
                objectArray[2] = indexManager;
                H.warn(NodeContext.g((Object)"d\u000b%Vv\u0018i\u0017s\u001f{Vo\u0004z\u0000v\u0019j\u0005?\u0002p\u001dz\u0018?\u0001w\u001fs\u0013?\u0004z\u0017{\u001fq\u0011?\u0013i\u0013q\u0002lVy\u0019mVd\u000b3V~\u0011x\u0004z\u0011~\u0002zVq\u0019kVy\u0019j\u0018{Vv\u0018?\u0005z\u0011r\u0013q\u0002?\rbZ?\u0015p\u0018k\u001fq\u0003zVv\u0018?\u0006m\u0013i\u001fp\u0003lVl\u0013x\u001bz\u0018k"), objectArray);
                a7 = indexManager.g() - 1L;
            }
            indexManager = (IndexManager)a8.E.get();
            if (indexManager == null) return treeMap;
            treeMap.putAll(((IndexManager)a8.E.get()).lookupAggregateInClosedSegments(a2, a3, a4, a5, a6, a7));
            return treeMap;
        }
        catch (IndexNotFoundException indexNotFoundException) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a8.c;
            objectArray[1] = a2;
            objectArray[2] = a7;
            objectArray[3] = a8.K;
            H.warn(AxonServers.g((Object)"C\u0014\u0002I]\u001bJ\u0006JIJ\fY\rQ\u0007_I]\u001f]\u0007L\u001a\u0018\u000fW\u001b\u0018\u0012EE\u0018\u0019J\fN\u0000W\u001cKIL\u0006S\fVIC\u0014\u0014IQ\u0007\\\f@\fKIC\u0014"), objectArray);
        }
        return treeMap;
    }

    public Index g(long a2) {
        ReadOnlyJumpSkipIndexManager a3;
        H.debug(NodeContext.g((Object)"S\u0019p\u001dv\u0018xVy\u0019mVd\u000b3Vv\u0018{\u0013g\u0013lL?\rb"), (Object)a2, (Object)a3.K);
        Integer n = (Integer)a3.K.get(a2);
        if (n != null) {
            return a3.g(new FileVersion(a2, n.intValue()));
        }
        n = (ReadOnlyJumpSkipIndexManager)a3.E.get();
        if (n != null) {
            H.debug(AxonServers.g((Object)"C\u0014\u0002I^\u0000V\r\u0018\u0000V\r]\u0011\u0018\u000fW\u001b\u0018\u0012EIQ\u0007\u0018\u0007]\u0011LIL\u0000]\u001b"), (Object)a3.c, (Object)a2);
            return n.g(a2);
        }
        throw new IndexNotFoundException(a3.c + ": Index not found: " + a2);
    }

    public List<File> indexFiles(FileVersion a2) {
        ReadOnlyJumpSkipIndexManager a3;
        return Collections.singletonList(((StorageProperties)a3.b.get()).newIndex(a3.G, a2));
    }

    public void addToActiveSegment(long a2, String a3, IndexEntry a4) {
    }

    public SegmentIndexEntries lastIndexEntries(String a2, long a3) {
        throw new UnsupportedOperationException(AxonServers.g((Object)"w\u0019]\u001bY\u001dQ\u0006VIW\u0007T\u0010\u0018\u001aM\u0019H\u0006J\u001d]\r\u0018\u000fW\u001b\u0018\u0019J\u0000U\bJ\u0010\u0018\u0000V\r]\u0011\u0018\u0004Y\u0007Y\u000e]\u001b"));
    }

    private /* synthetic */ Mono<Void> g(FileVersion a4, File a6) {
        ReadOnlyJumpSkipIndexManager a7;
        return Mono.fromSupplier(() -> {
            ReadOnlyJumpSkipIndexManager a3;
            return ((StorageProperties)a3.b.get()).newIndex(a3.G, a4);
        }).filter(a2 -> {
            if (!a2.exists()) {
                return true;
            }
            return false;
        }).doOnNext(a3 -> {
            ReadOnlyJumpSkipIndexManager a4;
            H.debug(AxonServers.g((Object)"\u0012ES\u0018([\u001dQ\u001fY\u001dQ\u0007_IQ\u0007\\\f@I^\u0006JI^\u0000T\fN\fJ\u001aQ\u0006VIC\u0014"), (Object)a4.c, (Object)a4);
        }).flatMap(a5 -> {
            ReadOnlyJumpSkipIndexManager a6;
            return Mono.fromSupplier(() -> a6).filter(File::exists).switchIfEmpty(Mono.error((Throwable)new RuntimeException())).doOnNext(a3 -> {
                ReadOnlyJumpSkipIndexManager a4;
                Object[] objectArray = new Object[3];
                objectArray[0] = a4.c;
                objectArray[1] = a3.getAbsolutePath();
                objectArray[2] = a5.getAbsolutePath();
                H.debug(NodeContext.g((Object)"d\u000b%VM\u0013q\u0017r\u001fq\u0011?\u0002w\u0013?\u0002z\u001bo\u0019m\u0017m\u000f?\u001fq\u0012z\u000e?\rbVk\u0019?\rb"), objectArray);
            }).flatMap(a4 -> FileUtils.g((File)a6, (File)a5));
        }).doOnSuccess(a3 -> {
            ReadOnlyJumpSkipIndexManager a4;
            a4.K.put(a4.g(), a4.g());
        }).doOnError(a2 -> a2.printStackTrace());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SegmentIndexEntries lastIndexEntriesFromClosedSegments(String a2, long a3, long a42) {
        ReadOnlyJumpSkipIndexManager a5;
        try {
            FileVersion fileVersion;
            long l2 = a42 = a42;
            while (l2 >= (Long)a5.K.lastKey()) {
                ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = a5;
                fileVersion = readOnlyJumpSkipIndexManager.g(a42);
                JumpSkipIndexEntries jumpSkipIndexEntries = readOnlyJumpSkipIndexManager.g(fileVersion).g(a2);
                if (jumpSkipIndexEntries == null) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a5.c;
                    objectArray[1] = a2;
                    objectArray[2] = fileVersion;
                    H.debug(NodeContext.g((Object)"\rbL?\u0013q\u0002m\u001fz\u0005?\u0010p\u0004?\rbVq\u0019kVy\u0019j\u0018{Vv\u0018?\u0005z\u0011r\u0013q\u0002?\rb"), objectArray);
                    return null;
                }
                if (jumpSkipIndexEntries.firstSequenceNumber() < a3) {
                    JumpSkipIndexEntries jumpSkipIndexEntries2 = jumpSkipIndexEntries;
                    return new SegmentIndexEntries(fileVersion, jumpSkipIndexEntries2.range(jumpSkipIndexEntries2.firstSequenceNumber(), a3, EventType.h.equals((Object)a5.h)));
                }
                l2 = jumpSkipIndexEntries.g();
            }
            fileVersion = (IndexManager)a5.E.get();
            if (fileVersion == null) return null;
            return fileVersion.lastIndexEntriesFromClosedSegments(a2, a3, a42);
        }
        catch (IndexNotFoundException a42) {
            H.debug(AxonServers.g((Object)"\u0012ES\u0018\u0000V\r]\u0011\u0018\u0007W\u001d\u0018\u000fW\u001cV\r"), (Object)a5.c, (Object)a42);
        }
        return null;
    }

    public Stream<File> getBackupFilenames(long a2, int a5) {
        ReadOnlyJumpSkipIndexManager a6;
        StorageProperties storageProperties = (StorageProperties)a6.b.get();
        return a6.K.entrySet().stream().filter(a4 -> {
            if ((Long)a4.getKey() > a2 || (Integer)a4.getValue() > a5) {
                return true;
            }
            return false;
        }).map(a3 -> {
            ReadOnlyJumpSkipIndexManager a4;
            return storageProperties.newIndex(a4.G, new FileVersion(((Long)a3.getKey()).longValue(), ((Integer)a3.getValue()).intValue()));
        });
    }

    public void complete(FileVersion a2) {
    }

    private /* synthetic */ boolean g(FileVersion a2) {
        ReadOnlyJumpSkipIndexManager a3;
        return ((StorageProperties)a3.b.get()).dataFile(a3.G, a2).exists();
    }

    protected void g() {
        ReadOnlyJumpSkipIndexManager a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = a2;
        while (readOnlyJumpSkipIndexManager.f.size() > ((StorageProperties)a2.b.get()).getMaxIndexesInMemory()) {
            Map.Entry entry = a2.f.pollFirstEntry();
            H.debug(NodeContext.g((Object)"\rbL?5s\u0019l\u001fq\u0011?\u001fq\u0012z\u000e?\rb"), (Object)a2.c, entry.getKey());
            a2.I = g.schedule(() -> ((Index)entry.getValue()).close(), 2L, TimeUnit.SECONDS);
            readOnlyJumpSkipIndexManager = a2;
        }
    }

    /*
     * Exception decompiling
     */
    protected void g(File a, int a) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean removeAllVersions(long a2) {
        ReadOnlyJumpSkipIndexManager a3;
        StorageProperties storageProperties = (StorageProperties)a3.b.get();
        Integer n = (Integer)a3.K.remove(a2);
        if (n != null) {
            int n2;
            int n3 = n2 = 0;
            while (n3 < n) {
                FileVersion fileVersion = new FileVersion(a2, n2);
                if (storageProperties.newIndex(a3.G, fileVersion).exists()) {
                    a3.remove(fileVersion);
                }
                n3 = ++n2;
            }
            return a3.remove(new FileVersion(a2, n.intValue()));
        }
        return true;
    }

    public void createIndex(FileVersion a2, Map<String, List<IndexEntry>> a3) {
        throw new UnsupportedOperationException(NodeContext.g((Object)"F\u0019jV|\u0017qVp\u0018s\u000f?\u0015m\u0013~\u0002zV~\u0018?\u001fq\u0012z\u000e?\u0010m\u0019rVk\u001ezVO\u0004v\u001b~\u0004f<j\u001bo%t\u001fo?q\u0012z\u000eR\u0017q\u0017x\u0013m"));
    }

    static {
        H = LoggerFactory.getLogger(ReadOnlyJumpSkipIndexManager.class);
        m = new E();
        g = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory(AxonServers.g((Object)"\u0003KDQ\u0007\\\f@DU\bV\b_\fJD")));
    }

    protected File g(FileVersion a2, Map<String, JumpSkipIndexEntries> a3) {
        StorageProperties storageProperties;
        ReadOnlyJumpSkipIndexManager a4;
        block9: {
            StorageProperties storageProperties2;
            block7: {
                storageProperties2 = (StorageProperties)a4.b.get();
                Object[] objectArray = new Object[3];
                objectArray[0] = a2;
                objectArray[1] = storageProperties2.newIndex(a4.G, (FileVersion)a2);
                objectArray[2] = a3.keySet();
                H.debug(NodeContext.g((Object)"\rbL?\u0015m\u0013~\u0002zVd\u000b3Vt\u0013f\u0005?\rb"), objectArray);
                a2 = storageProperties2.newIndexTemp(a4.G, a2.g());
                try {
                    Files.deleteIfExists(((File)a2).toPath());
                }
                catch (IOException iOException) {
                    throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, AxonServers.g((Object)"/Y\u0000T\f\\IL\u0006\u0018\r]\u0005]\u001d]IL\fU\u0019W\u001bY\u001bAIQ\u0007\\\f@I^\u0000T\f"), (Throwable)iOException);
                }
                storageProperties2 = DBMaker.volumeDB((Volume)new FileChannelVol((File)a2), (boolean)false).make();
                HTreeMap hTreeMap = storageProperties2.hashMap(F, (Serializer)Serializer.STRING, m).create();
                try {
                    hTreeMap.putAll(a3);
                    storageProperties2.commit();
                    if (hTreeMap == null) break block7;
                    storageProperties = storageProperties2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block8: {
                        if (hTreeMap != null) {
                            try {
                                hTreeMap.close();
                                throwable2 = throwable;
                                break block8;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                hTreeMap.close();
                break block9;
            }
            storageProperties = storageProperties2;
        }
        storageProperties.close();
        Object object = a2;
        a4.g((File)object, a3.size());
        return object;
    }

    private static /* synthetic */ void g(Index a2, HTreeMap a3, String a4, List a5) {
        int n;
        JumpSkipIndexEntries jumpSkipIndexEntries = a2.g(a4);
        IndexEntry indexEntry = (IndexEntry)a5.get(0);
        Integer[] integerArray = new Integer[a5.size()];
        int n2 = n = 0;
        while (n2 < a5.size()) {
            int n3 = n++;
            integerArray[n3] = ((IndexEntry)a5.get(n3)).g();
            n2 = n;
        }
        a3.put((Object)a4, (Object)new JumpSkipIndexEntries(jumpSkipIndexEntries.g(), indexEntry.g(), integerArray));
    }

    public ReadOnlyJumpSkipIndexManager(String a2, Supplier<StorageProperties> a3, String a4, EventType a5, MeterFactory a6, Supplier<IndexManager> a7) {
        ReadOnlyJumpSkipIndexManager a8;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = a8;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = a8;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager3 = a8;
        a8.f = new ConcurrentSkipListMap();
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager4 = a8;
        readOnlyJumpSkipIndexManager3.K = new ConcurrentSkipListMap(Comparator.reverseOrder());
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager5 = a8;
        a8.J = new AtomicLong();
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager6 = a8;
        a8.A = new AtomicBoolean(false);
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager7 = a8;
        a8.l = new AtomicLong();
        readOnlyJumpSkipIndexManager2.c = a2;
        readOnlyJumpSkipIndexManager2.b = a3;
        readOnlyJumpSkipIndexManager.G = a4;
        readOnlyJumpSkipIndexManager.h = a5;
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a2;
        stringArray[2] = "type";
        stringArray[3] = a5.name();
        a2 = Tags.of((String[])stringArray);
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager8 = a8;
        readOnlyJumpSkipIndexManager8.C = a6.rateMeter((MetricName)BaseMetricName.da, (Tags)a2);
        readOnlyJumpSkipIndexManager8.j = a6.rateMeter((MetricName)BaseMetricName.H, (Tags)a2);
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager9 = a8;
        readOnlyJumpSkipIndexManager9.E = a7;
        readOnlyJumpSkipIndexManager9.i = a3.get().getNewIndexSuffix();
        g.scheduleAtFixedRate(() -> a8.g(), 10L, 10L, TimeUnit.SECONDS);
    }
}

