/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.logging;

import io.axoniq.axonserver.applicationevents.UserEvents;
import io.axoniq.axonserver.component.version.ClientVersionsCache;
import io.axoniq.axonserver.localstorage.StorageResolver;
import io.axoniq.axonserver.logging.E;
import io.axoniq.axonserver.util.StringUtils;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class AuditLog {
    private static final Logger I = AuditLog.getLogger();

    @EventListener
    public void on(UserEvents.AdminUserUpdated a2) {
        if (I.isDebugEnabled()) {
            I.debug(a2.toString());
        }
    }

    public static String username(Principal a2) {
        if (a2 == null) {
            return StorageResolver.g((Object)"}1/?/),?4#\u007f");
        }
        return StringUtils.sanitize((String)a2.getName());
    }

    public static String enablement(boolean a2) {
        if (a2) {
            return ClientVersionsCache.g((Object)"5`1l<k4");
        }
        return StorageResolver.g((Object)"\u0014\b\u0003\u0000\u0012\r\u0015\u0005");
    }

    public static String username(String a2) {
        if (a2 == null) {
            return ClientVersionsCache.g((Object)"LO\u001eA\u001eW\u001dA\u0005]N");
        }
        return StringUtils.sanitize((String)a2);
    }

    @EventListener
    public void on(AbstractAuthenticationEvent a2) {
        if (a2 instanceof InteractiveAuthenticationSuccessEvent) {
            return;
        }
        Authentication authentication = a2.getAuthentication();
        if (I.isDebugEnabled()) {
            I.debug(a2.toString());
            return;
        }
        if (a2 instanceof AuthenticationSuccessEvent && authentication.isAuthenticated()) {
            I.info(StorageResolver.g((Object)"\r?&9/p6958a%253> =$pc+<ro"), (Object)authentication.getName());
            return;
        }
        if (a2 instanceof AbstractAuthenticationFailureEvent) {
            a2 = (AbstractAuthenticationFailureEvent)a2;
            I.error(ClientVersionsCache.g((Object)"<A\u0017G\u001e\u000e\u0007G\u0004FP[\u0003K\u0002@\u0011C\u0015\u000eRU\r\fPh1g<k4\u0014PU\r"), (Object)authentication.getName(), (Object)a2.getException().getMessage());
        }
    }

    public static <T> Logger getLogger() {
        return LoggerFactory.getLogger((String)("AUDIT." + E.I.g()[2].getName()));
    }

    public AuditLog() {
        AuditLog a2;
    }

    @EventListener
    public void on(UserEvents.AdminUserDeleted a2) {
        if (I.isDebugEnabled()) {
            I.debug(a2.toString());
        }
    }
}

