/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message;

import io.axoniq.axonserver.admin.context.requestprocessor.VisibleContextCache;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class ContextLimitedCache<CACHE extends NonReplacingConstraintCache<String, T>, T>
implements NonReplacingConstraintCache<String, T> {
    private final Function<T, String> H;
    private final CACHE m;
    private final Function<String, Long> h;
    private final Map<String, Long> b;
    private final Map<String, AtomicLong> I;

    public T remove(@Nonnull String a4) {
        if ((a4 = this.m.remove(a4)) != null) {
            ContextLimitedCache contextLimitedCache = this;
            contextLimitedCache.I.computeIfPresent((String)contextLimitedCache.H.apply(a4), (a2, a3) -> {
                AtomicLong atomicLong = a3;
                atomicLong.decrementAndGet();
                return atomicLong;
            });
        }
        return (T)a4;
    }

    public T putIfAbsent(@Nonnull String key, @Nonnull T a4) {
        String string = (String)this.H.apply(a4);
        long l2 = this.b.computeIfAbsent(string, this.h::apply);
        if (l2 != -1L) {
            this.I.computeIfAbsent(string, a2 -> new AtomicLong()).getAndUpdate(a3 -> {
                if (a3 >= l2) {
                    throw new InsufficientBufferCapacityException(VisibleContextCache.g((Object)"Fxbka\u007f$dw-bxha(-wakz$ikzj#"));
                }
                return a3 + 1L;
            });
        }
        try {
            return (T)this.m.putIfAbsent((Object)key, a4);
        }
        catch (InsufficientBufferCapacityException insufficientBufferCapacityException) {
            this.I.computeIfPresent(string, (a2, a3) -> {
                AtomicLong atomicLong = a3;
                atomicLong.decrementAndGet();
                return atomicLong;
            });
            throw insufficientBufferCapacityException;
        }
    }

    public Set<Map.Entry<String, T>> timedOut() {
        ContextLimitedCache a2;
        return a2.m.timedOut();
    }

    public int size() {
        ContextLimitedCache a2;
        return a2.m.size();
    }

    public Collection<Map.Entry<String, T>> entrySet() {
        ContextLimitedCache a2;
        return a2.m.entrySet();
    }

    public long activeMessages(String a2) {
        ContextLimitedCache a3;
        return a3.I.getOrDefault(a2, new AtomicLong(0L)).get();
    }

    public Stream<T> getMessagesForContext(String a2) {
        ContextLimitedCache a4;
        return a4.m.entrySet().stream().filter(a3 -> {
            ContextLimitedCache a4;
            return a2.equals(a4.H.apply(a3.getValue()));
        }).map(Map.Entry::getValue);
    }

    public void setMaxMessagesForContext(String a2, long a3) {
        ContextLimitedCache a4;
        a4.b.put(a2, a3);
    }

    public T get(String a2) {
        ContextLimitedCache a3;
        return (T)a3.m.get((Object)a2);
    }

    protected ContextLimitedCache(Function<T, String> a2, Function<String, Long> a3, CACHE a4) {
        ContextLimitedCache a5;
        ContextLimitedCache contextLimitedCache = a5;
        ContextLimitedCache contextLimitedCache2 = a5;
        ContextLimitedCache contextLimitedCache3 = a5;
        contextLimitedCache2.I = new ConcurrentHashMap();
        ContextLimitedCache contextLimitedCache4 = a5;
        contextLimitedCache2.b = new ConcurrentHashMap();
        contextLimitedCache2.H = a2;
        contextLimitedCache.h = a3;
        contextLimitedCache.m = a4;
    }
}

